/* CreateTable_Filespec.sql */

if exists (select * from dbo.sysobjects where id = object_id(N'FileSpec') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table FileSpec
GO

CREATE TABLE FileSpec (
	PartitionId binary (16) NOT NULL ,
	Owner varchar (64) NULL ,
	OwnerDomain varchar (64) NULL ,
	Size float NOT NULL ,
	Attributes int NOT NULL ,
	CreationTime datetime NOT NULL ,
	AccessTime datetime NOT NULL ,
	WriteTime datetime NOT NULL ,
	DirName varchar (255) NULL ,
	FileName varchar (255) NULL ,
	Extension varchar (255) NULL 
) ON SRMFC_tables
GO
CREATE  INDEX PartitionId_Index ON FileSpec(PartitionId) on SRMFC_tables
GO
CREATE  INDEX Owner_OwnerDomain_Index ON FileSpec(Owner, OwnerDomain) on SRMFC_tables
GO
CREATE  INDEX Size_Index ON FileSpec(Size) on SRMFC_tables
GO
CREATE  INDEX AccessTime_Index ON FileSpec(AccessTime) on SRMFC_tables
GO
CREATE  INDEX WriteTime_Index ON FileSpec(WriteTime) on SRMFC_tables
GO
CREATE  INDEX DirName_Index ON FileSpec(DirName) on SRMFC_tables
GO
CREATE  INDEX FileName_Index ON FileSpec(FileName) on SRMFC_tables
GO
CREATE  INDEX Extension_Index ON FileSpec(Extension) on SRMFC_tables
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON FileSpec  TO SRMSvcGroup
GO

