if exists (select * from dbo.sysobjects where id =
object_id(N'[dbo].[CreateFileSpecIndexes]') and OBJECTPROPERTY(id,
N'IsProcedure') = 1)
drop procedure [dbo].[CreateFileSpecIndexes]
GO

CREATE procedure CreateFileSpecIndexes
as

CHECKPOINT
create index PartitionId_Index
 on FileSpec (PartitionId)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

create index Owner_OwnerDomain_Index
 on FileSpec (Owner, OwnerDomain)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

create index Size_Index
 on FileSpec (Size)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

create index AccessTime_Index
 on FileSpec (AccessTime)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

create index WriteTime_Index
 on FileSpec (WriteTime)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

create index DirName_Index
 on FileSpec (DirName)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

Create index FileName_Index
 on FileSpec (FileName)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

create index Extension_Index
 on FileSpec (Extension)
WITH STATISTICS_NORECOMPUTE
 on SRMFC_tables

--
EXEC sp_updatestats
CHECKPOINT
-- Update the ServiceVariable stats
declare @VarNumFileSpec  integer
select @VarNumFileSpec = count (*) from FileSpec
update ServiceVariable
 set
  VarInteger = @VarNumFileSpec
 where
  VarName = 'StatNumFileSpec'

GO
GRANT  EXECUTE  ON [dbo].[CreateFileSpecIndexes]  TO [SRMSvcGroup]
GO




















---