/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import palm.conduit.AbstractRecord;

public class TodoRecord
extends AbstractRecord {
    private String description;
    private Date dueDate;
    private boolean isCompleted;
    private int priority;
    private boolean isPrivate;
    private String note;
    private static final int COMPLETED_BIT = 128;
    private static final int PRIORITY_BITS = 127;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setIsCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void writeData(DataOutputStream out) throws IOException {
        int flags = 0;
        AbstractRecord.writeDate(out, this.dueDate);
        if (this.isCompleted) {
            flags = (byte)(flags | 0x80);
        }
        flags = (byte)(flags | this.priority & 0x7F);
        out.writeByte(flags);
        AbstractRecord.writeCString(out, AbstractRecord.stringWithoutCarriageReturns(this.description));
        AbstractRecord.writeCString(out, AbstractRecord.stringWithoutCarriageReturns(this.note));
    }

    public void readData(DataInputStream in) throws IOException {
        this.dueDate = AbstractRecord.readDate(in);
        byte flags = in.readByte();
        this.isCompleted = (flags & 0x80) != 0;
        this.priority = flags & 0x7F;
        this.description = AbstractRecord.readCString(in);
        this.note = AbstractRecord.readCString(in);
    }

    public String toString() {
        return "Todo record: " + this.getDescription() + " " + super.toString();
    }

    public String toFormattedString() {
        return "Todo record: " + this.getDescription() + "\r\n" + super.toFormattedString();
    }

    static {
        COMPLETED_BIT = 128;
        PRIORITY_BITS = 127;
    }
}

