/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import com.sun.pdasync.SyncMgr.CDbList;
import com.sun.pdasync.SyncMgr.CSyncProperties;
import com.sun.pdasync.SyncUtils.ObjDump;
import com.sun.pdasync.SyncUtils.SyncUtils;
import palm.conduit.DbList;

public class SyncProperties
implements ObjDump {
    public static final int SYNC_FAST = 0;
    public static final int SYNC_SLOW = 1;
    public static final int SYNC_HH_TO_PC = 2;
    public static final int SYNC_PC_TO_HH = 3;
    public static final int SYNC_INSTALL = 4;
    public static final int SYNC_BACKUP = 5;
    public static final int SYNC_DO_NOTHING = 6;
    public static final int SYNC_PROFILE_INSTALL = 7;
    public static final int SYNC_TYPE_MIN_RANGE = -1;
    public static final int SYNC_TYPE_MAX_RANGE = 8;
    public int syncType;
    public String pathName = "";
    public String localName = "";
    public String userName = "";
    public String[] remoteNames;
    public int creator;
    public short cardNo;
    public int dbType;
    public int appInfoSize;
    public int sortInfoSize;
    public int firstDevice;
    public int connType;
    public String registry = "";
    public int hKey;
    private DbList[] remoteDb;

    public String toString() {
        return "Type: " + this.syncType + " path: " + this.pathName + " local: " + this.localName + " user: " + this.userName;
    }

    SyncProperties(CSyncProperties cProps) {
        this.syncType = cProps.m_SyncType;
        this.pathName = new String(cProps.m_PathName);
        this.localName = new String(cProps.m_LocalName);
        this.userName = new String(cProps.m_UserName);
        this.cardNo = cProps.m_CardNo_u;
        this.dbType = cProps.m_DbType_u;
        this.appInfoSize = cProps.m_AppInfoSize_u;
        this.sortInfoSize = cProps.m_SortInfoSize_u;
        this.firstDevice = cProps.m_FirstDevice;
        this.connType = cProps.m_Connection;
        this.registry = new String(cProps.m_Registry);
        this.hKey = cProps.m_hKey;
        this.remoteNames = new String[cProps.m_RemoteCount];
        this.remoteDb = this.copyFromCDbList(cProps.m_RemoteDbList);
    }

    public SyncProperties() {
    }

    public DbList[] copyFromCDbList(CDbList[] cdbList) {
        DbList[] retDb = null;
        if (cdbList != null) {
            retDb = DbList.makeDbListArray(cdbList.length);
            int i = 0;
            while (i < cdbList.length) {
                retDb[i] = new DbList();
                retDb[i].copyFromCDbList(cdbList[i]);
                ++i;
            }
        }
        return retDb;
    }

    public CDbList[] copyToCDbList(DbList[] dbList) {
        CDbList[] retCDb = null;
        if (dbList != null) {
            retCDb = CDbList.makeCDbListArray((int)dbList.length);
            int i = 0;
            while (i < dbList.length) {
                retCDb[i] = new CDbList();
                dbList[i].copyToCDbList(retCDb[i]);
                ++i;
            }
        }
        return retCDb;
    }

    public void copyToCSyncProperties(CSyncProperties cprops) {
        cprops.m_SyncType = this.syncType;
        cprops.m_PathName = this.pathName.getBytes();
        cprops.m_LocalName = this.localName.getBytes();
        cprops.m_UserName = this.userName.getBytes();
        if (this.remoteNames != null) {
            cprops.m_RemoteName = new byte[this.remoteNames.length][];
            int i = 0;
            while (i < this.remoteNames.length) {
                cprops.m_RemoteName[i] = this.remoteNames[i].getBytes();
                ++i;
            }
            cprops.m_RemoteCount = this.remoteNames.length;
        } else {
            cprops.m_RemoteName = null;
            cprops.m_RemoteCount = 0;
        }
        cprops.m_RemoteDbList = this.remoteDb != null ? this.copyToCDbList(this.remoteDb) : null;
        cprops.m_Creator_u = this.creator;
        cprops.m_CardNo_u = this.cardNo;
        cprops.m_DbType_u = this.dbType;
        cprops.m_AppInfoSize_u = this.appInfoSize;
        cprops.m_SortInfoSize_u = this.sortInfoSize;
        cprops.m_FirstDevice = this.firstDevice;
        cprops.m_Connection = this.connType;
        cprops.m_Registry = (byte[])(this.registry != null ? this.registry.getBytes() : null);
        cprops.m_hKey = this.hKey;
    }

    public void copyFromCSyncProperties(CSyncProperties cprops) {
        this.syncType = cprops.m_SyncType;
        this.pathName = new String(cprops.m_PathName);
        this.localName = new String(cprops.m_LocalName);
        this.userName = new String(cprops.m_UserName);
        if (cprops.m_RemoteName != null) {
            this.remoteNames = new String[cprops.m_RemoteName.length];
            int i = 0;
            while (i < cprops.m_RemoteName.length) {
                this.remoteNames[i] = new String(cprops.m_RemoteName[i]);
                ++i;
            }
        } else {
            this.remoteNames = null;
        }
        this.remoteDb = cprops.m_RemoteDbList != null ? this.copyFromCDbList(cprops.m_RemoteDbList) : null;
        this.creator = cprops.m_Creator_u;
        this.cardNo = cprops.m_CardNo_u;
        this.dbType = cprops.m_DbType_u;
        this.appInfoSize = cprops.m_AppInfoSize_u;
        this.sortInfoSize = cprops.m_SortInfoSize_u;
        this.firstDevice = cprops.m_FirstDevice;
        this.connType = cprops.m_Connection;
        this.registry = cprops.m_Registry != null ? new String(cprops.m_Registry) : null;
        this.hKey = cprops.m_hKey;
    }

    public String dump() {
        int i;
        String remNames = new String("> <Remote Names: ");
        String remDbs = new String("> <Remote Databases: ");
        if (this.remoteNames != null) {
            i = 0;
            while (i < this.remoteNames.length - 1) {
                remNames = remNames + this.remoteNames[i] + ", ";
                ++i;
            }
            remNames = remNames + this.remoteNames[i];
        } else {
            remNames = remNames + "null";
        }
        if (this.remoteDb != null) {
            i = 0;
            while (i < this.remoteDb.length - 1) {
                remDbs = remDbs + this.remoteDb[i].dump() + ", ";
                ++i;
            }
            remDbs = remDbs + this.remoteDb[i].dump();
        } else {
            remDbs = remDbs + "null";
        }
        return "<Sync Type: " + this.syncType + "> <Path Name: " + this.pathName + "> <Local Name: " + this.localName + "> <User Name: " + this.userName + remNames + "> <Creator: " + Integer.toHexString(this.creator) + "> <Card Number: " + this.cardNo + "> <DB Type: " + Integer.toHexString(this.dbType) + "> <App Info Size: " + this.appInfoSize + "> <First Device: " + this.firstDevice + "> <Connection Type: " + this.connType + "> <Registry Key: " + this.hKey + remDbs + ">\n";
    }

    public String dumpFormatted() {
        return this.dumpFormatted(0);
    }

    public String dumpFormatted(int numTabs) {
        int i;
        String tabs = SyncUtils.makeTabsString((int)numTabs);
        String remNames = new String(tabs + "    Remote Names:\n");
        String remDbs = new String(tabs + "    Remote Databases:\n");
        if (this.remoteNames != null) {
            i = 0;
            while (i < this.remoteNames.length) {
                remNames = remNames + tabs + "         " + this.remoteNames[i] + "\n";
                ++i;
            }
        } else {
            remNames = remNames + tabs + "         null\n";
        }
        if (this.remoteDb != null) {
            i = 0;
            while (i < this.remoteDb.length) {
                remDbs = remDbs + this.remoteDb[i].dumpFormatted(numTabs + 1) + "\n";
                ++i;
            }
        } else {
            remDbs = remDbs + tabs + "         null\n";
        }
        return tabs + "SyncProperties:\n" + tabs + "  {\n" + tabs + "    Sync Type        : " + this.syncType + "\n" + tabs + "    Path Name        : " + this.pathName + "\n" + tabs + "    Local Name       : " + this.localName + "\n" + tabs + "    User Name        : " + this.userName + "\n" + remNames + tabs + "    Creator          : " + Integer.toHexString(this.creator) + "\n" + tabs + "    Card Number      : " + this.cardNo + "\n" + tabs + "    DB Type          : " + Integer.toHexString(this.dbType) + "\n" + tabs + "    App Info Size    : " + this.appInfoSize + "\n" + tabs + "    First Device     : " + this.firstDevice + "\n" + tabs + "    Connection Type  : " + this.connType + "\n" + tabs + "    Registry Key     : " + this.hKey + "\n" + remDbs + tabs + "  }\n";
    }

    static {
        SYNC_FAST = 0;
        SYNC_SLOW = 1;
        SYNC_HH_TO_PC = 2;
        SYNC_PC_TO_HH = 3;
        SYNC_INSTALL = 4;
        SYNC_BACKUP = 5;
        SYNC_DO_NOTHING = 6;
        SYNC_PROFILE_INSTALL = 7;
        SYNC_TYPE_MIN_RANGE = -1;
        SYNC_TYPE_MAX_RANGE = 8;
    }
}

