/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.IOException;

public class SyncException
extends IOException {
    public int errorCode;
    public static final int NONE = 0;
    public static final int FIRST = 16384;
    public static final int UNKNOWN = 16385;
    public static final int MORE = 16386;
    public static final int FILE_NOT_FOUND = 16387;
    public static final int FILE_NOT_OPEN = 16388;
    public static final int FILE_OPEN = 16389;
    public static final int RECORD_BUSY = 16390;
    public static final int RECORD_DELETED = 16391;
    public static final int ROM_BASED = 16392;
    public static final int READ_ONLY = 16393;
    public static final int COMM_NOT_INIT = 16394;
    public static final int FILE_ALREADY_EXIST = 16395;
    public static final int FILE_ALREADY_OPEN = 16396;
    public static final int NO_FILES_OPEN = 16397;
    public static final int BAD_OPERATION = 16398;
    public static final int REMOTE_BAD_ARG = 16399;
    public static final int BAD_ARG_WRAPPER = 16400;
    public static final int ARG_MISSING = 16401;
    public static final int LOCAL_BUFF_TOO_SMALL = 16402;
    public static final int REMOTE_MEM = 16403;
    public static final int REMOTE_NO_SPACE = 16404;
    public static final int REMOTE_SYS = 16405;
    public static final int LOCAL_MEM = 16406;
    public static final int BAD_ARG = 16407;
    public static final int LIMIT_EXCEEDED = 16408;
    public static final int UNKNOWN_REQUEST = 16409;
    static final int LAST = 16416;
    static final int NUM = 32;
    static final String[] details;

    public SyncException(String msg, int errorCode) {
        super(msg);
        this.errorCode = errorCode;
    }

    public SyncException(String msg) {
        super(msg);
    }

    public String getMessage() {
        return this.getDetailMessage() + ": " + super.getMessage();
    }

    String getDetailMessage() {
        if (16384 <= this.errorCode && this.errorCode < 16416) {
            return details[this.errorCode - 16384];
        }
        return "Unknown";
    }

    String superGetMessage() {
        return super.getMessage();
    }

    static {
        NONE = 0;
        FIRST = 16384;
        UNKNOWN = 16385;
        MORE = 16386;
        FILE_NOT_FOUND = 16387;
        FILE_NOT_OPEN = 16388;
        FILE_OPEN = 16389;
        RECORD_BUSY = 16390;
        RECORD_DELETED = 16391;
        ROM_BASED = 16392;
        READ_ONLY = 16393;
        COMM_NOT_INIT = 16394;
        FILE_ALREADY_EXIST = 16395;
        FILE_ALREADY_OPEN = 16396;
        NO_FILES_OPEN = 16397;
        BAD_OPERATION = 16398;
        REMOTE_BAD_ARG = 16399;
        BAD_ARG_WRAPPER = 16400;
        ARG_MISSING = 16401;
        LOCAL_BUFF_TOO_SMALL = 16402;
        REMOTE_MEM = 16403;
        REMOTE_NO_SPACE = 16404;
        REMOTE_SYS = 16405;
        LOCAL_MEM = 16406;
        BAD_ARG = 16407;
        LIMIT_EXCEEDED = 16408;
        UNKNOWN_REQUEST = 16409;
        LAST = 16416;
        NUM = 32;
        details = new String[]{"None", "First", "More", "File Not Found", "File Not Open", "File Open", "Record Busy", "Record Deleted", "Rom Based", "Read Only", "Comm Not Init", "File Already Exist", "File Already Open", "No Files Open", "Bad Operation", "Remote Bad Arg", "Bad Arg Wrapper", "Arg Missing", "Local Buff Too Small", "Remote Mem", "Remote No Space", "Remote Sys", "Local Memory Exceeded", "Invalid Parameter", "Data Limit Exceeded", "Unknown Request"};
    }
}

