/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import com.sun.pdasync.SyncMgr.CDbList;
import com.sun.pdasync.SyncUtils.ObjDump;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.util.Date;

public class DbList
implements ObjDump {
    private int cardNum;
    private short dbFlags;
    private int dbType;
    private String name = "";
    private int creator;
    private short version;
    private int modNumber;
    private short index;
    private int createDate;
    private int modDate;
    private int backupDate;
    private int miscFlags;
    private int recCount;
    private int reserved;
    private static final int eMiscDbFlagExcludeFromSync = 128;
    private static final int eMiscDbFlagRamBased = 64;
    static final int YEAR_SHIFT_FACTOR = 25;
    static final int MONTH_SHIFT_FACTOR = 21;
    static final int DAY_SHIFT_FACTOR = 16;
    static final int HOUR_SHIFT_FACTOR = 8;
    static final int FIRST_YEAR = 1904;

    public static DbList[] makeDbListArray(int size) {
        DbList[] list = new DbList[size];
        int i = 0;
        while (i < size) {
            list[i] = new DbList();
            ++i;
        }
        return list;
    }

    public void copyToCDbList(CDbList cdbList) {
        cdbList.m_CardNum = this.cardNum;
        cdbList.m_DbFlags_u = this.dbFlags;
        cdbList.m_DbType_u = this.dbType;
        System.arraycopy(this.name.getBytes(), 0, cdbList.m_Name, 0, this.name.length());
        cdbList.m_Creator_u = this.creator;
        cdbList.m_Version_u = this.version;
        cdbList.m_ModNumber_u = this.modNumber;
        cdbList.m_Index_u = this.index;
        cdbList.m_CreateDate = (long)((double)this.createDate * 1000.0);
        cdbList.m_ModDate = (long)((double)this.modDate * 1000.0);
        cdbList.m_BackupDate = (long)((double)this.backupDate * 1000.0);
        cdbList.m_miscFlags = this.miscFlags;
        cdbList.m_RecCount = this.recCount;
        cdbList.m_dwReserved = this.reserved;
    }

    public void copyFromCDbList(CDbList cdbList) {
        this.cardNum = cdbList.m_CardNum;
        this.dbFlags = cdbList.m_DbFlags_u;
        this.dbType = cdbList.m_DbType_u;
        this.name = null;
        this.name = new String(cdbList.m_Name);
        this.creator = cdbList.m_Creator_u;
        this.version = cdbList.m_Version_u;
        this.modNumber = cdbList.m_ModNumber_u;
        this.index = cdbList.m_Index_u;
        this.createDate = (int)((long)((double)cdbList.m_CreateDate / 1000.0) & 0xFFFFFFFFFFFFFFFFL);
        this.modDate = (int)((long)((double)cdbList.m_ModDate / 1000.0) & 0xFFFFFFFFFFFFFFFFL);
        this.backupDate = (int)((long)((double)cdbList.m_BackupDate / 1000.0) & 0xFFFFFFFFFFFFFFFFL);
        this.miscFlags = cdbList.m_miscFlags;
        this.recCount = (int)cdbList.m_RecCount;
        this.reserved = (int)cdbList.m_dwReserved;
    }

    public String toString() {
        return this.name + " flag: 0x" + Integer.toHexString(this.dbFlags) + " type: 0x" + Integer.toHexString(this.dbType) + " creator: 0x" + Integer.toHexString(this.creator);
    }

    public String dumpFormatted(int numTabs) {
        String tabs = SyncUtils.makeTabsString((int)numTabs);
        String nm = new String(this.name);
        String cdStr = this.createDate != 0 ? new Date((long)((double)this.createDate * 1000.0)).toString() : "0";
        String mdStr = this.modDate != 0 ? new Date((long)((double)this.modDate * 1000.0)).toString() : "0";
        String bdStr = this.backupDate != 0 ? new Date((long)((double)this.backupDate * 1000.0)).toString() : "0";
        return tabs + "DbList\n" + tabs + "  {\n" + tabs + "    cardNum:    " + this.cardNum + "\n" + tabs + "    dbFlags:   " + this.dbFlags + "\n" + tabs + "    dbType:     0x" + Integer.toHexString(this.dbType) + "\n" + tabs + "    name:     " + nm + "\n" + tabs + "    creator:    0x" + Integer.toHexString(this.creator) + "\n" + tabs + "    version:  " + this.version + "\n" + tabs + "    modNumber: " + this.modNumber + "\n" + tabs + "    index:  " + this.index + "\n" + tabs + "    createDate:  " + cdStr + "\n" + tabs + "    modDate:  " + mdStr + "\n" + tabs + "    backupDate:  " + bdStr + "\n" + tabs + "    miscFlags:  0x" + Integer.toHexString(this.miscFlags) + "\n" + tabs + "    recCount:  " + this.recCount + "\n" + tabs + "    reserved:  " + this.reserved + "\n" + tabs + "  }\n";
    }

    public String dump() {
        return this.toString();
    }

    public String dumpFormatted() {
        return this.dumpFormatted(0);
    }

    static {
        eMiscDbFlagExcludeFromSync = 128;
        eMiscDbFlagRamBased = 64;
        YEAR_SHIFT_FACTOR = 25;
        MONTH_SHIFT_FACTOR = 21;
        DAY_SHIFT_FACTOR = 16;
        HOUR_SHIFT_FACTOR = 8;
        FIRST_YEAR = 1904;
    }
}

