/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import com.sun.pdasync.Transport.CTransportPAD;
import palm.conduit.SyncDatabaseInfo;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;

public final class CloseDBTester {
    public static CTransportPAD transportPAD;

    public static void main(String[] args) {
        boolean debug = false;
        if (args.length < 1) {
            System.out.println("Usage: CloseDBTester dbname [ -port <com port> ]");
            System.exit(1);
        }
        String dbName = args[0];
        String port = null;
        if (args.length >= 3 && args[1].equals("-port")) {
            port = new String(args[2]);
        }
        System.out.println("dbName = " + dbName);
        if (port == null) {
            port = new String("/dev/term/a");
        }
        try {
            SyncDatabaseInfo dbInfo;
            transportPAD = new CTransportPAD(false);
            long err = transportPAD.MakePlatformSerialPort(port);
            if (err != 0L) {
                System.out.println("Error Making Platform Serial Port: " + err);
            }
            CloseDBTester.transportPAD.m_padState = (short)16384;
            System.out.println("Establishing Connection ...");
            while ((err = transportPAD.PollConnection()) != 0L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                }
            }
            err = transportPAD.EstablishConnection();
            if (err == 0L) {
                System.out.println("Connection Established");
            } else {
                System.out.println("Connection NOT Established");
            }
            SyncManager.sunwSyncInit(transportPAD);
            byte optFlags = -32;
            try {
                dbInfo = SyncManager.findDbByName(optFlags, 0, dbName);
                System.out.println("Before openDB: dbInfo.baseInfo");
                System.out.println(dbInfo.baseInfo.dumpFormatted(2));
            }
            catch (SyncException e) {
                System.out.println("");
                System.out.println("****** Fatal Error:  cannot find database " + dbName + " ******");
                SyncManager.sunwSyncEndOfSync(0);
                System.exit(1);
            }
            int dbHandle = SyncManager.openDB(dbName, 0, 192);
            SyncManager.closeDBEx((byte)dbHandle, (byte)-128);
            dbInfo = SyncManager.findDbByName(optFlags, 0, dbName);
            System.out.println("After closeDBEx: dbInfo.baseInfo");
            System.out.println(dbInfo.baseInfo.dumpFormatted(2));
            SyncManager.sunwSyncEndOfSync(0);
            System.out.println(" ");
            System.out.println("HotSync Complete");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

