/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.IOException;
import java.util.Vector;
import palm.conduit.Category;
import palm.conduit.Log;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class CategoryManager {
    private int db;
    SyncProperties props;
    byte[] bytes;

    public CategoryManager(SyncProperties props, int db) {
        this.props = props;
        this.db = db;
    }

    public Vector getHHCategories() throws IOException {
        this.bytes = SyncManager.readDBAppInfoBlock(this.db, this.props.remoteNames[0]);
        return Category.parseCategories(this.bytes);
    }

    public Vector synchronize(Vector pcCategories) throws IOException {
        Vector hhCategories = this.getHHCategories();
        if (this.props.syncType == 2) {
            return hhCategories;
        }
        if (pcCategories.size() == 0) {
            int i = 0;
            while (i < hhCategories.size()) {
                Category hhCat = (Category)hhCategories.elementAt(i);
                hhCat.setIsModified(false);
                ++i;
            }
            this.writeHHCategories(hhCategories);
            return hhCategories;
        }
        if (this.props.syncType != 3) {
            Category hhCat;
            if (this.props.firstDevice == 1) {
                this.setDirtyCategoryFlags(hhCategories);
            } else if (this.props.firstDevice == 2) {
                this.setDirtyCategoryFlags(pcCategories);
            } else if (this.props.syncType == 1) {
                this.setDirtyCategoryFlags(hhCategories);
            }
            int i = 0;
            while (i < hhCategories.size()) {
                hhCat = (Category)hhCategories.elementAt(i);
                boolean deleteCat = true;
                if (!hhCat.getName().equals("") && !hhCat.isModified() && this.matchName(hhCat.getName(), pcCategories) == null && this.matchId(hhCat.getId(), pcCategories) == null) {
                    try {
                        SyncManager.changeCategory(this.db, hhCat.getIndex(), 0);
                    }
                    catch (SyncException e) {
                        Log.AddEntry("Error Changing Categories", -1, false);
                        e.printStackTrace();
                        deleteCat = false;
                    }
                    if (deleteCat) {
                        Log.AddEntry("Hand-Held Category Deleted: " + hhCat.getName(), -1, false);
                        hhCat.delete();
                    }
                } else {
                    hhCat.setIsModified(false);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < pcCategories.size()) {
                Category pcCat = (Category)pcCategories.elementAt(i2);
                if (!pcCat.getName().equals("")) {
                    hhCat = this.matchName(pcCat.getName(), hhCategories);
                    if (hhCat != null) {
                        if (pcCat.getIndex() != hhCat.getIndex()) {
                            pcCat.setIndex(hhCat.getIndex());
                        }
                    } else {
                        hhCat = this.matchId(pcCat.getId(), hhCategories);
                        if (hhCat != null) {
                            if (pcCat.isModified()) {
                                hhCat.setName(pcCat.getName());
                            } else if (pcCat.getIndex() != hhCat.getIndex()) {
                                pcCat.setIndex(hhCat.getIndex());
                            }
                        } else if (!pcCat.isModified()) {
                            Log.AddEntry("Desktop Category Deleted: " + pcCat.getName(), -1, false);
                            pcCat.delete();
                        } else {
                            hhCat = (Category)hhCategories.elementAt(pcCat.getIndex());
                            if (hhCat.getName().equals("")) {
                                hhCat.setName(pcCat.getName());
                                hhCat.setId(pcCat.getId());
                            } else {
                                int nextIndex = this.getNextIndex(hhCategories);
                                if (nextIndex == -1) {
                                    Log.AddEntry("Too Many Categories. Category not added to hand-held device: " + pcCat.getName(), -1, false);
                                } else {
                                    pcCat.setIndex(nextIndex);
                                    hhCat = (Category)hhCategories.elementAt(nextIndex);
                                    hhCat.setName(pcCat.getName());
                                    hhCat.setId(pcCat.getId());
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        pcCategories = hhCategories;
        this.writeHHCategories(hhCategories);
        return hhCategories;
    }

    public void writeHHCategories(Vector hhCategories) throws IOException {
        byte[] tmp = Category.toBytes(hhCategories);
        System.arraycopy(tmp, 0, this.bytes, 0, tmp.length);
        SyncManager.writeDBAppInfoBlock(this.db, this.props.remoteNames[0], this.bytes);
    }

    private void setDirtyCategoryFlags(Vector hhCategories) {
        int i = 0;
        while (i < hhCategories.size()) {
            Category tempCategory = (Category)hhCategories.elementAt(i);
            tempCategory.setIsModified(true);
            ++i;
        }
    }

    private Category matchName(String name, Vector categories) {
        int i = 0;
        while (i < categories.size()) {
            Category category = (Category)categories.elementAt(i);
            String categoryName = category.getName();
            if (categoryName != "" && name.equals(categoryName)) {
                return category;
            }
            ++i;
        }
        return null;
    }

    private Category matchId(int id, Vector categories) {
        int i = 0;
        while (i < categories.size()) {
            Category category = (Category)categories.elementAt(i);
            if (id == category.getId() && id != 0) {
                return category;
            }
            ++i;
        }
        return null;
    }

    private int getNextIndex(Vector categories) {
        int nextIndex = -1;
        int i = 0;
        while (i < categories.size()) {
            Category tempCategory = (Category)categories.elementAt(i);
            if (tempCategory.getName().equals("")) {
                nextIndex = tempCategory.getIndex();
                return nextIndex;
            }
            ++i;
        }
        return nextIndex;
    }
}

