/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class Category
implements Serializable {
    public int id;
    public int index;
    public String name;
    public boolean isModified;
    public static final int MAX_CATEGORIES = 16;
    public static final int CATEGORY_LENGTH = 16;

    public Category() {
    }

    public Category(String name) {
        this(name, 0, 0, false);
    }

    public Category(String name, int id, int index) {
        this(name, id, index, false);
    }

    public Category(String name, int id, int index, boolean isModified) {
        this.name = name;
        this.id = id;
        this.index = index;
        this.isModified = isModified;
    }

    public static Vector parseCategories(byte[] bytes) throws IOException {
        ByteArrayInputStream nameBytes = new ByteArrayInputStream(bytes, 0, 258);
        DataInputStream nameData = new DataInputStream(nameBytes);
        ByteArrayInputStream idBytes = new ByteArrayInputStream(bytes, 258, 16);
        DataInputStream idData = new DataInputStream(idBytes);
        Vector<Category> categories = new Vector<Category>(16);
        short dirtyFlags = nameData.readShort();
        int dirtyBit = 1;
        int i = 0;
        while (i < 16) {
            int index = i;
            int id = idData.read();
            String name = "";
            boolean isModified = (dirtyBit & dirtyFlags) > 0;
            boolean nameEndFound = false;
            int j = 0;
            while (j < 16) {
                byte c = (byte)nameData.read();
                if (c == 0) {
                    nameEndFound = true;
                } else if (!nameEndFound) {
                    name = name + (char)c;
                }
                ++j;
            }
            categories.addElement(new Category(name, id, index, isModified));
            dirtyBit <<= 1;
            ++i;
        }
        return categories;
    }

    public static byte[] toBytes(Vector categories) throws IOException {
        if (categories.size() > 16) {
            throw new IOException("Error: maximum categories exceeded");
        }
        byte[] bytes = new byte[274];
        int dirtyFlags = 0;
        int dirtyBit = 1;
        int i = 0;
        while (i < 16) {
            Category cat = (Category)categories.elementAt(i);
            if (cat.isModified()) {
                dirtyFlags |= dirtyBit;
            }
            dirtyBit <<= 1;
            String name = cat.getName();
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            System.arraycopy(name.getBytes(), 0, bytes, 2 + 16 * i, name.length());
            bytes[258 + i] = (byte)cat.getId();
            ++i;
        }
        bytes[0] = (byte)(dirtyBit >> 8);
        bytes[1] = (byte)(dirtyBit & 0xF);
        return bytes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setIsModified(boolean isModified) {
        this.isModified = isModified;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void delete() {
        this.name = "";
        this.id = 0;
        this.index = 0;
        this.isModified = false;
    }

    public String toFormattedString() {
        return "Category: {\n  category id: " + this.id + "\n" + "  category index: " + this.index + "\n" + "  category name: " + this.name + "\n" + "  is modified: " + this.isModified + "\n" + "}\n";
    }

    static {
        MAX_CATEGORIES = 16;
        CATEGORY_LENGTH = 16;
    }
}

