/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import com.sun.pdasync.SyncMgr.CRawPreferenceInfo;

public class AppPreferenceInfo {
    public short version;
    public int creator;
    public short prefId;
    public short reqBytes;
    public short retBytes;
    public short actSize;
    public int backedUp;
    public int nBytes;
    private int nativeBytes;
    private int reserved;
    private byte[] bytes;

    AppPreferenceInfo(int creator, short prefId, short reqBytes, short retBytes, boolean backedUp, byte[] bytes) {
        this.creator = creator;
        this.prefId = prefId;
        this.reqBytes = reqBytes;
        this.retBytes = retBytes;
        this.backedUp = backedUp ? 1 : 0;
        this.setBytes(bytes);
    }

    AppPreferenceInfo(short version, int creator, short prefId, boolean backedUp, byte[] bytes) {
        this.version = version;
        this.creator = creator;
        this.prefId = prefId;
        this.backedUp = (byte)(backedUp ? 1 : 0);
        this.setBytes(bytes);
    }

    public void copyToCRawPreferenceInfo(CRawPreferenceInfo cprefInfo) {
        cprefInfo.m_version_u = new short[1];
        cprefInfo.m_version_u[0] = this.version;
        cprefInfo.m_creator_u = this.creator;
        cprefInfo.m_prefId_u = this.prefId;
        cprefInfo.m_reqBytes_u = this.reqBytes;
        cprefInfo.m_retBytes_u = new short[1];
        cprefInfo.m_retBytes_u[0] = this.retBytes;
        cprefInfo.m_actSize_u = new short[1];
        cprefInfo.m_actSize_u[0] = this.actSize;
        cprefInfo.m_backedUp = this.backedUp != 0;
        cprefInfo.m_nBytes = this.nBytes;
        cprefInfo.m_pBytes = this.bytes;
        cprefInfo.m_dwReserved_u = this.reserved;
    }

    public void copyFromCRawPreferenceInfo(CRawPreferenceInfo cprefInfo) {
        this.version = cprefInfo.m_version_u[0];
        this.creator = cprefInfo.m_creator_u;
        this.prefId = cprefInfo.m_prefId_u;
        this.reqBytes = cprefInfo.m_reqBytes_u;
        this.retBytes = cprefInfo.m_retBytes_u[0];
        this.actSize = cprefInfo.m_actSize_u[0];
        this.backedUp = !cprefInfo.m_backedUp ? 0 : 1;
        this.nBytes = (int)cprefInfo.m_nBytes;
        this.bytes = cprefInfo.m_pBytes;
        this.reserved = cprefInfo.m_dwReserved_u;
    }

    public boolean isBackedUp() {
        return this.backedUp != 0;
    }

    public void setBackedUp(boolean flag) {
        this.backedUp = flag ? 1 : 0;
    }

    public void setBytes(byte[] bytes) {
        this.nBytes = bytes.length;
        this.reqBytes = (short)this.nBytes;
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

