/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import palm.conduit.AbstractRecord;

public class AddressRecord
extends AbstractRecord {
    private int[] phoneLabelId = new int[]{0, 0, 0, 0, 0};
    private int displayPhone = 0;
    private String name = null;
    private String firstName = null;
    private String company = null;
    private String[] phones = new String[]{null, null, null, null, null};
    private String address = null;
    private String city = null;
    private String state = null;
    private String zipCode = null;
    private String country = null;
    private String[] customs = new String[]{null, null, null, null, null};
    private String note = null;
    private static String[] phoneLabelText = new String[]{"Work", "Home", "Fax", "Other", "E-mail", "Main", "Pager", "Mobile"};

    public static String getPhoneLabelText(int i) {
        return phoneLabelText[i];
    }

    public int getPhoneLabelId(int index) {
        return this.phoneLabelId[index];
    }

    public void setPhoneLabelId(int index, int phone) {
        this.phoneLabelId[index] = phone;
    }

    public int getDisplayPhone() {
        return this.displayPhone;
    }

    public void setDisplayPhone(int displayPhone) {
        this.displayPhone = displayPhone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.nullIfEmpty(name);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = this.nullIfEmpty(firstName);
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = this.nullIfEmpty(company);
    }

    public String getPhone(int i) {
        return this.phones[i];
    }

    public void setPhone(int index, String phone) {
        this.phones[index] = this.nullIfEmpty(phone);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = this.nullIfEmpty(address);
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = this.nullIfEmpty(city);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = this.nullIfEmpty(state);
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = this.nullIfEmpty(zipCode);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = this.nullIfEmpty(country);
    }

    public String getCustom(int index) {
        return this.customs[index];
    }

    public void setCustom(int index, String custom) {
        this.customs[index] = this.nullIfEmpty(custom);
    }

    public String getTitle() {
        return this.customs[0];
    }

    public void setTitle(String title) {
        this.setCustom(0, title);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = this.nullIfEmpty(note);
    }

    public void writeData(DataOutputStream out) throws IOException {
        int options = (this.displayPhone & 0xF) - 1;
        int i = 5;
        i = 0;
        while (i < 5) {
            options <<= 4;
            options |= this.phoneLabelId[4 - i] & 0xF;
            ++i;
        }
        out.writeInt(options);
        int flags = 0;
        if (this.note != null) {
            flags |= 1;
        }
        flags <<= 1;
        i = 5;
        while (i-- > 0) {
            if (this.customs[i] != null) {
                flags |= 1;
            }
            flags <<= 1;
        }
        if (this.country != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.zipCode != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.state != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.city != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.address != null) {
            flags |= 1;
        }
        flags <<= 1;
        i = 5;
        while (i-- > 0) {
            if (this.phones[i] != null) {
                flags |= 1;
            }
            flags <<= 1;
        }
        if (this.company != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.firstName != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.name != null) {
            flags |= 1;
        }
        out.writeInt(flags);
        out.write(0);
        if (this.name != null) {
            out.write(this.name.getBytes());
            out.write(0);
        }
        if (this.firstName != null) {
            out.write(this.firstName.getBytes());
            out.write(0);
        }
        if (this.company != null) {
            out.write(this.company.getBytes());
            out.write(0);
        }
        i = 0;
        while (i < 5) {
            if (this.phones[i] != null) {
                out.write(this.phones[i].getBytes());
                out.write(0);
            }
            ++i;
        }
        if (this.address != null) {
            out.write(this.address.getBytes());
            out.write(0);
        }
        if (this.city != null) {
            out.write(this.city.getBytes());
            out.write(0);
        }
        if (this.state != null) {
            out.write(this.state.getBytes());
            out.write(0);
        }
        if (this.zipCode != null) {
            out.write(this.zipCode.getBytes());
            out.write(0);
        }
        if (this.country != null) {
            out.write(this.country.getBytes());
            out.write(0);
        }
        i = 0;
        while (i < 5) {
            if (this.customs[i] != null) {
                out.write(this.customs[i].getBytes());
                out.write(0);
            }
            ++i;
        }
        if (this.note != null) {
            AbstractRecord.writeCString(out, AbstractRecord.stringWithoutCarriageReturns(this.note));
        }
    }

    public void readData(DataInputStream in) throws IOException {
        int options = in.readInt();
        int i = 0;
        while (i < 5) {
            this.phoneLabelId[i] = options & 0xF;
            options >>>= 4;
            ++i;
        }
        this.displayPhone = (options & 0xF) + 1;
        int flags = in.readInt();
        in.read();
        this.name = (flags & 1) == 1 ? AbstractRecord.readCString(in) : null;
        this.firstName = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString(in) : null;
        this.company = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString(in) : null;
        flags >>>= 1;
        i = 0;
        while (i < 5) {
            this.phones[i] = (flags & 1) == 1 ? AbstractRecord.readCString(in) : null;
            flags >>>= 1;
            ++i;
        }
        this.address = (flags & 1) == 1 ? AbstractRecord.readCString(in) : null;
        this.city = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString(in) : null;
        this.state = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString(in) : null;
        this.zipCode = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString(in) : null;
        this.country = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString(in) : null;
        flags >>>= 1;
        i = 0;
        while (i < 5) {
            this.customs[i] = (flags & 1) == 1 ? AbstractRecord.readCString(in) : null;
            flags >>>= 1;
            ++i;
        }
        this.note = (flags & 1) == 1 ? AbstractRecord.readCString(in) : null;
        flags >>>= 1;
    }

    public String toString() {
        return "Address record: " + this.getFirstName() + " " + this.getName() + " " + super.toString();
    }

    public String toFormattedString() {
        return "Address record: {\r\n  name: " + this.getName() + "\r\n" + "  firstName: " + this.getFirstName() + "\r\n" + "  title: " + this.getTitle() + "\r\n" + "  company: " + this.getCompany() + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(0)) + ": " + this.getPhone(0) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(1)) + ": " + this.getPhone(1) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(2)) + ": " + this.getPhone(2) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(3)) + ": " + this.getPhone(3) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(4)) + ": " + this.getPhone(4) + "\r\n" + "  displayPhone: " + AddressRecord.getPhoneLabelText(this.getDisplayPhone() - 1) + "\r\n" + "  address: " + this.getAddress() + "\r\n" + "  city: " + this.getCity() + "\r\n" + "  state: " + this.getState() + "\r\n" + "  zipCode: " + this.getZipCode() + "\r\n" + "  country: " + this.getCountry() + "\r\n" + "  custom1: " + this.getCustom(1) + "\r\n" + "  custom2: " + this.getCustom(2) + "\r\n" + "  custom3: " + this.getCustom(3) + "\r\n" + "  custom4: " + this.getCustom(4) + "\r\n" + "  note: " + this.getNote() + "\r\n" + "}\r\n" + super.toFormattedString();
    }
}

