/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncMgr;

import com.sun.pdasync.SyncMgr.CCardInfo;
import com.sun.pdasync.SyncMgr.CCmdCloseDB;
import com.sun.pdasync.SyncMgr.CCmdDBRecordCount;
import com.sun.pdasync.SyncMgr.CCmdDeleteRecord;
import com.sun.pdasync.SyncMgr.CCmdEndOfSync;
import com.sun.pdasync.SyncMgr.CCmdFindDbByName;
import com.sun.pdasync.SyncMgr.CCmdFindDbByTypeCreator;
import com.sun.pdasync.SyncMgr.CCmdGetSysDateTime;
import com.sun.pdasync.SyncMgr.CCmdOpenDB;
import com.sun.pdasync.SyncMgr.CCmdReadAppBlock;
import com.sun.pdasync.SyncMgr.CCmdReadCardInfo;
import com.sun.pdasync.SyncMgr.CCmdReadOpenDbInfo;
import com.sun.pdasync.SyncMgr.CCmdReadRecordIndex;
import com.sun.pdasync.SyncMgr.CCmdReadSystemInfo;
import com.sun.pdasync.SyncMgr.CCmdReadUserInfo;
import com.sun.pdasync.SyncMgr.CCmdRebootSystem;
import com.sun.pdasync.SyncMgr.CCmdWriteRecordId;
import com.sun.pdasync.SyncMgr.CDTCommandBase;
import com.sun.pdasync.SyncMgr.CDTDateTime;
import com.sun.pdasync.SyncMgr.CDTResponseBase;
import com.sun.pdasync.SyncMgr.CDTWriteRecord;
import com.sun.pdasync.SyncMgr.CDbGenInfo;
import com.sun.pdasync.SyncMgr.CRawRecordInfo;
import com.sun.pdasync.SyncMgr.CRespCloseDB;
import com.sun.pdasync.SyncMgr.CRespDBRecordCount;
import com.sun.pdasync.SyncMgr.CRespEndOfSync;
import com.sun.pdasync.SyncMgr.CRespGetSysDateTime;
import com.sun.pdasync.SyncMgr.CRespOpenDB;
import com.sun.pdasync.SyncMgr.CRespReadAppBlock;
import com.sun.pdasync.SyncMgr.CRespReadCardInfo;
import com.sun.pdasync.SyncMgr.CRespReadDbInfo;
import com.sun.pdasync.SyncMgr.CRespReadRecord;
import com.sun.pdasync.SyncMgr.CRespReadSystemInfo;
import com.sun.pdasync.SyncMgr.CRespReadUserInfo;
import com.sun.pdasync.SyncMgr.CRespRebootSystem;
import com.sun.pdasync.SyncMgr.CRespSimpleResponse;
import com.sun.pdasync.SyncMgr.CRespWriteRecord;
import com.sun.pdasync.SyncMgr.CSyncFindDbByNameParams;
import com.sun.pdasync.SyncMgr.CSyncFindDbByTypeCreatorParams;
import com.sun.pdasync.SyncMgr.CSyncReadOpenDbInfoParams;
import com.sun.pdasync.SyncMgr.CSystemInfo;
import com.sun.pdasync.SyncMgr.CUserIDInfo;
import com.sun.pdasync.SyncMgr.SyncDatabaseInfoType;
import com.sun.pdasync.SyncMgr.SyncDefs;
import com.sun.pdasync.SyncMgr.m_CachedSysInfoType;
import com.sun.pdasync.SyncUtils.BufferedBytes;
import com.sun.pdasync.Transport.CTransportPAD;

public final class SyncMgrTester {
    public static CTransportPAD transport;
    public static String filename;
    public static byte[] fName;
    public static final long PRV_MAX_PALMOS_V1X_REC_SIZE = 64720L;
    public static final long PRV_MAX_PALMOS_V2X_REC_SIZE = 64720L;
    public static final long PRV_MAX_PALMOS_V3X_REC_SIZE = 65505L;
    public static m_CachedSysInfoType m_CachedSysInfo;

    public long ReadDBAppInfoBlock(byte fHandle, CDbGenInfo rInfo) {
        byte[] pBlockData = null;
        int[] dwBytesToCopy_u = new int[1];
        CCmdReadAppBlock cmdObj = new CCmdReadAppBlock(fHandle, rInfo.m_TotalBytes_u);
        CRespReadAppBlock respObj = new CRespReadAppBlock();
        rInfo.m_BytesRead_u = 0;
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L && retval == 0L) {
            rInfo.m_BytesRead_u = respObj.GetAppBlockSize();
            pBlockData = respObj.GetRawBlockData(dwBytesToCopy_u);
            if (dwBytesToCopy_u[0] > rInfo.m_TotalBytes_u) {
                dwBytesToCopy_u[0] = rInfo.m_TotalBytes_u;
            }
            if (dwBytesToCopy_u[0] != 0 && rInfo.m_pBytes_u != null && pBlockData != null) {
                System.out.println("pBlockData.length " + pBlockData.length + " " + rInfo.m_pBytes_u.length + " " + dwBytesToCopy_u[0]);
                System.arraycopy(pBlockData, 0, rInfo.m_pBytes_u, 0, dwBytesToCopy_u[0]);
            }
        }
        return retval;
    }

    public static long ResetSystem() {
        CCmdRebootSystem cmdObj = new CCmdRebootSystem();
        CRespRebootSystem respObj = new CRespRebootSystem();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            // empty if block
        }
        return retval;
    }

    public static long MaxRemoteRecSize(int[] rdwMaxRecSize) {
        long retval = 0L;
        CSystemInfo sysInfo = new CSystemInfo();
        m_CachedSysInfo = new m_CachedSysInfoType();
        rdwMaxRecSize[0] = 0;
        SyncMgrTester.m_CachedSysInfo.m_bSysInfoCached = true;
        if (SyncMgrTester.m_CachedSysInfo.m_bSysInfoCached) {
            SyncMgrTester.m_CachedSysInfo.m_bSysInfoCached = false;
            retval = SyncMgrTester.ReadSystemInfo(sysInfo);
        }
        if (retval == 0L) {
            rdwMaxRecSize[0] = SyncMgrTester.m_CachedSysInfo.m_dwMaxRecSize_u;
        }
        return retval;
    }

    public static long ReadSystemInfo(CSystemInfo rInfo) {
        CRespReadSystemInfo respObj;
        CCmdReadSystemInfo cmdObj;
        long retval = 0L;
        int prodIdLen_u = 0;
        if (!SyncMgrTester.m_CachedSysInfo.m_bSysInfoCached && (retval = SyncMgrTester.SendDTCommand(cmdObj = new CCmdReadSystemInfo(), respObj = new CRespReadSystemInfo())) == 0L) {
            byte[] pRawBytes;
            prodIdLen_u = respObj.GetProductIdLength();
            if ((prodIdLen_u & 0xFF) > 0 && (pRawBytes = respObj.GetProductIdText()) != null) {
                SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_ProductIdText_u = new byte[prodIdLen_u];
                if (SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_ProductIdText_u != null) {
                    int i = 0;
                    while (i < prodIdLen_u) {
                        SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_ProductIdText_u[i] = pRawBytes[i];
                        ++i;
                    }
                }
            }
            SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_ProdIdLength_u = (byte)prodIdLen_u;
            SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_RomSoftVersion_u = respObj.GetRomVersion();
            SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_LocalId_u = respObj.GetLocalId();
            int[] maxRecSize_u = new int[1];
            if (respObj.GetProdCompInfo(SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo, maxRecSize_u)) {
                if (SyncDefs.SYNCROMVMAJOR(SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_RomSoftVersion_u) == 1L) {
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.dlpVer.wMajor_u = 1;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.dlpVer.wMinor_u = 0;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.compVer.wMajor_u = 1;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.compVer.wMinor_u = 0;
                    SyncMgrTester.m_CachedSysInfo.m_dwMaxRecSize_u = 64720;
                } else if (SyncDefs.SYNCROMVMAJOR(SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_RomSoftVersion_u) == 2L) {
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.dlpVer.wMajor_u = 1;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.dlpVer.wMinor_u = 1;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.compVer.wMajor_u = (short)2;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.compVer.wMinor_u = 0;
                    SyncMgrTester.m_CachedSysInfo.m_dwMaxRecSize_u = 64720;
                } else if (SyncDefs.SYNCROMVMAJOR(SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_RomSoftVersion_u) == 3L) {
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.dlpVer.wMajor_u = 1;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.dlpVer.wMinor_u = (short)2;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.compVer.wMajor_u = (short)3;
                    SyncMgrTester.m_CachedSysInfo.m_rmtProdCompInfo.compVer.wMinor_u = 0;
                    SyncMgrTester.m_CachedSysInfo.m_dwMaxRecSize_u = 65505;
                }
            } else {
                SyncMgrTester.m_CachedSysInfo.m_dwMaxRecSize_u = maxRecSize_u[0];
            }
            if (retval == 0L) {
                SyncMgrTester.m_CachedSysInfo.m_bSysInfoCached = true;
            }
        }
        if (retval == 0L) {
            if (SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_ProductIdText_u != null) {
                int nBytesToCopy = prodIdLen_u & 0xFF;
                if (nBytesToCopy > rInfo.m_AllocedLen_u) {
                    nBytesToCopy = rInfo.m_AllocedLen_u & 0xFF;
                }
                if (nBytesToCopy > 0) {
                    System.arraycopy(SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_ProductIdText_u, 0, rInfo.m_ProductIdText_u, 0, nBytesToCopy);
                }
            }
            rInfo.m_ProdIdLength_u = (byte)prodIdLen_u;
            rInfo.m_RomSoftVersion_u = SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_RomSoftVersion_u;
            rInfo.m_LocalId_u = SyncMgrTester.m_CachedSysInfo.m_rmtSysInfo.m_LocalId_u;
        }
        return retval;
    }

    public static long DeleteRecord(CRawRecordInfo rRawRec, int opt) {
        CCmdDeleteRecord cmdObj = new CCmdDeleteRecord(rRawRec.m_FileHandle_u, (int)rRawRec.m_RecId, opt);
        CRespSimpleResponse respObj = new CRespSimpleResponse();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            // empty if block
        }
        return retval;
    }

    public static long WriteRecord(CRawRecordInfo rRawRec) {
        CDTWriteRecord writeRec = new CDTWriteRecord();
        writeRec.m_Flags_u = 0;
        writeRec.m_FileId_u = rRawRec.m_FileHandle_u;
        writeRec.m_RecordId_u = (int)rRawRec.m_RecId;
        writeRec.m_Attrib_u = rRawRec.m_Attribs_u;
        writeRec.m_CatId_u = (byte)rRawRec.m_CatId;
        writeRec.m_RecSize_u = (short)rRawRec.m_RecSize_u;
        writeRec.m_pRecBytes_u = rRawRec.m_pBytes_u;
        CCmdWriteRecordId cmdObj = new CCmdWriteRecordId(writeRec);
        CRespWriteRecord respObj = new CRespWriteRecord();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval != 0L) {
            // empty if block
        }
        return retval;
    }

    public static long ReadRecordByIndex(CRawRecordInfo rRawRec) {
        CCmdReadRecordIndex cmdObj = new CCmdReadRecordIndex(rRawRec.m_FileHandle_u, rRawRec.m_RecIndex_u, (short)rRawRec.m_TotalBytes);
        long retval = SyncMgrTester.ReadRecordHelper(cmdObj, rRawRec);
        return retval;
    }

    public static long ReadRecordHelper(CDTCommandBase rCmd, CRawRecordInfo rRawRec) {
        int[] dwBytesToCopy_u = new int[1];
        rRawRec.m_RecId = 0L;
        rRawRec.m_RecIndex_u = 0;
        rRawRec.m_CatId = 0;
        rRawRec.m_RecSize_u = 0;
        rRawRec.m_Attribs_u = 0;
        CRespReadRecord respObj = new CRespReadRecord();
        long retval = SyncMgrTester.SendDTCommand(rCmd, respObj);
        if (retval == 0L && retval == 0L) {
            rRawRec.m_RecId = respObj.GetRecordId();
            rRawRec.m_RecIndex_u = respObj.GetRecordIndex();
            rRawRec.m_CatId = respObj.GetCategoryId();
            rRawRec.m_RecSize_u = respObj.GetRecordSize();
            rRawRec.m_Attribs_u = respObj.GetAttributes();
            BufferedBytes pRecData = respObj.GetRawRecordData(dwBytesToCopy_u);
            if ((long)(dwBytesToCopy_u[0] & 0xFFFF) > rRawRec.m_TotalBytes) {
                dwBytesToCopy_u[0] = (int)rRawRec.m_TotalBytes;
            }
            if (dwBytesToCopy_u[0] != 0 && rRawRec.m_pBytes_u != null && pRecData != null) {
                System.arraycopy(pRecData.bytes, 0, rRawRec.m_pBytes_u, 0, dwBytesToCopy_u[0]);
            }
        }
        return retval;
    }

    public static long FindDbByTypeCreator(CSyncFindDbByTypeCreatorParams rParam, SyncDatabaseInfoType rInfo) {
        CCmdFindDbByTypeCreator cmdObj = new CCmdFindDbByTypeCreator(rParam);
        CRespReadDbInfo respObj = new CRespReadDbInfo();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            long dlpErrCode = respObj.GetDbInfo(rInfo);
        }
        return retval;
    }

    public static long FindDbByName(CSyncFindDbByNameParams rParam, SyncDatabaseInfoType rInfo) {
        CCmdFindDbByName cmdObj = new CCmdFindDbByName(rParam);
        CRespReadDbInfo respObj = new CRespReadDbInfo();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            short dlpErrCode = respObj.GetDbInfo(rInfo);
        }
        return retval;
    }

    public static long ReadSingleCardInfo(CCardInfo rInfo) {
        CCmdReadCardInfo cmdObj = new CCmdReadCardInfo(rInfo.m_CardNo_u);
        CRespReadCardInfo respObj = new CRespReadCardInfo();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            rInfo.m_CardNo_u = respObj.GetCardNo();
            rInfo.m_CardVersion_u = respObj.GetCardVersion();
            rInfo.m_RomSize_u = respObj.GetRomSize();
            rInfo.m_RamSize_u = respObj.GetRamSize();
            rInfo.m_FreeRam_u = respObj.GetFreeRam();
            rInfo.m_CardNameLen_u = respObj.GetCardNameLen();
            rInfo.m_ManufNameLen_u = respObj.GetManufNameLen();
            rInfo.m_CardName[0] = 0;
            rInfo.m_ManufName[0] = 0;
            CDTDateTime tdDate = new CDTDateTime();
            if (respObj.GetCreateDate(tdDate) != 0) {
                rInfo.m_CreateDate = tdDate.DTConvertFromHHDate();
            }
            if ((rInfo.m_CardNameLen_u & 0xFF) > 0) {
                respObj.GetCardName(rInfo.m_CardName, 32);
            }
            if ((rInfo.m_ManufNameLen_u & 0xFF) > 0) {
                // empty if block
            }
            respObj.GetManufName(rInfo.m_ManufName, 32);
            short[] romCount = new short[2];
            romCount[0] = rInfo.m_romDbCount_u[0];
            short[] ramCount = new short[2];
            ramCount[0] = rInfo.m_ramDbCount_u[0];
            respObj.GetDBCounts(romCount, ramCount);
        }
        return retval;
    }

    public static long ReadUserID(CUserIDInfo rInfo) {
        CCmdReadUserInfo cmdObj = new CCmdReadUserInfo();
        CRespReadUserInfo respObj = new CRespReadUserInfo();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            byte[] pName1;
            byte[] pName;
            CDTDateTime hhDate = new CDTDateTime();
            respObj.GetLastSyncDate(hhDate);
            rInfo.m_LastSyncDate = hhDate.DTConvertFromHHDate();
            rInfo.m_ViewerId_u = respObj.GetViewerId();
            rInfo.m_LastSyncPC_u = respObj.GetLastSyncPC();
            rInfo.m_Id_u = respObj.GetUserId();
            rInfo.m_NameLength = respObj.GetNameLength();
            byte remNameSize = respObj.GetNameLength();
            if (remNameSize > 0 && (pName = respObj.GetRemoteUserName()) != null) {
                System.out.println("");
                System.out.println("***** UserName is ***** = " + new String(pName));
                rInfo.m_pName = pName;
            }
            byte passwdLen = respObj.GetPasswdLength();
            rInfo.m_PasswdLength = passwdLen;
            if (passwdLen > 0 && (pName1 = respObj.GetPassword()) != null) {
                rInfo.m_Password = pName1;
            }
        }
        return retval;
    }

    public static long ReadSysDateTime(long[] rDate) {
        CCmdGetSysDateTime cmdObj = new CCmdGetSysDateTime();
        CRespGetSysDateTime respObj = new CRespGetSysDateTime();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            CDTDateTime tdDate = new CDTDateTime();
            respObj.GetDateTime(tdDate);
            System.out.println(" ");
            System.out.println("****** Date ******");
            System.out.println("****** " + tdDate.m_Month_u + "/" + tdDate.m_Day_u + "/" + tdDate.m_Year_u);
            System.out.println(" ");
            System.out.println("****** Time ******");
            System.out.println("****** " + tdDate.m_Hour_u + ":" + tdDate.m_Minute_u + ":" + tdDate.m_Seconds_u);
        }
        return retval;
    }

    public static long EndSyncSessionWithHH(int Status) {
        CCmdEndOfSync cmdObj = new CCmdEndOfSync((short)Status);
        CRespEndOfSync respObj = new CRespEndOfSync();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            // empty if block
        }
        return retval;
    }

    public static long SendDTCommand(CDTCommandBase rCmd, CDTResponseBase rResp) {
        int[] shipSize_u = new int[1];
        int[] respSize_u = new int[1];
        BufferedBytes pResponse = null;
        long err = rCmd.WrapYourself();
        if (err == 0L) {
            shipSize_u[0] = 0;
            byte[] pShip_u = rCmd.GetShipBuffer(shipSize_u);
            pResponse = new BufferedBytes(new byte[shipSize_u[0]]);
            respSize_u[0] = 0;
            err = transport.SendCommand(pShip_u, shipSize_u[0], pResponse, respSize_u);
            if (err == 0L) {
                rResp.SetRecvBuffer(pResponse.bytes, (short)respSize_u[0]);
                err = rResp.UnWrapYourself();
            }
        }
        return err;
    }

    public static long OpenDB(byte[] fName, byte cardNum, byte[] rHandle, byte openMode) {
        CCmdOpenDB cmdObj = new CCmdOpenDB(fName, cardNum, openMode);
        CRespOpenDB respObj = new CRespOpenDB();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            rHandle[0] = respObj.GetFileId();
        }
        return retval;
    }

    public static long CloseDBEx(byte handle, byte bOptFlags) {
        CCmdCloseDB cmdObj = new CCmdCloseDB(handle, bOptFlags);
        CRespCloseDB respObj = new CRespCloseDB();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        System.out.println("");
        if (retval == 0L) {
            System.out.println("Successfully closed DB");
        }
        return retval;
    }

    public static long GetDBRecordCount(byte handle, short[] rNumRecs) {
        CCmdDBRecordCount cmdObj = new CCmdDBRecordCount(handle);
        CRespDBRecordCount respObj = new CRespDBRecordCount();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        System.out.println("");
        if (retval == 0L) {
            rNumRecs[0] = respObj.GetRecordCount();
            System.out.println("NUMBER OF RECORDS FROM ANOTHER COMMAND TO CONFIRM ABOVE COUNT");
            System.out.println("Number of records in the database '" + new String(fName) + "'" + " = " + rNumRecs[0]);
        }
        return retval;
    }

    public static long ReadOpenDbInfo(CSyncReadOpenDbInfoParams rParam, SyncDatabaseInfoType rInfo) {
        CCmdReadOpenDbInfo cmdObj = new CCmdReadOpenDbInfo(rParam);
        CRespReadDbInfo respObj = new CRespReadDbInfo();
        long retval = SyncMgrTester.SendDTCommand(cmdObj, respObj);
        if (retval == 0L) {
            short dlpErrCode = respObj.GetDbInfo(rInfo);
        }
        return retval;
    }

    public static void main(String[] args) {
        long err;
        String port = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-port") && i + 1 < args.length) {
                port = new String(args[i + 1]);
            }
            ++i;
        }
        if (port == null) {
            port = new String("/dev/term/a");
        }
        if ((err = (transport = new CTransportPAD(false)).MakePlatformSerialPort(port)) != 0L) {
            System.out.println("Error Making Platform Serial Port: " + err);
        }
        SyncMgrTester.transport.m_padState = (short)16384;
        err = 99L;
        System.out.println("Establishing Connection ...");
        while ((err = transport.PollConnection()) != 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
        err = transport.EstablishConnection();
        if (err == 0L) {
            System.out.println("Connection Established");
        } else {
            System.out.println("Connection NOT! Established");
        }
        SyncMgrTester tester = new SyncMgrTester();
        long[] i2 = new long[]{0L};
        SyncMgrTester.ReadSysDateTime(i2);
        CUserIDInfo cuser = new CUserIDInfo();
        SyncMgrTester.ReadUserID(cuser);
        byte[] rHandle = new byte[1];
        String filename = new String("MemoDB");
        fName = filename.getBytes();
        fName = new byte[filename.length()];
        fName = filename.getBytes();
        SyncMgrTester.OpenDB(fName, (byte)0, rHandle, (byte)-32);
        System.out.println("****Before ReadDBAppInfoBlock() *****");
        CDbGenInfo rInfo1 = new CDbGenInfo();
        rInfo1.m_TotalBytes_u = (short)1000;
        rInfo1.m_pBytes_u = new byte[1000];
        tester.ReadDBAppInfoBlock(rHandle[0], rInfo1);
        System.out.println("****ReadDBAppInfoBlock() *****" + new String(rInfo1.m_pBytes_u));
        System.out.println("****After ReadDBAppInfoBlock() *****");
        CSyncReadOpenDbInfoParams params = new CSyncReadOpenDbInfoParams();
        params.bOptFlags_u = (byte)-32;
        params.bDbHandle_u = rHandle[0];
        SyncDatabaseInfoType info = new SyncDatabaseInfoType();
        SyncMgrTester.ReadOpenDbInfo(params, info);
        CSyncFindDbByNameParams rParams = new CSyncFindDbByNameParams();
        rParams.bOptFlags_u = (byte)-32;
        rParams.dwCardNum_u = 0;
        filename = new String("MemoDB");
        rParams.pcDatabaseName = filename.getBytes();
        SyncDatabaseInfoType Info = new SyncDatabaseInfoType();
        CSyncFindDbByTypeCreatorParams params1 = new CSyncFindDbByTypeCreatorParams();
        params1.bOptFlags_u = rParams.bOptFlags_u;
        params1.bSrchFlags_u = (byte)-128;
        params1.dwType_u = 0;
        params1.dwCreator_u = 0;
        SyncDatabaseInfoType info1 = new SyncDatabaseInfoType();
        SyncMgrTester.FindDbByTypeCreator(params1, info1);
        SyncMgrTester.FindDbByName(rParams, Info);
        System.out.println("Number of records in the database '" + new String(fName) + "'" + " = " + Info.dwNumRecords_u);
        System.out.println(" ");
        System.out.println("****************************************** ");
        System.out.println("Accessing database ... '" + new String(fName) + "'");
        System.out.println("Number of records in the database '" + new String(fName) + "'" + " = " + info.dwNumRecords_u);
        System.out.println("Total bytes of storage used by database = " + info.dwTotalBytes_u);
        System.out.println("****************************************** ");
        System.out.println(" ");
        short[] records = new short[1];
        SyncMgrTester.GetDBRecordCount(rHandle[0], records);
        CRawRecordInfo rRawRec = new CRawRecordInfo();
        byte[] bytes = new byte[8192];
        rRawRec.m_FileHandle_u = rHandle[0];
        rRawRec.m_RecIndex_u = 0;
        rRawRec.m_RecId = 0L;
        rRawRec.m_pBytes_u = bytes;
        rRawRec.m_TotalBytes = 8192L;
        SyncMgrTester.ReadRecordByIndex(rRawRec);
        System.out.println("ReadRecordByIndex - index is = " + rRawRec.m_RecIndex_u + " " + new String(rRawRec.m_pBytes_u));
        System.out.println("ReadRecordByIndex - ID is = " + rRawRec.m_RecId + " " + new String(rRawRec.m_pBytes_u));
        System.out.println("***********************");
        CRawRecordInfo writeRec = new CRawRecordInfo();
        writeRec.m_FileHandle_u = rHandle[0];
        writeRec.m_RecIndex_u = 1;
        writeRec.m_RecId = 0L;
        filename = new String("If this message shows up in your Memo List then Writing records to the HH is working");
        bytes = filename.getBytes();
        writeRec.m_pBytes_u = bytes;
        writeRec.m_TotalBytes = bytes.length;
        writeRec.m_RecSize_u = bytes.length;
        CRawRecordInfo deleteRec = new CRawRecordInfo();
        deleteRec.m_FileHandle_u = rHandle[0];
        deleteRec.m_RecId = rRawRec.m_RecId;
        CCardInfo rInfo = new CCardInfo();
        rInfo.m_CardNo_u = 0;
        SyncMgrTester.ReadSingleCardInfo(rInfo);
        int[] recSize = new int[1];
        System.out.println("");
        SyncMgrTester.MaxRemoteRecSize(recSize);
        System.out.println("");
        System.out.println("****MaxRemoteRecSize = " + recSize[0] + "*****");
        System.out.println("CardName is = '" + new String(rInfo.m_CardName) + "'" + " = " + " Manufacture name = " + new String(rInfo.m_ManufName));
        SyncMgrTester.CloseDBEx(rHandle[0], (byte)-128);
        SyncMgrTester.EndSyncSessionWithHH(0);
        System.out.println(" ");
        System.out.println("HotSync complete.");
    }

    static {
        filename = new String("AddressDB");
        PRV_MAX_PALMOS_V1X_REC_SIZE = 64720L;
        PRV_MAX_PALMOS_V2X_REC_SIZE = 64720L;
        PRV_MAX_PALMOS_V3X_REC_SIZE = 65505L;
    }
}

