/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Registry;

import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.Registry.ConduitRegInfo;
import com.sun.pdasync.Registry.ConduitStateInfo;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class Registry
implements Serializable {
    private static Locale theLocale;
    private static ResourceBundle regRes;
    private static final String USR = "usr";
    private static final String DT = "dt";
    private static final String PACKAGE = "sdtpdasync";
    private static final String ETC = "etc";
    private static final String LIB = "lib";
    private static final String REG_FILE = "conduit_info";
    private static final String STATE_FILE = "conduit_state";
    public static final String DEFAULT_CONDUITS;
    public static final String SYSTEM_CONDUITS;
    public static final String PERSONAL_CONDUITS;
    public static final String CONDUIT_STATE;
    public static final int SUCCESS = 0;
    public static final int CONDUIT_NOT_EXIST = 1;
    public static final int REGISTRY_NOT_EXIST = 2;
    public static final int IO_ERROR = 3;
    public static final int REGISTRY_DAMAGED = 4;
    public static final int UNKNOWN_ERROR = 99;
    protected Vector stateList;
    protected Vector conduitList = new Vector();
    private String feedback;

    /*
     * WARNING - void declaration
     */
    protected static int buildFromRegistry(String fileName, Vector clist) {
        int ret = 0;
        File conduitRegFile = new File(fileName);
        if (conduitRegFile.exists() && conduitRegFile.isFile()) {
            BufferedReader buffer;
            try {
                FileReader reader = new FileReader(conduitRegFile);
                buffer = new BufferedReader(reader);
            }
            catch (FileNotFoundException ex) {
                return 3;
            }
            try {
                String line;
                while ((line = buffer.readLine()) != null) {
                    void var2_9;
                    if (var2_9.charAt(0) == '#') continue;
                    ConduitRegInfo conduitInfo = new ConduitRegInfo();
                    if (conduitInfo.parseLine((String)var2_9)) {
                        if (Registry.hasConduit(clist, conduitInfo)) continue;
                        clist.addElement(conduitInfo);
                        continue;
                    }
                    ret = 4;
                }
                buffer.close();
            }
            catch (IOException ex) {
                ret = 3;
            }
            return ret;
        }
        return 2;
    }

    private static boolean hasConduit(Vector clist, ConduitRegInfo conduit) {
        if (clist.contains(conduit)) {
            return true;
        }
        Enumeration conduits = clist.elements();
        while (conduits.hasMoreElements()) {
            ConduitRegInfo aConduit = (ConduitRegInfo)conduits.nextElement();
            if (!aConduit.isSame(conduit)) continue;
            return true;
        }
        return false;
    }

    protected static boolean saveRegistryFile(String regFile, ConduitRegInfo conduit) {
        try {
            FileWriter writer = new FileWriter(regFile, true);
            BufferedWriter buffer = new BufferedWriter(writer);
            try {
                buffer.write(conduit.encodeConduitInfo());
                buffer.newLine();
                buffer.flush();
                buffer.close();
            }
            catch (IOException ex) {
                Logger.doDebugLogging((String)"IO Excepton: writing out conduit info", (int)4);
                return false;
            }
        }
        catch (IOException ex) {
            Logger.doDebugLogging((String)"Adding conduit info.\nIO Exception: creation of FileWriter and buffers", (int)4);
            return false;
        }
        return true;
    }

    public static boolean addConduitToRegistry(ConduitRegInfo conduit, Vector clist, String regFile) {
        if (regFile.equals(DEFAULT_CONDUITS)) {
            return false;
        }
        if (regFile.equals(PERSONAL_CONDUITS) && !SyncUtils.mkdirIfNotExist((String)SyncConstants.LIB_DIR_PATH)) {
            Logger.doDebugLogging((String)("Could not create directory: " + SyncConstants.LIB_DIR_PATH), (int)4);
            return false;
        }
        if (Registry.hasConduit(clist, conduit)) {
            return false;
        }
        if (Registry.saveRegistryFile(regFile, conduit)) {
            clist.addElement(conduit);
            return true;
        }
        return false;
    }

    public boolean addConduitToPersonalRegistry(ConduitRegInfo conduit) {
        return Registry.addConduitToRegistry(conduit, this.conduitList, PERSONAL_CONDUITS);
    }

    public boolean addConduitToSystemRegistry(ConduitRegInfo conduit) {
        return Registry.addConduitToRegistry(conduit, this.conduitList, SYSTEM_CONDUITS);
    }

    public void dumpConduitListContents(boolean userEnv) {
        Enumeration conduits;
        if (userEnv) {
            conduits = this.stateList.elements();
            Logger.doDebugLogging((String)("\nNumber of conduits found: " + this.stateList.size()), (int)4);
        } else {
            conduits = this.conduitList.elements();
            Logger.doDebugLogging((String)("\nNumber of conduits found: " + this.conduitList.size()), (int)4);
        }
        while (conduits.hasMoreElements()) {
            ConduitRegInfo aConduit;
            if (userEnv) {
                aConduit = (ConduitStateInfo)conduits.nextElement();
                Logger.doDebugLogging((String)((ConduitStateInfo)aConduit).dumpFormatted(), (int)4);
                continue;
            }
            aConduit = (ConduitRegInfo)conduits.nextElement();
            Logger.doDebugLogging((String)aConduit.dumpFormatted(), (int)4);
        }
        Logger.doDebugLogging((String)"\n", (int)4);
    }

    public void dumpUserConduitList() {
        this.dumpConduitListContents(true);
    }

    public void dumpRegistryConduitList() {
        this.dumpConduitListContents(false);
    }

    protected static ConduitRegInfo findInConduitList(Vector clist, String className) {
        ConduitRegInfo retVal = null;
        Enumeration conduits = clist.elements();
        boolean found = false;
        while (conduits.hasMoreElements() && !found) {
            ConduitRegInfo temp = (ConduitRegInfo)conduits.nextElement();
            if (!temp.getClassName().equals(className)) continue;
            retVal = temp;
            found = true;
        }
        return retVal;
    }

    public ConduitStateInfo findInStateList(String className) {
        ConduitStateInfo retVal = null;
        Enumeration conduits = this.stateList.elements();
        boolean found = false;
        while (conduits.hasMoreElements() && !found) {
            ConduitStateInfo temp = (ConduitStateInfo)conduits.nextElement();
            if (!temp.getClassName().equals(className)) continue;
            retVal = temp;
            found = true;
        }
        return retVal;
    }

    protected boolean saveStateFile() {
        BufferedWriter wBuffer;
        if (!SyncUtils.mkdirIfNotExist((String)SyncConstants.USER_PROPS_DIR_PATH)) {
            Logger.doDebugLogging((String)("Could not create directory: " + SyncConstants.USER_PROPS_DIR_PATH), (int)4);
            return false;
        }
        try {
            FileWriter writer = new FileWriter(CONDUIT_STATE);
            wBuffer = new BufferedWriter(writer);
        }
        catch (IOException ex) {
            Logger.doDebugLogging((String)"Creating state file.\nIO Exception: creation of FileWriter and buffers", (int)4);
            return false;
        }
        Enumeration aList = this.stateList.elements();
        while (aList.hasMoreElements()) {
            try {
                ConduitStateInfo condState = (ConduitStateInfo)aList.nextElement();
                wBuffer.write(condState.encodeStateInfo());
                wBuffer.newLine();
                wBuffer.flush();
            }
            catch (IOException ex) {
                Logger.doDebugLogging((String)"IO Excepton: writing out state info", (int)4);
                return false;
            }
        }
        try {
            wBuffer.close();
        }
        catch (IOException ex) {
            Logger.doDebugLogging((String)"Closing state file.\nIO Exception: closing state info file.", (int)4);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean initConduitState() {
        File stateFile = new File(CONDUIT_STATE);
        if (stateFile.exists()) {
            if (!stateFile.isFile()) {
                return false;
            }
            try {
                ConduitStateInfo state;
                ConduitRegInfo aConduit;
                FileReader reader = new FileReader(stateFile);
                BufferedReader rBuffer = new BufferedReader(reader);
                try {
                    String line;
                    while ((line = rBuffer.readLine()) != null) {
                        void var5_4;
                        StringTokenizer strTok = new StringTokenizer((String)var5_4, "|");
                        if (!strTok.hasMoreTokens()) {
                            return false;
                        }
                        String cname = strTok.nextToken();
                        aConduit = Registry.findInConduitList(this.conduitList, cname);
                        if (aConduit == null) continue;
                        if (!strTok.hasMoreTokens()) {
                            return false;
                        }
                        String active = strTok.nextToken();
                        if (!strTok.hasMoreTokens()) {
                            return false;
                        }
                        String deleted = strTok.nextToken();
                        state = new ConduitStateInfo(aConduit, Boolean.valueOf(active), Boolean.valueOf(deleted));
                        this.stateList.addElement(state);
                    }
                    rBuffer.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                Enumeration aList = this.conduitList.elements();
                while (aList.hasMoreElements()) {
                    aConduit = (ConduitRegInfo)aList.nextElement();
                    if (this.findInStateList(aConduit.getClassName()) != null) continue;
                    state = new ConduitStateInfo(aConduit);
                    this.stateList.addElement(state);
                }
            }
            catch (FileNotFoundException ex) {}
        } else {
            Enumeration aList = this.conduitList.elements();
            while (aList.hasMoreElements()) {
                ConduitRegInfo aConduit = (ConduitRegInfo)aList.nextElement();
                ConduitStateInfo state = new ConduitStateInfo(aConduit);
                this.stateList.addElement(state);
            }
        }
        return this.saveStateFile();
    }

    public int getRegistryCount() {
        return this.conduitList.size();
    }

    public Enumeration getConduitEnumeration() {
        return this.conduitList.elements();
    }

    public Enumeration getStateEnumeration() {
        return this.stateList.elements();
    }

    public void toggleActive(ConduitStateInfo conduit) {
        Logger.doDebugLogging((String)"Conduit list before toggling active state", (int)4);
        this.dumpUserConduitList();
        boolean newState = !conduit.getUsersActiveState();
        this.updateActiveState(conduit, newState);
    }

    public void setActive(ConduitStateInfo conduit, boolean state) {
        boolean curState = conduit.getUsersActiveState();
        if (curState == state) {
            return;
        }
        this.updateActiveState(conduit, state);
    }

    private void updateActiveState(ConduitStateInfo conduit, boolean state) {
        if (!this.stateList.removeElement(conduit)) {
            Logger.doDebugLogging((String)"Could not remove conduit from state list.", (int)4);
        }
        conduit.setUsersActiveState(state);
        this.stateList.addElement(conduit);
        this.saveStateFile();
        Logger.doDebugLogging((String)"Conduit list after updating active state", (int)4);
        this.dumpUserConduitList();
    }

    public void toggleDeleted(ConduitStateInfo conduit) {
        Logger.doDebugLogging((String)("Deleting conduit:\n" + conduit.dumpFormatted()), (int)4);
        boolean newState = !conduit.getUsersDeletedState();
        this.updateDeletedState(conduit, newState);
    }

    public void setDeleted(ConduitStateInfo conduit, boolean state) {
        boolean curState = conduit.getUsersDeletedState();
        if (curState == state) {
            return;
        }
        this.updateDeletedState(conduit, state);
    }

    public boolean getDeleted(ConduitStateInfo conduit) {
        return conduit.getUsersDeletedState();
    }

    private void updateDeletedState(ConduitStateInfo conduit, boolean state) {
        if (!this.stateList.removeElement(conduit)) {
            Logger.doDebugLogging((String)"Could not remove conduit from state list.", (int)4);
        }
        conduit.setUsersDeletedState(state);
        this.stateList.addElement(conduit);
        this.saveStateFile();
    }

    public Registry(boolean readPersonal) {
        this.stateList = new Vector();
        if (readPersonal) {
            Registry.buildFromRegistry(PERSONAL_CONDUITS, this.conduitList);
        }
        Registry.buildFromRegistry(SYSTEM_CONDUITS, this.conduitList);
        Registry.buildFromRegistry(DEFAULT_CONDUITS, this.conduitList);
        if (readPersonal) {
            this.initConduitState();
        }
        this.feedback = new String();
    }

    public Registry() {
        this(true);
    }

    public Registry(String regFile) {
        this.stateList = new Vector();
        File regfile = new File(regFile);
        if (regfile.exists()) {
            Registry.buildFromRegistry(regFile, this.conduitList);
        }
    }

    public void testWrite() {
        ConduitRegInfo testConduit = new ConduitRegInfo();
        testConduit.setClassName("MyConduitClass");
        testConduit.setClassPath("/home/jfunson/temp/MyConduit.jar");
        testConduit.setConduit("MyConduit.jar");
        testConduit.setCreatorID(-1);
        testConduit.setDirectory("testDir");
        testConduit.setFile0(null);
        testConduit.setName("My Conduit");
        testConduit.setModule(0);
        testConduit.setRemote0("remote0");
        testConduit.setVM("Java");
        testConduit.setPriority(0);
        if (this.addConduitToPersonalRegistry(testConduit)) {
            Logger.doDebugLogging((String)"Successfully added conduit to personal registry", (int)4);
        }
    }

    public static boolean rewriteRegistryFile(String file, Vector condList) {
        BufferedWriter buffer;
        try {
            FileWriter writer = new FileWriter(file);
            buffer = new BufferedWriter(writer);
        }
        catch (IOException ex) {
            Logger.doDebugLogging((String)("Rewriting registry file " + file + "\nIO Exception: creation of FileWriter and buffers"), (int)4);
            return false;
        }
        try {
            buffer.write("#");
            buffer.newLine();
            buffer.write("# Conduit Registry File.");
            buffer.newLine();
            buffer.write("#");
            buffer.newLine();
            buffer.write("# DO NOT EDIT OR MANIPULATE BY HAND.");
            buffer.newLine();
            buffer.write("#");
            buffer.newLine();
        }
        catch (IOException ex) {
            Logger.doDebugLogging((String)"Writing out registry preamble.\nIO Exception: writing out conduit info.", (int)4);
        }
        Enumeration conduits = condList.elements();
        while (conduits.hasMoreElements()) {
            ConduitRegInfo aConduit = (ConduitRegInfo)conduits.nextElement();
            try {
                buffer.write(aConduit.encodeConduitInfo());
                buffer.newLine();
            }
            catch (IOException ex) {
                Logger.doDebugLogging((String)"Rewriting registry items\nIO Excepton: writing out conduit info", (int)4);
                return false;
            }
        }
        try {
            buffer.flush();
            buffer.close();
        }
        catch (IOException ex) {
            Logger.doDebugLogging((String)"Closing registry file.\nIO Excepton: writing out conduit info", (int)4);
            return false;
        }
        return true;
    }

    public static void updatePersonal(ConduitStateInfo conduit) {
        Vector<ConduitStateInfo> local = new Vector<ConduitStateInfo>();
        Registry.buildFromRegistry(PERSONAL_CONDUITS, local);
        Logger.doDebugLogging((String)("Updating personal registry with changes for " + conduit.getName() + " conduit."), (int)4);
        if (!Registry.hasConduit(local, conduit)) {
            Registry.addConduitToRegistry(conduit, local, PERSONAL_CONDUITS);
            Logger.doDebugLogging((String)"Conduit appended to personal registry file.", (int)4);
        } else {
            ConduitRegInfo p = Registry.findInConduitList(local, conduit.getClassName());
            local.removeElement(p);
            ConduitStateInfo q = conduit;
            local.addElement(q);
            Registry.rewriteRegistryFile(PERSONAL_CONDUITS, local);
            Logger.doDebugLogging((String)"Personal registry file was rewritten.", (int)4);
        }
    }

    public static int removeConduitFromSystemRegistry(ConduitStateInfo conduit) {
        return Registry.removeFromRegistry(SYSTEM_CONDUITS, conduit);
    }

    public static int removeConduitFromPersonalRegistry(ConduitStateInfo conduit) {
        return Registry.removeFromRegistry(PERSONAL_CONDUITS, conduit);
    }

    public static int removeFromRegistry(String registryFile, ConduitStateInfo conduit) {
        Vector condList = new Vector();
        int ret = 0;
        ret = Registry.buildFromRegistry(registryFile, condList);
        if (ret != 0) {
            Logger.doDebugLogging((String)("removeFromRegistry(): buildFromRegistry() failed for file " + registryFile), (int)4);
            Logger.doDebugLogging((String)("removeFromRegistry(): error code: " + ret), (int)4);
            return ret;
        }
        if (!Registry.hasConduit(condList, conduit)) {
            Logger.doDebugLogging((String)("removeFromRegistry(): specified conduit " + conduit.getName() + " does not exist in registry file " + registryFile), (int)4);
            return 1;
        }
        ConduitRegInfo p = Registry.findInConduitList(condList, conduit.getClassName());
        condList.removeElement(p);
        if (Registry.rewriteRegistryFile(registryFile, condList)) {
            Logger.doDebugLogging((String)("Rewrote registry file: " + registryFile), (int)4);
        } else {
            Logger.doDebugLogging((String)("removeFromRegistry(): error rewriting registry file " + registryFile), (int)4);
            ret = 3;
        }
        return ret;
    }

    public static void main(String[] args) {
        Registry testReg = new Registry();
        testReg.testWrite();
        Registry newReg = new Registry();
        newReg.dumpRegistryConduitList();
        newReg.dumpUserConduitList();
    }

    static {
        try {
            theLocale = Locale.getDefault();
            regRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.RegistryMsgs", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"RegistryConduit: can't find properties");
            Logger.doLogging((String)("RegistryConduit:" + e.getMessage()));
        }
        USR = USR;
        DT = DT;
        PACKAGE = PACKAGE;
        ETC = ETC;
        LIB = LIB;
        REG_FILE = REG_FILE;
        STATE_FILE = STATE_FILE;
        DEFAULT_CONDUITS = SyncConstants.SEPARATOR + USR + SyncConstants.SEPARATOR + DT + SyncConstants.SEPARATOR + "appconfig" + SyncConstants.SEPARATOR + PACKAGE + SyncConstants.SEPARATOR + LIB + SyncConstants.SEPARATOR + REG_FILE;
        SYSTEM_CONDUITS = SyncConstants.SEPARATOR + ETC + SyncConstants.SEPARATOR + DT + SyncConstants.SEPARATOR + "appconfig" + SyncConstants.SEPARATOR + PACKAGE + SyncConstants.SEPARATOR + LIB + SyncConstants.SEPARATOR + REG_FILE;
        PERSONAL_CONDUITS = SyncConstants.LIB_DIR_PATH + SyncConstants.SEPARATOR + REG_FILE;
        CONDUIT_STATE = SyncConstants.USER_PROPS_DIR_PATH + STATE_FILE;
        SUCCESS = 0;
        CONDUIT_NOT_EXIST = 1;
        REGISTRY_NOT_EXIST = 2;
        IO_ERROR = 3;
        REGISTRY_DAMAGED = 4;
        UNKNOWN_ERROR = 99;
    }
}

