/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.HotSync.Associator;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncUtils.ObjDump;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.UserInfo;

public class UserResolver
implements ObjDump {
    private String feedback;
    private static Locale theLocale;
    private static ResourceBundle messages;
    protected static final int NO_USER_ID = 0;
    protected static final int MIN_USER_ID = 255;
    protected static final int MAX_USER_ID = 9999;
    protected Associator assoc;
    protected String storedPilotName;
    protected int storedPilotID;
    protected UserInfo hhInfo;
    protected boolean hasId;
    protected boolean matches;
    protected boolean associated;
    public boolean validUserInfo;
    public int pcAddress;

    public UserResolver() {
        String address;
        Properties startUp = new Properties();
        int ip = 0;
        this.assoc = new Associator(startUp);
        this.hhInfo = new UserInfo(0);
        this.hasId = false;
        this.matches = false;
        this.validUserInfo = false;
        this.storedPilotName = this.assoc.getPalmPilotName();
        this.associated = this.storedPilotName != null && !this.storedPilotName.equals("");
        this.storedPilotID = this.assoc.getPalmPilotId();
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            address = new String("0.0.0.0");
        }
        StringTokenizer strTok = new StringTokenizer(address, ".");
        while (strTok.hasMoreTokens()) {
            ip = (ip << 8) + Integer.parseInt(strTok.nextToken());
        }
        this.pcAddress = ip;
    }

    public int setStoredInfo(String newName, int newID) {
        int ret = 0;
        this.storedPilotName = new String(newName);
        this.storedPilotID = newID;
        this.hasId = true;
        this.matches = true;
        this.saveAssociation();
        if (this.storedPilotID != this.hhInfo.id) {
            this.hhInfo.id = this.storedPilotID;
        }
        return ret;
    }

    public int setStoredInfo() {
        return this.setStoredInfo(this.hhInfo.name, this.hhInfo.id);
    }

    public int saveAssociation() {
        int ret = 0;
        this.assoc.setPalmPilotName(this.storedPilotName);
        this.assoc.setPalmPilotId(this.storedPilotID);
        if (this.assoc.getPalmPilotId() != this.storedPilotID) {
            this.storedPilotID = this.assoc.getPalmPilotId();
        }
        this.assoc.saveProperties();
        return ret;
    }

    public boolean isFirstTimer() {
        return this.validUserInfo && this.hhInfo.id == 0;
    }

    public long readUserInfo() {
        long ret = 0L;
        try {
            ret = SyncManager.sunwSyncReadUserID((UserInfo)this.hhInfo);
            this.validUserInfo = ret == 0L;
            if (this.hhInfo.name != null && !this.hhInfo.name.equals("")) {
                this.hasId = true;
                this.matches = this.storedPilotName.equals(this.hhInfo.name) && this.storedPilotID == this.hhInfo.id;
            }
        }
        catch (SyncException ex) {
            this.feedback = messages.getString("Failed to retrieve user info from handheld: ") + ex.getMessage();
            Logger.doLogging((String)this.feedback);
            return ret;
        }
        return ret;
    }

    public String getHHPassword() {
        return this.hhInfo.password;
    }

    public boolean matchUser() {
        return this.matches;
    }

    public boolean isProfiled() {
        return this.hhInfo.id == 0 && this.hhInfo.lastSyncPC != 0;
    }

    protected static int SetUserID() {
        Date date = new Date();
        Random rand = new Random(date.getTime());
        int ret = 0;
        int modulo = 9742;
        ret = Math.abs(rand.nextInt() % modulo) + 255;
        return ret;
    }

    protected String SetUserName() {
        return new String(SyncConstants.USER_NAME);
    }

    public void createAssociation(String name, int id) {
        if (!this.associated) {
            if (this.hhInfo.id == 0) {
                if (id == 0) {
                    this.hhInfo.id = UserResolver.SetUserID();
                    Logger.doDebugLogging((String)("ID assigned by SetUserID(): " + this.hhInfo.id + " (0x" + Integer.toHexString(this.hhInfo.id) + ")"), (int)4);
                } else {
                    this.hhInfo.id = id;
                    Logger.doDebugLogging((String)("ID assigned: " + this.hhInfo.id + " (0x" + Integer.toHexString(this.hhInfo.id) + ")"), (int)4);
                }
            }
            if (this.hhInfo.name == null || this.hhInfo.name.equals("")) {
                if (name == null || name.equals("")) {
                    this.hhInfo.name = this.SetUserName();
                    Logger.doDebugLogging((String)("Name assigned by SetUserName(): " + this.hhInfo.name), (int)4);
                } else {
                    this.hhInfo.name = name;
                    Logger.doDebugLogging((String)("Name assigned: " + this.hhInfo.name), (int)4);
                }
            }
            this.setStoredInfo(this.hhInfo.name, this.hhInfo.id);
        }
    }

    public void createAssociation(String name) {
        this.createAssociation(name, 0);
    }

    public void createAssociation(int id) {
        this.createAssociation(null, id);
    }

    public void createAssociation() {
        this.createAssociation(null, 0);
    }

    public boolean TestPCIdentifier() {
        if (this.hhInfo.lastSyncPC == 0) {
            return true;
        }
        return this.hhInfo.lastSyncPC == this.pcAddress;
    }

    protected void SetPCIdentifier() {
        this.hhInfo.lastSyncPC = this.pcAddress;
    }

    protected void SetSyncTime() {
        if (this.validUserInfo) {
            Calendar cal = Calendar.getInstance();
            Date date = new Date();
            this.hhInfo.lastSyncDate = SyncUtils.millisecToSecond((long)date.getTime());
        }
    }

    public int WriteUserInfo() {
        int ret = 0;
        if (!this.validUserInfo) {
            return -1;
        }
        if (this.isFirstTimer()) {
            this.hhInfo.name = this.SetUserName();
            this.hhInfo.id = UserResolver.SetUserID();
        }
        if (!this.hasId && this.associated) {
            this.hhInfo.id = this.assoc.getPalmPilotId();
            this.hhInfo.name = new String(this.assoc.getPalmPilotName());
        }
        if (this.hhInfo.id != this.assoc.getPalmPilotId()) {
            this.setStoredInfo(this.hhInfo.name, this.hhInfo.id);
        }
        this.SetPCIdentifier();
        this.SetSyncTime();
        if (this.hhInfo.id == 0) {
            this.hhInfo.id = this.assoc.getPalmPilotId();
            while (!UserResolver.isValidUserId(this.hhInfo.id)) {
                this.hhInfo.id = UserResolver.SetUserID();
            }
            this.setStoredInfo(this.hhInfo.name, this.hhInfo.id);
        }
        try {
            this.feedback = messages.getString("Saving user information:");
            Logger.doDebugLogging((String)this.feedback, (int)4);
            Logger.doDebugLogging((String)this.dumpFormatted(), (int)4);
            ret = SyncManager.writeUserID((UserInfo)this.hhInfo);
        }
        catch (SyncException ex) {
            this.feedback = messages.getString("Could not save user information: ") + ex.getMessage();
            Logger.doDebugLogging((String)this.feedback, (int)4);
            ret = ex.errorCode;
        }
        return ret;
    }

    protected String dumpUserInfo(UserInfo info) {
        String syncDateStr = info.lastSyncDate != 0 ? new Date(SyncUtils.secondToMillisec((int)info.lastSyncDate)).toString() : "0";
        String passwdMsg = info.password == null || info.password.equals("") ? messages.getString("Not enabled") : messages.getString("Enabled.");
        return "<User name: " + info.name + "> <Password: " + passwdMsg + "> <Last Sync Date: " + syncDateStr + "> <Last Sync PC: " + Integer.toHexString(info.lastSyncPC) + "> <Handheld ID: " + info.id + ">\n";
    }

    public String dumpUserInfoFormatted(int numTabs, UserInfo info) {
        String tabs = SyncUtils.makeTabsString((int)(numTabs + 1));
        String syncDateStr = info.lastSyncDate != 0 ? new Date(SyncUtils.secondToMillisec((int)info.lastSyncDate)).toString() : "0";
        String passwdMsg = info.password == null || info.password.equals("") ? messages.getString("Not enabled.") : messages.getString("Enabled.");
        return tabs + "UserInfo:\n" + tabs + "  {\n" + tabs + "    User Name       : " + info.name + "\n" + tabs + "    Password        : " + passwdMsg + "\n" + tabs + "    Last Sync Date  : " + syncDateStr + "\n" + tabs + "    Last Sync PC    : " + Integer.toHexString(info.lastSyncPC) + "\n" + tabs + "    Handheld ID     : " + info.id + "\n" + tabs + "  }\n";
    }

    public String dump() {
        return "<Stored Pilot Name: " + this.storedPilotName + "> <Stored Pilot ID: " + this.storedPilotID + "> " + this.dumpUserInfo(this.hhInfo) + "> <Has ID Flag: " + this.hasId + "> <Matches Flag: " + this.matches + "> <Associated Flag: " + this.associated + "> <Valid User Info Flag: " + this.validUserInfo + "> <PC Address: " + Integer.toHexString(this.pcAddress) + ">\n";
    }

    public String dumpFormatted() {
        return this.dumpFormatted(0);
    }

    public static boolean isValidUserId(int id) {
        return (id & 0xFFFFFF00) != 0;
    }

    public String dumpFormatted(int numTabs) {
        String tabs = SyncUtils.makeTabsString((int)numTabs);
        return tabs + "UserResolver:\n" + tabs + "  {\n" + tabs + "    Stored Pilot Name    : " + this.storedPilotName + "\n" + tabs + "    Stored Pilot ID      : " + this.storedPilotID + "\n" + this.dumpUserInfoFormatted(numTabs, this.hhInfo) + tabs + "    Has ID Flag          : " + this.hasId + "\n" + tabs + "    Matches Flag         : " + this.matches + "\n" + tabs + "    Associated Flag      : " + this.associated + "\n" + tabs + "    Valid User Info Flag : " + this.validUserInfo + "\n" + tabs + "    PC Address           : " + Integer.toHexString(this.pcAddress) + "\n" + tabs + "  }\n";
    }

    static {
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.HotSyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"CConduitJar: can't find message file");
            Logger.doLogging((String)("CConduitJar:" + e.getMessage()));
            System.exit(1);
        }
        NO_USER_ID = 0;
        MIN_USER_ID = 255;
        MAX_USER_ID = 9999;
    }
}

