/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncUtils.SyncConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBListDef {
    public static final String DBLISTDEF_FILENAME = SyncConstants.USER_PROPS_DIR_PATH + SyncConstants.SEPARATOR + "DBList.def";
    public static final String DELIMITER = "|";
    public static final int FIELD_NUM = 2;
    protected Vector dblists = new Vector();

    public void addElement(String dbName, int creatorID) {
        DBItem item = new DBItem(dbName, creatorID);
        if (!this.hasItem(item)) {
            this.dblists.addElement(item);
        }
    }

    public void removeElement(String dbName, int creatorID) {
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            if (item.dbName.equals(dbName) && item.creatorID == creatorID) {
                this.dblists.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        String line;
        BufferedReader buffer = null;
        File dblistFile = new File(DBLISTDEF_FILENAME);
        if (!dblistFile.exists()) {
            return -1;
        }
        int retcode = 0;
        FileReader reader = new FileReader(dblistFile);
        buffer = new BufferedReader(reader);
        while ((line = buffer.readLine()) != null) {
            void var3_5;
            if (var3_5.charAt(0) == '#') continue;
            DBItem dbItem = new DBItem();
            if (dbItem.parseLine((String)var3_5)) {
                if (this.hasItem(dbItem)) continue;
                this.dblists.addElement(dbItem);
                continue;
            }
            retcode = -2;
        }
        Object var10_7 = null;
        if (buffer == null) return retcode;
        try {
            buffer.close();
            return retcode;
        }
        catch (IOException e2) {}
        return retcode;
        {
            catch (Exception e) {
                int n = -2;
                Object var10_8 = null;
                if (buffer == null) return n;
                try {
                    buffer.close();
                    return n;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (buffer == null) throw throwable;
            try {
                buffer.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean hasItem(DBItem db) {
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            if (db.dbName.equals(item.dbName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() {
        BufferedWriter buffer = null;
        FileWriter writer = new FileWriter(DBLISTDEF_FILENAME);
        buffer = new BufferedWriter(writer);
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem dbItem = (DBItem)this.dblists.elementAt(i);
            buffer.write(dbItem.encode());
            buffer.newLine();
            ++i;
        }
        Object var6_6 = null;
        if (buffer == null) return;
        try {
            buffer.flush();
            buffer.close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (IOException ex) {
                Logger.doDebugLogging((String)"Cannot write DBList.def.", (int)4);
                Object var6_7 = null;
                if (buffer == null) return;
                try {
                    buffer.flush();
                    buffer.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (buffer == null) throw throwable;
            try {
                buffer.flush();
                buffer.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String[] getDBNames() {
        String[] names = new String[this.dblists.size()];
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            names[i] = item.dbName;
            ++i;
        }
        return names;
    }

    public int findCreatorID(String dbName) {
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            if (item.dbName.equals(dbName)) {
                return item.creatorID;
            }
            ++i;
        }
        return -1;
    }

    public static void main(String[] args) {
        DBListDef dblist = new DBListDef();
        dblist.read();
        String[] names = dblist.getDBNames();
        System.out.println("Get DBName list");
        int i = 0;
        while (i < names.length) {
            System.out.println("dbname -- " + names[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < names.length) {
            int id = dblist.findCreatorID(names[i2]);
            System.out.println("name = " + names[i2] + ", id = " + id);
            ++i2;
        }
    }

    static {
        DELIMITER = DELIMITER;
        FIELD_NUM = 2;
    }

    class DBItem {
        String dbName;
        int creatorID;

        public DBItem() {
            this.dbName = null;
            this.creatorID = -1;
        }

        public DBItem(String dbname, int creator_id) {
            this.dbName = dbname;
            this.creatorID = creator_id;
        }

        protected String encode() {
            return this.dbName + DBListDef.DELIMITER + this.creatorID;
        }

        protected boolean parseLine(String line) {
            StringTokenizer strTok = new StringTokenizer(line, DBListDef.DELIMITER);
            String[] tokens = new String[2];
            int counter = 0;
            while (strTok.hasMoreTokens()) {
                tokens[counter] = new String(strTok.nextToken());
                ++counter;
            }
            if (counter != 2) {
                return false;
            }
            this.dbName = tokens[0];
            try {
                this.creatorID = Integer.parseInt(tokens[1]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }
}

