/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.HotSync.CSyncTask;
import com.sun.pdasync.HotSync.UserResolver;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.Registry.ConduitRegInfo;
import com.sun.pdasync.Registry.ConduitStateInfo;
import com.sun.pdasync.Registry.Registry;
import com.sun.pdasync.SharedUI.JarLoader;
import com.sun.pdasync.SyncMgr.CDbList;
import com.sun.pdasync.SyncMgr.CSyncProperties;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;

public class CConduitJar
implements Serializable {
    private String feedback;
    private static Locale theLocale;
    private static ResourceBundle messages;
    public static final int MIN_PRIORITY = 0;
    public static final int DEF_PRIORITY = 2;
    public static final int MAX_PRIORITY = 4;
    ConduitStateInfo conduit;
    JarLoader jarLoader;
    protected Vector m_csaFileNames;
    protected Class conduitClass;
    protected Object conduitObj;
    protected Vector m_csaRemoteFileNames;
    protected int m_defaultAction;
    protected static String origClasspath;
    protected static Properties origProperties;

    public CConduitJar(ConduitStateInfo aConduit) {
        this.conduit = aConduit;
        this.m_csaFileNames = new Vector();
        this.m_csaRemoteFileNames = new Vector();
        this.m_defaultAction = 7;
        try {
            this.jarLoader = new JarLoader(this.conduit.getClassPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conduitClass = null;
        this.conduitObj = null;
        origClasspath = System.getProperty("java.class.path");
        origProperties = System.getProperties();
    }

    public String GetFileName(int nIndex) {
        String ret = null;
        if (nIndex >= 0 && nIndex < this.GetFileCount()) {
            ret = new String((String)this.m_csaFileNames.elementAt(nIndex));
        }
        return ret;
    }

    public byte[] GetRemoteFileName(int nIndex) {
        byte[] ret = null;
        if (nIndex >= 0 && nIndex < this.GetRemoteFileCount()) {
            ret = (byte[])this.m_csaRemoteFileNames.elementAt(nIndex);
        }
        return ret;
    }

    public int GetViewerAppID() {
        return this.conduit.getCreatorID();
    }

    public String GetDirectory() {
        return this.conduit.getDirectory();
    }

    public String GetConduitName() {
        return this.conduit.getName();
    }

    public String GetModuleName() {
        return this.conduit.getConduit();
    }

    public String getClassPath() {
        return this.conduit.getClassPath();
    }

    public int GetPriority() {
        return this.conduit.getPriority();
    }

    public int GetRemoteFileCount() {
        return this.m_csaRemoteFileNames.size();
    }

    public void AddRemoteFileName(byte[] pszRemoteName) {
        this.m_csaRemoteFileNames.addElement(pszRemoteName);
    }

    public int GetFileCount() {
        return this.m_csaFileNames.size();
    }

    public void AddFileName(byte[] pszFileName) {
        this.m_csaFileNames.addElement(pszFileName);
    }

    public boolean Load() {
        this.feedback = messages.getString("Trying to load conduit: ") + this.conduit.getName();
        Logger.doDebugLogging((String)this.feedback, (int)4);
        String newClasspath = new String(this.conduit.getClassPath() + ":" + origClasspath);
        Properties newSystemProps = new Properties(origProperties);
        newSystemProps.put("java.class.path", newClasspath);
        System.setProperties(newSystemProps);
        newClasspath = System.getProperty("java.class.path");
        this.feedback = "Original classpath: " + origClasspath;
        Logger.doDebugLogging((String)this.feedback, (int)4);
        this.feedback = "New classpath: " + newClasspath;
        Logger.doDebugLogging((String)this.feedback, (int)4);
        try {
            JarLoader.loadJar((String)this.conduit.getClassName());
        }
        catch (Exception ex) {
            this.feedback = messages.getString("Could not load conduit jar file: ") + this.conduit.getClassPath();
            Logger.doDebugLogging((String)this.feedback, (int)4);
            System.setProperties(origProperties);
            return false;
        }
        try {
            this.conduitClass = Class.forName(JarLoader.getClassName());
        }
        catch (Exception ex) {
            this.feedback = messages.getString("Could not retrieve conduit class: ") + this.conduit.getClassName();
            Logger.doDebugLogging((String)this.feedback, (int)4);
            System.setProperties(origProperties);
            return false;
        }
        try {
            this.conduitObj = this.conduitClass.newInstance();
        }
        catch (Exception ex) {
            this.feedback = messages.getString("Could not create conduit class.");
            Logger.doDebugLogging((String)this.feedback, (int)4);
            System.setProperties(origProperties);
            return false;
        }
        return true;
    }

    public boolean isLoaded() {
        return this.conduitClass != null && this.conduitObj != null;
    }

    public String GetDisplayName() {
        String ret = null;
        if (this.conduitObj != null) {
            ret = ((Conduit)this.conduitObj).name();
        }
        return ret;
    }

    public int GetDefaultSyncAction() {
        if (this.m_defaultAction != -1) {
            return this.m_defaultAction;
        }
        return -1;
    }

    public boolean SetSyncType(UserResolver pUserResolver, CSyncTask pTask, CSyncProperties pProperties) {
        boolean bRtn = true;
        pProperties.m_SyncType = this.conduit.getDefaultSyncType();
        if (pUserResolver.isFirstTimer()) {
            if (pUserResolver.associated) {
                pProperties.m_SyncType = 3;
            }
        } else if (pUserResolver.isProfiled()) {
            pProperties.m_SyncType = 3;
        } else if (pProperties.m_SyncType == 0 || pProperties.m_SyncType == 1) {
            pProperties.m_SyncType = pUserResolver.TestPCIdentifier() ? 0 : 1;
        }
        Logger.doDebugLogging((String)("Setting sync type to: " + ConduitRegInfo.getDefaultSyncTypeString(pProperties.m_SyncType)), (int)4);
        return bRtn;
    }

    public boolean SetLocalSyncFiles(CSyncProperties pProperties) {
        String path = new String(SyncConstants.PILOT_DIR_PATH + this.conduit.getDirectory());
        if (!SyncUtils.mkdirIfNotExist((String)path)) {
            return false;
        }
        byte[] temp = path.getBytes();
        if (temp.length > 256) {
            return false;
        }
        System.arraycopy(temp, 0, pProperties.m_PathName, 0, temp.length);
        String filename = new String(this.conduit.getFile0());
        File file = new File(path + SyncConstants.SEPARATOR + filename);
        temp = filename.getBytes();
        if (!file.exists() || file.exists() && !file.isDirectory()) {
            temp = filename.getBytes();
            if (temp.length <= 256) {
                System.arraycopy(temp, 0, pProperties.m_LocalName, 0, temp.length);
            }
            return true;
        }
        return false;
    }

    public boolean SetRemoteSyncFiles(CSyncTask pTask, CSyncProperties pProperties) {
        int i;
        boolean bRtn = false;
        int nCount = pTask.getDatabaseCount();
        pProperties.m_RemoteDbList = null;
        pProperties.m_RemoteCount = 0;
        this.feedback = "CConduitJar.SetRemoteSyncFiles(): " + messages.getString("Remote database count: ") + nCount;
        Logger.doDebugLogging((String)this.feedback, (int)4);
        if (nCount > 0) {
            pProperties.m_RemoteDbList = CDbList.makeCDbListArray(nCount);
            if (pProperties.m_RemoteDbList != null) {
                if (pProperties.m_RemoteName != null) {
                    pProperties.m_RemoteName = null;
                }
                if (nCount != 0) {
                    pProperties.m_RemoteName = new byte[nCount][];
                }
                i = 0;
                while (i < nCount) {
                    CDbList pDatabase = pTask.getDatabase(i);
                    if (pDatabase != null) {
                        pProperties.m_RemoteName[i] = pDatabase.m_Name;
                        pProperties.m_RemoteDbList[i] = pDatabase;
                        ++pProperties.m_RemoteCount;
                    } else {
                        int n = i + 1;
                        this.feedback = "CConduitJar.SetRemoteSyncFiles(): " + messages.getString("Empty DB List item at location ") + n;
                        Logger.doDebugLogging((String)this.feedback, (int)4);
                    }
                    ++i;
                }
            } else {
                this.feedback = "CConduitJar.SetRemoteSyncFiles(): " + messages.getString("Failed to allocate remote DB list.");
                Logger.doDebugLogging((String)this.feedback, (int)4);
            }
        }
        if (pProperties.m_RemoteCount == 0) {
            if (pProperties.m_RemoteDbList != null) {
                i = 0;
                while (i < pProperties.m_RemoteDbList.length) {
                    pProperties.m_RemoteDbList[i] = null;
                    ++i;
                }
                pProperties.m_RemoteDbList = null;
            }
            if ((nCount = this.GetRemoteFileCount()) <= 0) {
                this.feedback = "CConduitJar.SetRemoteSyncFiles(): " + messages.getString("Remote database count: ") + nCount;
                Logger.doDebugLogging((String)this.feedback, (int)4);
            }
            i = 0;
            while (i < nCount) {
                byte[] pszFileName;
                if (pProperties.m_RemoteName != null) {
                    pProperties.m_RemoteName = null;
                }
                if (nCount != 0) {
                    pProperties.m_RemoteName = new byte[nCount][];
                }
                if ((pszFileName = this.GetRemoteFileName(i)) != null && pszFileName.length > 0 && pszFileName.length < 32) {
                    pProperties.m_RemoteName[i] = new byte[pszFileName.length + 1];
                    System.arraycopy(pszFileName, 0, pProperties.m_RemoteName[i], 0, pszFileName.length);
                    ++pProperties.m_RemoteCount;
                }
                ++i;
            }
        }
        return pProperties.m_RemoteCount > 0;
    }

    public ConfigureConduitInfo getConduitConfiguration() {
        ConfigureConduitInfo cfg = new ConfigureConduitInfo();
        cfg.creatorId = this.conduit.getCreatorID();
        cfg.pathName = this.conduit.getDirectory();
        cfg.syncTemporary = cfg.syncPermanent = this.conduit.getDefaultSyncType();
        return cfg;
    }

    public void processConduitConfigure(ConfigureConduitInfo cfg) {
        boolean changed = false;
        if (cfg.creatorId != this.conduit.getCreatorID()) {
            changed = true;
            this.conduit.setCreatorID(cfg.creatorId);
        }
        if (cfg.pathName != this.conduit.getDirectory()) {
            changed = true;
            this.conduit.setDirectory(cfg.pathName);
        }
        if (cfg.syncPermanent != this.conduit.getDefaultSyncType()) {
            changed = true;
            this.conduit.setDefaultSyncType(cfg.syncPermanent);
        }
        if (changed) {
            Logger.doDebugLogging((String)"Updating personal registry file due to conduit configuration chage.", (int)4);
            Registry.updatePersonal(this.conduit);
        }
    }

    static {
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.HotSyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"CConduitJar: can't find message file");
            Logger.doLogging((String)("CConduitJar:" + e.getMessage()));
        }
        MIN_PRIORITY = 0;
        DEF_PRIORITY = 2;
        MAX_PRIORITY = 4;
    }
}

