/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.Utils;

import com.sun.pdasync.Conduits.Utils.DesktopManager;
import com.sun.pdasync.Logger.Logger;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Record;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class SUNWRecManager {
    public Vector hhRecords;
    public Vector pcRecords;
    public Vector archivedRecords;
    public Vector backupRecords;
    public Vector slowPCRecords;
    public boolean slowSync;
    public int db;
    public int recordCount;
    public int recordIndex;
    public SyncProperties props;
    Class recordClass;
    DesktopManager dtMgr;
    private static final String MODIFY_BOTH_MSG1 = "The following record was modified on both the Palm organizer and the Desktop: ";
    private static final String MODIFY_BOTH_MSG2 = "This record will be duplicated on each platform. Delete the unwanted record and HotSync again.";
    private static final String MOD_DELETE_MSG1 = "The following record was modified on one platform and deleted on the other: ";
    private static final String MOD_DELETE_MSG2 = "The modified version will appear on both platforms.";
    private static Locale theLocale;
    private static ResourceBundle messages;

    public SUNWRecManager(SyncProperties props, int db, Class recordClass) {
        this(props, db, recordClass, null);
    }

    public SUNWRecManager(SyncProperties props, int db, Class recordClass, DesktopManager dtMgr) {
        this.props = props;
        this.db = db;
        this.recordClass = recordClass;
        this.dtMgr = dtMgr;
        this.hhRecords = new Vector();
        this.slowSync = false;
    }

    public Vector slowSyncData(Vector pcRecords, Vector archivedRecords, Vector backupRecords) throws SyncException, IOException {
        boolean allRecordsRead = false;
        this.backupRecords = backupRecords;
        this.archivedRecords = archivedRecords;
        this.pcRecords = pcRecords;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.slowPCRecords = new Vector();
        this.slowSync = true;
        this.recordCount = SyncManager.getDBRecordCount((int)this.db);
        this.recordIndex = 0;
        while (this.recordIndex < this.recordCount) {
            Record hhRecord = this.getNewRecord();
            hhRecord.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex((int)this.db, (Record)hhRecord);
            this.synchronizeHHRecord(hhRecord);
            ++this.recordIndex;
        }
        int i = 0;
        while (i < pcRecords.size()) {
            Record newRecord = (Record)pcRecords.elementAt(i);
            if (newRecord.isNew() || newRecord.isModified()) {
                this.resetAttributes(newRecord);
                this.addPCRecord(newRecord);
                this.hhRecords.addElement(newRecord);
            } else {
                Record pcRecord = this.getRecordById(newRecord.getId(), this.slowPCRecords);
                if (pcRecord == null && this.dtMgr != null) {
                    this.dtMgr.deleteRecord(newRecord);
                }
            }
            ++i;
        }
        this.writeHHRecords();
        return this.slowPCRecords;
    }

    public void fastSyncData(Vector pcRecords, Vector archivedRecords) throws SyncException, IOException {
        boolean allRecordsRead = false;
        this.archivedRecords = archivedRecords;
        this.pcRecords = pcRecords;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.recordIndex = 0;
        while (!allRecordsRead) {
            try {
                Record hhRecord = this.getNewRecord();
                SyncManager.readNextModifiedRec((int)this.db, (Record)hhRecord);
                this.synchronizeHHRecord(hhRecord);
            }
            catch (SyncException e) {
                allRecordsRead = true;
            }
        }
        allRecordsRead = false;
        this.recordIndex = 0;
        while (!allRecordsRead) {
            Record pcRecord = this.getNextModifiedRecord();
            if (pcRecord != null) {
                this.synchronizePCRecord(pcRecord);
                this.resetAttributes(pcRecord);
                continue;
            }
            allRecordsRead = true;
        }
        this.writeHHRecords();
    }

    public void synchronizePCRecord(Record pcRecord) throws IOException, SyncException {
        if (!pcRecord.isNew()) {
            Record hhRecord = this.retrieveHHRecord(pcRecord);
            if (hhRecord == null) {
                if (this.props.firstDevice == 2) {
                    this.hhRecords.addElement(pcRecord);
                }
                SyncManager.writeRec((int)this.db, (Record)pcRecord);
            } else if (pcRecord.isDeleted()) {
                this.deleteDtRecord(pcRecord);
                this.deleteHHRecord(hhRecord);
            } else if (!this.compareRecords(hhRecord, pcRecord)) {
                this.hhRecords.addElement(pcRecord);
            }
        } else if (pcRecord.isDeleted()) {
            this.deletePCRecord(pcRecord);
        } else {
            this.resetAttributes(pcRecord);
            this.hhRecords.addElement(pcRecord);
        }
    }

    public void synchronizeHHRecord(Record hhRecord) throws SyncException, IOException {
        Record pcRecord = this.getRecordById(hhRecord.getId(), this.pcRecords);
        if (pcRecord == null && (pcRecord = this.getRecordByContent(hhRecord, this.pcRecords)) != null) {
            this.resetAttributes(pcRecord);
            pcRecord.setId(hhRecord.getId());
            if (this.slowSync) {
                this.slowPCRecords.addElement(pcRecord);
            }
            return;
        }
        if (pcRecord == null) {
            if (hhRecord.isArchived()) {
                this.archiveRecord(hhRecord);
                this.deleteHHRecord(hhRecord);
            } else if (hhRecord.isDeleted()) {
                this.deleteHHRecord(hhRecord);
            } else {
                this.resetAttributes(hhRecord);
                this.addDtRecord(hhRecord);
                this.removeHHrecById(hhRecord);
            }
        } else if (hhRecord.isArchived()) {
            this.handleArchived(hhRecord, pcRecord);
        } else if (hhRecord.isDeleted()) {
            this.handleDeleted(hhRecord, pcRecord);
        } else {
            this.handleModified(hhRecord, pcRecord);
        }
    }

    public void handleArchived(Record hhRecord, Record pcRecord) throws IOException {
        Record backupRecord;
        if (!pcRecord.isModified()) {
            this.archiveRecord(hhRecord);
            this.deleteHHRecord(hhRecord);
            this.deleteDtRecord(pcRecord);
            return;
        }
        if (!(hhRecord.isModified() || hhRecord.isNew() || hhRecord.isDeleted() || this.props.syncType != 1 || (backupRecord = this.getRecordById(hhRecord.getId(), this.backupRecords)) != null && this.compareRecords(hhRecord, backupRecord))) {
            hhRecord.setIsModified(true);
        }
        if (hhRecord.isModified()) {
            if (this.compareRecords(hhRecord, pcRecord)) {
                this.archiveRecord(hhRecord);
                this.deleteHHRecord(hhRecord);
                this.deleteDtRecord(pcRecord);
            } else {
                pcRecord.setId(0);
                pcRecord.setIsNew(true);
                this.resetAttributes(hhRecord);
                this.addDtRecord(hhRecord);
            }
        } else if (pcRecord.isArchived() || pcRecord.isDeleted()) {
            this.archiveRecord(hhRecord);
            this.deleteDtRecord(pcRecord);
            this.deleteHHRecord(hhRecord);
        } else {
            this.resetAttributes(pcRecord);
            this.deleteHHRecord(hhRecord);
            this.hhRecords.addElement(pcRecord);
        }
    }

    public void handleModified(Record hhRecord, Record pcRecord) throws IOException {
        Record backupRecord;
        if (!(hhRecord.isModified() || (backupRecord = this.getRecordById(hhRecord.getId(), this.backupRecords)) != null && this.compareRecords(hhRecord, backupRecord))) {
            hhRecord.setIsModified(true);
        }
        if (hhRecord.isModified()) {
            if (pcRecord.isDeleted()) {
                this.resetAttributes(hhRecord);
                this.deletePCRecord(pcRecord);
                this.addDtRecord(hhRecord);
                Logger.doLogging((String)" ");
                Logger.doLogging((String)messages.getString(MOD_DELETE_MSG1));
                Logger.doLogging((String)hhRecord.toString());
                Logger.doLogging((String)messages.getString(MOD_DELETE_MSG2));
                Logger.doLogging((String)" ");
            } else if (!pcRecord.isModified()) {
                this.resetAttributes(hhRecord);
                this.updateDtRecord(pcRecord, hhRecord);
            } else if (this.compareRecords(hhRecord, pcRecord)) {
                if (pcRecord.isArchived()) {
                    this.archiveRecord(pcRecord);
                    this.deleteDtRecord(pcRecord);
                    this.deleteHHRecord(hhRecord);
                } else if (pcRecord.isDeleted()) {
                    this.deleteDtRecord(pcRecord);
                    this.deleteHHRecord(hhRecord);
                } else {
                    this.resetAttributes(pcRecord);
                    if (this.slowSync) {
                        this.slowPCRecords.addElement(pcRecord);
                    }
                }
            } else {
                this.resetAttributes(pcRecord);
                pcRecord.setIsNew(true);
                pcRecord.setId(0);
                this.resetAttributes(hhRecord);
                this.addDtRecord(hhRecord);
                Logger.doLogging((String)" ");
                Logger.doLogging((String)messages.getString(MODIFY_BOTH_MSG1));
                Logger.doLogging((String)hhRecord.toString());
                Logger.doLogging((String)messages.getString(MODIFY_BOTH_MSG2));
                Logger.doLogging((String)" ");
            }
        } else {
            if (pcRecord.isDeleted()) {
                this.deleteHHRecord(hhRecord);
            } else if (pcRecord.isModified() && !this.compareRecords(hhRecord, pcRecord)) {
                this.hhRecords.addElement(pcRecord);
                this.slowPCRecords.addElement(pcRecord);
            } else {
                this.slowPCRecords.addElement(pcRecord);
            }
            this.pcRecords.removeElement(pcRecord);
        }
    }

    public void handleDeleted(Record hhRecord, Record pcRecord) throws IOException {
        if (pcRecord.isModified()) {
            this.deleteHHRecord(hhRecord);
            this.resetAttributes(pcRecord);
            this.hhRecords.addElement(pcRecord);
            if (this.slowSync) {
                this.slowPCRecords.addElement(pcRecord);
            }
            Logger.doLogging((String)" ");
            Logger.doLogging((String)messages.getString(MOD_DELETE_MSG1));
            Logger.doLogging((String)pcRecord.toString());
            Logger.doLogging((String)messages.getString(MOD_DELETE_MSG2));
            Logger.doLogging((String)" ");
        } else {
            this.deleteHHRecord(hhRecord);
            this.deleteDtRecord(pcRecord);
        }
    }

    public Vector copyHHRecords() throws SyncException, IOException {
        this.pcRecords = new Vector();
        int recordCount = SyncManager.getDBRecordCount((int)this.db);
        this.recordIndex = 0;
        while (this.recordIndex < recordCount) {
            Record hhRecord = this.getNewRecord();
            hhRecord.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex((int)this.db, (Record)hhRecord);
            if (!hhRecord.isDeleted() && !hhRecord.isArchived()) {
                this.resetAttributes(hhRecord);
                this.addPCRecord(hhRecord);
            }
            ++this.recordIndex;
        }
        SyncManager.purgeDeletedRecs((int)this.db);
        SyncManager.resetSyncFlags((int)this.db);
        return this.pcRecords;
    }

    public Vector copyPCRecords(Vector pcRecs) throws SyncException, IOException {
        Record pcRecord;
        this.hhRecords = this.pcRecords = pcRecs;
        int recordCount = this.pcRecords.size();
        SyncManager.purgeAllRecs((int)this.db);
        int i = 0;
        while (i < pcRecs.size()) {
            pcRecord = (Record)pcRecs.elementAt(i);
            pcRecord.setId(0);
            ++i;
        }
        this.writeHHRecords();
        this.pcRecords = this.hhRecords;
        int i2 = 0;
        while (i2 < this.pcRecords.size()) {
            pcRecord = (Record)this.hhRecords.elementAt(i2);
            this.resetAttributes(pcRecord);
            ++i2;
        }
        return this.pcRecords;
    }

    public Record getRecordById(int id, Vector records) {
        if (records != null) {
            int i = 0;
            while (i < records.size()) {
                Record tempRecord = (Record)records.elementAt(i);
                if (tempRecord.getId() == id) {
                    return tempRecord;
                }
                ++i;
            }
        }
        return null;
    }

    public void archiveRecord(Record record) throws SyncException {
        this.resetAttributes(record);
        this.archivedRecords.addElement(record);
    }

    public void deleteHHRecord(Record record) throws SyncException {
        SyncManager.deleteRecord((int)this.db, (Record)record);
        this.removeHHrecById(record);
        --this.recordCount;
        --this.recordIndex;
    }

    public Record retrieveHHRecord(Record pcRecord) throws IOException {
        Record hhRecord = this.getNewRecord();
        hhRecord.setId(pcRecord.getId());
        try {
            SyncManager.readRecordById((int)this.db, (Record)hhRecord);
        }
        catch (SyncException e) {
            return null;
        }
        return hhRecord;
    }

    public void addPCRecord(Record record) {
        if (this.slowSync) {
            this.slowPCRecords.addElement(record);
        } else {
            this.pcRecords.addElement(record);
        }
    }

    public void deletePCRecord(Record pcRecord) {
        this.pcRecords.removeElement(pcRecord);
    }

    public void resetAttributes(Record record) {
        record.setIsModified(false);
        record.setIsArchived(false);
        record.setIsDeleted(false);
        record.setIsNew(false);
    }

    public Record getNextModifiedRecord() {
        if (this.pcRecords != null) {
            int i = this.recordIndex;
            while (i < this.pcRecords.size()) {
                Record record = (Record)this.pcRecords.elementAt(i);
                ++this.recordIndex;
                if (this.props.firstDevice == 2 || record.isModified() || record.isNew() || record.isDeleted() || record.isArchived()) {
                    return record;
                }
                ++i;
            }
        }
        return null;
    }

    public Record getNewRecord() {
        Record hhRecord = null;
        try {
            hhRecord = (Record)this.recordClass.newInstance();
        }
        catch (Throwable t) {
            System.out.println("Uncaught exception: " + t);
            t.printStackTrace();
        }
        return hhRecord;
    }

    public void writeHHRecords() throws IOException {
        if (this.hhRecords != null) {
            int i = 0;
            while (i < this.hhRecords.size()) {
                Record hhRecord = (Record)this.hhRecords.elementAt(i);
                SyncManager.writeRec((int)this.db, (Record)hhRecord);
                ++i;
            }
            SyncManager.purgeDeletedRecs((int)this.db);
            SyncManager.resetSyncFlags((int)this.db);
        }
    }

    public void addDtRecord(Record record) {
        if (this.dtMgr != null) {
            this.dtMgr.createRecord(record);
        }
        this.addPCRecord(record);
    }

    public void deleteDtRecord(Record record) {
        if (this.dtMgr != null) {
            this.dtMgr.deleteRecord(record);
        }
        this.deletePCRecord(record);
    }

    public void updateDtRecord(Record pcRecord, Record hhRecord) {
        this.deleteDtRecord(pcRecord);
        this.addDtRecord(hhRecord);
    }

    public void removeHHrecById(Record hhRecord) {
        int i = 0;
        while (i < this.hhRecords.size()) {
            Record hhRecordElement = (Record)this.hhRecords.elementAt(i);
            if (hhRecord.getId() == hhRecordElement.getId()) {
                this.hhRecords.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    public Record getRecordByContent(Record hhRec, Vector records) {
        if (records != null) {
            int i = 0;
            while (i < records.size()) {
                Record tempRecord = (Record)records.elementAt(i);
                if (tempRecord.getId() <= 0) {
                    try {
                        boolean result = this.compareRecords(hhRec, tempRecord);
                        if (result) {
                            return tempRecord;
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public boolean compareRecords(Record firstRecord, Record secondRecord) throws IOException {
        if (firstRecord.getCategoryIndex() != secondRecord.getCategoryIndex() || firstRecord.isPrivate() != secondRecord.isPrivate()) {
            return false;
        }
        return firstRecord.equals(secondRecord);
    }

    static {
        MODIFY_BOTH_MSG1 = MODIFY_BOTH_MSG1;
        MODIFY_BOTH_MSG2 = MODIFY_BOTH_MSG2;
        MOD_DELETE_MSG1 = MOD_DELETE_MSG1;
        MOD_DELETE_MSG2 = MOD_DELETE_MSG2;
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"PDASync: can't find properties", (boolean)true);
            Logger.doLogging((String)("PDASync:" + e.getMessage()), (boolean)true);
            System.exit(1);
        }
    }
}

