#!/bin/ksh
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2001 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#

Update_Cls_Config()
{
echo "#   Update Job Class Config: begin at `$DATECMD`"  >> $LOGFILE
echo "    Saving previous job class configuration file as ${MAKEACTFILE}.bck" >> $LOGFILE
mv $MAKEACTFILE ${MAKEACTFILE}.bck >> $LOGFILE 2>&1
if [ $? -ne 0 ]
then
    echo "   Warning unable to save previous job class configuration file" >> $LOGFILE
    return
fi
chmod 755 ${MAKEACTFILE}.bck >> $LOGFILE 2>&1
if [ $? -ne 0 ]
then
    echo "   Warning unable to change permission to job class backup configuration file" >> $LOGFILE
    return
fi
BAM_INFCLS_TIME=8; export BAM_INFCLS_TIME
infact_dcr "create_makeactfile" > /tmp/ebmact.$$
status_infact=$?
if [ $? -ne 0 ]
then
  cat <$DEVNULL >$MAKEACTFILE
  chmod 755 $MAKEACTFILE >> $LOGFILE 2>&1
  echo "#   No Classes are currently defined" >> $LOGFILE
  return
fi
unset BAM_INFCLS_TIME
echo "#!/bin/ksh" > $MAKEACTFILE
chmod 755 $MAKEACTFILE >> $LOGFILE 2>&1
cat /tmp/ebmact.$$ >> $MAKEACTFILE
if [ $? -ne 0 ]
then
    echo "   Warning unable to update job class configuration file, restoring previous configuration" >> $LOGFILE
    mv ${MAKEACTFILE}.bck $MAKEACTFILE >> $LOGFILE 2>&1
else
    echo "   Removing previous configuration file ${MAKEACTFILE}.bck" >> $LOGFILE
    rm ${MAKEACTFILE}.bck >> $LOGFILE 2>&1
fi
echo "#   Contents of the $MAKEACTFILE:" >> $LOGFILE
cat $MAKEACTFILE >> $LOGFILE
echo "#   The end of the $MAKEACTFILE" >> $LOGFILE
echo $N ".$C"
echo ""
echo ""
rm -f /tmp/ebmact.$$
echo "#   Update Job Class Config: end   at `$DATECMD`"  >> $LOGFILE
}

Create_List_CLs()
{
echo "#   Create List Cls: begin at `$DATECMD`"  >> $LOGFILE
cat <$DEVNULL >$TEMPFILE
num_a=0
num_b=0
num_c=0
num_d=0
num_e=0
num_f=0
num_g=0
num_h=0
num_i=0
num_j=0
num_k=0
num_l=0
num_m=0
num_n=0
num_o=0
num_p=0
num_q=0
num_r=0
num_s=0
num_t=0
num_u=0
num_v=0
num_w=0
num_x=0
num_y=0
num_z=0
num_tot=0
BAM_INFCLS_TIME=8; export BAM_INFCLS_TIME
infact_dcr "list_job_class_by_num" > /tmp/ebmact.$$
status_infact=$?
if [ $status_infact -eq 0 ]
then
  . /tmp/ebmact.$$
fi
echo "#   Infact output:"  >> $LOGFILE
cat /tmp/ebmact.$$ >> $LOGFILE
echo "#   End of infact output:"  >> $LOGFILE
unset BAM_INFCLS_TIME
echo "" > $TEMPFILE
echo "         Allocated" >> $TEMPFILE
echo "Class    Activities" >> $TEMPFILE
echo "--------------------------------------------------------------------------------" >> $TEMPFILE
if [ $num_a -ne 0 ]
then
  echo "  a          $num_a" >> $TEMPFILE
fi
if [ $num_b -ne 0 ]
then
  echo "  b          $num_b" >> $TEMPFILE
fi
if [ $num_c -ne 0 ]
then
  echo "  c          $num_c" >> $TEMPFILE
fi
if [ $num_d -ne 0 ]
then
  echo "  d          $num_d" >> $TEMPFILE
fi
if [ $num_e -ne 0 ]
then
  echo "  e          $num_e" >> $TEMPFILE
fi
if [ $num_f -ne 0 ]
then
  echo "  f          $num_f" >> $TEMPFILE
fi
if [ $num_g -ne 0 ]
then
  echo "  g          $num_g" >> $TEMPFILE
fi
if [ $num_h -ne 0 ]
then
  echo "  h          $num_h" >> $TEMPFILE
fi
if [ $num_i -ne 0 ]
then
  echo "  i          $num_i" >> $TEMPFILE
fi
if [ $num_j -ne 0 ]
then
  echo "  j          $num_j" >> $TEMPFILE
fi
if [ $num_k -ne 0 ]
then
  echo "  k          $num_k" >> $TEMPFILE
fi
if [ $num_l -ne 0 ]
then
  echo "  l          $num_l" >> $TEMPFILE
fi
if [ $num_m -ne 0 ]
then
  echo "  m          $num_m" >> $TEMPFILE
fi
if [ $num_n -ne 0 ]
then
  echo "  n          $num_n" >> $TEMPFILE
fi
if [ $num_o -ne 0 ]
then
  echo "  o          $num_o" >> $TEMPFILE
fi
if [ $num_p -ne 0 ]
then
  echo "  p          $num_p" >> $TEMPFILE
fi
if [ $num_q -ne 0 ]
then
  echo "  q          $num_q" >> $TEMPFILE
fi
if [ $num_r -ne 0 ]
then
  echo "  r          $num_r" >> $TEMPFILE
fi
if [ $num_s -ne 0 ]
then
  echo "  s          $num_s" >> $TEMPFILE
fi
if [ $num_t -ne 0 ]
then
  echo "  t          $num_t" >> $TEMPFILE
fi
if [ $num_u -ne 0 ]
then
  echo "  u          $num_u" >> $TEMPFILE
fi
if [ $num_v -ne 0 ]
then
  echo "  v          $num_v" >> $TEMPFILE
fi
if [ $num_w -ne 0 ]
then
  echo "  w          $num_w" >> $TEMPFILE
fi
if [ $num_x -ne 0 ]
then
  echo "  x          $num_x" >> $TEMPFILE
fi
if [ $num_y -ne 0 ]
then
  echo "  y          $num_y" >> $TEMPFILE
fi
if [ $num_z -ne 0 ]
then
  echo "  z          $num_z" >> $TEMPFILE
fi
echo "--------------------------------------------------------------------------------" >> $TEMPFILE
echo "Total        $num_tot" >> $TEMPFILE
echo "" >> $TEMPFILE
cat $TEMPFILE >> $LOGFILE
rm -f /tmp/ebmact.$$
echo "#   Create List Cls: end   at `$DATECMD`"  >> $LOGFILE
}

List_Cls()
{
if [ -z "$XTERM" ]
then
  XTERM=xterm; export XTERM
fi
#if xterm not found, unset DISPLAY
whence $XTERM 2>&1 > $DEVNULL
ret_whence=$?
if [ $ret_whence -ne 0 ]
then
  unset DISPLAY
fi
BAM_INFCLS_TIME=8; export BAM_INFCLS_TIME
if [ ! -z "$DISPLAY" ]
then
  if [ ! -z "$EBM_NODENAME" ]
  then
    $XTERM -title "$EBM_NODENAME: List Job Classes" -e /bin/ksh -c infact_dcr &
  else
    $XTERM -title "Batch: List Job Classes" -e /bin/ksh -c infact_dcr &
  fi
else
  case $EBM_OS_NAME in
   NT)
      mode 81,25
      infact_dcr
   ;;
   *)
      infact_dcr
   ;;
  esac
fi
unset BAM_INFCLS_TIME
}

Create_Cls()
{
echo "#   Create a Job Class: begin at `$DATECMD`"  >> $LOGFILE
if [ ! -f $TEMPFILE ]
then
  Create_List_CLs
fi
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "                 Classes & Activities: Create                $DATEVAR"
echo ""
cat $TEMPFILE
echo ""
echo $N "Enter the Class name you want to create: [a-z] $C"
read classname
case $classname in
     [a-z])
        grep "  $classname  " $TEMPFILE >> $LOGFILE 2>&1
        if [ $? -eq 0 ]
        then
          $KIXCLS
          DATEVAR="`$DATEVARFILE`"; export DATEVAR
          echo "                 Classes & Activities: Create                $DATEVAR"
          echo ""
          echo ""
          echo ""
          echo ""
          echo "# ERROR. Class $classname is already defined"
          echo ""
          echo ""
          echo "Press Return to Continue"
          read risp
          return
        fi
     ;;
     *) echo "#"
        echo "# ERROR. Invalid Class name"
        echo "#"
        echo "Press Return to Continue"
        read risp
        return
     ;;
esac
echo $N "Enter the number of Activities (Concurrent Jobs) to allocate for Class $classname: $C"
read numacts
case $numacts in
     [1-9]) ;;
     [1-9][0-9]) ;;
     *) echo "#"
        echo "# ERROR. Invalid parameter"
        echo "#"
        echo "Press Return to Continue"
        read risp
        return
     ;;
esac
if [ $numacts -gt 99 ]
then
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities: Create                $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo ""
  echo "# ERROR. The number of Activities is greater than the imposed limit of 99."
  echo ""
  echo ""
  echo "Press Return to Continue"
  read risp
  return
fi
countact=1
echo $N "Please wait $C"
while [ $countact -le $numacts ]
do
  gen=`echo ${countact} | awk ' {printf "%2.2d",$1}'`
  crtact ${classname}_$gen -c$classname > /tmp/act.$$.status 2>&1
  if [ $? -ne 0 ]
  then
    echo "# ERROR. Configuration of Class $classname aborted. Reason:" >> $LOGFILE
    cat /tmp/act.$$.status >> $LOGFILE
    echo "#"
    echo "# ERROR. Configuration of Class $classname aborted. Reason:"
    echo "#"
    cat /tmp/act.$$.status
    echo "#"
    echo "Press Return to Continue"
    read risp
    rm -f /tmp/act.$$.status
    rm -f $TEMPFILE
    return
  else
    cat /tmp/act.$$.status >> $LOGFILE
  fi
  countact=`expr $countact + 1`
  echo $N ".$C"
done
echo ""
Update_Cls_Config
echo "#"
echo "# Class $classname created."
echo "#"
echo "Press Return to Continue"
read risp
rm -f /tmp/act.$$.status
rm -f $TEMPFILE
echo "#   Create a Job Class: end   at `$DATECMD`"  >> $LOGFILE
}

Delete_Cls()
{
echo "#   Delete a Job Class: begin at `$DATECMD`"  >> $LOGFILE
if [ ! -f $TEMPFILE ]
then
  Create_List_CLs
fi
if [ ! -s $TEMPFILE ]
then
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities: Delete                $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo ""
  echo " No Classes are currently defined"
  echo ""
  echo ""
  echo "Press Return to Continue"
  read risp
  return
fi
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "                 Classes & Activities: Delete                $DATEVAR"
echo ""
cat $TEMPFILE
echo ""
echo $N "Enter the Class name you want to delete: [a-z] $C"
read classname
case $classname in
     [a-z])
        grep "  $classname  " $TEMPFILE >> $LOGFILE 2>&1
        if [ $? -ne 0 ]
        then
          $KIXCLS
          DATEVAR="`$DATEVARFILE`"; export DATEVAR
          echo "                 Classes & Activities: Delete                $DATEVAR"
          echo ""
          echo ""
          echo ""
          echo ""
          echo "# ERROR. Class $classname is not defined"
          echo ""
          echo ""
          echo "Press Return to Continue"
          read risp
          return
        fi
     ;;
     *) echo "#"
        echo "# ERROR. Invalid Class name"
        echo "#"
        echo "Press Return to Continue"
        read risp
        return
     ;;
esac
BAM_INFCLS_TIME=8; export BAM_INFCLS_TIME
infact_dcr "list_job_class_by_name" > /tmp/deleteact.$$
status_infact=$?
if [ $status_infact -ne 0 ]
then
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities: Delete                $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo ""
  echo " No Classes are currently defined"
  echo ""
  echo ""
  echo "Press Return to Continue"
  read risp
  return
fi
unset BAM_INFCLS_TIME
rm -f /tmp/war.dlt.$$
rm -f /tmp/err.dlt.$$
touch /tmp/war.dlt.$$
touch /tmp/err.dlt.$$
cat /tmp/deleteact.$$ >> $LOGFILE
cat /tmp/deleteact.$$ |  while read actline
do
  set $actline
  classtype=$1
  actname=$2
  if [ $classname = $classtype ]
  then
    echo $N ".$C"
    dltact $actname > /tmp/dltact.$$.status 2>&1
    case $? in
      0) cat /tmp/dltact.$$.status >> $LOGFILE
         ;;
      1) cat /tmp/dltact.$$.status >> /tmp/war.dlt.$$
         ;;
      *)
         echo "# ERROR. Deleting Class $classname. Reason:" >> $LOGFILE
         cat /tmp/dltact.$$.status >> $LOGFILE
         cat /tmp/dltact.$$.status > /tmp/err.dlt.$$
         cat <$DEVNULL >/tmp/war.dlt.$$
         break
       ;;
    esac
  fi
done
if [ -s /tmp/err.dlt.$$ ]
then
  echo "# Warning. Deletion of Class $classname failed. Reason: " >> $LOGFILE
  cat /tmp/err.dlt.$$ >> $LOGFILE
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities: Delete                $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo "#"
  echo "# ERROR.   Deletion of Class $classname failed. Reason: "
  echo "#"
  cat /tmp/err.dlt.$$
  echo "#"
  echo ""
  echo ""
  echo "Press Return to Continue"
  read risp
  rm -f $TEMPFILE
  rm -f /tmp/deleteact.$$
  rm -f /tmp/dltact.$$.status
  rm -f /tmp/war.dlt.$$
  rm -f /tmp/err.dlt.$$
  return
fi
if [ -s /tmp/war.dlt.$$ ]
then
  echo "# Warning. Deletion of Class $classname partially failed. Reason: " >> $LOGFILE
  cat /tmp/war.dlt.$$ >> $LOGFILE
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities: Delete                $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo "#"
  echo "# Warning. Deletion of Class $classname partially failed. Reason: "
  echo "#"
  cat /tmp/war.dlt.$$
  echo "#"
  echo ""
  echo ""
else
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities: Delete                $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo "#"
  echo "# Class $classname deleted"
  echo "#"
  echo ""
  echo ""
fi
echo "Press Return to Continue"
read risp
Update_Cls_Config
rm -f $TEMPFILE
rm -f /tmp/deleteact.$$
rm -f /tmp/dltact.$$.status
rm -f /tmp/war.dlt.$$
rm -f /tmp/err.dlt.$$
echo "#   Delete a Job Class: end   at `$DATECMD`"  >> $LOGFILE
}

Get_Max_Num_Acts()
{
if [ ! -r $DOTINSTALL ]
then
  echo "# ERROR. The current user does not have appropriate privileges to execute."
  echo "# ERROR. $DOTINSTALL: permission denied" >> $LOGFILE
  exit 1
fi

grep "^max_num_acts=" $DOTINSTALL >> $LOGFILE 2>&1
if [ $? -eq 0 ]
then
  max_num_acts=`grep "^max_num_acts=" $DOTINSTALL | cut -f2 -d'='`
  entry_found_in_dot_install=y
  echo "#   Entry max_num_acts $max_num_acts found in .install" >> $LOGFILE
fi
echo "#   max_num_acts=$max_num_acts" >> $LOGFILE
}

Check_View_Only()
{
View_Only=n
if [ ! $DIRPERM $DOTINSTALL ]
then
  echo "#   $DOTINSTALL: not owner. View only." >> $LOGFILE
  View_Only=y
fi
chmod 644 $DOTINSTALL >> $LOGFILE 2>&1
if [ ! -w $DOTINSTALL ]
then
  echo "#   $DOTINSTALL: permission denied. View only." >> $LOGFILE
  View_Only=y
fi
}

Max_Num_Acts()
{
echo "#   Max Num of Acts: begin at `$DATECMD`"  >> $LOGFILE
Check_View_Only
Get_Max_Num_Acts
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "                 Classes & Activities                        $DATEVAR"
echo ""
echo ""
echo ""
echo ""
echo ""
echo "#"
echo "# Maximum Number of Activities (Concurrent Jobs) Allowed: $max_num_acts"
echo "#"
echo ""
echo ""
echo ""
echo ""
if [ $View_Only = y ]
then
  echo "Press Return to Continue"
  read risp
  return
fi
echo $N "Do you want to update current configuration? <y/n> $C"
read risp
case $risp in
  ""|n|N)
     echo "#"
     echo "# Current configuration not updated"
     echo "#"
     echo "Press Return to Continue"
     read risp
     return
     ;;
  y|Y) ;;
  *) echo "#"
     echo "# Invalid option. Current configuration not updated"
     echo "#"
     echo "Press Return to Continue"
     read risp
     return
     ;;
esac

echo $N "Enter the maximum number of Activities allowed in the system: [1-99] $C"
read risp
case $risp in
  [1-9]) max_num_acts=$risp;;
  [1-9][0-9]) max_num_acts=$risp;;
  *) echo "#"
     echo "# ERROR. Invalid parameter. Configuration aborted."
     echo "#"
     echo "Press Return to Continue"
     read risp
     return
     ;;
esac
rm -f /tmp/secursed.$$
rm -f /tmp/securecho.$$
if [ $entry_found_in_dot_install = y ]
then
  echo "s%^max_num_acts=.*$%max_num_acts=$max_num_acts%" >> /tmp/secursed.$$
else
  echo "max_num_acts=$max_num_acts" >> /tmp/securecho.$$
fi
if [ -s /tmp/secursed.$$ ]
then
  echo "#   Updating .install file" >> $LOGFILE
  cp $DOTINSTALL /tmp/dotinstall.$$
  echo "#   Directives for \"sed\" command:" >> $LOGFILE
  cat /tmp/secursed.$$ >> $LOGFILE
  echo "#   The end of \"sed\" directives." >> $LOGFILE
  sed -f /tmp/secursed.$$ < /tmp/dotinstall.$$ > $DOTINSTALL.$$ 2>> $LOGFILE
  if [ -s $DOTINSTALL.$$ ]
  then
    cat $DOTINSTALL.$$ | grep -v "^$" > $DOTINSTALL 2>> $LOGFILE
    rm $DOTINSTALL.$$
    echo "#   # .install file successfully updated. #" >> $LOGFILE
  fi
fi
if [ -s /tmp/securecho.$$ ]
then
  echo "#   Lines to add:" >> $LOGFILE
  cat /tmp/securecho.$$ >> $LOGFILE
  echo "#   The end added lines." >> $LOGFILE
  cat /tmp/securecho.$$ >> $DOTINSTALL
fi
echo "#   Output of the \"diff\" command is:" >> $LOGFILE
diff $DOTINSTALL /tmp/dotinstall.$$ >> $LOGFILE 2>&1
echo "#   The end of the \"diff\" command." >> $LOGFILE
echo "#"
echo "# Configuration updated."
echo "# In order for this parameter to take effect, you must reboot the batch node."
echo "#"
echo "Press Return to Continue"
read risp
rm -f /tmp/dotinstall.$$
rm -f /tmp/secursed.$$
rm -f /tmp/securecho.$$
echo "#   Max Num of Acts: end   at `$DATECMD`"  >> $LOGFILE
}

View_Only=n
max_num_acts=12
entry_found_in_dot_install=n
TEMPFILE=/tmp/showlistcls.$$
rm -f $TEMPFILE
Cls_loop=1
if [ ! -f $PACK/etc/EBM.ACT ]
then
  echo "# ERROR. Batch node must be active." >> $LOGFILE
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities                        $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo "#"
  echo "# ERROR. The batch node must be active."
  echo "#"
  echo ""
  echo ""
  echo ""
  echo ""
  echo "Press Return to Continue"
  read risp
  exit 1
fi
ebminfo -p > $DEVNULL 2>&1
if [ $? -ne 0 ]
then
  echo "# ERROR. Batch node must be active." >> $LOGFILE
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "                 Classes & Activities                        $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo "#"
  echo "# ERROR. The batch node must be active."
  echo "#"
  echo ""
  echo ""
  echo ""
  echo ""
  echo "Press Return to Continue"
  read risp
  exit 1
fi

case "$BAM_SKILL_0_5" in
     1) List_Cls
        exit 0
        ;;
     ""|*) ;;
esac

while [ $Cls_loop -ne 0 ]
do
# Begin Cls Menu Loop {
# this line clears the screen 
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "                 Classes & Activities                        $DATEVAR"
echo " "
echo " "
echo " "
echo " "
echo " "
echo "             1   List All Job Classes"
echo "             2   Create a Job Class"
echo "             3   Delete a Job Class"
echo "             4   Maximum Number of Activities (Concurrent Jobs) Allowed"
echo " "
echo " "
echo " "
echo " "
echo " "
echo " "
echo "             H - Help"
echo "             R - Return Main Menu"
echo " "
echo "--------------------------------------------------------------------------------"
echo $N "Enter the option number corresponding to the selection you want: $C"
read opt
case $opt in
     1) List_Cls
        ;;
     2) Create_Cls
        ;;
     3) Delete_Cls
        ;;
     4) Max_Num_Acts
        ;;
     R|r|"")
        Cls_loop=0
        ;;
     H|h)   
        $KIXCLS
        DATEVAR="`$DATEVARFILE`"; export DATEVAR
        echo "                 Classes & Activities                        $DATEVAR"
        ${PAGER-'/bin/more'} $PACK/etc/$MYNAME.Cls.help
        echo "Press Return to Continue"
        read risp
     ;;
     *) echo "#"
        echo "# ERROR. Invalid Option"
        echo "#"
        echo "Press Return to Continue"
        read risp
     ;;
esac
# End Cls Menu Loop }
done
rm -f $TEMPFILE
exit 0
