
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2001 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#



#* $Date:   27 Mar 2002 11:28:00  $
#* $Modtime:   20 Feb 2002 10:02:42  $

#
# The makefile may be invoked in the following manner:
#
# make all - Create all user modifiable objects and executables.
#
# make clean - Remove all user modifiable objects and executables.
# 
#----------- RDBMSFLAG = -DORACLE, -DINFORMIX, -DSYBASE or -DDBTWO -----------
RDBMSFLAG=
#------ Set include path for SQLCA ---------------------------
# oracle (pro*cobol 1.3)             INCDIR = $(ORACLE_HOME)/cobol/lib
# oracle (pro*cobol 1.4 and upwards) INCDIR = $(ORACLE_HOME)/procob/lib
# sybase                             INCDIR = $(SYBASE)/include
INCDIR=
#-------------- for oracle database -----------------------
PCC=
PCCFLAGS=
ORACLELIB=
#
#-------------- for informix database -----------------------
INFORMIXLIB=
#
#-------------- for sybase database -----------------------
SYBCC=
SYBFLAGS=
SYBASELIB=

#-------------- for Liant interface -----------------------
PLI=$(LPI_PRODUCT_DIR)/bin/lpipl1
PLT=$(LPI_PRODUCT_DIR)/bin/kixplt
PLX=$(LPI_PRODUCT_DIR)/bin/lpiplx
PP=$(LPI_PRODUCT_DIR)/bin/lpipp
PPL=$(LPI_PRODUCT_DIR)/bin/propli
 
INCPATH=$(LPI_PRODUCT_DIR)/include
PPFLAGS=-isuffix .inc -margins 2,72 -ipath $(INCPATH)
PLIFLAGS=-zp1 -opt 3 -pic -ipath $(INCPATH)
PLTFLAGS=
 
LINKLIBDIR=
#
# ***********************************************
# rules
# ***********************************************

.SUFFIXES:	.c .int .o .cbl .cl2 .pco .eco .cop .pgm .scb .ppl .sqb

.cbl.int:
	rm -f $*.int
	$(COBOL) $(COBFLAGS) -C $(COBOPT) $<
.c.o:
	rm -f $*.o
	$(CC) $(CFLAGS)	$(RDBMSFLAG) -c $<
.pco.o:
	$(PCC) $(PCCFLAGS) iname=$*.pco oname=$*.cob include=$(INCDIR) \
	       ireclen=132
	$(COBOL) -x -c $*.cob
.cop.o:
	$(SYBCC) $(SYBFLAGS) -O$*.cob $*.cop
	$(COBOL) -x -c $*.cob
.eco.o:
	esqlcobol -e $*.eco
	$(COBOL) -x -c $*.cob
.pgm.o:
	rm -f $*.int
	$(COBOL) -x -c -k $*.pgm
.sqb.o:
	rm -f $*.int
		db2 connect to $(DB2DBDFT); \
		db2 prep $< bindfile target mfcob; \
		db2 bind $*.bnd ; \
		db2 connect reset ; \
		db2 terminate ; \
		COBCPY=$(INSTHOME)/sqllib/include/cobol_mf ;\
		export COBCPY ;\
		$(COBOL) -x -c -C $(COBOPT) -k $*.cbl
.scb.o:
	rm -f $*.int
	esqlcbl $*.scb
	$(COBOL) -x -c $*.cbl
.cbl.o:
	rm -f $*.int $*.o
	$(COBOL) -x -c $*.cbl
.ppl.o:
	$(PP)  $(PPFLAGS) $< -o temp.ppl
	$(PPL) iname=temp.ppl oname=temp.pli include=$(INCDIR) ireclen=256 \
	 lmargin=1 rmargin=256 maxliteral=160 mode=ansi
	$(PLI) $(PLIFLAGS) temp.pli -o $*.o
	rm -f temp.lis temp.ppl temp.pli



# ***********************************************
# variables to rules
# ***********************************************

MACHINE=SUN2

#
# Default C compiler location
#

CC=cc

#
# Default C flag settings (optimize).
#

CFLAGS=-D_LARGEFILE64_SOURCE=1 -DSUN -DSolaris2 -I../include

#
# Invoke Linker command.
#

LD=ld

#
# Default Linker flag settings (none).
#

LDFLAGS=

#
# Invoke copy command.
#

CP=cp

#
# Invoke Cobol command.
#

COBOL=cob

#
# Default Cobol compiler options
#
COBOPT="ibmcomp noalter ans85"

#
# Default Cobol flag settings (none).
#

COBFLAGS=
EBMMFDATE=

# ***********************************************
# standard variables
# ***********************************************

#
# Declare the directory where the RUNB will be generated
#

BINDIR=

#
# Declare variable for the location of the src directory
# This directory is the target for the user modifiable source and
# object files.
#

USERSRCDIR=$(BINDIR)

#
# Declare variable for the source modules within the
# user source directory.
# For example USERSOURCES=FSORACLE.pco
#

USERSOURCES=

#
# Declare variable for the object modules within the
# user source directory.
# For example USERSOURCES=FSORACLE.o
#

USEROBJECTS=

#
# Declare variable for the Oracle archives and objects.
#
# Note that ORACLELIB must be set prior to executing the
# make for Oracle.
#

ORACLEOBJECTS=

ORACLE_LINKS=

#
# Declare variable for the Informix archives and objects.
#
# Note that INFORMIXLIB must be set prior to executing the
# make for Informix.
#

INFORMIXOBJECTS=

INFORMIX_LINKS=

#
# Declare variable for the Sybase archives and objects.
#
# Note that INCDIR, SYBASELIB must be set prior to executing the
# make for Sybase/TRANS transaction processor.

SYBASEOBJECTS=

SYBASE_LINKS=

#
# Declare variable for the DB2 archives and objects.
#
# make for DB26000/TRANS transaction processor.

DB2OBJECTS=

DB2_LINKS=

# Declare variable for the Ingres archives and objects.
# Note that INGRESLIB must be set prior to executing this command.
#

INGRESOBJECTS=

INGRES_LINKS=

#
# Declare variable for all source modules plus "system" source
# modules, such as this makefile.
#

SOURCES= \
	makefile.rtsfs \
	fsusrexit.c \
	runfs.c \
	coberror.cbl \
	CCFinit.cbl \
	CCFextfh.cbl \
	cobwrap.cbl \
	$(USERSOURCES)

#
# Declare variable for user object module storage.
#


OBJECTS= \
	coberror.o \
	cobwrap.o \
	fsusrexit.o \
	runfs.o \
	$(USEROBJECTS)

#
# Declare variable for EBM object module storage.
#

EBMOBJECTS= \
	$(EBMMFDATE) \
	CPR.o \
	COB.o \
	CCFinit.o \
	CCFextfh.o \
	kxpassrem.o \
	kxpassubs.o \
	el_date.o \
	ebmlsfile.o \
	kxcat.o \
	lppfserv.o \
	$(OBJECTS) \
	$(ORACLEOBJECTS) \
	$(INFORMIXOBJECTS) \
	$(SYBASEOBJECTS) \
	$(DB2OBJECTS) \
	$(INGRESOBJECTS) 

EBMOBJECTS_NT= \
	$(EBMMFDATE) \
	el_date.o \
	kxpassrem.o \
	kxpassubs.o \
	CPR.o \
	COB.o \
	ebmlsfile.o \
	lppfserv.o \
	cobwrap.lib \
	coberror.lib \
	CCFinit.lib \
	CCFconsole.lib \
	CCFextfh.lib \
	ebmMFbridge.lib \
 fsusrexit.o \
	runfs.o \
	$(USEROBJECTS) \
	$(ORACLEOBJECTS) \
	$(INFORMIXOBJECTS) \
	$(SYBASEOBJECTS) \
	$(DB2OBJECTS) \
	$(INGRESOBJECTS) 

#
# Define link libraries for the various databases.  To be used in
# the process for building unikixtran and RUNB
#

DBLINKS=	\
	$(ORACLE_LINKS) \
	$(INFORMIX_LINKS) \
	$(SYBASE_LINKS) \
	$(DB2_LINKS) \
	$(INGRES_LINKS) 



# ***********************************************
# standard targets
# ***********************************************


all: $(BINDIR)/RUNB

allNT: $(BINDIR)/rtsfsNT
	  chmod 755 $(BINDIR)/rtsfs$(MACHINE).exe
	  rm -f $(BINDIR)/RUNB
	  ln $(BINDIR)/rtsfs$(MACHINE).exe $(BINDIR)/RUNB
	  chmod 755 $(BINDIR)/RUNB

fsusrexitORA.o: fsusrexit.c
	rm -f $?
	$(CC) $(CFLAGS)	$(RDBMSFLAG) -DORACLE -c fsusrexit.c
	mv fsusrexit.o fsusrexitORA.o

$(BINDIR)/RUNB:	$(BINDIR)/rtsfs$(MACHINE)
	if [ $(MACHINE) = "NT" ] ; \
	then \
	  chmod 755 $(BINDIR)/rtsfs$(MACHINE).exe; \
	  rm -f $@; \
	  ln -s $(BINDIR)/rtsfs$(MACHINE).exe $@; \
	  chmod 755 $@; \
	else \
	  chmod 755 $?; \
	  rm -f $@; \
	  ln -s $? $@; \
	  chmod 755 $@; \
	fi;
	@echo "#"
	@echo "#------------------------------------------------------------------------------"
	@echo "# COBOL runtime system $(BINDIR)/RUNB created."
	@echo "#------------------------------------------------------------------------------"
	@echo "#"

clean:
	rm -f $(OBJECTS)
	rm -f $(BINDIR)/rtsfs$(MACHINE)
	rm -f $(BINDIR)/rtsfs$(MACHINE).exe
	rm -f $(BINDIR)/RUNB
	rm -f CCFinit.dll
	rm -f CCFconsole.dll
	rm -f CCFextfh.dll
	rm -f cobwrap.dll
	rm -f coberror.dll
	rm -f ebmMFbridge.dll
	rm -f $(BINDIR)/CCFinit.dll
	rm -f $(BINDIR)/CCFconsole.dll
	rm -f $(BINDIR)/CCFextfh.dll
	rm -f $(BINDIR)/cobwrap.dll
	rm -f $(BINDIR)/coberror.dll
	rm -f $(BINDIR)/ebmMFbridge.dll
	rm -f ebmusrexit.o

#
# Pyramid specific build directives
#

$(BINDIR)/rtsfsNT:	fsusrexit.o runfs.o $(SOURCES)
	rm -f $@
	rm -f cobwrap.obj
	rm -f $(BINDIR)/cobwrap.dll
	cobol cobwrap.cbl ;
	rm -f cobwrap.dll cobwrap.def cobwrap.exp cobwrap.lib
	cbllink -v -d -k -ocobwrap.dll cobwrap.obj
	rm -f coberror.obj
	rm -f $(BINDIR)/coberror.dll
	cobol coberror.cbl ;
	rm -f coberror.dll coberror.def coberror.exp coberror.lib
	cbllink -v -d -k -ocoberror.dll coberror.obj
	rm -f CCFinit.obj
	rm -f $(BINDIR)/CCFinit.dll
	cobol CCFinit.cbl ;
	rm -f CCFinit.dll CCFinit.def CCFinit.exp CCFinit.lib
	cbllink -v -d -k -oCCFinit.dll CCFinit.obj
	rm -f CCFconsole.obj
	rm -f $(BINDIR)/CCFconsole.dll
	cobol CCFconsole.cbl ;
	rm -f CCFconsole.dll CCFconsole.def CCFconsole.exp CCFconsole.lib
	cbllink -v -d -k -oCCFconsole.dll CCFconsole.obj
	rm -f CCFextfh.obj
	rm -f $(BINDIR)/CCFextfh.dll
	cobol CCFextfh.cbl ;
	rm -f CCFextfh.dll CCFextfh.def CCFextfh.exp CCFextfh.lib
	cbllink -v -d -k -oCCFextfh.dll CCFextfh.obj
	rm -f ebmMFbridge.obj
	rm -f $(BINDIR)/ebmMFbridge.dll
	cl -DWINTEL -DINTEL -D__NUTC__=0x301 -I ../include -c ebmMFbridge.c
	rm -f ebmMFbridge.dll ebmMFbridge.def ebmMFbridge.exp ebmMFbridge.lib
	link -dll -subsystem:console -out:ebmMFbridge.dll ebmMFbridge.obj \
	      CCFconsole.lib MFRTS32.lib LIBC.lib OLDNAMES.lib
	cc -o $@ $(EBMOBJECTS_NT) -lsocket -lcurses

$(BINDIR)/rtsfsPYR:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD $(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lm -lmproc -lext -lsocket -lnsl -lcurses

#
# Sequent specific build directives
#

$(BINDIR)/rtsfsSEQ:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lm -lsocket -lnsl -lcurses 

#
# Stratus specific build directives
#

$(BINDIR)/rtsfsSTRATUS:  $(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD $(LDFLAGS) $(LINKLIBDIR) -L /usr/ccs/lib -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lm -lcurses -lsocket -lnsl

#
# DG specific build directives
#

$(BINDIR)/rtsfsDG:		$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) -L /usr/sde/default/usr/lib \
			-lm -lsocket -lnsl -lcurses

#
# HP specific build directives
#

$(BINDIR)/rtsfsHP:		$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lV3 -lm -lc -lcurses

#
# RS/6000 (AIX) specific build directives
#

DB2VSAM=-e ""

$(BINDIR)/rtsfsAIX:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(DB2VSAM)  \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lm -lcurses

#
# ENCORE specific build directives
#

$(BINDIR)/rtsfsENC: 	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD $(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lcurses


#
# SUN (Solaris1.x) 
#

$(BINDIR)/rtsfsSUN:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lcurses

#
# SUN2 (Solaris2.x) specific build directives
#

$(BINDIR)/rtsfsSUN2:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD $(LDFLAGS) $(LINKLIBDIR) -L /usr/ccs/lib -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lm -lcurses -lsocket -lnsl

#
# Tandem specific build directives
#

$(BINDIR)/rtsfsTAND:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lm -lcurses

#
# NCR specific build directives
#

$(BINDIR)/rtsfsNCR:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lsocket -lnsl -lcurses -lx -lnet -lm

#
# SINIX specific build directives
#

$(BINDIR)/rtsfsSINIX:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD	$(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			-lm -lcurses

#
# DEC/Alpha specific build directives
#

$(BINDIR)/rtsfsALPHA:	$(EBMOBJECTS) $(SOURCES)
	rm -f $@
	$(COBOL) $(COBFLAGS) -xD -lots -Q"-taso" $(LDFLAGS) $(LINKLIBDIR) -o $@ \
			$(EBMOBJECTS) \
			$(DBLINKS) \
			/usr/shlib/libm.so /usr/shlib/libcurses.so

