/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.util;

import com.sun.emp.mbm.util.DialogHandler;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdLabelSeparator;
import com.sun.emp.mbm.util.JdTraceFilterClass;
import com.sun.emp.mbm.util.Log;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JdTraceDialog
extends JDialog {
    private JdTraceFilterClass[] arr_filterClasses;
    private JTabbedPane jtabpane;
    private JPanel jpnl_controls;
    private JdLabelSeparator lblSep;
    private JRadioButton jrBtn_on;
    private JRadioButton jrBtn_off;
    private ButtonGroup bgroup;
    private TextArea ta_log;
    private JComboBox cBox_levels;
    private JComboBox cBox_classes;
    private JComboBox cBox_refreshInterval;
    private JTextArea jTA_refreshInterval;
    private JTextArea jTADir;
    private WarningDlg wDlg;
    private Level logLevel;
    private Thread refreshThread;
    private JRadioButton jrBtn_activate;
    private JRadioButton jrBtn_deactivate;
    private final String SELECT_TRACE_LEVEL = "Select a Trace Level...";
    private final String TRACE_LEVEL_1 = "Trace Level 1";
    private final String TRACE_LEVEL_2 = "Trace Level 2";
    private final String TRACE_LEVEL_3 = "Trace Level 3";
    private final FileDialog fileDlg = new FileDialog(new Frame());
    private String trace_Level;
    private String filterClass = "All Components";
    private String logLocation;
    private long refreshInterval = 5L;
    private boolean traceOn;
    private int threadCounter = 0;
    private boolean flag_firstCycle = true;
    private boolean flag_userChange;
    private boolean flag_threadToLive;
    private boolean flag_activateTrace;
    private boolean flag_dirChanged;
    private boolean flag_dirListed = true;
    private boolean flag_refreshThreadIsDead = true;

    public JdTraceDialog(JdTraceFilterClass[] arr_tfc) {
        super((Dialog)new JDialog(), "Trace Dialog");
        Log.setFilterClasses(arr_tfc[0].getFilterItems());
        this.arr_filterClasses = arr_tfc;
        this.jtabpane = new JTabbedPane();
        this.jtabpane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                if (JdTraceDialog.this.jtabpane.getSelectedIndex() == 2) {
                    JdTraceDialog.this.ta_log.setVisible(true);
                }
            }
        });
        this.createTab1();
        this.createTab2();
        this.createTab3();
        this.createTab4();
        this.getContentPane().add(this.jtabpane);
        this.jpnl_controls = new JPanel();
        this.createControlsJPan();
        this.getContentPane().add((Component)this.jpnl_controls, "South");
        this.setSize(600, 555);
        this.setVisible(false);
    }

    public void setVisibility(boolean vis) {
        this.setVisible(vis);
    }

    private void createTab1() {
        JPanel tab1 = new JPanel();
        tab1.setLayout(new JdFormLayout());
        JPanel jp1 = new JPanel();
        this.lblSep = new JdLabelSeparator("Trace Setting");
        jp1.add(this.lblSep);
        tab1.add(jp1);
        JPanel jp2 = new JPanel();
        this.jrBtn_on = new JRadioButton("On", this.traceOn);
        this.jrBtn_off = new JRadioButton("Off", this.traceOn);
        this.bgroup = new ButtonGroup();
        this.bgroup.add(this.jrBtn_on);
        this.bgroup.add(this.jrBtn_off);
        jp2.add(this.jrBtn_on);
        jp2.add(this.jrBtn_off);
        tab1.add(jp2);
        RadioListener radioListen = new RadioListener(this);
        this.jrBtn_on.addActionListener(radioListen);
        this.jrBtn_off.addActionListener(radioListen);
        JPanel jp3 = new JPanel();
        this.lblSep = new JdLabelSeparator("Trace Levels");
        jp3.add(this.lblSep);
        tab1.add(jp3);
        JPanel jp4 = new JPanel();
        this.cBox_levels = new JComboBox();
        this.cBox_levels.addItem("Select a Trace Level...");
        this.cBox_levels.addItem("Trace Level 1");
        this.cBox_levels.addItem("Trace Level 2");
        this.cBox_levels.addItem("Trace Level 3");
        jp4.add(this.cBox_levels);
        tab1.add(jp4);
        this.cBox_levels.addItemListener(new ComBoxListener(this));
        this.jtabpane.add("Level Settings", tab1);
    }

    private void createTab2() {
        JPanel tab2 = new JPanel();
        tab2.setLayout(new JdFormLayout());
        JPanel jp1 = new JPanel();
        this.lblSep = new JdLabelSeparator("Filter Selection");
        jp1.add(this.lblSep);
        tab2.add(jp1);
        JPanel jp2 = new JPanel();
        this.cBox_classes = new JComboBox();
        int i = 0;
        while (i < this.arr_filterClasses.length) {
            this.cBox_classes.addItem(this.arr_filterClasses[i].getFilterOption());
            ++i;
        }
        jp2.add(this.cBox_classes);
        tab2.add(jp2);
        this.cBox_classes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                Log.setFilterClasses(JdTraceDialog.this.arr_filterClasses[JdTraceDialog.this.cBox_classes.getSelectedIndex()].getFilterItems());
                JdTraceDialog.this.filterClass = JdTraceDialog.this.arr_filterClasses[JdTraceDialog.this.cBox_classes.getSelectedIndex()].getFilterOption();
            }
        });
        JPanel jp3 = new JPanel();
        this.lblSep = new JdLabelSeparator("Clear Trace Filter");
        jp3.add(this.lblSep);
        tab2.add(jp3);
        JPanel jp4 = new JPanel();
        JButton jBtn_clear = new JButton("Reset");
        jBtn_clear.addActionListener(new ClearHandler(this));
        jp4.add(jBtn_clear);
        tab2.add(jp4);
        this.jtabpane.add("Filter Setting", tab2);
    }

    private void createTab3() {
        JPanel tab3 = new JPanel();
        tab3.setLayout(new JdFormLayout());
        JPanel jp1 = new JPanel();
        this.lblSep = new JdLabelSeparator("Activate Console");
        jp1.add(this.lblSep);
        tab3.add(jp1);
        JPanel jp2 = new JPanel();
        this.jrBtn_activate = new JRadioButton("On", false);
        this.jrBtn_deactivate = new JRadioButton("Off", true);
        ButtonGroup bgrp = new ButtonGroup();
        this.jrBtn_activate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdTraceDialog.this.flag_activateTrace = true;
            }
        });
        this.jrBtn_deactivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdTraceDialog.this.flag_activateTrace = false;
            }
        });
        bgrp.add(this.jrBtn_activate);
        bgrp.add(this.jrBtn_deactivate);
        jp2.add(this.jrBtn_activate);
        jp2.add(this.jrBtn_deactivate);
        tab3.add(jp2);
        JPanel jp3 = new JPanel();
        this.lblSep = new JdLabelSeparator("Display");
        jp3.add(this.lblSep);
        tab3.add(jp3);
        JPanel jp4 = new JPanel();
        this.ta_log = new TextArea(16, 80);
        this.ta_log.setVisible(false);
        jp4.add(this.ta_log);
        tab3.add(jp4);
        this.jtabpane.add("Log Console", tab3);
    }

    private void createTab4() {
        JPanel tab4 = new JPanel();
        tab4.setLayout(new JdFormLayout());
        JPanel jp1 = new JPanel();
        this.lblSep = new JdLabelSeparator("Trace File Location");
        jp1.add(this.lblSep);
        tab4.add(jp1);
        JPanel jp2 = new JPanel();
        JLabel jLDir = new JLabel("Enter Directory: ");
        this.jTADir = new JTextArea(this.getLogDirectory(), 1, 15);
        this.jTADir.setEnabled(false);
        jp2.add(jLDir);
        jp2.add(this.jTADir);
        tab4.add(jp2);
        JPanel jp3 = new JPanel();
        JButton jBtn_browse = new JButton("Browse");
        jBtn_browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdTraceDialog.this.fileDlg.setFile("System Generated Filename");
                JdTraceDialog.this.fileDlg.show();
                if (JdTraceDialog.this.fileDlg.getDirectory() != null) {
                    JdTraceDialog.this.flag_dirChanged = true;
                    JdTraceDialog.this.jTADir.setText(JdTraceDialog.this.fileDlg.getDirectory());
                }
                if (JdTraceDialog.this.jTADir.getText().equals("No Default")) {
                    JdTraceDialog.this.flag_dirListed = false;
                } else {
                    JdTraceDialog.this.flag_dirListed = true;
                }
            }
        });
        jp3.add(jBtn_browse);
        tab4.add(jp3);
        JPanel jp4 = new JPanel();
        this.lblSep = new JdLabelSeparator("Log Console Refresh Interval");
        jp4.add(this.lblSep);
        tab4.add(jp4);
        JPanel jp5 = new JPanel();
        JLabel jLbl_refreshInterval = new JLabel("Enter Seconds: ");
        this.jTA_refreshInterval = new JTextArea("5", 1, 1);
        jp5.add(jLbl_refreshInterval);
        jp5.add(this.jTA_refreshInterval);
        tab4.add(jp5);
        this.jtabpane.add("Pane Properties", tab4);
    }

    private void createControlsJPan() {
        this.jpnl_controls.setLayout(new JdFormLayout());
        JPanel jp1 = new JPanel();
        this.lblSep = new JdLabelSeparator("Processing Options");
        jp1.add(this.lblSep);
        this.jpnl_controls.add(jp1);
        JPanel jp2 = new JPanel();
        JButton jBtn_ok = new JButton("OK");
        jBtn_ok.addActionListener(new OKHandler(this));
        jp2.add(jBtn_ok);
        JButton jBtn_apply = new JButton("Apply");
        jBtn_apply.addActionListener(new ApplyHandler(this));
        jp2.add(jBtn_apply);
        JButton jBtn_cancel = new JButton("Cancel");
        jBtn_cancel.addActionListener(new CancelHandler(this));
        jp2.add(jBtn_cancel);
        this.jpnl_controls.add(jp2);
        JPanel jp3 = new JPanel();
        this.lblSep = new JdLabelSeparator();
        jp3.add(this.lblSep);
        this.jpnl_controls.add(jp3);
    }

    private String getLogDirectory() {
        String tdir = Log.getTraceDirectory();
        if (tdir.indexOf("%t") != -1) {
            // empty if block
        }
        return tdir;
    }

    private void performLog(JdTraceDialog tl) {
        if (this.bgroup.getSelection() == null) {
            this.wDlg = new WarningDlg(tl, "A Trace Setting must be selected.");
        } else if (tl.cBox_levels.getSelectedIndex() == 0) {
            this.wDlg = new WarningDlg(tl, "A Trace Level must be selected.");
        } else {
            if (this.flag_dirListed && this.flag_dirChanged) {
                this.flag_dirChanged = false;
                this.logLocation = this.jTADir.getText();
                Log.setTraceDirectory(this.logLocation);
            } else if (!this.flag_dirListed) {
                this.logLocation = "Not Selected";
                Log.setTraceDirectory(this.logLocation);
            } else {
                this.logLocation = this.jTADir.getText();
            }
            if (this.flag_activateTrace) {
                Log.tracing(this.traceOn);
                Log.setTraceLevel(this.logLevel);
                this.setJTA_refreshInterval();
                if (this.flag_firstCycle) {
                    this.flag_firstCycle = false;
                    this.flag_threadToLive = true;
                    this.createRefreshThread();
                    this.refreshThread.start();
                } else if (this.flag_userChange || this.flag_refreshThreadIsDead) {
                    this.flag_threadToLive = true;
                    this.createRefreshThread();
                    this.refreshThread.start();
                }
            } else {
                this.flag_threadToLive = false;
                this.setJTA_refreshInterval();
            }
        }
        String trcSet = null;
        trcSet = this.jrBtn_on.isSelected() ? "On" : "Off";
        String logCons = null;
        logCons = this.jrBtn_activate.isSelected() ? "Activated" : "Deactivated";
        ViewSettingsDlg vsd = new ViewSettingsDlg(tl, trcSet, this.trace_Level, this.filterClass, logCons, this.logLocation, this.refreshInterval);
    }

    private void createRefreshThread() {
        this.refreshThread = new Thread(new Runnable(){

            public void run() {
                int thisThreadNum = 0;
                boolean flag_latestThread = true;
                DialogHandler dh = Log.getDialogHandler();
                JdTraceDialog.this.flag_refreshThreadIsDead = false;
                while (JdTraceDialog.this.flag_threadToLive && flag_latestThread) {
                    thisThreadNum = ++JdTraceDialog.this.threadCounter;
                    JdTraceDialog.this.ta_log.setText(Log.getTextArea().getText());
                    JdTraceDialog.this.ta_log.setCaretPosition(Log.getTextArea().getText().length());
                    try {
                        Thread.sleep(JdTraceDialog.this.refreshInterval * 1000L);
                    }
                    catch (InterruptedException ie) {
                        System.out.println("Interrupted Exception - " + ie);
                    }
                    if (thisThreadNum == JdTraceDialog.this.threadCounter) continue;
                    flag_latestThread = false;
                }
                JdTraceDialog.this.flag_refreshThreadIsDead = true;
            }
        });
    }

    private void setJTA_refreshInterval() {
        long oldInterval = this.refreshInterval;
        String str_newInterval = this.jTA_refreshInterval.getText();
        try {
            Long Long_temp = new Long(str_newInterval);
            this.refreshInterval = Long_temp;
            if (this.refreshInterval != oldInterval) {
                this.flag_userChange = true;
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("NumberFormatException - " + nfe);
            this.refreshInterval = oldInterval;
            this.wDlg = new WarningDlg(this, "Interval entry must be numeric.");
            this.jTA_refreshInterval.setText(new Long(oldInterval).toString());
        }
    }

    public static void main(String[] args) {
        int ARRAY_SIZE = 5;
        JdTraceFilterClass[] test_arr_tfc = new JdTraceFilterClass[5];
        JdTraceFilterClass test_tfc = null;
        int i = 0;
        test_arr_tfc[i] = test_tfc = new JdTraceFilterClass("All components (default)", "com.sun.emp.mbm.jedit.pgm.JEdit");
        test_tfc = new JdTraceFilterClass("Tree Expansion", "com.sun.emp.mbm.jedit.controller.JdTreeExpansionListener");
        test_arr_tfc[++i] = test_tfc;
        test_tfc = new JdTraceFilterClass("Tree Selection", "com.sun.emp.mbm.jedit.controller.JdTreeSelectionListener");
        test_arr_tfc[++i] = test_tfc;
        test_tfc = new JdTraceFilterClass("Node Action", "com.sun.emp.mbm.jedit.controller.JdActionListener");
        test_arr_tfc[++i] = test_tfc;
        test_tfc = new JdTraceFilterClass("Data Persistence", "com.sun.emp.mbm.jedit.model.JdJobFolderElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdProcFolderElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdProjectElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdJobElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdProcElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdProcStepElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdPgmStepElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdUtilStepElement");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdInputFile");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdVsamFile");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdConcatenatedFile");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdGdgFile");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdPrintFile");
        test_tfc.addFilterItem("com.sun.emp.mbm.jedit.model.JdStandardFile");
        test_arr_tfc[++i] = test_tfc;
        JdTraceDialog td = new JdTraceDialog(test_arr_tfc);
        td.setVisibility(true);
    }

    private class ViewSettingsDlg
    extends JDialog {
        ViewSettingsDlg(Dialog d, String trcSet, String trcLvl, String fltrSel, String logCons, String logLocation, long refreshInterval) {
            super(d, "Current Settings", true);
            JPanel centerJPan = new JPanel();
            centerJPan.setLayout(new GridLayout(6, 1));
            JLabel jlbl_1 = new JLabel("Trace Setting:  " + trcSet);
            jlbl_1.setHorizontalAlignment(0);
            centerJPan.add(jlbl_1);
            JLabel jlbl_2 = new JLabel("Trace Level:  " + trcLvl);
            jlbl_2.setHorizontalAlignment(0);
            centerJPan.add(jlbl_2);
            JLabel jlbl_3 = new JLabel("Filter Selection:  " + fltrSel);
            jlbl_3.setHorizontalAlignment(0);
            centerJPan.add(jlbl_3);
            JLabel jlbl_4 = new JLabel("Log Console:  " + logCons);
            jlbl_4.setHorizontalAlignment(0);
            centerJPan.add(jlbl_4);
            JLabel jlbl_5 = new JLabel("Trace File Location:  " + logLocation);
            jlbl_5.setHorizontalAlignment(0);
            centerJPan.add(jlbl_5);
            JLabel jlbl_6 = new JLabel("Refresh Interval:  " + refreshInterval + " Seconds");
            jlbl_6.setHorizontalAlignment(0);
            centerJPan.add(jlbl_6);
            this.getContentPane().add((Component)centerJPan, "Center");
            JButton jbtn_okd = new JButton("OK");
            jbtn_okd.addActionListener(new ActionListener(this){
                private final /* synthetic */ ViewSettingsDlg this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.setVisible(false);
                }
            });
            JPanel jP = new JPanel();
            jP.add(jbtn_okd);
            this.getContentPane().add((Component)jP, "South");
            this.setSize(450, 250);
            this.setVisible(true);
        }
    }

    private class CancelHandler
    implements ActionListener {
        JdTraceDialog tl = null;

        public CancelHandler(JdTraceDialog tl) {
            this.tl = tl;
        }

        public void actionPerformed(ActionEvent ae) {
            this.tl.setVisible(false);
        }
    }

    private class WarningDlg
    extends JDialog {
        WarningDlg(Dialog d, String str) {
            super(d, "Warning", true);
            JLabel jlbl_warning = new JLabel(str);
            JPanel p1 = new JPanel();
            p1.add(jlbl_warning);
            this.getContentPane().add(p1);
            JButton jbtn_okd = new JButton("OK");
            jbtn_okd.addActionListener(new ActionListener(this){
                private final /* synthetic */ WarningDlg this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.setVisible(false);
                }
            });
            JPanel p2 = new JPanel();
            p2.add(jbtn_okd);
            this.getContentPane().add((Component)p2, "South");
            this.setSize(250, 100);
            this.setVisible(true);
        }
    }

    private class ApplyHandler
    implements ActionListener {
        JdTraceDialog tl = null;

        public ApplyHandler(JdTraceDialog tl) {
            this.tl = tl;
        }

        public void actionPerformed(ActionEvent ae) {
            JdTraceDialog.this.performLog(this.tl);
        }
    }

    private class OKHandler
    implements ActionListener {
        JdTraceDialog tl = null;

        public OKHandler(JdTraceDialog tl) {
            this.tl = tl;
        }

        public void actionPerformed(ActionEvent ae) {
            JdTraceDialog.this.performLog(this.tl);
            this.tl.setVisible(false);
        }
    }

    private class ClearHandler
    implements ActionListener {
        JdTraceDialog tl = null;

        public ClearHandler(JdTraceDialog tl) {
            this.tl = tl;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.tl.jrBtn_on.isSelected()) {
                this.tl.jrBtn_off.setSelected(true);
                JdTraceDialog.this.traceOn = false;
                JdTraceDialog.this.flag_threadToLive = false;
                JdTraceDialog.this.jrBtn_deactivate.doClick();
            }
            JdTraceDialog.this.cBox_levels.setSelectedIndex(0);
            JdTraceDialog.this.logLevel = Level.OFF;
            JdTraceDialog.this.cBox_classes.setSelectedIndex(0);
            this.tl.repaint();
            Log.clearTraceFilter();
        }
    }

    private class ComBoxListener
    implements ItemListener {
        JdTraceDialog td = null;

        ComBoxListener(JdTraceDialog td) {
            this.td = td;
        }

        public void itemStateChanged(ItemEvent e) {
            switch (this.td.cBox_levels.getSelectedIndex()) {
                case 1: {
                    JdTraceDialog.this.logLevel = Level.INFO;
                    JdTraceDialog.this.trace_Level = "Trace Level 1";
                    break;
                }
                case 2: {
                    JdTraceDialog.this.logLevel = Level.WARNING;
                    JdTraceDialog.this.trace_Level = "Trace Level 2";
                    break;
                }
                case 3: {
                    JdTraceDialog.this.logLevel = Level.SEVERE;
                    JdTraceDialog.this.trace_Level = "Trace Level 3";
                    break;
                }
                default: {
                    JdTraceDialog.this.logLevel = Level.OFF;
                    JdTraceDialog.this.trace_Level = "Select a Trace Level...";
                }
            }
        }
    }

    private class RadioListener
    implements ActionListener {
        JdTraceDialog td = null;

        RadioListener(JdTraceDialog td) {
            this.td = td;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.td.jrBtn_on) {
                JdTraceDialog.this.traceOn = true;
            } else {
                JdTraceDialog.this.traceOn = false;
            }
        }
    }
}

