/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.util;

import com.sun.emp.mbm.util.JdLabelSeparator;
import com.sun.emp.mbm.util.Tester;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JdFormLayout
implements LayoutManager {
    protected int jdDivider = -1;
    protected int jdHGap = 10;
    protected int jdVGap = 5;
    protected Vector jdV = new Vector();
    protected static final int COMP_TWO_COL = 0;
    protected static final int COMP_BIG = 1;
    protected static final int COMP_BUTTON = 2;

    public JdFormLayout() {
    }

    public JdFormLayout(int hGap, int vGap) {
        this.jdHGap = hGap;
        this.jdVGap = vGap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void layoutContainer(Container parent) {
        this.jdV.removeAllElements();
        int jd_type = -1;
        Insets jd_insets = parent.getInsets();
        int jd_width = parent.getWidth() - jd_insets.left - jd_insets.right;
        int jd_x = jd_insets.left;
        int jd_y = jd_insets.top;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component comp = parent.getComponent(i);
            int newType = this.getLayoutType(comp);
            if (i == 0) {
                jd_type = newType;
            }
            if (jd_type != newType) {
                jd_y = this.layoutComponents(this.jdV, jd_type, jd_x, jd_y, jd_width);
                this.jdV.removeAllElements();
                jd_type = newType;
            }
            this.jdV.addElement(comp);
            ++i;
        }
        jd_y = this.layoutComponents(this.jdV, jd_type, jd_x, jd_y, jd_width);
        this.jdV.removeAllElements();
    }

    protected int layoutComponents(Vector jd_vec, int jd_type, int jd_x, int jd_y, int jd_width) {
        switch (jd_type) {
            case 0: {
                int divider = this.getDivider(jd_vec);
                int i = 1;
                while (i < jd_vec.size()) {
                    Component comp1 = (Component)jd_vec.elementAt(i - 1);
                    Component comp2 = (Component)jd_vec.elementAt(i);
                    Dimension d = comp2.getPreferredSize();
                    comp1.setBounds(jd_x + 5, jd_y, divider - this.jdHGap, d.height);
                    comp2.setBounds(jd_x + divider, jd_y, jd_width - divider, d.height);
                    jd_y += d.height + this.jdVGap;
                    i += 2;
                }
                return jd_y;
            }
            case 1: {
                int i = 0;
                while (i < jd_vec.size()) {
                    Component comp = (Component)jd_vec.elementAt(i);
                    Dimension d = comp.getPreferredSize();
                    comp.setBounds(jd_x, jd_y, jd_width, d.height);
                    jd_y += d.height + this.jdVGap;
                    ++i;
                }
                return jd_y;
            }
            case 2: {
                Dimension d = this.getMaxDimension(jd_vec);
                int ww = d.width * jd_vec.size() + this.jdHGap * (jd_vec.size() - 1);
                int xx = jd_x + Math.max(0, (jd_width - ww) / 2);
                int i = 0;
                while (i < jd_vec.size()) {
                    Component comp = (Component)jd_vec.elementAt(i);
                    comp.setBounds(xx, jd_y, d.width, d.height);
                    xx += d.width + this.jdHGap;
                    ++i;
                }
                return jd_y + d.height;
            }
        }
        throw new IllegalArgumentException("Illegal type " + jd_type);
    }

    public void setDivider(int jd_divider) {
        if (jd_divider > 0) {
            this.jdDivider = jd_divider;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.jdV.removeAllElements();
        int jd_width = 0;
        int jd_height = 0;
        int jd_type = -1;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component comp = parent.getComponent(i);
            int newType = this.getLayoutType(comp);
            if (i == 0) {
                jd_type = newType;
            }
            if (jd_type != newType) {
                Dimension d = this.preferredLayoutSize(this.jdV, jd_type);
                jd_width = Math.max(jd_width, d.width);
                jd_height += d.height + this.jdVGap;
                this.jdV.removeAllElements();
                jd_type = newType;
            }
            this.jdV.addElement(comp);
            ++i;
        }
        Dimension jd_dimen = this.preferredLayoutSize(this.jdV, jd_type);
        jd_width = Math.max(jd_width, jd_dimen.width);
        jd_height += jd_dimen.height + this.jdVGap;
        Insets jd_insets = parent.getInsets();
        return new Dimension(jd_width + jd_insets.left + jd_insets.right, (jd_height -= this.jdVGap) + jd_insets.top + jd_insets.bottom);
    }

    protected Dimension preferredLayoutSize(Vector jd_vec, int jd_type) {
        int jd_width = 0;
        int jd_height = 0;
        switch (jd_type) {
            case 0: {
                int divider = this.getDivider(jd_vec);
                int i = 1;
                while (i < jd_vec.size()) {
                    Component comp = (Component)jd_vec.elementAt(i);
                    Dimension d = comp.getPreferredSize();
                    jd_width = Math.max(jd_width, d.width);
                    jd_height += d.height + this.jdVGap;
                    i += 2;
                }
                return new Dimension(divider + jd_width, jd_height -= this.jdVGap);
            }
            case 1: {
                int i = 0;
                while (i < jd_vec.size()) {
                    Component comp = (Component)jd_vec.elementAt(i);
                    Dimension d = comp.getPreferredSize();
                    jd_width = Math.max(jd_width, d.width);
                    jd_height += d.height + this.jdVGap;
                    ++i;
                }
                return new Dimension(jd_width, jd_height -= this.jdVGap);
            }
            case 2: {
                Dimension d = this.getMaxDimension(jd_vec);
                jd_width = d.width + this.jdHGap;
                jd_height = d.height;
                return new Dimension(jd_width * jd_vec.size() - this.jdHGap, jd_height);
            }
        }
        throw new IllegalArgumentException("Illegal type " + jd_type);
    }

    public int getHGap() {
        return this.jdHGap;
    }

    public int getVGap() {
        return this.jdVGap;
    }

    public int getDivider() {
        return this.jdDivider;
    }

    protected int getDivider(Vector jd_vec) {
        if (this.jdDivider > 0) {
            return this.jdDivider;
        }
        int jd_divider = 0;
        int i = 0;
        while (i < jd_vec.size()) {
            Component comp = (Component)jd_vec.elementAt(i);
            Dimension d = comp.getPreferredSize();
            jd_divider = Math.max(jd_divider, d.width);
            i += 2;
        }
        return jd_divider += this.jdHGap;
    }

    protected Dimension getMaxDimension(Vector jd_vec) {
        int jd_width = 0;
        int jd_height = 0;
        int i = 0;
        while (i < jd_vec.size()) {
            Component comp = (Component)jd_vec.elementAt(i);
            Dimension d = comp.getPreferredSize();
            jd_width = Math.max(jd_width, d.width);
            jd_height = Math.max(jd_height, d.height);
            ++i;
        }
        return new Dimension(jd_width, jd_height);
    }

    protected int getLayoutType(Component comp) {
        if (comp instanceof AbstractButton) {
            return 2;
        }
        if (comp instanceof JPanel || comp instanceof JScrollPane || comp instanceof JdLabelSeparator) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap = " + this.jdHGap + ", vgap = " + this.jdVGap + ", divider = " + this.jdDivider + "]";
    }

    public static void main(String[] args) {
        Tester tester = new Tester();
    }

    static {
        COMP_TWO_COL = 0;
        COMP_BIG = 1;
        COMP_BUTTON = 2;
    }
}

