/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.util;

import com.sun.emp.mbm.util.EmpFormatter;
import java.awt.Font;
import java.awt.TextArea;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class DialogHandler
extends Handler {
    private LogManager manager = LogManager.getLogManager();
    private TextArea textArea;
    private Object devLock;
    private boolean doneHeader = false;

    public DialogHandler() {
        this.init();
    }

    public synchronized void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.reportError(null, ex, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                this.textArea.append(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.textArea.append(msg + "\n");
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record);
    }

    public synchronized void close() {
    }

    public synchronized void flush() {
    }

    public TextArea getTextArea() {
        return this.textArea;
    }

    private void init() {
        this.textArea = new TextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.setFormatter(new EmpFormatter());
    }

    public void setTextArea(TextArea textarea) {
        if (textarea != null) {
            this.textArea = textarea;
        }
    }
}

