/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.interfaces.JdIIconElement;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.jedit.view.Tester;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class JdIconCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected Color m_textSelection = UIManager.getColor("Tree.selectionForeground");
    protected Color m_textNonSelection = UIManager.getColor("Tree.textForeground");
    protected Color m_bkSelection = UIManager.getColor("Tree.selectionBackground");
    protected Color m_bkNonSelection = UIManager.getColor("Tree.textBackground");
    protected Color m_borderSelection = UIManager.getColor("Tree.selectionBorderColor");
    protected boolean m_selected;

    public JdIconCellRenderer() {
        this.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            JdMutableTreeNode node = (JdMutableTreeNode)value;
            JdIIconElement ie = node.getJdIIconElement();
            this.setText(node.toString());
            if (expanded) {
                this.setIcon(ie.getExpandedIcon());
            } else {
                this.setIcon(ie.getIcon());
            }
        } else {
            this.setIcon(null);
        }
        this.setFont(tree.getFont());
        this.setForeground(selected ? this.m_textSelection : this.m_textNonSelection);
        this.setBackground(selected ? this.m_bkSelection : this.m_bkNonSelection);
        this.m_selected = selected;
        return this;
    }

    public void paintComponent(Graphics g) {
        Color bColor = this.getBackground();
        Icon icon = this.getIcon();
        g.setColor(bColor);
        int offset = 0;
        if (icon != null && this.getText() != null) {
            offset = icon.getIconWidth() + this.getIconTextGap();
        }
        g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        if (this.m_selected) {
            g.setColor(this.m_borderSelection);
            g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        }
        super.paintComponent(g);
    }

    public static void main(String[] args) {
        Tester tester = new Tester();
    }
}

