/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIStepElement;
import com.sun.emp.mbm.jedit.model.JdPgmStepElement;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JdCondCodeUI
extends JPanel
implements JdIFormUI {
    private JdIStepElement jdElement;
    private JLabel jdiflbl;
    private JLabel jdthenlbl;
    private JLabel jdgotolbl;
    private JComboBox jdfirstcmb;
    private JComboBox jdthencmb;
    private JTextField jdgototxt;
    private JTextField jdvaluetxt;
    private JButton jdlistbtn;

    public JdCondCodeUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 30);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp = new JPanel();
        this.jdiflbl = new JLabel("If Condition Code");
        this.jdthenlbl = new JLabel("Then");
        this.jdgotolbl = new JLabel("Goto Step");
        this.jdfirstcmb = new JComboBox();
        this.jdvaluetxt = new JTextField(5);
        this.jdthencmb = new JComboBox();
        this.jdgototxt = new JTextField("End Of Job");
        this.jdlistbtn = new JButton("List");
        this.jdlistbtn.setEnabled(false);
        this.jdthencmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String str = (String)cb.getSelectedItem();
                if (str.equals("GOTO")) {
                    JdCondCodeUI.this.jdgototxt.setEditable(true);
                    JdCondCodeUI.this.jdlistbtn.setEnabled(true);
                } else {
                    JdCondCodeUI.this.jdgototxt.setText("");
                    JdCondCodeUI.this.jdgototxt.setEditable(false);
                    JdCondCodeUI.this.jdlistbtn.setEnabled(false);
                }
            }
        });
        this.jdfirstcmb.addItem("EQ");
        this.jdfirstcmb.addItem("NE");
        this.jdfirstcmb.addItem("GT");
        this.jdfirstcmb.addItem("LT");
        this.jdfirstcmb.addItem("GE");
        this.jdfirstcmb.addItem("LE");
        this.jdthencmb.addItem("CONTINUE");
        this.jdthencmb.addItem("BYPASS");
        this.jdthencmb.addItem("GOTO");
        jp.add(this.jdiflbl);
        jp.add(this.jdfirstcmb);
        jp.add(this.jdvaluetxt);
        this.add(jp);
        this.add(this.jdthenlbl);
        this.add(this.jdthencmb);
        this.add(this.jdgotolbl);
        this.add(this.jdgototxt);
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ArrayList arr = JdMediator.getGotoStepList();
                arr.add("End Of Job");
                JdListChooser listChooser = new JdListChooser("GoTo Step Chooser", "Select a GoTo Step", arr.toArray(), JdCondCodeUI.this.jdlistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdCondCodeUI.this.jdgototxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(this.jdlistbtn);
        jp.setOpaque(false);
        this.jdlistbtn.setEnabled(false);
        this.jdgototxt.setEnabled(false);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIStepElement)jdIElement;
        String str = this.jdElement.getCondOperator();
        if (str == null) {
            this.jdfirstcmb.setSelectedIndex(0);
        } else {
            this.jdfirstcmb.setSelectedItem(str);
        }
        str = this.jdElement.getCondValue();
        if (str != null) {
            this.jdvaluetxt.setText(str);
        }
        if ((str = this.jdElement.getCondAction()) == null) {
            this.jdthencmb.setSelectedIndex(0);
        } else {
            this.jdthencmb.setSelectedItem(str);
        }
        str = this.jdElement.getCondActionName();
        this.jdgototxt.setText(str);
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setCondOperator(this.jdfirstcmb.getSelectedItem().toString());
        this.jdElement.setCondValue(this.jdvaluetxt.getText());
        this.jdElement.setCondAction(this.jdthencmb.getSelectedItem().toString());
        String str = this.jdgototxt.getText();
        this.jdElement.setCondActionName(str);
    }

    public void reset() {
        String str = this.jdElement.getCondOperator();
        if (str == null) {
            this.jdfirstcmb.setSelectedItem("NE");
        } else {
            this.jdfirstcmb.setSelectedItem(str);
        }
        str = this.jdElement.getCondValue();
        if (str != null) {
            this.jdvaluetxt.setText(str);
        }
        if ((str = this.jdElement.getCondAction()) == null) {
            this.jdthencmb.setSelectedItem("BYPASS");
        } else {
            this.jdthencmb.setSelectedItem(str);
        }
        str = this.jdElement.getCondActionName();
        this.jdgototxt.setText(str);
    }

    public void setUpdate() {
        this.jdfirstcmb.setEnabled(true);
        this.jdvaluetxt.setEnabled(true);
        this.jdthencmb.setEnabled(true);
        if (this.jdthencmb.getSelectedItem().equals("GOTO")) {
            this.jdlistbtn.setEnabled(true);
            this.jdgototxt.setEnabled(true);
        } else {
            this.jdlistbtn.setEnabled(false);
            this.jdgototxt.setEnabled(false);
        }
    }

    public void setReadOnly() {
        this.jdfirstcmb.setEnabled(false);
        this.jdvaluetxt.setEnabled(false);
        this.jdthencmb.setEnabled(false);
        this.jdgototxt.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdthencmb.getSelectedItem().equals("GOTO") && this.jdgototxt.getText().length() == 0) {
            component.setJdReason(new String("The Goto Step cannot be empty"));
            component.setJdLabel(new String(this.jdgotolbl.getText()));
            component.setJdComponent((Component)this.jdgototxt);
            return false;
        }
        try {
            String valstr = this.jdvaluetxt.getText();
            if (valstr.length() > 0) {
                Integer.parseInt(valstr);
            } else {
                this.jdElement.setCondValue(null);
            }
        }
        catch (NumberFormatException num) {
            component.setJdReason(new String("The Condition Code value should be a number"));
            component.setJdComponent((Component)this.jdvaluetxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdCondCodeUI jdccui = new JdCondCodeUI();
        JdPgmStepElement jde = new JdPgmStepElement();
        jdccui.show(jde);
        jf.getContentPane().add(jdccui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jdccui.update();
    }
}

