/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.model;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIIconElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdINodeElement;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.jedit.model.JdConcatenatedFile;
import com.sun.emp.mbm.jedit.model.JdGdgFile;
import com.sun.emp.mbm.jedit.model.JdInputFile;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.jedit.model.JdPgmStepElement;
import com.sun.emp.mbm.jedit.model.JdPrintFile;
import com.sun.emp.mbm.jedit.model.JdProcElement;
import com.sun.emp.mbm.jedit.model.JdProcStepElement;
import com.sun.emp.mbm.jedit.model.JdStandardFile;
import com.sun.emp.mbm.jedit.model.JdUtilStepElement;
import com.sun.emp.mbm.jedit.model.JdVsamFile;
import com.sun.emp.mbm.util.JdProgressBar;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class JdNode
implements JdIMutableTreeNode,
Serializable {
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    static final long serialVersionUID = 8385877914454004024L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final int INDEX = 0;
    private static final int NUM_CHILDREN = 1;
    private static final int TREE_SIZE = 2;
    private static JdProgressBar m_read_pbar;
    private JdIElement m_jdelement;
    private JdProgressBar m_pbar = null;
    private int m_index = 0;
    private int m_tree_size = 0;
    public Vector m_child_list;
    static /* synthetic */ Class class$java$lang$Integer;

    public JdNode(JdIMutableTreeNode node) {
        if (node != null) {
            if (this.m_pbar == null) {
                this.m_tree_size = ((JdMutableTreeNode)node).getLeafCount();
                this.m_pbar = new JdProgressBar("Saving " + node.getJdIElement().getName() + "...", this.m_tree_size);
            }
            this.m_jdelement = node.getJdIElement();
            this.m_index = node.getPosition();
            this.m_child_list = new Vector();
            this.insertJdNode(node);
        }
    }

    private JdNode(JdIMutableTreeNode node, JdProgressBar pBar) {
        if (node != null) {
            this.m_jdelement = node.getJdIElement();
            this.m_index = node.getPosition();
            this.m_child_list = new Vector();
            this.m_pbar = pBar;
            this.insertJdNode(node);
        }
    }

    public JdNode() {
        this.m_jdelement = null;
        this.m_child_list = new Vector();
        this.m_index = 0;
    }

    private JdNode(JdProgressBar pBar) {
        this.m_pbar = pBar;
        this.m_jdelement = null;
        this.m_child_list = new Vector();
        this.m_index = 0;
    }

    private JdNode(JdNode node, JdProgressBar pBar) {
        if (node != null) {
            this.m_pbar = pBar;
            this.m_jdelement = node.m_jdelement;
            this.m_child_list = new Vector();
            this.m_child_list = node.m_child_list;
            this.m_index = node.m_index;
        }
    }

    public void insertJdNode(JdIMutableTreeNode childNode, int index) {
    }

    public void insertJdNode(JdIMutableTreeNode childNode) {
        Enumeration e = childNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode next_node = (JdIMutableTreeNode)e.nextElement();
            this.m_child_list.add(new JdNode(next_node, this.m_pbar));
        }
    }

    public void removeJdNode(JdIMutableTreeNode childNode) {
    }

    public void setJdParent(JdIMutableTreeNode parentNode) {
    }

    public void setJdIElement(JdIElement jdElement) {
        this.m_jdelement = jdElement;
    }

    public void acceptVisitor(JdIVisitor jdVisitor) {
    }

    public JdIElement getJdIElement() {
        return this.m_jdelement;
    }

    public JdIIconElement getJdIIconElement() {
        return null;
    }

    public JdINodeElement getJdINodeElement() {
        return null;
    }

    public JdIMutableTreeNode getJdParent() {
        return null;
    }

    public Enumeration getAllChildren() {
        if (this.m_child_list == null || this.m_child_list.size() <= 0) {
            return EMPTY_ENUMERATION;
        }
        return this.m_child_list.elements();
    }

    public String toString() {
        return this.dump("");
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    public JdIMutableTreeNode deepClone() {
        JdNode clone = new JdNode(this);
        return clone;
    }

    public int getPosition() {
        return this.m_index;
    }

    private void writeObject(ObjectOutputStream stream) {
        if (this.m_child_list.size() == 0) {
            this.m_pbar.run();
        }
        try {
            ObjectOutputStream.PutField fields = stream.putFields();
            fields.put(serialPersistentFields[0].getName(), new Integer(this.m_index));
            fields.put(serialPersistentFields[1].getName(), new Integer(this.m_child_list.size()));
            fields.put(serialPersistentFields[2].getName(), new Integer(this.m_tree_size));
            stream.writeFields();
            stream.writeObject(this.m_jdelement);
            stream.flush();
            int i = 0;
            while (i < this.m_child_list.size()) {
                stream.writeObject((JdNode)this.m_child_list.get(i));
                stream.flush();
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            ObjectInputStream.GetField fields = stream.readFields();
            Integer idx = (Integer)fields.get(serialPersistentFields[0].getName(), null);
            Integer nc = (Integer)fields.get(serialPersistentFields[1].getName(), null);
            Integer ts = (Integer)fields.get(serialPersistentFields[2].getName(), null);
            this.m_index = idx;
            int num_children = nc;
            this.m_tree_size = ts;
            if (m_read_pbar == null) {
                m_read_pbar = new JdProgressBar("Expanding tree...", this.m_tree_size);
            }
            this.m_jdelement = (JdIElement)stream.readObject();
            if (num_children == 0) {
                m_read_pbar.run();
            }
            int i = 0;
            while (i < num_children) {
                JdNode child_node = (JdNode)stream.readObject();
                if (this.m_child_list == null) {
                    this.m_child_list = new Vector();
                }
                this.m_child_list.add(child_node);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            throw e;
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.toString());
        }
    }

    private String dump(String indent) {
        String ret_string = indent + this.m_jdelement.getClass().getName() + " at position " + this.m_index + "\n";
        if (this.m_child_list != null) {
            indent = indent + "  ";
            int i = 0;
            while (i < this.m_child_list.size()) {
                ret_string = ret_string + ((JdNode)this.m_child_list.get(i)).dump(indent);
                ++i;
            }
        }
        return ret_string;
    }

    private void addNextNode(JdIMutableTreeNode node) {
    }

    public static JdIMutableTreeNode testjob() {
        JdMutableTreeNode treeJob1 = new JdMutableTreeNode(new JdJobElement("Job1"));
        JdMutableTreeNode treeStep1 = new JdMutableTreeNode(new JdPgmStepElement("Step1"));
        treeJob1.insertJdNode(treeStep1, 0);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdInputFile("InputFile1")), 1);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdVsamFile("VSAMFile1")), 2);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdPrintFile("PrintFile1")), 4);
        JdMutableTreeNode treeConc1 = new JdMutableTreeNode(new JdConcatenatedFile("Concat1"));
        treeStep1.insertJdNode(treeConc1, 5);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdInputFile("Inputfile1")), 1);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile2")), 2);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        treeJob1.insertJdNode(new JdMutableTreeNode(new JdUtilStepElement("StepUtil1")), 0);
        return treeJob1;
    }

    public static JdIMutableTreeNode testproc() {
        JdMutableTreeNode pstep1 = new JdMutableTreeNode(new JdProcElement("Proc1"));
        pstep1.insertJdNode(new JdMutableTreeNode(new JdProcStepElement("ProcStep1")), 0);
        pstep1.insertJdNode(new JdMutableTreeNode(new JdUtilStepElement("StepUtil1")), 1);
        return pstep1;
    }

    public static void printChildren(JdIMutableTreeNode node) {
        System.out.println(node.getJdIElement().toString());
        Enumeration e = node.getAllChildren();
        while (e.hasMoreElements()) {
            JdNode.printChildren((JdIMutableTreeNode)e.nextElement());
        }
    }

    public static void main(String[] av) {
        System.out.println("*********************\nJob Test\n*********************");
        JdNode node = new JdNode(JdNode.testjob());
        System.out.println(node.toString());
        JdNode.printChildren(node);
        System.out.println("*********************\nProc Test\n*********************");
        JdNode node2 = new JdNode(JdNode.testproc());
        System.out.println(node2.toString());
        System.out.println("*********************\nDeep clone test\n*********************");
        JdIMutableTreeNode clone_node = node.deepClone();
        System.out.println(clone_node.toString());
        System.out.println("*********************\nWrite test\n*********************");
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("jdnode.tmp"));
            oos.writeObject(node);
            oos.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Write Test" + fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println("Write Test" + ioe.toString());
        }
        System.out.println("*********************\nRead test\n*********************");
        JdNode node3 = new JdNode();
        try {
            FileInputStream fstream = new FileInputStream("jdnode.tmp");
            ObjectInputStream istream = new ObjectInputStream(fstream);
            node3 = (JdNode)istream.readObject();
            istream.close();
            System.out.println(node3.toString());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.toString());
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Read Test" + fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serialVersionUID = 8385877914454004024L;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("f_element_index", class$java$lang$Integer == null ? (class$java$lang$Integer = JdNode.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("f_num_children", class$java$lang$Integer == null ? (class$java$lang$Integer = JdNode.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("f_tree_size", class$java$lang$Integer == null ? (class$java$lang$Integer = JdNode.class$("java.lang.Integer")) : class$java$lang$Integer)};
        INDEX = 0;
        NUM_CHILDREN = 1;
        TREE_SIZE = 2;
        m_read_pbar = null;
    }
}

