/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.model;

import com.sun.emp.mbm.jedit.controller.JdIconFactory;
import com.sun.emp.mbm.jedit.controller.JdNodeFactory;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIIconElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdINodeElement;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.util.Log;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class JdMutableTreeNode
extends DefaultMutableTreeNode
implements JdIMutableTreeNode {
    protected static JdNodeFactory m_jdNodeFactory = JdNodeFactory.getJdNodeFactory();
    protected static JdIconFactory m_jdIconFactory = JdIconFactory.getJdIconFactory();
    private JdIElement m_jdiElement = null;
    private JdIIconElement m_jdiIconElement = null;
    private JdINodeElement m_jdiNodeElement = null;

    public JdMutableTreeNode(JdIElement jdIElement) {
        this(jdIElement, true);
    }

    public JdMutableTreeNode(JdIElement jdIElement, boolean allowsChildren) {
        this.setAllowsChildren(allowsChildren);
        this.setJdIElement(jdIElement);
    }

    public void insertJdNode(JdIMutableTreeNode childNode, int index) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"insertJdNode");
        super.insert((MutableTreeNode)((Object)childNode), index);
        Log.exit((Level)Level.INFO, (Object)this, (String)"insertJdNode");
    }

    public void removeJdNode(JdIMutableTreeNode childNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"removeJdNode");
        super.remove((MutableTreeNode)((Object)childNode));
        Log.exit((Level)Level.INFO, (Object)this, (String)"removeJdNode");
    }

    public void setJdParent(JdIMutableTreeNode parentNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"setJdParent");
        super.setParent((MutableTreeNode)((Object)parentNode));
        Log.exit((Level)Level.INFO, (Object)this, (String)"setJdParent");
    }

    public void setJdIElement(JdIElement jdElement) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"setJdIElement");
        this.m_jdiElement = jdElement;
        this.m_jdiIconElement = m_jdIconFactory.getJdIIconElement(jdElement);
        super.setUserObject(this.m_jdiIconElement);
        this.m_jdiNodeElement = m_jdNodeFactory.getJdINodeElement(jdElement);
        this.m_jdiIconElement.setJdINodeElement(this.m_jdiNodeElement);
        this.m_jdiNodeElement.setJdIElement(jdElement);
        Log.exit((Level)Level.INFO, (Object)this, (String)"setJdIElement");
    }

    public void acceptVisitor(JdIVisitor jdVisitor) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"acceptVisitor");
        this.m_jdiElement.acceptVisitor(jdVisitor, this);
        Log.exit((Level)Level.INFO, (Object)this, (String)"acceptVisitor");
    }

    public JdIElement getJdIElement() {
        return this.m_jdiElement;
    }

    public JdIIconElement getJdIIconElement() {
        return this.m_jdiIconElement;
    }

    public JdINodeElement getJdINodeElement() {
        return this.m_jdiNodeElement;
    }

    public JdIMutableTreeNode getJdParent() {
        return (JdIMutableTreeNode)((Object)super.getParent());
    }

    public Enumeration getAllChildren() {
        return super.children();
    }

    public String toString() {
        if (null != this.m_jdiElement) {
            return this.m_jdiElement.getName();
        }
        return null;
    }

    public Object clone() {
        JdMutableTreeNode simpleClone;
        Log.entry((Level)Level.INFO, (Object)this, (String)"clone");
        try {
            simpleClone = new JdMutableTreeNode((JdIElement)this.m_jdiElement.clone());
            simpleClone.m_jdiNodeElement.setNodeAdded(true);
        }
        catch (Exception e) {
            System.err.println("ERROR:JdMutableTreeNode::clone():exception:" + e);
            simpleClone = null;
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"clone");
        return simpleClone;
    }

    public JdIMutableTreeNode deepClone() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"deepClone");
        if (!this.getJdINodeElement().isNodeAdded()) {
            this.getJdINodeElement().expandNode(this);
        }
        JdIMutableTreeNode deepClone = (JdIMutableTreeNode)this.clone();
        Enumeration e = this.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode nextNode = (JdIMutableTreeNode)e.nextElement();
            JdIMutableTreeNode nextClone = nextNode.deepClone();
            deepClone.insertJdNode(nextClone, nextNode.getPosition());
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"deepClone");
        return deepClone;
    }

    public int getPosition() {
        int position = this.getParent().getIndex(this);
        return position;
    }

    public String getToolTipText() {
        if (null != this.m_jdiElement) {
            return this.m_jdiElement.getToolTipText();
        }
        return "";
    }

    public boolean haveSameJobProcAncestor(JdIMutableTreeNode secondJdMTNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"haveSameJobProcAncestor");
        JdMutableTreeNode firstJdMTNode = this;
        boolean bHaveSameJobProcAncestor = false;
        if (firstJdMTNode == secondJdMTNode) {
            return true;
        }
        if (this.isJobProcOrAbove(firstJdMTNode) || this.isJobProcOrAbove(secondJdMTNode)) {
            return false;
        }
        JdIMutableTreeNode firstAncestor = this.getJobProcAncestor(firstJdMTNode);
        JdIMutableTreeNode secondAncestor = this.getJobProcAncestor(secondJdMTNode);
        if (null == firstAncestor || null == secondAncestor) {
            bHaveSameJobProcAncestor = false;
        } else if (firstAncestor == secondAncestor) {
            bHaveSameJobProcAncestor = true;
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"haveSameJobProcAncestor");
        return bHaveSameJobProcAncestor;
    }

    private JdIMutableTreeNode getJobProcAncestor(JdIMutableTreeNode node) {
        JdIMutableTreeNode jobProcAncestor = null;
        boolean foundJobProcAncestor = false;
        if (this.isJobProcOrAbove(node)) {
            return null;
        }
        JdIMutableTreeNode nextNode = node;
        while (!foundJobProcAncestor && null != nextNode) {
            if ((nextNode = nextNode.getJdParent()) == null || !this.isJobProcOrAbove(nextNode)) continue;
            foundJobProcAncestor = true;
        }
        jobProcAncestor = nextNode;
        return jobProcAncestor;
    }

    private boolean isJobProcOrAbove(JdIMutableTreeNode node) {
        boolean jobProcOrAbove = false;
        int elementType = node.getJdIElement().getElementType();
        switch (elementType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                jobProcOrAbove = true;
                break;
            }
            default: {
                jobProcOrAbove = false;
            }
        }
        return jobProcOrAbove;
    }

    public static void main(String[] args) {
    }
}

