/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.controller;

import com.sun.emp.mbm.jedit.controller.JdWriterVisitor;
import com.sun.emp.mbm.jedit.interfaces.JdIAliasFile;
import com.sun.emp.mbm.jedit.interfaces.JdIConcatenatedFile;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFolderElement;
import com.sun.emp.mbm.jedit.interfaces.JdIGdgFile;
import com.sun.emp.mbm.jedit.interfaces.JdIInputFile;
import com.sun.emp.mbm.jedit.interfaces.JdIJobElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIPgmStepElement;
import com.sun.emp.mbm.jedit.interfaces.JdIPrintFile;
import com.sun.emp.mbm.jedit.interfaces.JdIProcElement;
import com.sun.emp.mbm.jedit.interfaces.JdIProcStepElement;
import com.sun.emp.mbm.jedit.interfaces.JdIProjectElement;
import com.sun.emp.mbm.jedit.interfaces.JdIStandardFile;
import com.sun.emp.mbm.jedit.interfaces.JdIUtilStepElement;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.jedit.interfaces.JdIVsamFile;
import com.sun.emp.mbm.jedit.model.JdConcatenatedFile;
import com.sun.emp.mbm.jedit.model.JdGdgFile;
import com.sun.emp.mbm.jedit.model.JdInputFile;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import com.sun.emp.mbm.jedit.model.JdJobFolderElement;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.jedit.model.JdPgmStepElement;
import com.sun.emp.mbm.jedit.model.JdPrintFile;
import com.sun.emp.mbm.jedit.model.JdProcElement;
import com.sun.emp.mbm.jedit.model.JdProcFolderElement;
import com.sun.emp.mbm.jedit.model.JdProcStepElement;
import com.sun.emp.mbm.jedit.model.JdProjectElement;
import com.sun.emp.mbm.jedit.model.JdStandardFile;
import com.sun.emp.mbm.jedit.model.JdUtilStepElement;
import com.sun.emp.mbm.jedit.model.JdVsamFile;
import com.sun.emp.mbm.util.JdDirectory;
import com.sun.emp.mbm.util.JdParameter;
import com.sun.emp.mbm.util.Log;
import java.io.File;
import java.util.Enumeration;
import java.util.logging.Level;

public class JdSaveVisitor
implements JdIVisitor {
    private JdWriterVisitor m_jdWriterVisiter;

    JdSaveVisitor(String destDir) {
        Log.entry((Level)Level.INFO, (Object)this, (String)("JdSaveVisitor constructor destDir=" + destDir));
        this.m_jdWriterVisiter = new JdWriterVisitor();
        Log.exit((Level)Level.INFO, (Object)this, (String)"JdSaveVisitor constructor");
    }

    public void doSave(JdIMutableTreeNode jdTreeNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"doSave");
        if (null != jdTreeNode) {
            jdTreeNode.acceptVisitor(this);
        } else {
            Log.displayMessage((Object)this, (String)"doSave", (String)"jdTreeNode is Null", (String)"E00002", (Object)"jdTreeNode");
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"doSave");
    }

    public void visitProject(JdIProjectElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitProject");
        if (!targetNode.getJdINodeElement().isNodeAdded()) {
            targetNode.getJdINodeElement().expandNode(targetNode);
        }
        this.m_jdWriterVisiter.doWriteConfiguration();
        if (targetNode.getJdParent() == null) {
            return;
        }
        JdWriterVisitor.doCreateDir(targetNode);
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode tNode = (JdIMutableTreeNode)e.nextElement();
            tNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitProject");
    }

    public void visitFolder(JdIFolderElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitFolder");
        if (!targetNode.getJdINodeElement().isNodeAdded()) {
            targetNode.getJdINodeElement().expandNode(targetNode);
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode tNode = (JdIMutableTreeNode)e.nextElement();
            tNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitFolder");
    }

    public void visitJob(JdIJobElement targetElement, JdIMutableTreeNode targetNode) {
        String fullPath;
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitJob");
        if (!targetNode.getJdINodeElement().isNodeAdded()) {
            targetNode.getJdINodeElement().expandNode(targetNode);
        }
        if (null != (fullPath = this.getFullPath(targetNode))) {
            this.m_jdWriterVisiter.doWriteFile(targetNode, fullPath);
        } else {
            Log.displayMessage((Object)this, (String)"visitJob", (String)"fullPath is Null", (String)"E00002", (Object)"fullPath");
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitJob");
    }

    public void visitProc(JdIProcElement targetElement, JdIMutableTreeNode targetNode) {
        String fullPath;
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitProc");
        if (!targetNode.getJdINodeElement().isNodeAdded()) {
            targetNode.getJdINodeElement().expandNode(targetNode);
        }
        if (null != (fullPath = this.getFullPath(targetNode))) {
            this.m_jdWriterVisiter.doWriteFile(targetNode, fullPath);
        } else {
            Log.displayMessage((Object)this, (String)"visitProc", (String)"fullPath is Null", (String)"E00002", (Object)"fullPath");
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitProc");
    }

    public void visitPgmStep(JdIPgmStepElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitPgmStep");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Step")) {
            Log.displayMessage((Object)this, (String)"visitPgmStep", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitPgmStep");
    }

    public void visitProcStep(JdIProcStepElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitProcStep");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Step")) {
            Log.displayMessage((Object)this, (String)"visitProcStep", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)targetNode.toString());
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitProcStep");
    }

    public void visitUtilStep(JdIUtilStepElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitUtilStep");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Step")) {
            Log.displayMessage((Object)this, (String)"visitUtilStep", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitUtilStep");
    }

    public void visitConcatenatedFile(JdIConcatenatedFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitConcatenatedFile");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Concatenated File")) {
            Log.displayMessage((Object)this, (String)"visitConcatenatedFile", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitConcatenatedFile");
    }

    public void visitStandardFile(JdIStandardFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitStandardFile");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Standard File")) {
            Log.displayMessage((Object)this, (String)"visitStandardFile", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitStandardFile");
    }

    public void visitAliasFile(JdIAliasFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitAliasFile");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Alias File")) {
            Log.displayMessage((Object)this, (String)"visitAliasFile", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitAliasFile");
    }

    public void visitVsamFile(JdIVsamFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitVsamFile");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New VSAM File")) {
            Log.displayMessage((Object)this, (String)"visitVsamFile", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitVsamFile");
    }

    public void visitGdgFile(JdIGdgFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitGdgFile");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New GDG File")) {
            Log.displayMessage((Object)this, (String)"visitGdgFile", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitGdgFile");
    }

    public void visitPrintFile(JdIPrintFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitPrintFile");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Print File")) {
            Log.displayMessage((Object)this, (String)"visitPrintFile", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitPrintFile");
    }

    public void visitInputFile(JdIInputFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitInputFile");
        JdIMutableTreeNode parentNode = targetNode.getJdParent();
        if (null != parentNode) {
            parentNode.acceptVisitor(this);
        } else if (!targetNode.toString().equals("New Input File")) {
            Log.displayMessage((Object)this, (String)"visitInputFile", (String)("Error parentNode NULL for target: " + targetNode.toString()), (String)"E00002", (Object)("parentNode of " + targetNode.toString()));
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitInputFile");
    }

    private String getFullPath(JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"getFullPath");
        String fullPath = null;
        String projectPath = null;
        String parentPath = null;
        if (null != targetNode) {
            JdIMutableTreeNode parentNode = targetNode.getJdParent();
            if (null != parentNode) {
                JdIMutableTreeNode grandParentNode = parentNode.getJdParent();
                if (null != grandParentNode) {
                    JdIElement jdie = grandParentNode.getJdIElement();
                    JdProjectElement jdpe = (JdProjectElement)jdie;
                    JdDirectory jdDirectory = jdpe.getDirectoryPathname();
                    projectPath = jdDirectory.getPathname() + File.separator + jdpe.getName();
                } else {
                    Log.displayMessage((Object)this, (String)"getFullPath", (String)"grandParentNode is Null", (String)"E00002", (Object)"grandParentNode");
                }
                parentPath = parentNode.toString();
            } else {
                Log.displayMessage((Object)this, (String)"getFullPath", (String)"parentNode is Null", (String)"E00002", (Object)"parentNode");
            }
        } else {
            Log.displayMessage((Object)this, (String)"getFullPath", (String)"targetNode is Null", (String)"E00002", (Object)"targetNode");
        }
        fullPath = projectPath + File.separator + parentPath;
        Log.exit((Level)Level.INFO, (Object)this, (String)("getFullPath:fullPath=" + fullPath));
        return fullPath;
    }

    public static void main(String[] av) {
        JdMutableTreeNode rootNode = new JdMutableTreeNode(new JdProjectElement("Projects"));
        JdProjectElement kix1 = new JdProjectElement("kix1");
        kix1.setDirectoryPathname(new JdDirectory("/net/haven/home/testing/scapes"));
        kix1.setDescription("First Kix Project");
        JdMutableTreeNode kix1node = new JdMutableTreeNode(kix1);
        JdMutableTreeNode kix1jfolder = new JdMutableTreeNode(new JdJobFolderElement());
        JdMutableTreeNode kix1pfolder = new JdMutableTreeNode(new JdProcFolderElement());
        kix1node.insertJdNode(kix1jfolder, 0);
        kix1node.insertJdNode(kix1pfolder, 1);
        JdJobElement FirstBornJob = new JdJobElement("FirstBornJob");
        FirstBornJob.setDescription("First job created using Job Editor");
        FirstBornJob.setAuthor("The Job Editor Team");
        JdMutableTreeNode FirstBornJobNode = new JdMutableTreeNode(FirstBornJob);
        kix1jfolder.insertJdNode(FirstBornJobNode, 0);
        JdPgmStepElement step1 = new JdPgmStepElement("COBOL_STEP");
        step1.setExecName("PRIMER");
        step1.setDescription("First step executes a COBOL program to access a VSAM file");
        step1.setParameter(new JdParameter("PARM", "DUMMY"));
        JdMutableTreeNode step1Node = new JdMutableTreeNode(step1);
        FirstBornJobNode.insertJdNode(step1Node, 0);
        JdVsamFile vsam1 = new JdVsamFile("INPUT1");
        vsam1.setVsamName("ACCTFIL");
        vsam1.setDescription("ACCT VSAM file");
        JdMutableTreeNode vsam1Node = new JdMutableTreeNode(vsam1);
        step1Node.insertJdNode(vsam1Node, 0);
        JdUtilStepElement step2 = new JdUtilStepElement("JAVA_STEP");
        step2.setExecName("EJAVA");
        step2.setDescription("Second step executes a JAVA class that reads a SYSIN file");
        step2.setParameter(new JdParameter("PARM", "MyClass", "Java Class name to be executed"));
        JdMutableTreeNode step2Node = new JdMutableTreeNode(step2);
        FirstBornJobNode.insertJdNode(step2Node, 1);
        JdInputFile input1 = new JdInputFile("SYSIN");
        input1.setInputData("     HELLO WORLD FROM JEDIT");
        input1.setDescription("SYSIN file that will be read by the JAVA Class");
        JdMutableTreeNode input1Node = new JdMutableTreeNode(input1);
        step2Node.insertJdNode(input1Node, 0);
        rootNode.insertJdNode(kix1node, 0);
        JdMutableTreeNode treeProject1 = new JdMutableTreeNode(new JdProjectElement("Project1"));
        ((JdProjectElement)treeProject1.getJdIElement()).setDirectoryPathname(new JdDirectory("/net/haven/home/testing/scapes"));
        rootNode.insertJdNode(treeProject1, 0);
        JdMutableTreeNode jfolder1 = new JdMutableTreeNode(new JdJobFolderElement());
        treeProject1.insertJdNode(jfolder1, 0);
        JdMutableTreeNode treeJob1 = new JdMutableTreeNode(new JdJobElement("Job1"));
        jfolder1.insertJdNode(treeJob1, 0);
        JdMutableTreeNode treeJob2 = new JdMutableTreeNode(new JdJobElement("Job2"));
        jfolder1.insertJdNode(treeJob2, 1);
        JdMutableTreeNode treeStep1 = new JdMutableTreeNode(new JdPgmStepElement("Step1"));
        treeJob1.insertJdNode(treeStep1, 0);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdInputFile("InputFile1")), 1);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdVsamFile("VSAMFile1")), 2);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdPrintFile("PrintFile1")), 4);
        JdMutableTreeNode treeStep2 = new JdMutableTreeNode(new JdPgmStepElement("Step2"));
        treeJob2.insertJdNode(treeStep2, 0);
        treeStep2.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeStep2.insertJdNode(new JdMutableTreeNode(new JdInputFile("InputFile1")), 1);
        treeStep2.insertJdNode(new JdMutableTreeNode(new JdVsamFile("VSAMFile1")), 2);
        treeStep2.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        JdMutableTreeNode treeConc1 = new JdMutableTreeNode(new JdConcatenatedFile("Concat1"));
        treeStep1.insertJdNode(treeConc1, 5);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdInputFile("Inputfile1")), 1);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile2")), 2);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        JdMutableTreeNode treeConc2 = new JdMutableTreeNode(new JdConcatenatedFile("Concat2"));
        treeStep2.insertJdNode(treeConc2, 4);
        treeConc2.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeConc2.insertJdNode(new JdMutableTreeNode(new JdInputFile("Inputfile1")), 1);
        treeConc2.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 2);
        treeConc2.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        treeJob1.insertJdNode(new JdMutableTreeNode(new JdUtilStepElement("StepUtil1")), 0);
        JdMutableTreeNode pfolder1 = new JdMutableTreeNode(new JdProcFolderElement());
        treeProject1.insertJdNode(pfolder1, 1);
        JdMutableTreeNode pstep1 = new JdMutableTreeNode(new JdProcElement("Proc1"));
        pfolder1.insertJdNode(pstep1, 0);
        JdMutableTreeNode pstep2 = new JdMutableTreeNode(new JdProcElement("Proc2"));
        pfolder1.insertJdNode(pstep2, 1);
        pstep1.insertJdNode(new JdMutableTreeNode(new JdProcStepElement("ProcStep1")), 0);
        pstep1.insertJdNode(new JdMutableTreeNode(new JdUtilStepElement("StepUtil1")), 1);
        pstep2.insertJdNode(new JdMutableTreeNode(new JdProcStepElement("ProcStep1")), 0);
        pstep2.insertJdNode(new JdMutableTreeNode(new JdUtilStepElement("StepUtil1")), 1);
        JdSaveVisitor visitor = new JdSaveVisitor(".");
        visitor.doSave(rootNode);
        visitor.doSave(FirstBornJobNode);
        visitor.doSave(pstep1);
        System.exit(0);
    }
}

