/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.controller;

import com.sun.emp.mbm.jedit.controller.JdCommentParser;
import com.sun.emp.mbm.jedit.controller.JdJobParser;
import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.controller.JdProcParser;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.logging.Level;

public class JdLexicalAnalizer {
    private BufferedReader _br = null;
    private StreamTokenizer _st = null;
    private String _fileName = null;
    private JdIMutableTreeNode _jdTreeNode = null;
    private JdIMutableTreeNode _newNode = null;
    private JdMediator _jdMediator = null;
    private int token = -1;
    private int prevToken = -1;
    private String tokValue = null;
    private String tokKey = null;
    private String tokName = null;
    private Hashtable ht = null;
    public static final int TOK_WARN = 0;
    public static final String WARN;
    public static final int TOK_BEGIN_JOB = 1;
    public static final String BEGIN_JOB;
    public static final int TOK_BEGIN_PROC = 2;
    public static final String BEGIN_PROC;
    public static final int TOK_END_JOB = 3;
    public static final String END_JOB;
    public static final int TOK_END_PROC = 4;
    public static final String END_PROC;
    public static final int TOK_BEGIN_EXEC_PGM = 5;
    public static final String BEGIN_EXEC_PGM;
    public static final int TOK_BEGIN_EXEC_PROC = 6;
    public static final String BEGIN_EXEC_PROC;
    public static final int TOK_BEGIN_EXEC_UTIL = 7;
    public static final String BEGIN_EXEC_UTIL;
    public static final int TOK_END_EXEC = 8;
    public static final String END_EXEC;
    public static final int TOK_BEGIN_DESCRIPTION = 9;
    public static final String BEGIN_DESCRIPTION;
    public static final int TOK_END_DESCRIPTION = 54;
    public static final String END_DESCRIPTION;
    public static final int TOK_BEGIN_DD_STD = 11;
    public static final String BEGIN_DD_STD;
    public static final int TOK_BEGIN_DD_VSAM = 12;
    public static final String BEGIN_DD_VSAM;
    public static final int TOK_BEGIN_DD_INPUT = 13;
    public static final String BEGIN_DD_INPUT;
    public static final int TOK_BEGIN_DD_PRINT = 14;
    public static final String BEGIN_DD_PRINT;
    public static final int TOK_BEGIN_DD_ALIAS = 15;
    public static final String BEGIN_DD_ALIAS;
    public static final int TOK_BEGIN_DD_GDG = 16;
    public static final String BEGIN_DD_GDG;
    public static final int TOK_END_DD = 17;
    public static final String END_DD;
    public static final int TOK_BEGIN_CONCATENATED = 18;
    public static final String BEGIN_CONCATENATED;
    public static final int TOK_END_CONCATENATED = 19;
    public static final String END_CONCATENATED;
    public static final int TOK_PRINTER_CLASS = 20;
    public static final String PRINTER_CLASS;
    public static final int TOK_NOTIFY = 21;
    public static final String NOTIFY;
    public static final int TOK_NAME = 22;
    public static final String NAME;
    public static final int TOK_PGM_DIRS = 23;
    public static final String PGM_DIRS;
    public static final int TOK_PROC_DIRS = 24;
    public static final String PROC_DIRS;
    public static final int TOK_PARM_ELEM = 25;
    public static final String PARM_ELEM;
    public static final int TOK_EXEC_NAME = 26;
    public static final String EXEC_NAME;
    public static final int TOK_BEGIN_COND = 27;
    public static final String BEGIN_COND;
    public static final int TOK_COND_OPERATOR = 28;
    public static final String COND_OPERATOR;
    public static final int TOK_COND_VALUE = 29;
    public static final String COND_VALUE;
    public static final int TOK_COND_ACTION = 30;
    public static final String COND_ACTION;
    public static final int TOK_RET_OPERATOR = 31;
    public static final String RET_OPERATOR;
    public static final int TOK_RET_VALUE = 32;
    public static final String RET_VALUE;
    public static final int TOK_RET_ACTION = 33;
    public static final String RET_ACTION;
    public static final int TOK_RET_STEPNAME = 34;
    public static final String RET_STEPNAME;
    public static final int TOK_END_COND = 35;
    public static final String END_COND;
    public static final int TOK_VSAM_NAME = 36;
    public static final String VSAM_NAME;
    public static final int TOK_DUMMY = 37;
    public static final String DUMMY;
    public static final int TOK_BURST = 38;
    public static final String BURST;
    public static final int TOK_CHAR = 39;
    public static final String CHAR;
    public static final int TOK_COPIES = 40;
    public static final String COPIES;
    public static final int TOK_LRECL = 41;
    public static final String LRECL;
    public static final int TOK_RECFM = 42;
    public static final String RECFM;
    public static final int TOK_DEST = 43;
    public static final String DEST;
    public static final int TOK_CLASS = 44;
    public static final String CLASS;
    public static final int TOK_OCCURRENCE = 45;
    public static final String OCCURRENCE;
    public static final int TOK_PATHNAME = 46;
    public static final String PATHNAME;
    public static final int TOK_DISP_STATUS = 47;
    public static final String DISP_STATUS;
    public static final int TOK_NORMAL_DISP = 48;
    public static final String NORMAL_DISP;
    public static final int TOK_ABEND_DISP = 49;
    public static final String ABEND_DISP;
    public static final int TOK_BEGIN_DATA_INPUT = 50;
    public static final String BEGIN_DATA_INPUT;
    public static final int TOK_END_DATA_INPUT = 51;
    public static final String END_DATA_INPUT;
    public static final int TOK_ALIAS = 52;
    public static final String ALIAS;
    public static final int TOK_TEMP = 53;
    public static final String TEMP;
    public static final int TOK_SET_PARM = 54;
    public static final String SET_PARM;
    public static final int TOK_END_PARM = 55;
    public static final String END_PARM;
    public static final int TOK_RET_ACTION_STEPNAME = 56;
    public static final String RET_ACTION_STEPNAME;
    private static int MAX_TOK_VALUE;
    private static Hashtable tokTable;
    private int _jdtnNode = 0;

    public JdLexicalAnalizer(BufferedReader br, String fileName, JdIMutableTreeNode treeNode, JdMediator jdm) {
        this._br = br;
        this._fileName = fileName;
        this._jdTreeNode = treeNode;
        this._jdMediator = jdm;
        this._st = new StreamTokenizer(this._br);
        this.setJclTokenizer();
        this.initTable();
    }

    public JdIMutableTreeNode parse() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"parse");
        while (this.nextToken() != -1) {
            switch (this.token) {
                case 1: {
                    JdJobParser jdjp = new JdJobParser(this, this._jdTreeNode);
                    this._newNode = jdjp.parse();
                    break;
                }
                case 2: {
                    JdProcParser jdpp = new JdProcParser(this, this._jdTreeNode);
                    this._newNode = jdpp.parse();
                    break;
                }
                case 3: {
                    System.out.println("We have the END_JOB token");
                    return this._newNode;
                }
                case 9: {
                    JdCommentParser jdcp = new JdCommentParser(this, this._jdTreeNode);
                    break;
                }
                default: {
                    System.out.println("Don't know what token we have ->" + this.token + ":" + this.tokValue);
                }
            }
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"parse");
        return this._newNode;
    }

    public int nextToken() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"nextToken");
        try {
            this.token = this._st.nextToken();
            if (this.token != -1) {
                this.prevToken = this.token;
                this.tokValue = this._st.sval;
                block1 : switch (this.token) {
                    case -1: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case -2: {
                        Double d = new Double(this._st.nval);
                        this.tokValue = Integer.toString(d.intValue());
                        break;
                    }
                    case -3: {
                        if (this._st.sval.charAt(0) != '_' || this._st.sval.length() < 3) break;
                        switch (this._st.sval.charAt(2)) {
                            case 'A': {
                                if (this._st.sval.equals(ALIAS)) {
                                    this.token = 52;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (!this._st.sval.equals(ABEND_DISP)) break block1;
                                this.token = 49;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'B': {
                                if (this._st.sval.equals(BEGIN_JOB)) {
                                    this.token = 1;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_PROC)) {
                                    this.token = 2;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_EXEC_PGM)) {
                                    this.token = 5;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_EXEC_PROC)) {
                                    this.token = 6;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_EXEC_UTIL)) {
                                    this.token = 7;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DESCRIPTION)) {
                                    this.token = 9;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_CONCATENATED)) {
                                    this.token = 18;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_COND)) {
                                    this.token = 27;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DATA_INPUT)) {
                                    this.token = 50;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DD_STD)) {
                                    this.token = 11;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DD_VSAM)) {
                                    this.token = 12;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DD_INPUT)) {
                                    this.token = 13;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DD_PRINT)) {
                                    this.token = 14;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DD_ALIAS)) {
                                    this.token = 15;
                                    break block1;
                                }
                                if (this._st.sval.equals(BEGIN_DD_GDG)) {
                                    this.token = 16;
                                    break block1;
                                }
                                if (!this._st.sval.equals(BURST)) break block1;
                                this.token = 38;
                                break block1;
                            }
                            case 'C': {
                                if (this._st.sval.equals(COND_OPERATOR)) {
                                    this.token = 28;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(COND_VALUE)) {
                                    this.token = 29;
                                    if (this._st.nextToken() == -1) break block1;
                                    if (this._st.ttype == -2) {
                                        Double d1 = new Double(this._st.nval);
                                        this.tokValue = Integer.toString(d1.intValue());
                                        break block1;
                                    }
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(COND_ACTION)) {
                                    this.token = 30;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(CHAR)) {
                                    this.token = 39;
                                    break block1;
                                }
                                if (this._st.sval.equals(COPIES)) {
                                    this.token = 40;
                                    if (this._st.nextToken() == -1) break block1;
                                    if (this._st.ttype == -2) {
                                        Double d2 = new Double(this._st.nval);
                                        this.tokValue = Integer.toString(d2.intValue());
                                        break block1;
                                    }
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (!this._st.sval.equals(CLASS)) break block1;
                                this.token = 44;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'D': {
                                if (this._st.sval.equals(DUMMY)) {
                                    this.token = 37;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(DEST)) {
                                    this.token = 43;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (!this._st.sval.equals(DISP_STATUS)) break block1;
                                this.token = 47;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'E': {
                                if (this._st.sval.equals(END_JOB)) {
                                    this.token = 3;
                                    break block1;
                                }
                                if (this._st.sval.equals(END_PROC)) {
                                    this.token = 4;
                                    break block1;
                                }
                                if (this._st.sval.equals(END_EXEC)) {
                                    this.token = 8;
                                    break block1;
                                }
                                if (this._st.sval.equals(END_DESCRIPTION)) {
                                    this.token = 54;
                                    break block1;
                                }
                                if (this._st.sval.equals(END_DD)) {
                                    this.token = 17;
                                    break block1;
                                }
                                if (this._st.sval.equals(END_CONCATENATED)) {
                                    this.token = 19;
                                    break block1;
                                }
                                if (this._st.sval.equals(EXEC_NAME)) {
                                    this.token = 26;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(END_COND)) {
                                    this.token = 35;
                                    break block1;
                                }
                                if (this._st.sval.equals(END_DATA_INPUT)) {
                                    this.token = 51;
                                    break block1;
                                }
                                if (!this._st.sval.equals(END_PARM)) break block1;
                                this.token = 55;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'L': {
                                if (!this._st.sval.equals(LRECL)) break block1;
                                this.token = 41;
                                if (this._st.nextToken() == -1) break block1;
                                if (this._st.ttype == -2) {
                                    Double d3 = new Double(this._st.nval);
                                    this.tokValue = Integer.toString(d3.intValue());
                                    break block1;
                                }
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'N': {
                                if (this._st.sval.equals(NOTIFY)) {
                                    this.token = 21;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(NAME)) {
                                    this.token = 22;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (!this._st.sval.equals(NORMAL_DISP)) break block1;
                                this.token = 48;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'O': {
                                if (!this._st.sval.equals(OCCURRENCE)) break block1;
                                this.token = 45;
                                if (this._st.nextToken() == -1) break block1;
                                if (this._st.ttype == -2) {
                                    Double d4 = new Double(this._st.nval);
                                    this.tokValue = Integer.toString(d4.intValue());
                                    break block1;
                                }
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'P': {
                                if (this._st.sval.equals(PRINTER_CLASS)) {
                                    this.token = 20;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(PGM_DIRS)) {
                                    this.token = 23;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(PROC_DIRS)) {
                                    this.token = 24;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(PARM_ELEM)) {
                                    this.token = 25;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (!this._st.sval.equals(PATHNAME)) break block1;
                                this.token = 46;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'R': {
                                if (this._st.sval.equals(RET_OPERATOR)) {
                                    this.token = 31;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(RET_VALUE)) {
                                    this.token = 32;
                                    if (this._st.nextToken() == -1) break block1;
                                    if (this._st.ttype == -2) {
                                        Double d5 = new Double(this._st.nval);
                                        this.tokValue = Integer.toString(d5.intValue());
                                        break block1;
                                    }
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(RET_ACTION)) {
                                    this.token = 33;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(RET_STEPNAME)) {
                                    this.token = 34;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (this._st.sval.equals(RET_ACTION_STEPNAME)) {
                                    this.token = 56;
                                    if (this._st.nextToken() == -1) break block1;
                                    this.tokValue = this._st.sval;
                                    break block1;
                                }
                                if (!this._st.sval.equals(RECFM)) break block1;
                                this.token = 42;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'S': {
                                if (!this._st.sval.equals(SET_PARM)) break block1;
                                this.token = 54;
                                break block1;
                            }
                            case 'T': {
                                if (!this._st.sval.equals(TEMP)) break block1;
                                this.token = 53;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'V': {
                                if (!this._st.sval.equals(VSAM_NAME)) break block1;
                                this.token = 36;
                                if (this._st.nextToken() == -1) break block1;
                                this.tokValue = this._st.sval;
                                break block1;
                            }
                            case 'W': {
                                if (!this._st.sval.equals(WARN)) break block1;
                                this.token = 0;
                                break block1;
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            Log.buildMessage((Object)this, (String)"nextToken", (String)"Error", (String)"X00001", (Object)e.toString());
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"nextToken");
        return this.token;
    }

    public int getPrevToken() {
        return this.prevToken;
    }

    public String tokenValue() {
        return this.tokValue;
    }

    public int getToken() {
        return this.token;
    }

    public String tokenKey() {
        return this.tokKey;
    }

    public JdMediator getMediator() {
        return this._jdMediator;
    }

    public int getTokString() {
        this._st.quoteChar(34);
        this.token = this.nextToken();
        this._st.ordinaryChar(34);
        return this.token;
    }

    public String tokenName(int tokkey) {
        return (String)this.ht.get(new Integer(tokkey));
    }

    public void setStEOL(boolean b) {
        this._st.eolIsSignificant(b);
    }

    public void setJclTokenizer() {
        this._st.resetSyntax();
        this._st.wordChars(33, 39);
        this._st.wordChars(42, 57);
        this._st.wordChars(60, 255);
        this._st.whitespaceChars(0, 32);
        this._st.whitespaceChars(58, 59);
        this._st.ordinaryChar(40);
        this._st.ordinaryChar(41);
    }

    public void setInstreamTokenizer() {
        this._st.resetSyntax();
        this._st.whitespaceChars(0, 31);
        this._st.wordChars(32, 255);
    }

    private void initTable() {
        this.ht = new Hashtable();
        this.ht.put(new Integer(0), WARN);
        this.ht.put(new Integer(1), BEGIN_JOB);
        this.ht.put(new Integer(2), BEGIN_PROC);
        this.ht.put(new Integer(3), END_JOB);
        this.ht.put(new Integer(4), END_PROC);
        this.ht.put(new Integer(5), BEGIN_EXEC_PGM);
        this.ht.put(new Integer(6), BEGIN_EXEC_PROC);
        this.ht.put(new Integer(7), BEGIN_EXEC_UTIL);
        this.ht.put(new Integer(8), END_EXEC);
        this.ht.put(new Integer(9), BEGIN_DESCRIPTION);
        this.ht.put(new Integer(54), END_DESCRIPTION);
        this.ht.put(new Integer(11), BEGIN_DD_STD);
        this.ht.put(new Integer(12), BEGIN_DD_VSAM);
        this.ht.put(new Integer(13), BEGIN_DD_INPUT);
        this.ht.put(new Integer(14), BEGIN_DD_PRINT);
        this.ht.put(new Integer(15), BEGIN_DD_ALIAS);
        this.ht.put(new Integer(16), BEGIN_DD_GDG);
        this.ht.put(new Integer(17), END_DD);
        this.ht.put(new Integer(18), BEGIN_CONCATENATED);
        this.ht.put(new Integer(19), END_CONCATENATED);
        this.ht.put(new Integer(20), PRINTER_CLASS);
        this.ht.put(new Integer(21), NOTIFY);
        this.ht.put(new Integer(22), NAME);
        this.ht.put(new Integer(23), PGM_DIRS);
        this.ht.put(new Integer(24), PROC_DIRS);
        this.ht.put(new Integer(25), PARM_ELEM);
        this.ht.put(new Integer(26), EXEC_NAME);
        this.ht.put(new Integer(27), BEGIN_COND);
        this.ht.put(new Integer(28), COND_OPERATOR);
        this.ht.put(new Integer(29), COND_VALUE);
        this.ht.put(new Integer(30), COND_ACTION);
        this.ht.put(new Integer(31), RET_OPERATOR);
        this.ht.put(new Integer(32), RET_VALUE);
        this.ht.put(new Integer(33), RET_ACTION);
        this.ht.put(new Integer(56), RET_ACTION_STEPNAME);
        this.ht.put(new Integer(34), RET_STEPNAME);
        this.ht.put(new Integer(35), END_COND);
        this.ht.put(new Integer(36), VSAM_NAME);
        this.ht.put(new Integer(37), DUMMY);
        this.ht.put(new Integer(38), BURST);
        this.ht.put(new Integer(39), CHAR);
        this.ht.put(new Integer(40), COPIES);
        this.ht.put(new Integer(41), LRECL);
        this.ht.put(new Integer(42), RECFM);
        this.ht.put(new Integer(43), DEST);
        this.ht.put(new Integer(44), CLASS);
        this.ht.put(new Integer(45), OCCURRENCE);
        this.ht.put(new Integer(46), PATHNAME);
        this.ht.put(new Integer(47), DISP_STATUS);
        this.ht.put(new Integer(48), NORMAL_DISP);
        this.ht.put(new Integer(49), ABEND_DISP);
        this.ht.put(new Integer(50), BEGIN_DATA_INPUT);
        this.ht.put(new Integer(51), END_DATA_INPUT);
        this.ht.put(new Integer(52), ALIAS);
        this.ht.put(new Integer(53), TEMP);
        this.ht.put(new Integer(54), SET_PARM);
        this.ht.put(new Integer(55), END_PARM);
    }

    public static void main(String[] av) {
        System.exit(0);
    }

    static {
        TOK_WARN = 0;
        WARN = new String("__WARN_");
        TOK_BEGIN_JOB = 1;
        BEGIN_JOB = new String("__BEGIN_JOB_");
        TOK_BEGIN_PROC = 2;
        BEGIN_PROC = new String("__BEGIN_PROC_");
        TOK_END_JOB = 3;
        END_JOB = new String("__END_JOB_");
        TOK_END_PROC = 4;
        END_PROC = new String("__END_PROC_");
        TOK_BEGIN_EXEC_PGM = 5;
        BEGIN_EXEC_PGM = new String("__BEGIN_EXEC_PGM_");
        TOK_BEGIN_EXEC_PROC = 6;
        BEGIN_EXEC_PROC = new String("__BEGIN_EXEC_PROC_");
        TOK_BEGIN_EXEC_UTIL = 7;
        BEGIN_EXEC_UTIL = new String("__BEGIN_EXEC_UTIL_");
        TOK_END_EXEC = 8;
        END_EXEC = new String("__END_EXEC_");
        TOK_BEGIN_DESCRIPTION = 9;
        BEGIN_DESCRIPTION = new String("__BEGIN_DESCRIPTION_");
        TOK_END_DESCRIPTION = 54;
        END_DESCRIPTION = new String("__END_DESCRIPTION_");
        TOK_BEGIN_DD_STD = 11;
        BEGIN_DD_STD = new String("__BEGIN_DD_STD_");
        TOK_BEGIN_DD_VSAM = 12;
        BEGIN_DD_VSAM = new String("__BEGIN_DD_VSAM_");
        TOK_BEGIN_DD_INPUT = 13;
        BEGIN_DD_INPUT = new String("__BEGIN_DD_INPUT_");
        TOK_BEGIN_DD_PRINT = 14;
        BEGIN_DD_PRINT = new String("__BEGIN_DD_PRINT_");
        TOK_BEGIN_DD_ALIAS = 15;
        BEGIN_DD_ALIAS = new String("__BEGIN_DD_ALIAS_");
        TOK_BEGIN_DD_GDG = 16;
        BEGIN_DD_GDG = new String("__BEGIN_DD_GDG_");
        TOK_END_DD = 17;
        END_DD = new String("__END_DD_");
        TOK_BEGIN_CONCATENATED = 18;
        BEGIN_CONCATENATED = new String("__BEGIN_DD_CONCATENATED_");
        TOK_END_CONCATENATED = 19;
        END_CONCATENATED = new String("__END_DD_CONCATENATED_");
        TOK_PRINTER_CLASS = 20;
        PRINTER_CLASS = new String("__PRINTER_CLASS_");
        TOK_NOTIFY = 21;
        NOTIFY = new String("__NOTIFY_");
        TOK_NAME = 22;
        NAME = new String("__NAME_");
        TOK_PGM_DIRS = 23;
        PGM_DIRS = new String("__PGM_DIRS_");
        TOK_PROC_DIRS = 24;
        PROC_DIRS = new String("__PROC_DIRS_");
        TOK_PARM_ELEM = 25;
        PARM_ELEM = new String("__PARM_ELEM_");
        TOK_EXEC_NAME = 26;
        EXEC_NAME = new String("__EXEC_NAME_");
        TOK_BEGIN_COND = 27;
        BEGIN_COND = new String("__BEGIN_COND_");
        TOK_COND_OPERATOR = 28;
        COND_OPERATOR = new String("__COND_OPERATOR_");
        TOK_COND_VALUE = 29;
        COND_VALUE = new String("__COND_VALUE_");
        TOK_COND_ACTION = 30;
        COND_ACTION = new String("__COND_ACTION_");
        TOK_RET_OPERATOR = 31;
        RET_OPERATOR = new String("__RET_OPERATOR_");
        TOK_RET_VALUE = 32;
        RET_VALUE = new String("__RET_VALUE_");
        TOK_RET_ACTION = 33;
        RET_ACTION = new String("__RET_ACTION_");
        TOK_RET_STEPNAME = 34;
        RET_STEPNAME = new String("__RET_STEPNAME_");
        TOK_END_COND = 35;
        END_COND = new String("__END_COND_");
        TOK_VSAM_NAME = 36;
        VSAM_NAME = new String("__VSAM_NAME_");
        TOK_DUMMY = 37;
        DUMMY = new String("__DUMMY_");
        TOK_BURST = 38;
        BURST = new String("__BURST_");
        TOK_CHAR = 39;
        CHAR = new String("__CHAR_");
        TOK_COPIES = 40;
        COPIES = new String("__COPIES_");
        TOK_LRECL = 41;
        LRECL = new String("__LRECL_");
        TOK_RECFM = 42;
        RECFM = new String("__RECFM_");
        TOK_DEST = 43;
        DEST = new String("__DEST_");
        TOK_CLASS = 44;
        CLASS = new String("__CLASS_");
        TOK_OCCURRENCE = 45;
        OCCURRENCE = new String("__OCCURRENCE_");
        TOK_PATHNAME = 46;
        PATHNAME = new String("__PATHNAME_");
        TOK_DISP_STATUS = 47;
        DISP_STATUS = new String("__DISP_STATUS_");
        TOK_NORMAL_DISP = 48;
        NORMAL_DISP = new String("__NORMAL_DISP_");
        TOK_ABEND_DISP = 49;
        ABEND_DISP = new String("__ABEND_DISP_");
        TOK_BEGIN_DATA_INPUT = 50;
        BEGIN_DATA_INPUT = new String("__BEGIN_DATA_INPUT_");
        TOK_END_DATA_INPUT = 51;
        END_DATA_INPUT = new String("__END_DATA_INPUT_");
        TOK_ALIAS = 52;
        ALIAS = new String("__ALIAS_");
        TOK_TEMP = 53;
        TEMP = new String("__TEMP_");
        TOK_SET_PARM = 54;
        SET_PARM = new String("__SET_PARM_");
        TOK_END_PARM = 55;
        END_PARM = new String("__END_PARM_");
        TOK_RET_ACTION_STEPNAME = 56;
        RET_ACTION_STEPNAME = new String("__RET_ACTION_STEPNAME_");
        MAX_TOK_VALUE = 57;
        tokTable = null;
    }
}

