/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.controller;

import com.sun.emp.mbm.jedit.interfaces.JdIAliasFile;
import com.sun.emp.mbm.jedit.interfaces.JdIConcatenatedFile;
import com.sun.emp.mbm.jedit.interfaces.JdIFolderElement;
import com.sun.emp.mbm.jedit.interfaces.JdIGdgFile;
import com.sun.emp.mbm.jedit.interfaces.JdIInputFile;
import com.sun.emp.mbm.jedit.interfaces.JdIJobElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIPgmStepElement;
import com.sun.emp.mbm.jedit.interfaces.JdIPrintFile;
import com.sun.emp.mbm.jedit.interfaces.JdIProcElement;
import com.sun.emp.mbm.jedit.interfaces.JdIProcStepElement;
import com.sun.emp.mbm.jedit.interfaces.JdIProjectElement;
import com.sun.emp.mbm.jedit.interfaces.JdIStandardFile;
import com.sun.emp.mbm.jedit.interfaces.JdIUtilStepElement;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.jedit.interfaces.JdIVsamFile;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.util.JdDirectory;
import com.sun.emp.mbm.util.JdParameter;
import com.sun.emp.mbm.util.JdProgressBar;
import com.sun.emp.mbm.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.JOptionPane;

public class JdExportVisitor
implements JdIVisitor {
    private static final int JD_YES_OVERWRITE = 0;
    private static final int JD_YES_ALL_OVERWRITE = 1;
    private static final int JD_NO_OVERWRITE = 2;
    private static final int JD_NO_ALL_OVERWRITE = 3;
    private String _jdDestDir = null;
    private FileWriter _out = null;
    private boolean _inConcat = false;
    private int _inConcatPos = 0;
    private JdProgressBar _jPbar = null;
    private boolean _resetPBar = true;
    private int _overwrite = 2;
    private boolean _file_created = false;

    public JdExportVisitor(String destDir) {
        this._jdDestDir = destDir;
        this._overwrite = 0;
    }

    public void visitProject(JdIProjectElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitProject");
        if (!targetNode.getJdINodeElement().isNodeAdded()) {
            targetNode.getJdINodeElement().expandNode(targetNode);
        }
        this.pBar((JdMutableTreeNode)targetNode);
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitProject");
    }

    public void visitFolder(JdIFolderElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitFolder");
        if (!targetNode.getJdINodeElement().isNodeAdded()) {
            targetNode.getJdINodeElement().expandNode(targetNode);
        }
        this.pBar((JdMutableTreeNode)targetNode);
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitFolder");
    }

    public void visitJob(JdIJobElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitJob");
        int curJobOverwrite = this._overwrite;
        this._file_created = false;
        if (this._overwrite == 3) {
            return;
        }
        try {
            if (!targetNode.getJdINodeElement().isNodeAdded()) {
                targetNode.getJdINodeElement().expandNode(targetNode);
            }
            this.pBar((JdMutableTreeNode)targetNode);
            if (this._out != null) {
                this._out.close();
            }
            File outFile = new File(this._jdDestDir + "/ish/" + targetNode.toString());
            if (this._overwrite != 1 && outFile.exists()) {
                Object[] options = new Object[]{"Yes", "Yes to All", "No", "No to All"};
                String jdmessage = "File: " + outFile.toString();
                jdmessage = jdmessage + "\n\nThis file exists would you like to overwrite?\n\n";
                JOptionPane optionpane = new JOptionPane();
                curJobOverwrite = this._overwrite = JOptionPane.showOptionDialog(null, jdmessage, "Job Editor - Overwrite File?", 0, 3, null, options, options[0]);
            }
            if (curJobOverwrite == 0 || this._overwrite == 1) {
                this._out = new FileWriter(outFile);
                this._out.write("################################################################################\n");
                this._out.write("#\n");
                this._out.write("# Generated by Job Editor 1.0\n");
                this._out.write("# JOB: " + targetNode.toString() + "  Generated: ");
                this._out.write(DateFormat.getDateTimeInstance(3, 1).format(new Date()) + "\n");
                if (!targetElement.getDescription().equals("Enter Description")) {
                    this.writeDescription(targetElement.getDescription());
                }
                this._out.write("# Author: " + targetElement.getAuthor() + "\n");
                this._out.write("#\n################################################################################\n");
                this._out.write("BEGINJOB mode='MVS' ");
                if (targetElement.getPrinterClass().length() > 0) {
                    this._out.write("jobclass='" + targetElement.getPrinterClass() + "' ");
                }
                if (targetElement.getRouting().length() > 0) {
                    this._out.write("programmer='" + targetElement.getRouting() + "' ");
                }
                if (targetElement.getVerbose()) {
                    this._out.write("verbose");
                }
                this._out.write("\n\n");
                this._out.flush();
                if (targetElement.getRouting().length() > 0) {
                    this._out.write("SETPRINT dest='" + targetElement.getRouting() + "' printid='ALL' scope='JOB' overridedd='N'\n");
                }
                ArrayList procList = targetElement.getListProcDirs();
                int i = 0;
                while (i < procList.size()) {
                    JdDirectory jdDir = (JdDirectory)procList.get(i);
                    this._out.write("LIBDEF scope='JOB' type='PROC'  lib='" + jdDir.getPathname() + "'\n");
                    ++i;
                }
                ArrayList pgmList = targetElement.getListPgmDirs();
                int i2 = 0;
                while (i2 < pgmList.size()) {
                    JdDirectory jdDir = (JdDirectory)pgmList.get(i2);
                    this._out.write("LIBDEF scope='JOB' type='PGM'  lib='" + jdDir.getPathname() + "'\n");
                    ++i2;
                }
            }
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitJob", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitJob - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        catch (NullPointerException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitJob", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitJob - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        if (curJobOverwrite == 0 || this._overwrite == 1) {
            Enumeration e = targetNode.getAllChildren();
            while (e.hasMoreElements()) {
                JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
                treeNode.acceptVisitor(this);
            }
            try {
                this._out.write("\nENDJOB\n");
                this._out.close();
                this._out = null;
                this._file_created = true;
            }
            catch (IOException e2) {
                Log.trace((Level)Level.INFO, (Object)this, (String)"visitJob", (String)("Error Closing Job File : " + e2.getMessage()));
                System.out.println("visitJob - Error: '" + e2.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
                JOptionPane.showMessageDialog(null, e2.getMessage(), "Error Exporting Job", 0);
                this.hideDialog();
            }
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitJob");
    }

    public void visitProc(JdIProcElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitProc");
        int curProcOverwrite = this._overwrite;
        this._file_created = false;
        if (this._overwrite == 3) {
            return;
        }
        try {
            if (!targetNode.getJdINodeElement().isNodeAdded()) {
                targetNode.getJdINodeElement().expandNode(targetNode);
            }
            this.pBar((JdMutableTreeNode)targetNode);
            if (this._out != null) {
                this._out.close();
            }
            File outFile = new File(this._jdDestDir + "/ishp/" + targetNode.toString());
            if (this._overwrite != 1 && outFile.exists()) {
                Object[] options = new Object[]{"Yes", "Yes to All", "No", "No to All"};
                String jdmessage = "File: " + outFile.toString();
                jdmessage = jdmessage + "\n\nThis file exists would you like to overwrite?\n\n";
                JOptionPane optionpane = new JOptionPane();
                curProcOverwrite = this._overwrite = JOptionPane.showOptionDialog(null, jdmessage, "Job Editor - Overwrite File?", 0, 3, null, options, options[0]);
            }
            if (curProcOverwrite == 0 || this._overwrite == 1) {
                this._out = new FileWriter(outFile);
                this._out.write("################################################################################\n");
                this._out.write("#\n");
                this._out.write("# Generated by Job Editor\n");
                this._out.write("# PROC: " + targetNode.toString() + "  Generated: ");
                this._out.write(DateFormat.getDateTimeInstance(3, 1).format(new Date()) + "\n");
                if (!targetElement.getDescription().equals("Enter Description")) {
                    this.writeDescription(targetElement.getDescription());
                }
                this._out.write("# Author: " + targetElement.getAuthor() + "\n");
                this._out.write("#\n################################################################################\n");
                this._out.write("BEGINPROC procname='" + targetNode.toString() + "'");
                if (targetElement.getVerbose()) {
                    this._out.write(" verbose");
                }
                this._out.write("\n");
                this._out.flush();
            }
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitProc", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitProc - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Procedure", 0);
            this.hideDialog();
        }
        catch (NullPointerException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitProc", (String)("Error Creating Proc File : " + e.getMessage()));
            System.out.println("visitProc - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Procedure", 0);
            this.hideDialog();
        }
        if (curProcOverwrite == 0 || this._overwrite == 1) {
            Enumeration e = targetNode.getAllChildren();
            while (e.hasMoreElements()) {
                JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
                treeNode.acceptVisitor(this);
            }
            try {
                this._out.write("ENDPROC\n");
                this._out.close();
                this._out = null;
                this._file_created = true;
            }
            catch (IOException e2) {
                Log.trace((Level)Level.INFO, (Object)this, (String)"visitProc", (String)("Error Closing Proc File : " + e2.getMessage()));
                System.out.println("visitProc - Error: '" + e2.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
                JOptionPane.showMessageDialog(null, e2.getMessage(), "Error Exporting Procedure", 0);
                this.hideDialog();
            }
            Log.exit((Level)Level.INFO, (Object)this, (String)"visitProc");
        }
    }

    public void visitPgmStep(JdIPgmStepElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitPgmStep");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            this._out.write("\n###############################################\n");
            this._out.write("LABEL name=" + targetElement.getName() + "\n");
            this._out.write("###############################################\n");
            ArrayList pgmList = targetElement.getListPgmDirs();
            int i = 0;
            while (i < pgmList.size()) {
                JdDirectory jdDir = (JdDirectory)pgmList.get(i);
                this._out.write("LIBDEF scope='STEP' type='PGM'  lib='" + jdDir.getPathname() + "'\n");
                ++i;
            }
            if (targetElement.getCondValue() != null && targetElement.getCondValue().length() > 0) {
                this._out.write("ONCONDCODE " + targetElement.getCondOperator() + " " + targetElement.getCondValue() + " " + targetElement.getCondAction());
                if (targetElement.getCondAction().equals("GOTO")) {
                    if (targetElement.getCondActionName().equals("End Of Job")) {
                        this._out.write(" END_JOB");
                    } else {
                        this._out.write(" " + targetElement.getCondActionName());
                    }
                }
                this._out.write(" scope='STEP'\n");
            }
            if (targetElement.getRetValue() != null && targetElement.getRetValue().length() > 0) {
                this._out.write("ONRETCODE " + targetElement.getRetStepName() + " " + targetElement.getRetOperator() + " " + targetElement.getRetValue() + " " + targetElement.getRetAction());
                if (targetElement.getRetAction().equals("GOTO")) {
                    if (targetElement.getRetActionStepName().equals("End Of Job")) {
                        this._out.write(" END_JOB");
                    } else {
                        this._out.write(" " + targetElement.getRetActionStepName());
                    }
                }
                this._out.write(" scope='STEP'\n");
            }
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitPgmStep", (String)("Error Writing Job File : " + e.getMessage()));
            System.out.println("visitPgmStep - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        try {
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            this._out.write("EXECPGM pgmname='" + targetElement.getExecName() + "' stepname='" + targetElement.getName() + "'");
            if (targetElement.getParameter() != null) {
                this._out.write(" parm='" + this.btshifyString(targetElement.getParameter().getValue()) + "' ");
            }
            if (targetElement.getVerbose()) {
                this._out.write("verbose ");
            }
            this._out.write("\n");
        }
        catch (IOException e2) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitPgmStep", (String)("Error Writing Job File : " + e2.getMessage()));
            System.out.println("visitPgmStep - Error: '" + e2.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e2.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        catch (NullPointerException e3) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitPgmStep", (String)("Error Writing Job File : " + e3.getMessage()));
            System.out.println("visitPgmStep - Error: '" + e3.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e3.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitPgmStep");
    }

    public void visitProcStep(JdIProcStepElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitProcStep");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            this._out.write("\n###############################################\n");
            this._out.write("LABEL name=" + targetElement.getName() + "\n");
            this._out.write("###############################################\n");
            ArrayList pgmList = targetElement.getListPgmDirs();
            int i = 0;
            while (i < pgmList.size()) {
                JdDirectory jdDir = (JdDirectory)pgmList.get(i);
                this._out.write("LIBDEF scope='STEP' type='PGM'  lib='" + jdDir.getPathname() + "'\n");
                ++i;
            }
            if (targetElement.getCondValue() != null && targetElement.getCondValue().length() > 0) {
                this._out.write("ONCONDCODE " + targetElement.getCondOperator() + " " + targetElement.getCondValue() + " " + targetElement.getCondAction());
                if (targetElement.getCondAction().equals("GOTO")) {
                    if (targetElement.getCondActionName().equals("End Of Job")) {
                        this._out.write(" END_JOB");
                    } else {
                        this._out.write(" " + targetElement.getCondActionName());
                    }
                }
                this._out.write(" scope='STEP'\n");
            }
            if (targetElement.getRetValue() != null && targetElement.getRetValue().length() > 0) {
                this._out.write("ONRETCODE " + targetElement.getRetStepName() + " " + targetElement.getRetOperator() + " " + targetElement.getRetValue() + " " + targetElement.getRetAction());
                if (targetElement.getRetAction().equals("GOTO")) {
                    if (targetElement.getRetActionStepName().equals("End Of Job")) {
                        this._out.write(" END_JOB");
                    } else {
                        this._out.write(" " + targetElement.getRetActionStepName());
                    }
                }
                this._out.write(" scope='STEP'\n");
            }
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitProcStep", (String)("Error Writing Job File : " + e.getMessage()));
            System.out.println("visitProcStep - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        catch (NullPointerException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitProcStep", (String)("Error Writing Job File : " + e.getMessage()));
            System.out.println("visitProcStep - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        try {
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            ArrayList al = targetElement.getListParameters();
            int i = 0;
            while (i < al.size()) {
                JdParameter param = (JdParameter)al.get(i);
                if (param.getKey().equals("ONCONDCODE") || param.getKey().equals("ONRETCODE")) {
                    this._out.write(param.getKey() + " " + param.getValue() + "\n");
                    al.remove(i);
                    --i;
                }
                ++i;
            }
            this._out.write("EXECPROC procname='" + targetElement.getExecName() + "' stepname='" + targetElement.getName() + "' ");
            if (al.size() > 0) {
                this._out.write("parms='");
            }
            int i2 = 0;
            while (i2 < al.size()) {
                if (i2 > 0) {
                    this._out.write(",");
                }
                JdParameter param = (JdParameter)al.get(i2);
                this._out.write(param.getKey() + "=" + param.getValue());
                ++i2;
            }
            if (al.size() > 0) {
                this._out.write("' ");
            }
            if (targetElement.getVerbose()) {
                this._out.write("verbose ");
            }
            this._out.write("\n");
        }
        catch (IOException e2) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitProcStep", (String)("Error Writing Job File : " + e2.getMessage()));
            System.out.println("visitProcStep - Error: '" + e2.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e2.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitProcStep");
    }

    public void visitUtilStep(JdIUtilStepElement targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitUtilStep");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            this._out.write("\n###############################################\n");
            this._out.write("LABEL name=" + targetElement.getName() + "\n");
            this._out.write("###############################################\n");
            if (targetElement.getCondValue() != null && targetElement.getCondValue().length() > 0) {
                this._out.write("ONCONDCODE " + targetElement.getCondOperator() + " " + targetElement.getCondValue() + " " + targetElement.getCondAction());
                if (targetElement.getCondAction().equals("GOTO")) {
                    if (targetElement.getCondActionName().equals("End Of Job")) {
                        this._out.write(" END_JOB");
                    } else {
                        this._out.write(" " + targetElement.getCondActionName());
                    }
                }
                this._out.write(" scope='STEP'\n");
            }
            if (targetElement.getRetValue() != null && targetElement.getRetValue().length() > 0) {
                this._out.write("ONRETCODE " + targetElement.getRetStepName() + " " + targetElement.getRetOperator() + " " + targetElement.getRetValue() + " " + targetElement.getRetAction());
                if (targetElement.getRetAction().equals("GOTO")) {
                    if (targetElement.getRetActionStepName().equals("End Of Job")) {
                        this._out.write(" END_JOB");
                    } else {
                        this._out.write(" " + targetElement.getRetActionStepName());
                    }
                }
                this._out.write(" scope='STEP'\n");
            }
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitUtilStep", (String)("Error Writing Job File : " + e.getMessage()));
            System.out.println("visitUtilStep - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        catch (NullPointerException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitUtilStep", (String)("Error Writing Job File : " + e.getMessage()));
            System.out.println("visitUtilStep - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        try {
            this._out.write("EXECPGM pgmname='" + targetElement.getExecName() + "' stepname='" + targetElement.getName() + "'");
            if (targetElement.getParameter() != null) {
                this._out.write(" parm='" + this.btshifyString(targetElement.getParameter().getValue()) + "' ");
            }
            if (targetElement.getVerbose()) {
                this._out.write("verbose ");
            }
            this._out.write("\n");
        }
        catch (IOException e2) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitUtilStep", (String)("Error Writing Job File : " + e2.getMessage()));
            System.out.println("visitUtilStep - Error: '" + e2.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e2.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitUtilStep");
    }

    public void visitConcatenatedFile(JdIConcatenatedFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitConcatenatedFile");
        this._inConcat = true;
        this._inConcatPos = 0;
        this.pBar((JdMutableTreeNode)targetNode);
        if (!targetElement.getDescription().equals("Enter Description")) {
            this.writeDescription(targetElement.getDescription());
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        this._inConcat = false;
        this._inConcatPos = 0;
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitConcatenatedFile");
    }

    public void visitStandardFile(JdIStandardFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitStandardFile");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            if (this._inConcat) {
                ++this._inConcatPos;
                if (this._inConcatPos == 1) {
                    this._out.write("ASSGNDD ddname='" + targetNode.getJdParent().getJdIElement().getName() + "'");
                    if (((JdIConcatenatedFile)targetNode.getJdParent().getJdIElement()).isDummy()) {
                        this._out.write(" type='DUMMY'");
                    }
                } else {
                    this._out.write("ASSGNDD        ");
                }
            } else {
                this._out.write("ASSGNDD ddname='" + targetElement.getName() + "'");
            }
            if (targetElement.isTemp()) {
                this._out.write(" type='TEMP'");
            } else if (targetElement.isDummy()) {
                this._out.write(" type='DUMMY'");
            }
            if (targetElement.getDisp().equals("Input")) {
                this._out.write(" disp='i'");
            } else if (targetElement.getDisp().equals("I-O")) {
                this._out.write(" disp='i-o'");
            } else if (targetElement.getDisp().equals("Append")) {
                this._out.write(" disp='a'");
            } else {
                this._out.write(" disp='o'");
            }
            if (targetElement.getNormal().equals("Keep")) {
                this._out.write(" normal='k'");
            } else {
                this._out.write(" normal='d'");
            }
            if (targetElement.getAbend().equals("Keep")) {
                this._out.write(" abend='k'");
            } else {
                this._out.write(" abend='d'");
            }
            if (targetElement.getRecfmt().equals("Variable")) {
                this._out.write(" recfmt='V'");
            } else if (targetElement.getRecfmt().equals("Other")) {
                this._out.write(" recfmt='mfrcdv'");
            } else {
                this._out.write(" recfmt='F'");
            }
            if (targetElement.getRecsize().length() > 0) {
                this._out.write(" recsize=" + targetElement.getRecsize());
            }
            if (targetElement.getPathName().length() > 0) {
                this._out.write(" filename='" + targetElement.getPathName() + "'");
            }
            if (targetElement.getVerbose()) {
                this._out.write(" verbose");
            }
            this._out.write("\n");
            this._out.flush();
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitStandardFile", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitStandardFile - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitStandardFile");
    }

    public void visitAliasFile(JdIAliasFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitAliasFile");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            if (targetElement.getName().length() > 0) {
                this._out.write("ASSGNDD ddname='" + targetElement.getName() + "'");
            }
            if (targetElement.getAliasName().length() > 0) {
                this._out.write(" alias='" + targetElement.getAliasName() + "'\n");
            }
            if (targetElement.getVerbose()) {
                this._out.write(" verbose");
            }
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitVsamFile", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitVsamFile - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitAliasFile");
    }

    public void visitVsamFile(JdIVsamFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitVsamFile");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            if (this._inConcat) {
                ++this._inConcatPos;
                if (this._inConcatPos == 1) {
                    this._out.write("ASSGNDD ddname='" + targetNode.getJdParent().getJdIElement().getName() + "'");
                    if (((JdIConcatenatedFile)targetNode.getJdParent().getJdIElement()).isDummy()) {
                        this._out.write(" type='DUMMY'");
                    }
                } else {
                    this._out.write("ASSGNDD        ");
                }
            } else {
                this._out.write("ASSGNDD ddname='" + targetElement.getName() + "'");
            }
            if (targetElement.getName().length() > 0) {
                this._out.write(" filename='" + targetElement.getVsamName() + "'");
            }
            this._out.write(" disp='i-o' type='VS'");
            if (targetElement.getVerbose()) {
                this._out.write(" verbose");
            }
            this._out.write("\n");
            this._out.flush();
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitVsamFile", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitVsamFile - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitVsamFile");
    }

    public void visitGdgFile(JdIGdgFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitGdgFile");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            if (this._inConcat) {
                ++this._inConcatPos;
                if (this._inConcatPos == 1) {
                    this._out.write("ASSGNDD ddname='" + targetNode.getJdParent().getJdIElement().getName() + "'");
                    if (((JdIConcatenatedFile)targetNode.getJdParent().getJdIElement()).isDummy()) {
                        this._out.write(" type='DUMMY'");
                    }
                } else {
                    this._out.write("ASSGNDD        ");
                }
            } else {
                this._out.write("ASSGNDD ddname='" + targetElement.getName() + "'");
            }
            if (targetElement.getSuffix().length() > 0) {
                this._out.write(" filename='" + targetElement.getSuffix() + "'");
            }
            this._out.write(" gdg='" + targetElement.getOccurrence() + "'");
            if (targetElement.isDummy()) {
                this._out.write(" type='DUMMY'");
            }
            if (targetElement.getDisp().equals("Input")) {
                this._out.write(" disp='i'");
            } else if (targetElement.getDisp().equals("I-O")) {
                this._out.write(" disp='i-o'");
            } else if (targetElement.getDisp().equals("Append")) {
                this._out.write(" disp='a'");
            } else {
                this._out.write(" disp='o'");
            }
            if (targetElement.getNormal().equals("Keep")) {
                this._out.write(" normal='k'");
            } else {
                this._out.write(" normal='d'");
            }
            if (targetElement.getAbend().equals("Keep")) {
                this._out.write(" abend='k'");
            } else {
                this._out.write(" abend='d'");
            }
            if (targetElement.getRecfmt().equals("Variable")) {
                this._out.write(" recfmt='V'");
            } else if (targetElement.getRecfmt().equals("Other")) {
                this._out.write(" recfmt='mfrcdv'");
            } else {
                this._out.write(" recfmt='F'");
            }
            if (targetElement.getRecsize().length() > 0) {
                this._out.write(" recsize='" + targetElement.getRecsize() + "'");
            }
            if (targetElement.getVerbose()) {
                this._out.write(" verbose");
            }
            this._out.write("\n");
            this._out.flush();
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitGdgFile", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitGdgFile - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitGdgFile");
    }

    public void visitPrintFile(JdIPrintFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitPrintFile");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            this._out.write("SETPRINT ddname='" + targetElement.getName() + "'");
            if (targetElement.getCopies().length() > 0) {
                this._out.write(" copies='" + targetElement.getCopies() + "'");
            }
            if (targetElement.getDest().length() > 0) {
                this._out.write(" dest='" + targetElement.getDest() + "'");
            }
            this._out.write("\n");
            if (this._inConcat) {
                ++this._inConcatPos;
                if (this._inConcatPos == 1) {
                    this._out.write("ASSGNDD ddname='" + targetNode.getJdParent().getJdIElement().getName() + "'");
                    if (((JdIConcatenatedFile)targetNode.getJdParent().getJdIElement()).isDummy()) {
                        this._out.write(" type='DUMMY'");
                    }
                } else {
                    this._out.write("ASSGNDD        ");
                }
            } else {
                this._out.write("ASSGNDD ddname='" + targetElement.getName() + "'");
            }
            if (targetElement.isDummy()) {
                this._out.write(" type='DUMMY'");
            } else {
                this._out.write(" type='SYSOUT'");
            }
            ArrayList al = targetElement.getListParameters();
            int i = 0;
            while (i < al.size()) {
                JdParameter param = (JdParameter)al.get(i);
                this._out.write(" " + param.getKey() + "='" + param.getValue() + "'");
                ++i;
            }
            if (targetElement.getPrinterClass().length() > 0) {
                this._out.write(" class='" + targetElement.getPrinterClass() + "'");
            }
            if (targetElement.getDisp().equals("Input")) {
                this._out.write(" disp='i'");
            } else if (targetElement.getDisp().equals("I-O")) {
                this._out.write(" disp='i-o'");
            } else if (targetElement.getDisp().equals("Append")) {
                this._out.write(" disp='a'");
            } else {
                this._out.write(" disp='o'");
            }
            if (targetElement.getNormal().equals("Keep")) {
                this._out.write(" normal='k'");
            } else {
                this._out.write(" normal='d'");
            }
            if (targetElement.getAbend().equals("Keep")) {
                this._out.write(" abend='k'");
            } else {
                this._out.write(" abend='d'");
            }
            if (targetElement.getVerbose()) {
                this._out.write(" verbose");
            }
            this._out.write("\n");
            this._out.flush();
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitPrintFile", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitPrintFile - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitPrintFile");
    }

    public void visitInputFile(JdIInputFile targetElement, JdIMutableTreeNode targetNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"visitInputFile");
        try {
            this.pBar((JdMutableTreeNode)targetNode);
            if (!targetElement.getDescription().equals("Enter Description")) {
                this.writeDescription(targetElement.getDescription());
            }
            if (this._inConcat) {
                ++this._inConcatPos;
                if (this._inConcatPos == 1) {
                    this._out.write("ASSGNDD ddname='" + targetNode.getJdParent().getJdIElement().getName() + "'");
                    if (((JdIConcatenatedFile)targetNode.getJdParent().getJdIElement()).isDummy()) {
                        this._out.write(" type='DUMMY'");
                    }
                    this._out.write(" type='INSTREAM' << !\n");
                } else {
                    this._out.write("ASSGNDD        ");
                    if (targetElement.getVerbose()) {
                        this._out.write("verbose ");
                    }
                    this._out.write("type='INSTREAM' << !\n");
                }
            } else {
                this._out.write("ASSGNDD ddname='" + targetElement.getName() + "'");
                if (targetElement.getVerbose()) {
                    this._out.write(" verbose");
                }
                this._out.write(" type='INSTREAM' << !\n");
            }
            this._out.write(targetElement.getInputData() + "\n!\n");
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"visitInputFile", (String)("Error Creating Job File : " + e.getMessage()));
            System.out.println("visitInputFile - Error: '" + e.getMessage() + "' File:" + this._jdDestDir + "/ish/" + targetNode.toString() + "\n");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        Enumeration e = targetNode.getAllChildren();
        while (e.hasMoreElements()) {
            JdIMutableTreeNode treeNode = (JdIMutableTreeNode)e.nextElement();
            treeNode.acceptVisitor(this);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"visitInputFile");
    }

    public boolean isMacroWritten() {
        return this._file_created;
    }

    public void hideDialog() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"hideDialog");
        if (this._jPbar != null) {
            this._jPbar.cancel();
            this._jPbar = null;
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"hideDialog");
    }

    private String btshifyString(String inString) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"btshifyString");
        String outString = inString.replace(' ', '_');
        outString = this.replaceStringWithString(outString, "\\", new String("\\\\"));
        outString = this.replaceCharWithString(outString, '$', new String("\\$"));
        outString = this.replaceStringWithString(outString, "''", new String("/x27"));
        outString = this.replaceCharWithString(outString, '!', new String("\\\\!"));
        outString = this.replaceCharWithString(outString, '<', new String("/x3C"));
        outString = this.replaceCharWithString(outString, '>', new String("/x3E"));
        outString = this.replaceCharWithString(outString, '(', new String("/x28"));
        outString = this.replaceCharWithString(outString, ')', new String("/x29"));
        outString = this.replaceCharWithString(outString, '|', new String("/x7C"));
        outString = this.replaceCharWithString(outString, '^', new String("/x5E"));
        outString = this.replaceCharWithString(outString, ';', new String("/x3B"));
        outString = this.replaceCharWithString(outString, '\"', new String("/x7E"));
        outString = this.replaceCharWithString(outString, '#', new String("\\\\#"));
        outString = this.replaceCharWithString(outString, '*', new String("/x2A"));
        outString = this.replaceCharWithString(outString, '[', new String("/x5B"));
        outString = this.replaceCharWithString(outString, ']', new String("/x5D"));
        outString = this.replaceCharWithString(outString, ':', new String("/x3A"));
        outString = this.replaceCharWithString(outString, '?', new String("/x3F"));
        Log.exit((Level)Level.INFO, (Object)this, (String)"btshifyString");
        return outString;
    }

    private String replaceCharWithString(String inString, char rChar, String repString) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"replaceCharWithString");
        Log.trace((Level)Level.WARNING, (Object)this, (String)"replaceCharWithString", (String)("inString='" + inString + "' rChar='" + rChar + "'\n"));
        int index = 0;
        int lastindex = 0;
        StringBuffer outBuf = new StringBuffer(inString);
        while ((index = outBuf.toString().indexOf(rChar, lastindex)) != -1) {
            outBuf.deleteCharAt(index);
            outBuf.insert(index, repString);
            lastindex = index + repString.length();
            index = 0;
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"replaceCharWithString");
        return outBuf.toString();
    }

    private String replaceStringWithString(String inString, String rString, String repString) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"replaceStringWithString");
        Log.trace((Level)Level.WARNING, (Object)this, (String)"replaceStringWithString", (String)("inString='" + inString + "' rString='" + rString + "'\n"));
        int index = 0;
        int lastindex = 0;
        StringBuffer outBuf = new StringBuffer(inString);
        while ((index = outBuf.toString().indexOf(rString, lastindex)) != -1) {
            outBuf.delete(index, index + rString.length());
            outBuf.insert(index, repString);
            lastindex = index + repString.length();
            index = 0;
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"replaceStringWithString");
        return outBuf.toString();
    }

    private void writeDescription(String inDescription) {
        try {
            this._out.write("#\n# " + this.replaceCharWithString(inDescription, '\n', new String("\n#")) + "\n# \n");
        }
        catch (IOException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"writeDescription", (String)("Error writing Description " + e.getMessage()));
            System.out.println("writeDescription - Error: '" + e.getMessage());
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
        catch (NullPointerException e) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"writeDescription", (String)("Error writing Description " + e.getMessage()));
            System.out.println("writeDescription - Error: '" + e.getMessage());
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Exporting Job", 0);
            this.hideDialog();
        }
    }

    private void pBar(JdMutableTreeNode curNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"pBar");
        if (this._jPbar == null) {
            int max = curNode.getLeafCount();
            this._jPbar = new JdProgressBar(new String("Exporting..."), max);
            Log.trace((Level)Level.INFO, (Object)this, (String)"pBar", (String)("Setting pBar max to " + max + "\n"));
        }
        if (curNode.isLeaf()) {
            this._jPbar.run();
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"pBar");
    }

    static {
        JD_YES_OVERWRITE = 0;
        JD_YES_ALL_OVERWRITE = 1;
        JD_NO_OVERWRITE = 2;
        JD_NO_ALL_OVERWRITE = 3;
    }
}

