/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.command;

import com.sun.emp.mbm.jedit.command.JdCommand;
import com.sun.emp.mbm.jedit.command.JdInvalidRedoException;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIProjectElement;
import com.sun.emp.mbm.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JdFileMapImportCommand
extends JdCommand {
    private static final String _commandName = "import";
    private String _fileMap = null;
    private Properties _envProperties = null;
    private static String exportPath;
    JdIMutableTreeNode _jdTreeNode = null;

    public void doIt() {
        JdIMutableTreeNode l_jdTreeNode;
        Log.entry((Level)Level.INFO, (Object)this, (String)"doIt");
        String fmString = JdCommand._jdMediator.getFileMap();
        if (fmString == null) {
            Log.displayMessage((Object)this, (String)"doIt", (String)"Warning", (String)"E00009", (Object)"You must select a FileMap.");
            Log.exit((Level)Level.INFO, (Object)this, (String)"doIt");
            return;
        }
        this._fileMap = fmString;
        this._jdTreeNode = l_jdTreeNode = JdCommand._jdMediator.getSelectedNode();
        while (l_jdTreeNode.getJdIElement().getElementType() != 0) {
            l_jdTreeNode = l_jdTreeNode.getJdParent();
        }
        JdIProjectElement projectElement = (JdIProjectElement)l_jdTreeNode.getJdIElement();
        if (exportPath == null) {
            exportPath = projectElement.getDirectoryPathname().getPathname() + File.separator + projectElement.getName() + File.separatorChar + "jmvs";
        }
        JFileChooser chooser = new JFileChooser(exportPath);
        File selFile = new File(exportPath);
        chooser.setSelectedFile(selFile);
        chooser.setDialogTitle(new String("Please select the JCL file to Import:"));
        int option = chooser.showDialog(null, "Select");
        if (option == 0) {
            exportPath = chooser.getSelectedFile().getAbsolutePath();
        }
        this.doMvstrans(exportPath);
        Log.exit((Level)Level.INFO, (Object)this, (String)"doIt");
    }

    public void undoIt() {
        throw new JdInvalidRedoException();
    }

    public void redoIt() {
        throw new JdInvalidRedoException();
    }

    public String canUndo() {
        return null;
    }

    public String canRedo() {
        return null;
    }

    public String getCommandName() {
        return new String("import ...");
    }

    private void doMvstrans(String jclFullPath) {
        try {
            String jclFile;
            Runtime rt = Runtime.getRuntime();
            String[] cmd = new String[3];
            String[] envp = null;
            cmd[0] = "mvstrans";
            int lastslash = jclFullPath.lastIndexOf(File.separatorChar);
            if (lastslash == -1) {
                return;
            }
            int jobProcSlash = jclFullPath.lastIndexOf(File.separatorChar, lastslash - 1);
            if (jobProcSlash == -1) {
                return;
            }
            String jclPath = jclFullPath.substring(0, jobProcSlash);
            String jobOrProc = jclFullPath.substring(jobProcSlash + 1, lastslash);
            cmd[1] = jclFile = jclFullPath.substring(lastslash + 1);
            cmd[2] = jobOrProc.equalsIgnoreCase("mvsp") ? "-vp" : "-v";
            File dirp = new File(jclPath);
            envp = this.getEnv();
            Process proc = rt.exec(cmd, envp, dirp);
            StreamProc errorGobbler = new StreamProc(proc.getErrorStream(), "ERROR");
            StreamProc outputGobbler = new StreamProc(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            outputGobbler.join();
            JOptionPane.showMessageDialog(null, "FileMap Import Finished.", "Finished Importing", 1);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String[] getEnv() {
        if (this._envProperties == null) {
            try {
                Runtime rt = Runtime.getRuntime();
                String[] cmd = new String[3];
                String os = System.getProperty("os.name");
                if (os != null && os.startsWith("Windows")) {
                    cmd[0] = "cmd.exe";
                    cmd[1] = "/c";
                    cmd[2] = "set";
                } else {
                    cmd[0] = "ksh";
                    cmd[1] = "-c";
                    cmd[2] = "env";
                }
                Process proc = rt.exec(cmd);
                StreamProc errorGobbler = new StreamProc(proc.getErrorStream(), "ERROR");
                EnvProc outputGobbler = new EnvProc(proc.getInputStream(), "ENV");
                errorGobbler.start();
                outputGobbler.start();
                int exitVal = proc.waitFor();
                outputGobbler.join();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this._fileMap == null) {
            this._fileMap = new String("File_Map");
        }
        this._envProperties.setProperty("FILEMAP", this._fileMap);
        int propcount = this._envProperties.size();
        String[] env = new String[propcount];
        Enumeration<?> enprop = this._envProperties.propertyNames();
        int index = 0;
        String key = null;
        while (enprop.hasMoreElements()) {
            key = (String)enprop.nextElement();
            env[index++] = key + "=" + this._envProperties.getProperty(key);
        }
        return env;
    }

    static {
        _commandName = _commandName;
        exportPath = null;
    }

    class EnvProc
    extends Thread {
        InputStream is;
        String type;

        EnvProc(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    StringTokenizer strtok = new StringTokenizer(line, "=");
                    if (strtok.countTokens() != 2) continue;
                    String key = strtok.nextToken();
                    String value = strtok.nextToken();
                    if (JdFileMapImportCommand.this._envProperties == null) {
                        JdFileMapImportCommand.this._envProperties = new Properties();
                    }
                    JdFileMapImportCommand.this._envProperties.setProperty(key, value);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            JdFileMapImportCommand.this._envProperties.setProperty("SYSTEM_OUTPUT", "JCL");
        }
    }

    class StreamProc
    extends Thread {
        InputStream is;
        String type;

        StreamProc(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

