/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.command;

import com.sun.emp.mbm.jedit.command.JdCommand;
import com.sun.emp.mbm.jedit.command.JdInvalidRedoException;
import com.sun.emp.mbm.jedit.controller.JdExportVisitor;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIProjectElement;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.util.Log;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JdExportCommand
extends JdCommand {
    private static final String _commandName = "export";
    private static String exportPath;
    JdIMutableTreeNode _jdTreeNode = null;

    public void doIt() {
        JdIMutableTreeNode l_jdTreeNode;
        Log.entry((Level)Level.INFO, (Object)this, (String)"doIt");
        this._jdTreeNode = l_jdTreeNode = JdCommand._jdMediator.getSelectedNode();
        while (l_jdTreeNode.getJdIElement().getElementType() != 0) {
            l_jdTreeNode = l_jdTreeNode.getJdParent();
        }
        JdIProjectElement projectElement = (JdIProjectElement)l_jdTreeNode.getJdIElement();
        if (exportPath == null) {
            exportPath = projectElement.getDirectoryPathname().getPathname() + File.separator + projectElement.getName();
        }
        JFileChooser chooser = new JFileChooser(exportPath);
        chooser.setFileSelectionMode(1);
        File selFile = new File(exportPath);
        chooser.setSelectedFile(selFile);
        chooser.setDialogTitle(new String("Please select the destination directory for MBM macros: (should be parent of ish/ishp)"));
        int option = chooser.showDialog(null, "Select");
        if (option == 0) {
            exportPath = chooser.getSelectedFile().getAbsolutePath();
            JdExportVisitor exportVisitor = new JdExportVisitor(exportPath);
            ExportThread et = new ExportThread(this._jdTreeNode, exportVisitor);
            et.start();
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"doIt");
    }

    public void undoIt() {
        throw new JdInvalidRedoException();
    }

    public void redoIt() {
        throw new JdInvalidRedoException();
    }

    public String canUndo() {
        return null;
    }

    public String canRedo() {
        return null;
    }

    public String getCommandName() {
        return new String("export ...");
    }

    static {
        _commandName = _commandName;
        exportPath = null;
    }

    class ExportThread
    extends Thread {
        JdIMutableTreeNode treeNode;
        JdIVisitor visitor;

        public ExportThread(JdIMutableTreeNode treeNode, JdIVisitor visitor) {
            this.treeNode = treeNode;
            this.visitor = visitor;
        }

        public void run() {
            Log.entry((Level)Level.INFO, (Object)this, (String)"ExportThread");
            this.treeNode.acceptVisitor(this.visitor);
            JdExportVisitor jdvisit = (JdExportVisitor)this.visitor;
            jdvisit.hideDialog();
            if (jdvisit.isMacroWritten()) {
                Object[] options = new Object[]{"OK"};
                String jdmessage = new String("MBM macro output created!");
                JOptionPane jp = new JOptionPane();
                JOptionPane.showOptionDialog(null, jdmessage, "Job Editor", -1, 1, null, options, options[0]);
                Log.trace((Level)Level.INFO, (Object)this, (String)"ExportThread", (String)"Dialog Should be Hidden");
            }
            Log.exit((Level)Level.INFO, (Object)this, (String)"ExportThread");
        }
    }
}

