/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.util;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JdProgressBar
extends JProgressBar {
    private String m_title = null;
    private int m_max_value = 0;
    private JDialog m_dialog = null;
    private boolean m_reset_bar = true;

    public JdProgressBar(String title, int max_value) {
        this.m_title = new String(title);
        this.m_max_value = max_value;
    }

    public void setTitle(String title) {
        this.m_title = title;
        if (this.m_dialog != null) {
            this.m_dialog.setTitle(this.m_title);
            this.m_dialog.repaint();
        }
    }

    public void setMaximum(int max_value) {
        this.m_max_value = max_value;
        super.setMaximum(this.m_max_value);
    }

    public void reset() {
        this.m_reset_bar = true;
        this.m_dialog = null;
    }

    public void cancel() {
        if (this.m_dialog != null) {
            this.m_dialog.setVisible(false);
            this.m_dialog.dispose();
            this.m_dialog = null;
        }
        this.reset();
    }

    public void run() {
        Runnable runner = new Runnable(){

            public void run() {
                int value = JdProgressBar.this.getValue();
                JdProgressBar.this.setValue(value + 1);
                if (JdProgressBar.this.getValue() != value + 1) {
                    // empty if block
                }
                if (JdProgressBar.this.getValue() >= JdProgressBar.this.m_max_value && JdProgressBar.this.m_dialog != null) {
                    JdProgressBar.this.m_dialog.setVisible(false);
                    JdProgressBar.this.m_dialog.dispose();
                    JdProgressBar.this.m_dialog = null;
                }
            }
        };
        if (null == this.m_dialog) {
            this.m_dialog = new JDialog();
            this.m_dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    JdProgressBar.this.cancel();
                }
            });
            JPanel panel = new JPanel();
            this.setStringPainted(true);
            panel.add(this);
            this.m_dialog.getContentPane().add((Component)panel, "Center");
            this.m_dialog.setSize(300, 60);
            this.m_dialog.setTitle(this.m_title);
            this.m_dialog.setResizable(false);
            this.m_dialog.setVisible(true);
        }
        if (this.m_reset_bar) {
            this.m_reset_bar = false;
            this.setMaximum(this.m_max_value);
            this.setValue(0);
            this.m_dialog.setVisible(true);
            SwingUtilities.invokeLater(runner);
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public static void main(String[] av) {
        JdProgressBar pbar = new JdProgressBar("Test...", 100);
        pbar.setTitle("Begin test...");
        int i = 0;
        while (i <= 100) {
            try {
                if (i == 50) {
                    pbar.setTitle("Halfway there...");
                }
                Thread.sleep(50L);
            }
            catch (Exception e) {
                // empty catch block
            }
            pbar.run();
            ++i;
        }
        System.out.println("Resetting progress bar");
        pbar.reset();
        System.out.println("Setting new title for test two");
        pbar.setTitle("Test Two");
        System.out.println("Setting new maximum for test two");
        pbar.setMaximum(25);
        System.out.println("Running test two");
        int i2 = 0;
        while (i2 <= 20) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                // empty catch block
            }
            pbar.run();
            ++i2;
        }
        System.out.println("Cancelling progress bar before completion");
        pbar.cancel();
        System.out.println("Running the reset/cancelled progress bar again");
        pbar.run();
    }
}

