/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIStandardFile;
import com.sun.emp.mbm.jedit.model.JdStandardFile;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JdStandardAttributesUI
extends JPanel
implements JdIFormUI {
    JPanel parent = this;
    private JdIStandardFile jdElement;
    private JLabel jdddlbl;
    private JLabel jdpathlbl;
    private JTextField jdddtxt;
    private JTextField jdpathtxt;
    private JButton jdbrowsebtn;
    private JButton jdlistbtn;
    private JRadioButton jdstandardrb;
    private JRadioButton jdtemporaryrb;
    private JRadioButton jddummyrb;
    private JCheckBox jdverbosechk;
    private ButtonGroup jdbg;
    private File lastSelectedFile = null;

    public JdStandardAttributesUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 30);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp = new JPanel();
        JPanel jp1 = new JPanel();
        this.jdddlbl = new JLabel("DD Name");
        this.jdpathlbl = new JLabel("Path Name");
        this.jdddtxt = new JTextField("");
        this.jdpathtxt = new JTextField("");
        this.jdbrowsebtn = new JButton("Browse");
        this.jdlistbtn = new JButton("List");
        this.jdstandardrb = new JRadioButton("Standard");
        this.jdtemporaryrb = new JRadioButton("Temporary");
        this.jddummyrb = new JRadioButton("Dummy");
        this.jdverbosechk = new JCheckBox("Verbose");
        this.jdbg = new ButtonGroup();
        this.jdbg.add(this.jdstandardrb);
        this.jdbg.add(this.jdtemporaryrb);
        this.jdbg.add(this.jddummyrb);
        this.jdbrowsebtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(JdStandardAttributesUI.this.lastSelectedFile);
                chooser.setFileSelectionMode(0);
                int option = chooser.showDialog(JdStandardAttributesUI.this.parent, "Select");
                if (option == 0) {
                    JdStandardAttributesUI.this.lastSelectedFile = chooser.getSelectedFile();
                    JdStandardAttributesUI.this.jdpathtxt.setText(JdStandardAttributesUI.this.lastSelectedFile.getAbsolutePath());
                }
            }
        });
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser listChooser = new JdListChooser("Standard Name Chooser", "Select a Standard Name", JdMediator.getStandardNameList().toArray(), JdStandardAttributesUI.this.jdlistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdStandardAttributesUI.this.jdpathtxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(this.jdddlbl);
        this.add(this.jdddtxt);
        this.add(this.jdpathlbl);
        this.add(this.jdpathtxt);
        this.add(this.jdbrowsebtn);
        this.add(this.jdlistbtn);
        jp.add(this.jdstandardrb);
        jp.add(this.jdtemporaryrb);
        jp.add(this.jddummyrb);
        this.add(jp);
        jp1.add(this.jdverbosechk);
        this.add(jp1);
        jp.setOpaque(false);
        this.jdstandardrb.setOpaque(false);
        this.jdtemporaryrb.setOpaque(false);
        this.jddummyrb.setOpaque(false);
        jp1.setOpaque(false);
        this.jdverbosechk.setOpaque(false);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIStandardFile)jdIElement;
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdddtxt.setText("");
        } else {
            this.jdddtxt.setText(str);
        }
        str = this.jdElement.getPathName();
        if (str == null) {
            this.jdpathtxt.setText("");
        } else {
            this.jdpathtxt.setText(str);
        }
        if (this.jdElement.isDummy()) {
            this.jddummyrb.setSelected(true);
        } else if (this.jdElement.isTemp()) {
            this.jdtemporaryrb.setSelected(true);
        } else if (this.jdElement.isDefault()) {
            this.jdstandardrb.setSelected(true);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbosechk.setSelected(verbose);
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setName(this.jdddtxt.getText());
        this.jdElement.setPathName(this.jdpathtxt.getText());
        if (this.jdtemporaryrb.isSelected()) {
            this.jdElement.setTemp();
        } else if (this.jddummyrb.isSelected()) {
            this.jdElement.setDummy();
        } else if (this.jdstandardrb.isSelected()) {
            this.jdElement.setDefault();
        }
        this.jdElement.setVerbose(this.jdverbosechk.isSelected());
    }

    public void reset() {
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdddtxt.setText("");
        } else {
            this.jdddtxt.setText(str);
        }
        str = this.jdElement.getPathName();
        if (str == null) {
            this.jdpathtxt.setText("");
        } else {
            this.jdpathtxt.setText(str);
        }
        if (this.jdElement.isDummy()) {
            this.jddummyrb.setSelected(true);
        } else if (this.jdElement.isTemp()) {
            this.jdtemporaryrb.setSelected(true);
        } else if (this.jdElement.isDefault()) {
            this.jdstandardrb.setSelected(true);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbosechk.setSelected(verbose);
    }

    public void setUpdate() {
        this.jdddtxt.setEnabled(true);
        this.jdpathtxt.setEnabled(true);
        this.jdbrowsebtn.setEnabled(true);
        this.jdlistbtn.setEnabled(true);
        this.jdstandardrb.setEnabled(true);
        this.jdtemporaryrb.setEnabled(true);
        this.jddummyrb.setEnabled(true);
        this.jdverbosechk.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdddtxt.setEnabled(false);
        this.jdpathtxt.setEnabled(false);
        this.jdbrowsebtn.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
        this.jdstandardrb.setEnabled(false);
        this.jdtemporaryrb.setEnabled(false);
        this.jddummyrb.setEnabled(false);
        this.jdverbosechk.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdddtxt.getText().length() == 0) {
            component.setJdReason(new String("The DD Name cannot be empty"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (this.jdddtxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The DD Name cannot contain space"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (JdMediator.getBrotherList().contains(this.jdddtxt.getText())) {
            component.setJdReason(new String("The DD Name already exists"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (this.jdpathtxt.getText().length() == 0) {
            component.setJdReason(new String("The Path Name cannot be empty"));
            component.setJdLabel(new String(this.jdpathlbl.getText()));
            component.setJdComponent((Component)this.jdpathtxt);
            return false;
        }
        if (this.jdpathtxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Path Name cannot contain space"));
            component.setJdLabel(new String(this.jdpathlbl.getText()));
            component.setJdComponent((Component)this.jdpathtxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdStandardAttributesUI jddui = new JdStandardAttributesUI();
        JdStandardFile jdp = new JdStandardFile();
        jddui.show(jdp);
        jf.getContentPane().add(jddui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jddui.update();
    }
}

