/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIStepElement;
import com.sun.emp.mbm.jedit.model.JdUtilStepElement;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JdReturnCodeUI
extends JPanel
implements JdIFormUI {
    private JdIStepElement jdElement;
    private JLabel jdiflbl;
    private JLabel jdreturnlbl;
    private JLabel jdthenlbl;
    private JLabel jdgotolbl;
    private JComboBox jdsecondcmb;
    private JComboBox jdthencmb;
    private JTextField jdgototxt;
    private JTextField jdiftxt;
    private JTextField jdvaluetxt;
    private JButton jdlistbtn;
    private JButton jdiflistbtn;

    public JdReturnCodeUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 30);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp = new JPanel();
        this.jdiflbl = new JLabel("If ");
        this.jdreturnlbl = new JLabel("Return Code");
        this.jdthenlbl = new JLabel("Then");
        this.jdgotolbl = new JLabel("Goto Step");
        this.jdiftxt = new JTextField(10);
        this.jdiflistbtn = new JButton("List");
        this.jdsecondcmb = new JComboBox();
        this.jdvaluetxt = new JTextField(5);
        this.jdthencmb = new JComboBox();
        this.jdgototxt = new JTextField("End Of Job");
        this.jdlistbtn = new JButton("List");
        jp.add(this.jdiflbl);
        jp.add(this.jdiftxt);
        jp.add(this.jdiflistbtn);
        jp.add(this.jdreturnlbl);
        jp.add(this.jdsecondcmb);
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ArrayList arr = JdMediator.getBrotherList();
                arr.add("End Of Job");
                JdListChooser listChooser = new JdListChooser("GoTo Step Chooser", "Select a GoTo Step", arr.toArray(), JdReturnCodeUI.this.jdlistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdReturnCodeUI.this.jdgototxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.jdiflistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ArrayList arr = JdMediator.getGotoStepList();
                arr.add(0, "Any");
                JdListChooser listChooser = new JdListChooser("List chooser", "Select a value", arr.toArray(), JdReturnCodeUI.this.jdiflistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdReturnCodeUI.this.jdiftxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.jdthencmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String str = (String)cb.getSelectedItem();
                if (str.equals("GOTO")) {
                    JdReturnCodeUI.this.jdgototxt.setEditable(true);
                } else {
                    JdReturnCodeUI.this.jdgototxt.setText("");
                    JdReturnCodeUI.this.jdgototxt.setEditable(false);
                }
            }
        });
        this.jdsecondcmb.addItem("EQ");
        this.jdsecondcmb.addItem("NE");
        this.jdsecondcmb.addItem("GT");
        this.jdsecondcmb.addItem("LT");
        this.jdsecondcmb.addItem("GE");
        this.jdsecondcmb.addItem("LE");
        jp.add(this.jdvaluetxt);
        this.add(jp);
        this.add(this.jdthenlbl);
        this.add(this.jdthencmb);
        this.jdthencmb.addItem("CONTINUE");
        this.jdthencmb.addItem("BYPASS");
        this.jdthencmb.addItem("GOTO");
        this.add(this.jdgotolbl);
        this.add(this.jdgototxt);
        this.add(this.jdlistbtn);
        jp.setOpaque(false);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIStepElement)jdIElement;
        String str = this.jdElement.getRetStepName();
        if (str == null) {
            this.jdiftxt.setText("Any");
        } else {
            this.jdiftxt.setText(str);
        }
        str = this.jdElement.getRetOperator();
        if (str == null) {
            this.jdsecondcmb.setSelectedIndex(0);
        } else {
            this.jdsecondcmb.setSelectedItem(str);
        }
        str = this.jdElement.getRetValue();
        if (str != null) {
            this.jdvaluetxt.setText(str);
        }
        if ((str = this.jdElement.getRetAction()) == null) {
            this.jdthencmb.setSelectedIndex(0);
        } else {
            this.jdthencmb.setSelectedItem(str);
        }
        str = this.jdElement.getRetActionStepName();
        if (str == null) {
            this.jdgototxt.setText("");
        } else {
            this.jdgototxt.setText(str);
        }
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setRetStepName(this.jdiftxt.getText());
        this.jdElement.setRetOperator(this.jdsecondcmb.getSelectedItem().toString());
        this.jdElement.setRetValue(this.jdvaluetxt.getText());
        this.jdElement.setRetAction(this.jdthencmb.getSelectedItem().toString());
        this.jdElement.setRetActionStepName(this.jdgototxt.getText());
    }

    public void reset() {
        String str = this.jdElement.getRetStepName();
        if (str == null) {
            this.jdiftxt.setText("Any");
        } else {
            this.jdiftxt.setText("Any");
        }
        str = this.jdElement.getRetOperator();
        if (str == null) {
            this.jdsecondcmb.setSelectedItem("");
        } else {
            this.jdsecondcmb.setSelectedItem(str);
        }
        str = this.jdElement.getRetValue();
        if (str != null) {
            this.jdvaluetxt.setText(str);
        }
        if ((str = this.jdElement.getRetAction()) == null) {
            this.jdthencmb.setSelectedItem("");
        } else {
            this.jdthencmb.setSelectedItem(str);
        }
        str = this.jdElement.getRetActionStepName();
        if (str == null) {
            this.jdgototxt.setText("");
        } else {
            this.jdgototxt.setText(str);
        }
    }

    public void setUpdate() {
        this.jdiftxt.setEnabled(true);
        this.jdsecondcmb.setEnabled(true);
        this.jdvaluetxt.setEnabled(true);
        this.jdthencmb.setEnabled(true);
        this.jdgototxt.setEnabled(true);
        this.jdlistbtn.setEnabled(true);
        this.jdiflistbtn.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdiftxt.setEnabled(false);
        this.jdsecondcmb.setEnabled(false);
        this.jdvaluetxt.setEnabled(false);
        this.jdthencmb.setEnabled(false);
        this.jdgototxt.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
        this.jdiflistbtn.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdthencmb.getSelectedItem().equals("GOTO") && this.jdgototxt.getText().length() == 0) {
            component.setJdReason(new String("The Goto Step cannot be empty"));
            component.setJdLabel(new String(this.jdgotolbl.getText()));
            component.setJdComponent((Component)this.jdgototxt);
            return false;
        }
        try {
            String mystr = this.jdvaluetxt.getText();
            if (mystr.length() > 0) {
                Integer.parseInt(mystr);
            }
        }
        catch (NumberFormatException num) {
            component.setJdReason(new String("The Return Code value should be a number"));
            component.setJdComponent((Component)this.jdvaluetxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdReturnCodeUI jdrcui = new JdReturnCodeUI();
        JdUtilStepElement jdp = new JdUtilStepElement();
        jdrcui.show(jdp);
        jf.getContentPane().add(jdrcui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jdrcui.update();
    }
}

