/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIGdgFile;
import com.sun.emp.mbm.jedit.model.JdGdgFile;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JdGdgAttributesUI
extends JPanel
implements JdIFormUI {
    JPanel parent = this;
    private JdIGdgFile jdElement;
    private JLabel jdddnamelbl;
    private JLabel jdsuffixlbl;
    private JLabel jdoccurrencelbl;
    private JTextField jdddnametxt;
    private JTextField jdsuffixtxt;
    private JTextField jdoccurrencetxt;
    private JButton jdbrowsebtn;
    private JButton jdlistbtn;
    private JCheckBox jdallchk;
    private JCheckBox jdverbosechk;
    private JRadioButton jdgdgrb;
    private JRadioButton jddummyrb;
    private ButtonGroup jdbgroup;
    private File lastSelectedFile = null;

    public JdGdgAttributesUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 30);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp1 = new JPanel();
        JPanel jp2 = new JPanel();
        JPanel jp3 = new JPanel();
        this.jdddnamelbl = new JLabel("DD Name");
        this.jdsuffixlbl = new JLabel("Suffix Path Name");
        this.jdoccurrencelbl = new JLabel("Occurrence Number");
        this.jdddnametxt = new JTextField(15);
        this.jdsuffixtxt = new JTextField(15);
        this.jdbrowsebtn = new JButton("Browse");
        this.jdlistbtn = new JButton("List");
        this.jdallchk = new JCheckBox("All Occurrences");
        this.jdverbosechk = new JCheckBox("Verbose");
        this.jdgdgrb = new JRadioButton("GDG", true);
        this.jddummyrb = new JRadioButton("Dummy");
        this.jdbgroup = new ButtonGroup();
        this.jdbgroup.add(this.jdgdgrb);
        this.jdbgroup.add(this.jddummyrb);
        this.jdoccurrencetxt = new JTextField(5);
        this.jdbrowsebtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(JdGdgAttributesUI.this.lastSelectedFile);
                chooser.setFileSelectionMode(0);
                int option = chooser.showDialog(JdGdgAttributesUI.this.parent, "Select");
                if (option == 0) {
                    JdGdgAttributesUI.this.lastSelectedFile = chooser.getSelectedFile();
                    JdGdgAttributesUI.this.jdsuffixtxt.setText(JdGdgAttributesUI.this.lastSelectedFile.getAbsolutePath());
                }
            }
        });
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser listChooser = new JdListChooser("Gdg Name Chooser", "Select a Gdg Name", JdMediator.getGdgNameList().toArray(), JdGdgAttributesUI.this.jdlistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdGdgAttributesUI.this.jdsuffixtxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(this.jdddnamelbl);
        this.add(this.jdddnametxt);
        this.add(this.jdsuffixlbl);
        this.add(this.jdsuffixtxt);
        this.add(this.jdbrowsebtn);
        this.add(this.jdlistbtn);
        this.add(this.jdoccurrencelbl);
        this.add(this.jdoccurrencetxt);
        jp1.add(this.jdallchk);
        this.add(jp1);
        jp2.add(this.jdgdgrb);
        jp2.add(this.jddummyrb);
        this.add(jp2);
        jp3.add(this.jdverbosechk);
        this.add(jp3);
        jp1.setOpaque(false);
        jp2.setOpaque(false);
        jp3.setOpaque(false);
        this.jdallchk.setOpaque(false);
        this.jdverbosechk.setOpaque(false);
        this.jdgdgrb.setOpaque(false);
        this.jddummyrb.setOpaque(false);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIGdgFile)jdIElement;
        String str = this.jdElement.getName();
        if (str == null) {
            this.jdddnametxt.setText("");
        } else {
            this.jdddnametxt.setText(str);
        }
        str = this.jdElement.getSuffix();
        if (str == null) {
            this.jdsuffixtxt.setText("");
        } else {
            this.jdsuffixtxt.setText(str);
        }
        str = this.jdElement.getOccurrence();
        if (str == null) {
            this.jdoccurrencetxt.setText("");
        } else {
            this.jdoccurrencetxt.setText(str);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbosechk.setSelected(verbose);
        if (this.jdElement.isDummy()) {
            this.jddummyrb.setSelected(true);
        } else {
            this.jdgdgrb.setSelected(true);
        }
        if (this.jdoccurrencetxt.getText().equals("All")) {
            this.jdallchk.setSelected(true);
        }
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setName(this.jdddnametxt.getText());
        this.jdElement.setSuffix(this.jdsuffixtxt.getText());
        this.jdElement.setOccurrence(this.jdoccurrencetxt.getText());
        if (this.jddummyrb.isSelected()) {
            this.jdElement.setDummy();
        } else if (this.jdgdgrb.isSelected()) {
            this.jdElement.setDefault();
        }
        this.jdElement.setVerbose(this.jdverbosechk.isSelected());
        this.jdElement.setVerbose(this.jdverbosechk.isSelected());
    }

    public void reset() {
        String str = this.jdElement.getName();
        if (str == null) {
            this.jdddnametxt.setText("");
        } else {
            this.jdddnametxt.setText(str);
        }
        str = this.jdElement.getSuffix();
        if (str == null) {
            this.jdsuffixtxt.setText("");
        } else {
            this.jdsuffixtxt.setText(str);
        }
        str = this.jdElement.getOccurrence();
        if (str == null) {
            this.jdoccurrencetxt.setText(" ");
        } else {
            this.jdoccurrencetxt.setText(str);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbosechk.setSelected(verbose);
        if (this.jdElement.isDummy()) {
            this.jddummyrb.setSelected(true);
        } else {
            this.jdgdgrb.setSelected(true);
        }
    }

    public void setUpdate() {
        this.jdddnametxt.setEnabled(true);
        this.jdsuffixtxt.setEnabled(true);
        this.jdbrowsebtn.setEnabled(true);
        this.jdlistbtn.setEnabled(true);
        this.jdallchk.setEnabled(true);
        this.jdverbosechk.setEnabled(true);
        this.jdgdgrb.setEnabled(true);
        this.jddummyrb.setEnabled(true);
        this.jdoccurrencetxt.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdddnametxt.setEnabled(false);
        this.jdsuffixtxt.setEnabled(false);
        this.jdbrowsebtn.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
        this.jdallchk.setEnabled(false);
        this.jdverbosechk.setEnabled(false);
        this.jdgdgrb.setEnabled(false);
        this.jddummyrb.setEnabled(false);
        this.jdoccurrencetxt.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdddnametxt.getText().length() == 0) {
            component.setJdReason(new String("The DD Name cannot be empty"));
            component.setJdLabel(new String(this.jdddnamelbl.getText()));
            component.setJdComponent((Component)this.jdddnametxt);
            return false;
        }
        if (this.jdddnametxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The DD Name cannot contain space"));
            component.setJdLabel(new String(this.jdddnamelbl.getText()));
            component.setJdComponent((Component)this.jdddnametxt);
            return false;
        }
        if (JdMediator.getBrotherList().contains(this.jdddnametxt.getText())) {
            component.setJdReason(new String("The DD Name already exists"));
            component.setJdLabel(new String(this.jdddnamelbl.getText()));
            component.setJdComponent((Component)this.jdddnametxt);
            return false;
        }
        if (this.jdsuffixtxt.getText().length() == 0) {
            component.setJdReason(new String("The Suffix Path Name cannot be empty"));
            component.setJdLabel(new String(this.jdsuffixlbl.getText()));
            component.setJdComponent((Component)this.jdsuffixtxt);
            return false;
        }
        if (this.jdsuffixtxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Suffix Path Name cannot contain space"));
            component.setJdLabel(new String(this.jdsuffixlbl.getText()));
            component.setJdComponent((Component)this.jdsuffixtxt);
            return false;
        }
        try {
            StringBuffer ocBuf = new StringBuffer(this.jdoccurrencetxt.getText());
            if (ocBuf.charAt(0) == '+') {
                ocBuf.setCharAt(0, '0');
            }
            Integer.parseInt(ocBuf.toString());
        }
        catch (NumberFormatException num) {
            component.setJdReason(new String("The occurrence should be a number"));
            component.setJdLabel(new String(this.jdoccurrencelbl.getText()));
            component.setJdComponent((Component)this.jdoccurrencetxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdGdgAttributesUI jdgdgui = new JdGdgAttributesUI();
        JdGdgFile jde = new JdGdgFile();
        jdgdgui.show(jde);
        jf.getContentPane().add(jdgdgui);
        jf.setSize(300, 350);
        jf.setVisible(true);
        jdgdgui.update();
    }
}

