/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIAliasFile;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.model.JdAliasFile;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JdAliasAttributesUI
extends JPanel
implements JdIFormUI {
    JPanel parent = this;
    private JdIAliasFile jdElement;
    private JLabel jdddlbl;
    private JLabel jdpathlbl;
    private JTextField jdddtxt;
    private JTextField jdpathtxt;
    private JButton jdlistbtn;
    private JCheckBox jdverbosechk;
    private ButtonGroup jdbg;
    private File lastSelectedFile = null;

    public JdAliasAttributesUI() {
        JdFormLayout jdfl = new JdFormLayout(30, 30);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp1 = new JPanel();
        this.jdddlbl = new JLabel("DD Name");
        this.jdpathlbl = new JLabel("Alias Name");
        this.jdddtxt = new JTextField("", 25);
        this.jdpathtxt = new JTextField("", 25);
        this.jdlistbtn = new JButton("List");
        this.jdverbosechk = new JCheckBox("Verbose");
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser listChooser = new JdListChooser("Alias Name Chooser", "Select a Alias Name", JdMediator.getAliasNameList().toArray(), JdAliasAttributesUI.this.jdlistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdAliasAttributesUI.this.jdpathtxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(this.jdddlbl);
        this.add(this.jdddtxt);
        this.add(this.jdpathlbl);
        this.add(this.jdpathtxt);
        this.add(this.jdlistbtn);
        jp1.add(this.jdverbosechk);
        this.add(jp1);
        jp1.setOpaque(false);
        this.jdverbosechk.setOpaque(false);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIAliasFile)jdIElement;
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdddtxt.setText("");
        } else {
            this.jdddtxt.setText(str);
        }
        str = this.jdElement.getAliasName();
        if (str == null) {
            this.jdpathtxt.setText("");
        } else {
            this.jdpathtxt.setText(str);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbosechk.setSelected(verbose);
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setName(this.jdddtxt.getText());
        this.jdElement.setAliasName(this.jdpathtxt.getText());
        this.jdElement.setVerbose(this.jdverbosechk.isSelected());
    }

    public void reset() {
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdddtxt.setText("");
        } else {
            this.jdddtxt.setText(str);
        }
        str = this.jdElement.getAliasName();
        if (str == null) {
            this.jdpathtxt.setText("");
        } else {
            this.jdpathtxt.setText(str);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbosechk.setSelected(verbose);
    }

    public void setUpdate() {
        this.jdddtxt.setEnabled(true);
        this.jdpathtxt.setEnabled(true);
        this.jdlistbtn.setEnabled(true);
        this.jdverbosechk.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdddtxt.setEnabled(false);
        this.jdpathtxt.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
        this.jdverbosechk.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdddtxt.getText().length() == 0) {
            component.setJdReason(new String("The DD Name cannot be empty"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (this.jdddtxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The DD Name cannot contain space"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (JdMediator.getBrotherList().contains(this.jdddtxt.getText())) {
            component.setJdReason(new String("The DD Name already exists"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (this.jdpathtxt.getText().length() == 0) {
            component.setJdReason(new String("The Alias Name cannot be empty"));
            component.setJdLabel(new String(this.jdpathlbl.getText()));
            component.setJdComponent((Component)this.jdpathtxt);
            return false;
        }
        if (this.jdpathtxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Alias Name cannot contain space"));
            component.setJdLabel(new String(this.jdpathlbl.getText()));
            component.setJdComponent((Component)this.jdpathtxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdAliasAttributesUI jddui = new JdAliasAttributesUI();
        JdAliasFile jdp = new JdAliasFile();
        jddui.show(jdp);
        jf.getContentPane().add(jddui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jddui.update();
    }
}

