/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.model;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIProcElement;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import com.sun.emp.mbm.jedit.model.JdPgmStepElement;
import com.sun.emp.mbm.util.JdParameter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;

public class JdProcElement
implements JdIProcElement {
    static final long serialVersionUID = -830093350519506220L;
    private static final ObjectStreamField[] serialPersistentFields;
    private String jdAuthor = "";
    private boolean jdVerbose = false;
    private String jdDescription = "Enter Description";
    private String jdName = "New Procedure";
    private ArrayList jdListParameters = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$ArrayList;

    public JdProcElement() {
    }

    public JdProcElement(String proc_element) {
        this.jdName = proc_element;
    }

    public void setAuthor(String authorName) {
        this.jdAuthor = authorName;
    }

    public void setVerbose(boolean verboseMode) {
        this.jdVerbose = verboseMode;
    }

    public void setName(String elementName) {
        this.jdName = elementName;
    }

    public void setDescription(String text) {
        this.jdDescription = text;
    }

    public void restoreFrom(JdIElement jdElement) {
        JdProcElement jdProcElement = (JdProcElement)jdElement;
        this.jdAuthor = jdProcElement.jdAuthor;
        this.jdVerbose = jdProcElement.jdVerbose;
        this.jdDescription = jdProcElement.jdDescription;
        this.jdName = jdProcElement.jdName;
        ArrayList<JdParameter> parameterslistrestore = new ArrayList<JdParameter>();
        int i = 0;
        while (i < jdProcElement.jdListParameters.size()) {
            JdParameter jdparameterrestore1 = (JdParameter)jdProcElement.jdListParameters.get(i);
            try {
                JdParameter jdparameterrestore2 = (JdParameter)jdparameterrestore1.clone();
                parameterslistrestore.add(jdparameterrestore2);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            ++i;
        }
        this.jdListParameters = parameterslistrestore;
    }

    public void acceptVisitor(JdIVisitor visitor, JdIMutableTreeNode treeNodeOwner) {
        visitor.visitProc(this, treeNodeOwner);
    }

    public void setListParameters(ArrayList parameterList) {
        if (!parameterList.isEmpty()) {
            this.jdListParameters = parameterList;
        }
    }

    public String getAuthor() {
        return this.jdAuthor;
    }

    public boolean getVerbose() {
        return this.jdVerbose;
    }

    public String getDescription() {
        return this.jdDescription;
    }

    public String getName() {
        return this.jdName;
    }

    public String getToolTipText() {
        if (this.jdDescription.equals("Enter Description")) {
            return this.jdName;
        }
        if (this.jdDescription.length() > 72) {
            String jdAbridgedDesc = this.jdDescription.substring(0, 72) + "...";
            return jdAbridgedDesc;
        }
        return this.jdDescription;
    }

    public boolean canContain(JdIElement jdElement, JdIElement parentElement) {
        switch (jdElement.getElementType()) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean canInsert(int jType, int parentType) {
        switch (jType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean canExport() {
        return true;
    }

    public boolean canImport() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canModify() {
        return true;
    }

    public int getElementType() {
        return 3;
    }

    public ArrayList getListParameters() {
        return this.jdListParameters;
    }

    public Object clone() throws CloneNotSupportedException {
        JdProcElement jdproccopy = (JdProcElement)super.clone();
        ArrayList<JdParameter> parameterslistcopy = new ArrayList<JdParameter>();
        int i = 0;
        while (i < this.jdListParameters.size()) {
            JdParameter jdparameter1 = (JdParameter)this.jdListParameters.get(i);
            JdParameter jdparametercopy = (JdParameter)jdparameter1.clone();
            parameterslistcopy.add(jdparametercopy);
            ++i;
        }
        jdproccopy.jdListParameters = parameterslistcopy;
        return jdproccopy;
    }

    private void writeObject(ObjectOutputStream stream) {
        try {
            ObjectOutputStream.PutField fields = stream.putFields();
            fields.put("f_jdAuthor", this.jdAuthor);
            fields.put("f_jdVerbose", new Boolean(this.jdVerbose));
            fields.put("f_jdDescription", this.jdDescription);
            fields.put("f_jdName", this.jdName);
            fields.put("f_jdListParameters", this.jdListParameters);
            stream.writeFields();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            ObjectInputStream.GetField fields = stream.readFields();
            this.jdAuthor = (String)fields.get("f_jdAuthor", "");
            this.jdVerbose = (Boolean)fields.get("f_jdVerbose", new Boolean(false));
            this.jdDescription = (String)fields.get("f_jdDescription", "Enter Description");
            this.jdName = (String)fields.get("f_jdName", "New Procedure");
            this.jdListParameters = (ArrayList)fields.get("f_jdListParameters", new ArrayList());
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
    }

    public static void main(String[] av) {
        System.out.println("-------------------------------------------------");
        System.out.println("Test Constructors: ");
        System.out.println("-------------------------------------------------");
        JdProcElement jpe1 = new JdProcElement();
        JdProcElement jpe2 = new JdProcElement();
        JdProcElement jpe3 = new JdProcElement();
        JdProcElement jpe4 = new JdProcElement();
        JdProcElement jpe6 = new JdProcElement();
        System.out.println("Default Author Name is " + jpe1.getAuthor());
        System.out.println("Default Procedure Name is " + jpe1.getName());
        System.out.println("Default Procedure Description is " + jpe1.getDescription());
        System.out.println("Verbose is " + jpe1.getVerbose());
        System.out.println("Parameters are " + jpe1.getListParameters());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setAuthor ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setAuthor with author name: J. Doeproc");
        jpe2.setAuthor("J. Doeproc");
        System.out.println("getAuthor returned Proc Author name: " + jpe2.getAuthor());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setVerbose ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setVerbose with true");
        jpe1.setVerbose(true);
        System.out.println("getVerbose returned: " + jpe1.getVerbose());
        System.out.println("Invoking setVerbose with false");
        jpe2.setVerbose(false);
        System.out.println("getVerbose returned: " + jpe2.getVerbose());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setName ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setName with Proc name:PROC002");
        jpe2.setName("PROC002");
        System.out.println("getName returned Proc name: " + jpe2.getName());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText I");
        System.out.println("-------------------------------------------------");
        System.out.println("Returns the Proc Name from above if the Description is not set");
        System.out.println("getToolTipText returned: " + jpe2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setDescription (short)");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setDescription with: 'Major Mondo Procedure'");
        jpe2.setName("Major Modo Procedure");
        System.out.println("getDescription returned: " + jpe2.getName());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText II");
        System.out.println("-------------------------------------------------");
        System.out.println("Should return the Description Name from above if set");
        System.out.println("getToolTipText returned: " + jpe2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setDescription (long) for ToolTipTest III");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setDescription with a job description longer than 72 characters");
        jpe2.setDescription("This job description exceeds 72 characters.  The important feature to notice is that the following ToolTipText test turncates the description at 72 characters (just after the 'o' in 'notice').  The end of this description (after 72 characters) should be replaced by an ellipsis.  (...)");
        System.out.println("getDescription returned Job description: " + jpe2.getDescription());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText III");
        System.out.println("-------------------------------------------------");
        System.out.println("Should return the ABRIDGED Description from above");
        System.out.println("getToolTipText returned: " + jpe2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setListParameters ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setListParameters with list of parameters:");
        System.out.println(" ");
        ArrayList<JdParameter> parmlist = new ArrayList<JdParameter>();
        JdParameter parametera = new JdParameter("PARAM1", "AA", "1st parameter");
        JdParameter parameterb = new JdParameter("PARAM2", "BBB", "2nd parameter");
        JdParameter parameterc = new JdParameter("PARAM3", "CCCC", "3rd parameter");
        parmlist.add(parametera);
        parmlist.add(parameterb);
        parmlist.add(parameterc);
        jpe2.setListParameters(parmlist);
        System.out.println("getListParameters List of Parameters returned:");
        ArrayList printlistparameters = jpe2.getListParameters();
        int i = 0;
        while (i < printlistparameters.size()) {
            JdParameter printparameter = (JdParameter)printlistparameters.get(i);
            System.out.println("Key=" + printparameter.getKey() + " Value=" + printparameter.getValue() + " Description=" + printparameter.getDescription());
            ++i;
        }
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canContain ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoked canContain with VALID JdIElement JdPgmStepElement, it returned: " + jpe3.canContain(new JdPgmStepElement(), null));
        System.out.println("Invoked canContain with INVALID JdIElement JdJobElement, it returned: " + jpe3.canContain(new JdJobElement(), null));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canInsert ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoked canInsert with VALID type JD_STEP_PROC, it returned:  " + jpe3.canInsert(5, 2));
        System.out.println("Invoked canInsert with INVALID type JD_FOLDER, it returned:  " + jpe3.canInsert(1, 7));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test clone and restoreFrom");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        System.out.println("Creating jpe4");
        System.out.println(" with Verbose           = true");
        System.out.println(" with Description       = JPE4 Description");
        System.out.println(" with Name              = JPE4 Name");
        System.out.println(" with Author            = JPE4 Author");
        System.out.println(" with ParameterList     = key41, value41, desc41");
        System.out.println("                          key42, value42, desc42");
        System.out.println("                          key43, value43, desc43");
        System.out.println("     (and that is all)      ");
        jpe4.setVerbose(true);
        jpe4.setDescription("JPE4 Description");
        jpe4.setName("JPE4 Name");
        jpe4.setAuthor("JPE4 Author");
        ArrayList<JdParameter> cloneparmlist = new ArrayList<JdParameter>();
        JdParameter cloneparm1 = new JdParameter("key41", "value41", "desc41");
        JdParameter cloneparm2 = new JdParameter("key42", "value42", "desc42");
        JdParameter cloneparm3 = new JdParameter("key43", "value43", "desc43");
        cloneparmlist.add(cloneparm1);
        cloneparmlist.add(cloneparm2);
        cloneparmlist.add(cloneparm3);
        jpe4.setListParameters(cloneparmlist);
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Print the Original jpe4 Object");
        System.out.println(" ");
        System.out.println(" --- jpe4 original --- ");
        System.out.println(" ");
        Boolean org4Verbose = new Boolean(jpe4.getVerbose());
        String org4VerboseStr = org4Verbose.toString();
        System.out.println("Verbose           = " + org4VerboseStr);
        System.out.println("Description       = " + jpe4.getDescription());
        System.out.println("Name              = " + jpe4.getName());
        System.out.println("Author            = " + jpe4.getAuthor());
        ArrayList orgprint4listparameters = new ArrayList();
        JdParameter orgprint4parm = new JdParameter();
        orgprint4listparameters = jpe4.getListParameters();
        int i2 = 0;
        while (i2 < orgprint4listparameters.size()) {
            orgprint4parm = (JdParameter)orgprint4listparameters.get(i2);
            System.out.println("Key= " + orgprint4parm.getKey() + " Value= " + orgprint4parm.getValue() + " Desc= " + orgprint4parm.getDescription());
            ++i2;
        }
        System.out.println(" --- end jpe4 original --- ");
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Make the clone, jpe5, of the original, jpe4");
        System.out.println(" ");
        try {
            JdProcElement jpe5 = (JdProcElement)jpe4.clone();
            System.out.println("Print the CLONE -- it should be identical to original");
            System.out.println(" ");
            System.out.println(" --- jpe5 identical clone to jpe4 --- ");
            System.out.println(" ");
            Boolean tmp5aVerbose = new Boolean(jpe5.getVerbose());
            String tmp5aVerboseStr = tmp5aVerbose.toString();
            System.out.println("Verbose           = " + tmp5aVerboseStr);
            System.out.println("Description       = " + jpe5.getDescription());
            System.out.println("Name              = " + jpe5.getName());
            System.out.println("Author            = " + jpe5.getAuthor());
            ArrayList print5listparameters = new ArrayList();
            JdParameter print5parm = new JdParameter();
            print5listparameters = jpe5.getListParameters();
            int i3 = 0;
            while (i3 < print5listparameters.size()) {
                print5parm = (JdParameter)print5listparameters.get(i3);
                System.out.println("Key= " + print5parm.getKey() + " Value= " + print5parm.getValue() + " Desc= " + print5parm.getDescription());
                ++i3;
            }
            System.out.println(" --- end jpe5 identical clone to jpe4 --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Change the values of jpe5");
            System.out.println(" ");
            System.out.println("Changing jpe5");
            System.out.println(" with Verbose           = false");
            System.out.println(" with Description       = JPE5 Description");
            System.out.println(" with Name              = JPE5 Name");
            System.out.println(" with Author            = JPE5 Author");
            System.out.println(" with ParameterList     = key51,value51,desc51");
            System.out.println("                          key52,value52,desc52");
            System.out.println("                          key53,value53,desc53");
            System.out.println("     (and that is all)      ");
            jpe5.setVerbose(false);
            jpe5.setDescription("JPE5 Description");
            jpe5.setName("JPE5 Name");
            jpe5.setAuthor("JPE5 Author");
            ArrayList<JdParameter> newcloneparmlist = new ArrayList<JdParameter>();
            JdParameter cloneparm51 = new JdParameter("key51", "value51", "desc51");
            JdParameter cloneparm52 = new JdParameter("key52", "value52", "desc52");
            JdParameter cloneparm53 = new JdParameter("key53", "value53", "desc53");
            newcloneparmlist.add(cloneparm51);
            newcloneparmlist.add(cloneparm52);
            newcloneparmlist.add(cloneparm53);
            jpe5.setListParameters(newcloneparmlist);
            System.out.println(" ");
            System.out.println("Print the New Values of the clone, jpe5");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated CLONE -- it should have new values");
            System.out.println(" ");
            System.out.println(" --- jpe5 modified clone --- ");
            Boolean new5Verbose = new Boolean(jpe5.getVerbose());
            String new5VerboseStr = new5Verbose.toString();
            System.out.println("Verbose           = " + new5VerboseStr);
            System.out.println("Description       = " + jpe5.getDescription());
            System.out.println("Name              = " + jpe5.getName());
            System.out.println("Author            = " + jpe5.getAuthor());
            ArrayList newprint5listparameters = new ArrayList();
            JdParameter newprint5parm = new JdParameter();
            newprint5listparameters = jpe5.getListParameters();
            int i4 = 0;
            while (i4 < newprint5listparameters.size()) {
                newprint5parm = (JdParameter)newprint5listparameters.get(i4);
                System.out.println("Key= " + newprint5parm.getKey() + " Value= " + newprint5parm.getValue() + " Desc= " + newprint5parm.getDescription());
                ++i4;
            }
            System.out.println(" --- end jpe5 modified clone --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the Original -- it should be unchanged");
            System.out.println(" --- jpe4 original --- ");
            System.out.println(" ");
            Boolean tmp4Verbose = new Boolean(jpe4.getVerbose());
            String tmp4VerboseStr = tmp4Verbose.toString();
            System.out.println("Verbose           = " + tmp4VerboseStr);
            System.out.println("Description       = " + jpe4.getDescription());
            System.out.println("Name              = " + jpe4.getName());
            System.out.println("Author            = " + jpe4.getAuthor());
            ArrayList print4listparameters = new ArrayList();
            JdParameter print4parm = new JdParameter();
            print4listparameters = jpe4.getListParameters();
            int i5 = 0;
            while (i5 < print4listparameters.size()) {
                print4parm = (JdParameter)print4listparameters.get(i5);
                System.out.println("Key= " + print4parm.getKey() + " Value= " + print4parm.getValue() + " Desc= " + print4parm.getDescription());
                ++i5;
            }
            System.out.println(" --- end jpe4 original --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Restore jpe5 from jpe4 so they are identical again.");
            jpe5.restoreFrom(jpe4);
            System.out.println(" ");
            System.out.println("Print out restored jpe5 (should look like jpe4)");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated CLONE -- it should have old values");
            System.out.println(" ");
            System.out.println(" --- jpe5 modified clone --- ");
            Boolean res5Verbose = new Boolean(jpe5.getVerbose());
            String res5VerboseStr = res5Verbose.toString();
            System.out.println("Verbose           = " + res5VerboseStr);
            System.out.println("Description       = " + jpe5.getDescription());
            System.out.println("Name              = " + jpe5.getName());
            System.out.println("Author            = " + jpe5.getAuthor());
            ArrayList resprint5listparameters = new ArrayList();
            JdParameter resprint5parm = new JdParameter();
            resprint5listparameters = jpe5.getListParameters();
            int i6 = 0;
            while (i6 < resprint5listparameters.size()) {
                resprint5parm = (JdParameter)resprint5listparameters.get(i6);
                System.out.println("Key= " + resprint5parm.getKey() + " Value= " + resprint5parm.getValue() + " Desc= " + resprint5parm.getDescription());
                ++i6;
            }
            System.out.println(" --- end jpe5 restored --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Change the values of jpe5");
            System.out.println(" ");
            System.out.println("Changing jpe5");
            System.out.println(" with Verbose           = false");
            System.out.println(" with Description       = JPE5a Description");
            System.out.println(" with Name              = JPE5a Name");
            System.out.println(" with Author            = JPE5a Author");
            System.out.println(" with ParameterList     = key54,value54,desc54");
            System.out.println("                          key55,value55,desc55");
            System.out.println("                          key56,value56,desc56");
            System.out.println("     (and that is all)      ");
            jpe5.setVerbose(false);
            jpe5.setDescription("JPE5a Description");
            jpe5.setName("JPE5a Name");
            jpe5.setAuthor("JPE5a Author");
            ArrayList<JdParameter> newrestoreparmlist = new ArrayList<JdParameter>();
            JdParameter restoreparm54 = new JdParameter("key54", "value54", "desc54");
            JdParameter restoreparm55 = new JdParameter("key55", "value55", "desc55");
            JdParameter restoreparm56 = new JdParameter("key56", "value56", "desc56");
            newrestoreparmlist.add(restoreparm54);
            newrestoreparmlist.add(restoreparm55);
            newrestoreparmlist.add(restoreparm56);
            jpe5.setListParameters(newrestoreparmlist);
            System.out.println(" ");
            System.out.println("Print the New (mnodified) values of the (previously) restored object, jpe5");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated (restored) object -- it should have new values");
            System.out.println(" ");
            System.out.println(" --- jpe5 modified restored object --- ");
            Boolean new5aVerbose = new Boolean(jpe5.getVerbose());
            String new5aVerboseStr = new5aVerbose.toString();
            System.out.println("Verbose           = " + new5aVerboseStr);
            System.out.println("Description       = " + jpe5.getDescription());
            System.out.println("Name              = " + jpe5.getName());
            System.out.println("Author            = " + jpe5.getAuthor());
            ArrayList newrestoreprint5listparameters = new ArrayList();
            JdParameter newrestoreprint5parm = new JdParameter();
            newrestoreprint5listparameters = jpe5.getListParameters();
            int i7 = 0;
            while (i7 < newrestoreprint5listparameters.size()) {
                newrestoreprint5parm = (JdParameter)newrestoreprint5listparameters.get(i7);
                System.out.println("Key= " + newrestoreprint5parm.getKey() + " Value= " + newrestoreprint5parm.getValue() + " Desc= " + newrestoreprint5parm.getDescription());
                ++i7;
            }
            System.out.println(" --- end jpe5 modified clone --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the Original -- it should still be unchanged");
            System.out.println(" --- jpe4 original --- ");
            System.out.println(" ");
            Boolean tmp4RVerbose = new Boolean(jpe4.getVerbose());
            String tmp4RVerboseStr = tmp4Verbose.toString();
            System.out.println("Verbose           = " + tmp4VerboseStr);
            System.out.println("Description       = " + jpe4.getDescription());
            System.out.println("Name              = " + jpe4.getName());
            System.out.println("Author            = " + jpe4.getAuthor());
            ArrayList print4Rlistparameters = new ArrayList();
            JdParameter print4Rparm = new JdParameter();
            print4Rlistparameters = jpe4.getListParameters();
            int i8 = 0;
            while (i8 < print4Rlistparameters.size()) {
                print4Rparm = (JdParameter)print4Rlistparameters.get(i8);
                System.out.println("Key= " + print4Rparm.getKey() + " Value= " + print4Rparm.getValue() + " Desc= " + print4Rparm.getDescription());
                ++i8;
            }
            System.out.println(" --- end jpe4 original --- ");
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Error: " + e.toString());
        }
        System.out.println("End of clone and restore test ");
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test writeObject and readObject");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        System.out.println("Creating jpe6");
        System.out.println(" with Verbose           = true");
        System.out.println(" with Description       = JPE6 Description");
        System.out.println(" with Name              = JPE6 Name");
        System.out.println(" with Author            = JPE6 Author");
        System.out.println(" with ParameterList     = key1, value1, desc1");
        System.out.println("                          key2, value2, desc2");
        System.out.println("                          key3, value3, desc3");
        System.out.println("     (and that is all)      ");
        jpe6.setVerbose(true);
        jpe6.setDescription("JPE6 Description");
        jpe6.setName("JPE6 Name");
        jpe6.setAuthor("JPE6 Author");
        ArrayList<JdParameter> parm6list = new ArrayList<JdParameter>();
        JdParameter parm1 = new JdParameter("key1", "value1", "desc1");
        JdParameter parm2 = new JdParameter("key2", "value2", "desc2");
        JdParameter parm3 = new JdParameter("key3", "value3", "desc3");
        parm6list.add(parm1);
        parm6list.add(parm2);
        parm6list.add(parm3);
        jpe6.setListParameters(parm6list);
        System.out.println(" ");
        System.out.println("Write the Object");
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("JdProcElement.ser"));
            oos.writeObject(jpe6);
            System.out.println(" ");
            System.out.println("Read the Object");
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream("JdProcElement.ser"));
            try {
                JdProcElement ijpse = (JdProcElement)ois.readObject();
                System.out.println(" ");
                System.out.println("--Print the contents of the Object--");
                Boolean tmpVerbose = new Boolean(ijpse.getVerbose());
                String tmpVerboseStr = tmpVerbose.toString();
                System.out.println("Verbose           = " + tmpVerboseStr);
                System.out.println("Description       = " + ijpse.getDescription());
                System.out.println("Name              = " + ijpse.getName());
                System.out.println("Author            = " + ijpse.getAuthor());
                ArrayList print6listparameters = new ArrayList();
                JdParameter printparm = new JdParameter();
                print6listparameters = ijpse.getListParameters();
                int i9 = 0;
                while (i9 < print6listparameters.size()) {
                    printparm = (JdParameter)print6listparameters.get(i9);
                    System.out.println("Key= " + printparm.getKey() + " Value= " + printparm.getValue() + " Desc= " + printparm.getDescription());
                    ++i9;
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error: " + e.toString());
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
        }
        System.out.println("End of write/read test ");
        System.out.println(" ");
        System.out.println(" ");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serialVersionUID = -830093350519506220L;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("f_jdAuthor", class$java$lang$String == null ? (class$java$lang$String = JdProcElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdVerbose", class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdProcElement.class$("java.lang.Boolean")) : class$java$lang$Boolean), new ObjectStreamField("f_jdDescription", class$java$lang$String == null ? (class$java$lang$String = JdProcElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdName", class$java$lang$String == null ? (class$java$lang$String = JdProcElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdListParameters", class$java$util$ArrayList == null ? (class$java$util$ArrayList = JdProcElement.class$("java.util.ArrayList")) : class$java$util$ArrayList)};
    }
}

