/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.model;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIJobElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.jedit.model.JdPgmStepElement;
import com.sun.emp.mbm.jedit.model.JdProcFolderElement;
import com.sun.emp.mbm.util.JdDirectory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;

public class JdJobElement
implements JdIJobElement {
    static final long serialVersionUID = 8352722918406327392L;
    private static final ObjectStreamField[] serialPersistentFields;
    private String jdJobName = "New Job";
    private String jdPrinterClass = "A";
    private String jdRoutingName = "";
    private String jdAuthorName = "";
    private String jdJobDescription = "Enter Description";
    private ArrayList jdListProcDirs = new ArrayList();
    private ArrayList jdListPgmDirs = new ArrayList();
    private boolean jdVerbose = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$lang$Boolean;

    public JdJobElement() {
    }

    public JdJobElement(String job_element) {
        this.jdJobName = job_element;
    }

    public void setPrinterClass(String className) {
        this.jdPrinterClass = className;
    }

    public void setRouting(String routingName) {
        this.jdRoutingName = routingName;
    }

    public void setAuthor(String authorName) {
        this.jdAuthorName = authorName;
    }

    public void setListProcDirs(ArrayList directoryList) {
        if (!directoryList.isEmpty()) {
            this.jdListProcDirs = directoryList;
        }
    }

    public void setListPgmDirs(ArrayList directoryList) {
        if (!directoryList.isEmpty()) {
            this.jdListPgmDirs = directoryList;
        }
    }

    public void setVerbose(boolean verboseMode) {
        this.jdVerbose = verboseMode;
    }

    public void setName(String elementName) {
        this.jdJobName = elementName;
    }

    public void setDescription(String text) {
        this.jdJobDescription = text;
    }

    public void restoreFrom(JdIElement jdElement) {
        JdJobElement jdjobelement = (JdJobElement)jdElement;
        this.jdJobName = jdjobelement.jdJobName;
        this.jdPrinterClass = jdjobelement.jdPrinterClass;
        this.jdRoutingName = jdjobelement.jdRoutingName;
        this.jdAuthorName = jdjobelement.jdAuthorName;
        this.jdJobDescription = jdjobelement.jdJobDescription;
        this.jdVerbose = jdjobelement.jdVerbose;
        ArrayList<JdDirectory> jdlistprocdirs = new ArrayList<JdDirectory>();
        int i = 0;
        while (i < jdjobelement.jdListProcDirs.size()) {
            JdDirectory jddirectory1 = (JdDirectory)jdjobelement.jdListProcDirs.get(i);
            try {
                JdDirectory jddirectory2 = (JdDirectory)jddirectory1.clone();
                jdlistprocdirs.add(jddirectory2);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            ++i;
        }
        this.jdListProcDirs = jdlistprocdirs;
        ArrayList<JdDirectory> jdlistpgmdirs = new ArrayList<JdDirectory>();
        int i2 = 0;
        while (i2 < jdjobelement.jdListPgmDirs.size()) {
            JdDirectory jddirectory1 = (JdDirectory)jdjobelement.jdListPgmDirs.get(i2);
            try {
                JdDirectory jddirectory2 = (JdDirectory)jddirectory1.clone();
                jdlistpgmdirs.add(jddirectory2);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            ++i2;
        }
        this.jdListPgmDirs = jdlistpgmdirs;
    }

    public void acceptVisitor(JdIVisitor visitor, JdIMutableTreeNode treeNodeOwner) {
        visitor.visitJob(this, treeNodeOwner);
    }

    public String getPrinterClass() {
        return this.jdPrinterClass;
    }

    public String getRouting() {
        return this.jdRoutingName;
    }

    public String getAuthor() {
        return this.jdAuthorName;
    }

    public ArrayList getListProcDirs() {
        return this.jdListProcDirs;
    }

    public ArrayList getListPgmDirs() {
        return this.jdListPgmDirs;
    }

    public boolean getVerbose() {
        return this.jdVerbose;
    }

    public String getDescription() {
        return this.jdJobDescription;
    }

    public String getName() {
        return this.jdJobName;
    }

    public String getToolTipText() {
        if (this.jdJobDescription.equals("Enter Description")) {
            return this.jdJobName;
        }
        if (this.jdJobDescription.length() > 72) {
            String jdAbridgedDesc = this.jdJobDescription.substring(0, 72) + "...";
            return jdAbridgedDesc;
        }
        return this.jdJobDescription;
    }

    public boolean canContain(JdIElement jdElement, JdIElement parentElement) {
        switch (jdElement.getElementType()) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean canInsert(int jType, int parentType) {
        switch (jType) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean canExport() {
        return true;
    }

    public boolean canImport() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canModify() {
        return true;
    }

    public int getElementType() {
        return 2;
    }

    public Object clone() throws CloneNotSupportedException {
        JdJobElement jdjobcopy = (JdJobElement)super.clone();
        ArrayList<JdDirectory> proclistcopy = new ArrayList<JdDirectory>();
        int i = 0;
        while (i < this.jdListProcDirs.size()) {
            JdDirectory jdprocdirectory = (JdDirectory)this.jdListProcDirs.get(i);
            JdDirectory jdprocdircopy = (JdDirectory)jdprocdirectory.clone();
            proclistcopy.add(jdprocdircopy);
            ++i;
        }
        jdjobcopy.jdListProcDirs = proclistcopy;
        ArrayList<JdDirectory> pgmlistcopy = new ArrayList<JdDirectory>();
        int i2 = 0;
        while (i2 < this.jdListPgmDirs.size()) {
            JdDirectory jdpgmdirectory = (JdDirectory)this.jdListPgmDirs.get(i2);
            JdDirectory jdpgmdircopy = (JdDirectory)jdpgmdirectory.clone();
            pgmlistcopy.add(jdpgmdircopy);
            ++i2;
        }
        jdjobcopy.jdListPgmDirs = pgmlistcopy;
        return jdjobcopy;
    }

    private void writeObject(ObjectOutputStream stream) {
        try {
            ObjectOutputStream.PutField fields = stream.putFields();
            fields.put("f_jdJobName", this.jdJobName);
            fields.put("f_jdPrinterClass", this.jdPrinterClass);
            fields.put("f_jdRoutingName", this.jdRoutingName);
            fields.put("f_jdAuthorName", this.jdAuthorName);
            fields.put("f_jdJobDescription", this.jdJobDescription);
            fields.put("f_jdListProcDirs", this.jdListProcDirs);
            fields.put("f_jdListPgmDirs", this.jdListPgmDirs);
            fields.put("f_jdVerbose", new Boolean(this.jdVerbose));
            stream.writeFields();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            ObjectInputStream.GetField fields = stream.readFields();
            this.jdJobName = (String)fields.get("f_jdJobName", "New Job");
            this.jdPrinterClass = (String)fields.get("f_jdPrinterClass", "A");
            this.jdRoutingName = (String)fields.get("f_jdRoutingName", "");
            this.jdAuthorName = (String)fields.get("f_jdAuthorName", "");
            this.jdJobDescription = (String)fields.get("f_jdJobDescription", "Enter Description");
            this.jdListProcDirs = (ArrayList)fields.get("f_jdListProcDirs", this.jdListProcDirs);
            this.jdListPgmDirs = (ArrayList)fields.get("f_jdListPgmDirs", this.jdListPgmDirs);
            this.jdVerbose = (Boolean)fields.get("f_jdVerbose", new Boolean(false));
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
    }

    public static void main(String[] av) {
        JdJobElement jje1 = new JdJobElement();
        JdJobElement jje4 = new JdJobElement();
        JdJobElement jje6 = new JdJobElement();
        System.out.println("-------------------------------------------------");
        System.out.println("Test Constructors: ");
        System.out.println("-------------------------------------------------");
        System.out.println("Default Printer Class is: " + jje1.getPrinterClass());
        System.out.println("Default Routing Name is: " + jje1.getRouting());
        System.out.println("Default Author Name is: " + jje1.getAuthor());
        System.out.println("Default Job Description is: " + jje1.getDescription());
        System.out.println("Verbose is: " + jje1.getVerbose());
        System.out.println("Pgm Dirs is: " + jje1.getListPgmDirs());
        System.out.println("Proc Dirs is: " + jje1.getListProcDirs());
        System.out.println("-------------------------------------------------");
        System.out.println("Test setPrinterClass ");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        JdJobElement jje2 = new JdJobElement();
        System.out.println("Invoking setPrinterClass with class:  Z");
        jje2.setPrinterClass("Z");
        System.out.println("getPrinterClass returned Job Printer Class: " + jje2.getPrinterClass());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setRouting ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setRouting with routing name: N. Machiavelli");
        jje2.setRouting("N. Machiavelli");
        System.out.println("getRouting returned Job Routing name: " + jje2.getRouting());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setAuthor ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setAuthor with author name: J. Doe");
        jje2.setAuthor("J. Doe");
        System.out.println("setAuthor returned Job Author name: " + jje2.getAuthor());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setListProcDirs ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setListProcDirs with list of directories:\n/test/proc1dir\n/test/proc2dir\n/test/proc3dir");
        System.out.println(" ");
        ArrayList<JdDirectory> proclist = new ArrayList<JdDirectory>();
        JdDirectory jdprocdir1 = new JdDirectory("/test/proc1dir");
        proclist.add(jdprocdir1);
        JdDirectory jdprocdir2 = new JdDirectory("/test/proc2dir");
        proclist.add(jdprocdir2);
        JdDirectory jdprocdir3 = new JdDirectory("/test/proc3dir");
        proclist.add(jdprocdir3);
        jje2.setListProcDirs(proclist);
        System.out.println("getListProcDirs List of Job Procedure Libraries returned:");
        ArrayList printlistprocdirs2 = new ArrayList();
        JdDirectory testprocdir = new JdDirectory();
        printlistprocdirs2 = jje2.getListProcDirs();
        System.out.println("Size of the ArrayList:" + printlistprocdirs2.size());
        int i = 0;
        while (i < printlistprocdirs2.size()) {
            testprocdir = (JdDirectory)printlistprocdirs2.get(i);
            System.out.println(testprocdir.getPathname());
            ++i;
        }
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setListPgmDirs ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setListPgmDirs with list of directories:\n/test/pgm1dir\n/test/pgm2dir\n/test/pgm3dir");
        System.out.println(" ");
        ArrayList<JdDirectory> pgmlist = new ArrayList<JdDirectory>();
        JdDirectory jdpgmdir1 = new JdDirectory("/test/pgm1dir");
        pgmlist.add(jdpgmdir1);
        JdDirectory jdpgmdir2 = new JdDirectory("/test/pgm2dir");
        pgmlist.add(jdpgmdir2);
        JdDirectory jdpgmdir3 = new JdDirectory("/test/pgm3dir");
        pgmlist.add(jdpgmdir3);
        jje2.setListPgmDirs(pgmlist);
        System.out.println("getListPgmDirs List of Job Program Libraries returned:");
        ArrayList printlistpgmdirs2 = new ArrayList();
        JdDirectory testpgmdir = new JdDirectory();
        printlistpgmdirs2 = jje2.getListPgmDirs();
        System.out.println("Size of the ArrayList:" + printlistpgmdirs2.size());
        int i2 = 0;
        while (i2 < printlistpgmdirs2.size()) {
            testpgmdir = (JdDirectory)printlistpgmdirs2.get(i2);
            System.out.println(testpgmdir.getPathname());
            ++i2;
        }
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setVerbose ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setVerbose with true");
        jje1.setVerbose(true);
        System.out.println("getVerbose returned: " + jje1.getVerbose());
        System.out.println("Invoking setVerbose with false");
        jje2.setVerbose(false);
        System.out.println("getVerbose returned: " + jje2.getVerbose());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setName ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setName with job name: JOBXXXX");
        jje2.setName("JOBXXXX");
        System.out.println("getName returned Job name: " + jje2.getName());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText I");
        System.out.println("-------------------------------------------------");
        System.out.println("Returns the Job Name from above if the Description is not set");
        System.out.println("getToolTipText returned: " + jje2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setDescription  (short)");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setDescription with job description: This job runs the monthly payroll");
        jje2.setDescription("This job runs the monthly payroll");
        System.out.println("getDescription returned Job description: " + jje2.getDescription());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText II");
        System.out.println("-------------------------------------------------");
        System.out.println("Should return the Description from above if set");
        System.out.println("getToolTipText returned: " + jje2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setDescription (long) for ToolTipTest III");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setDescription with a job description longer than 72 characters.");
        jje2.setDescription("This job description exceeds 72 characters.  The important feature to notice is that the following ToolTipText test turncates the description at 72 characters (just after the 'o' in 'notice').  The end of this description (after 72 characters) should be replaced by an ellipsis.  (...)");
        System.out.println("getDescription returned Job description: " + jje2.getDescription());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText III");
        System.out.println("-------------------------------------------------");
        System.out.println("Should return the ABRIDGED Description from above");
        System.out.println("getToolTipText returned: " + jje2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canInsert ");
        System.out.println("-------------------------------------------------");
        JdJobElement jje3 = new JdJobElement();
        System.out.println("Invoked canInsert with VALID type JD_STEP_PGM, it returned:  " + jje3.canInsert(4, 2));
        System.out.println("Invoked canInsert with INVALID type JD_PROCEDURE, it returned:  " + jje3.canInsert(3, 2));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canContain ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoked canContain with VALID JdIElement JdPgmStepElement, it returned: " + jje3.canContain(new JdPgmStepElement(), null));
        System.out.println(" ");
        System.out.println("Invoked canContain with INVALID JdIElement JdProcFolderElement, it returned: " + jje3.canContain(new JdProcFolderElement(), null));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test clone and restoreFrom");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        System.out.println("Creating jje4");
        System.out.println(" with Verbose      = true");
        System.out.println(" with Description  = JJE4 Description");
        System.out.println(" with Name         = JJE4 Name");
        System.out.println(" with RoutingName  = JJE4 RoutingName");
        System.out.println(" with AuthorName   = JJE4 AuthorName");
        System.out.println(" with PrinterClass = JJE4 PrinterClass");
        System.out.println(" with ProcDirList  = JJE4/proc1/dir");
        System.out.println("                     JJE4/proc2/dir");
        System.out.println("                     JJE4/proc3/dir");
        System.out.println(" with PgmDirList   = JJE4/pgm1/dir");
        System.out.println("                     JJE4/pgm2/dir");
        System.out.println("                     JJE4/pgm3/dir");
        System.out.println("     (and that is all)      ");
        jje4.setVerbose(true);
        jje4.setDescription("JJE4 Description");
        jje4.setName("JJE4 Name");
        jje4.setRouting("JJE4 RoutingName");
        jje4.setAuthor("JJE4 AuthorName");
        jje4.setPrinterClass("JJE4 PrinterClass");
        ArrayList<JdDirectory> cloneprocdirlist = new ArrayList<JdDirectory>();
        cloneprocdirlist.add(new JdDirectory("/JJE4/proc1/dir"));
        cloneprocdirlist.add(new JdDirectory("/JJE4/proc2/dir"));
        cloneprocdirlist.add(new JdDirectory("/JJE4/proc3/dir"));
        jje4.setListProcDirs(cloneprocdirlist);
        ArrayList<JdDirectory> clonepgmdirlist = new ArrayList<JdDirectory>();
        clonepgmdirlist.add(new JdDirectory("/JJE4/pgm1/dir"));
        clonepgmdirlist.add(new JdDirectory("/JJE4/pgm2/dir"));
        clonepgmdirlist.add(new JdDirectory("/JJE4/pgm3/dir"));
        jje4.setListPgmDirs(clonepgmdirlist);
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Print the Original jje4 Object");
        System.out.println(" ");
        System.out.println(" --- jje4 original --- ");
        System.out.println(" ");
        Boolean org4Verbose = new Boolean(jje4.getVerbose());
        String org4VerboseStr = org4Verbose.toString();
        System.out.println("Verbose      = " + org4VerboseStr);
        System.out.println("Descrtiption = " + jje4.getDescription());
        System.out.println("Name         = " + jje4.getName());
        System.out.println("RoutingName  = " + jje4.getRouting());
        System.out.println("AuthorName   = " + jje4.getAuthor());
        System.out.println("PrinterClass = " + jje4.getPrinterClass());
        ArrayList orgprint4procdirlist = new ArrayList();
        JdDirectory orgproc4dir = new JdDirectory();
        orgprint4procdirlist = jje4.getListProcDirs();
        int i3 = 0;
        while (i3 < orgprint4procdirlist.size()) {
            orgproc4dir = (JdDirectory)orgprint4procdirlist.get(i3);
            System.out.println("ProcDir" + i3 + "     = " + orgproc4dir.getPathname());
            ++i3;
        }
        ArrayList orgprint4pgmdirlist = new ArrayList();
        JdDirectory orgpgm4dir = new JdDirectory();
        orgprint4pgmdirlist = jje4.getListPgmDirs();
        int i4 = 0;
        while (i4 < orgprint4pgmdirlist.size()) {
            orgpgm4dir = (JdDirectory)orgprint4pgmdirlist.get(i4);
            System.out.println("PgmDir" + i4 + "      = " + orgpgm4dir.getPathname());
            ++i4;
        }
        System.out.println(" --- end jje4 original --- ");
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Make the clone, jje5, of the original, jje4");
        System.out.println(" ");
        try {
            JdJobElement jje5 = (JdJobElement)jje4.clone();
            System.out.println("Print the CLONE -- it should be identical to original");
            System.out.println(" ");
            System.out.println(" --- jje5 identical clone to jje4 --- ");
            System.out.println(" ");
            Boolean tmp5aVerbose = new Boolean(jje5.getVerbose());
            String tmp5aVerboseStr = tmp5aVerbose.toString();
            System.out.println("Verbose      = " + tmp5aVerboseStr);
            System.out.println("Descrtiption = " + jje5.getDescription());
            System.out.println("Name         = " + jje5.getName());
            System.out.println("RoutingName  = " + jje5.getRouting());
            System.out.println("AuthorName   = " + jje5.getAuthor());
            System.out.println("PrinterClass = " + jje5.getPrinterClass());
            ArrayList print5procdirlist = new ArrayList();
            JdDirectory print5procdir = new JdDirectory();
            print5procdirlist = jje5.getListProcDirs();
            int i5 = 0;
            while (i5 < print5procdirlist.size()) {
                print5procdir = (JdDirectory)print5procdirlist.get(i5);
                System.out.println("ProcDir" + i5 + "     = " + print5procdir.getPathname());
                ++i5;
            }
            ArrayList print5pgmdirlist = new ArrayList();
            JdDirectory print5pgmdir = new JdDirectory();
            print5pgmdirlist = jje5.getListPgmDirs();
            int i6 = 0;
            while (i6 < print5pgmdirlist.size()) {
                print5pgmdir = (JdDirectory)print5pgmdirlist.get(i6);
                System.out.println("PgmDir" + i6 + "      = " + print5pgmdir.getPathname());
                ++i6;
            }
            System.out.println(" --- end jje5 identical clone to jje4 --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Change the values of jje5");
            System.out.println(" ");
            System.out.println("Changing jje5");
            System.out.println(" with Verbose       = false");
            System.out.println(" with Description   = JJE5 Description");
            System.out.println(" with Name          = JJE5 Name");
            System.out.println(" with RoutingName   = JJE5 RoutingName");
            System.out.println(" with AuthorName    = JJE5 AuthorName ");
            System.out.println(" with PrinterClass  = JJE5 PrinterClass");
            System.out.println(" with ProcDirList   = JJE5/proc1/dir");
            System.out.println("                      JJE5/proc2/dir");
            System.out.println("                      JJE5/proc3/dir");
            System.out.println(" with PgmDirList    = JJE5/pgm1/dir");
            System.out.println("                      JJE5/pgm2/dir");
            System.out.println("                      JJE5/pgm3/dir");
            System.out.println("     (and that is all)      ");
            jje5.setVerbose(false);
            jje5.setDescription("JJE5 Description");
            jje5.setName("JJE5 Name");
            jje5.setRouting("JJE5 RoutingName");
            jje5.setAuthor("JJE5 AuthorName");
            jje5.setPrinterClass("JJE5 PrinterClass");
            ArrayList<JdDirectory> newcloneprocdirlist = new ArrayList<JdDirectory>();
            newcloneprocdirlist.add(new JdDirectory("/JJE5/proc1/dir"));
            newcloneprocdirlist.add(new JdDirectory("/JJE5/proc2/dir"));
            newcloneprocdirlist.add(new JdDirectory("/JJE5/proc3/dir"));
            jje5.setListProcDirs(newcloneprocdirlist);
            ArrayList<JdDirectory> newclonepgmdirlist = new ArrayList<JdDirectory>();
            newclonepgmdirlist.add(new JdDirectory("/JJE5/pgm1/dir"));
            newclonepgmdirlist.add(new JdDirectory("/JJE5/pgm2/dir"));
            newclonepgmdirlist.add(new JdDirectory("/JJE5/pgm3/dir"));
            jje5.setListPgmDirs(newclonepgmdirlist);
            System.out.println(" ");
            System.out.println("Print the New Values of the clone, jje5");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated CLONE -- it should have new values");
            System.out.println(" ");
            System.out.println(" --- jje5 restored clone --- ");
            Boolean new5Verbose = new Boolean(jje5.getVerbose());
            String new5VerboseStr = new5Verbose.toString();
            System.out.println("Verbose      = " + new5VerboseStr);
            System.out.println("Descrtiption = " + jje5.getDescription());
            System.out.println("Name         = " + jje5.getName());
            System.out.println("RoutingName  = " + jje5.getRouting());
            System.out.println("AuthorName   = " + jje5.getAuthor());
            System.out.println("PrinterClass = " + jje5.getPrinterClass());
            ArrayList newprint5procdirlist = new ArrayList();
            JdDirectory newprint5procdir = new JdDirectory();
            newprint5procdirlist = jje5.getListProcDirs();
            int i7 = 0;
            while (i7 < newprint5procdirlist.size()) {
                newprint5procdir = (JdDirectory)newprint5procdirlist.get(i7);
                System.out.println("ProcDir" + i7 + "     = " + newprint5procdir.getPathname());
                ++i7;
            }
            ArrayList newprint5pgmdirlist = new ArrayList();
            JdDirectory newprint5pgmdir = new JdDirectory();
            newprint5pgmdirlist = jje5.getListPgmDirs();
            int i8 = 0;
            while (i8 < newprint5pgmdirlist.size()) {
                newprint5pgmdir = (JdDirectory)newprint5pgmdirlist.get(i8);
                System.out.println("PgmDir" + i8 + "      = " + newprint5pgmdir.getPathname());
                ++i8;
            }
            System.out.println(" --- end jje5 modified clone --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the Original -- it should be unchanged");
            System.out.println(" --- jje4 original --- ");
            System.out.println(" ");
            Boolean tmp4Verbose = new Boolean(jje4.getVerbose());
            String tmp4VerboseStr = tmp4Verbose.toString();
            System.out.println("Verbose      = " + tmp4VerboseStr);
            System.out.println("Descrtiption = " + jje4.getDescription());
            System.out.println("Name         = " + jje4.getName());
            System.out.println("RoutingName  = " + jje4.getRouting());
            System.out.println("AuthorName   = " + jje4.getAuthor());
            System.out.println("PrinterClass = " + jje4.getPrinterClass());
            ArrayList print4procdirlist = new ArrayList();
            JdDirectory print4procdir = new JdDirectory();
            print4procdirlist = jje4.getListProcDirs();
            int i9 = 0;
            while (i9 < print4procdirlist.size()) {
                print4procdir = (JdDirectory)print4procdirlist.get(i9);
                System.out.println("ProcDir" + i9 + "     = " + print4procdir.getPathname());
                ++i9;
            }
            ArrayList print4pgmdirlist = new ArrayList();
            JdDirectory print4pgmdir = new JdDirectory();
            print4pgmdirlist = jje4.getListPgmDirs();
            int i10 = 0;
            while (i10 < print4pgmdirlist.size()) {
                print4pgmdir = (JdDirectory)print4pgmdirlist.get(i10);
                System.out.println("PgmDir" + i10 + "      = " + print4pgmdir.getPathname());
                ++i10;
            }
            System.out.println(" --- end jje4 original --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Restore jje5 from jje4 so they are identical again.");
            jje5.restoreFrom(jje4);
            System.out.println(" ");
            System.out.println("Print out restored jje5 (should look like jje4)");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated CLONE -- it should have old values");
            System.out.println(" ");
            System.out.println(" --- jje5 modified clone --- ");
            Boolean res5Verbose = new Boolean(jje5.getVerbose());
            String res5VerboseStr = res5Verbose.toString();
            System.out.println("Verbose      = " + res5VerboseStr);
            System.out.println("Descrtiption = " + jje5.getDescription());
            System.out.println("Name         = " + jje5.getName());
            System.out.println("RoutingName  = " + jje5.getRouting());
            System.out.println("AuthorName   = " + jje5.getAuthor());
            System.out.println("PrinterClass = " + jje5.getPrinterClass());
            ArrayList resprint5procdirlist = new ArrayList();
            JdDirectory resprint5procdir = new JdDirectory();
            resprint5procdirlist = jje5.getListProcDirs();
            int i11 = 0;
            while (i11 < resprint5procdirlist.size()) {
                resprint5procdir = (JdDirectory)resprint5procdirlist.get(i11);
                System.out.println("ProcDir" + i11 + "     = " + resprint5procdir.getPathname());
                ++i11;
            }
            ArrayList resprint5pgmdirlist = new ArrayList();
            JdDirectory resprint5pgmcdir = new JdDirectory();
            resprint5pgmdirlist = jje5.getListPgmDirs();
            int i12 = 0;
            while (i12 < resprint5pgmdirlist.size()) {
                resprint5pgmcdir = (JdDirectory)resprint5pgmdirlist.get(i12);
                System.out.println("PgmDir" + i12 + "      = " + resprint5pgmcdir.getPathname());
                ++i12;
            }
            System.out.println(" --- end jje5 restored --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Change the values of jje5");
            System.out.println(" ");
            System.out.println("Changing jje5");
            System.out.println(" with Verbose       = false");
            System.out.println(" with Description   = JJE5a Description");
            System.out.println(" with Name          = JJE5a Name");
            System.out.println(" with RoutingName   = JJE5a RoutingName");
            System.out.println(" with AuthorName    = JJE5a AuthorName");
            System.out.println(" with PrinterClass  = JJE5a PrinterClass");
            System.out.println(" with ProcDirList   = JJE5a/proc1/dir");
            System.out.println("                      JJE5a/proc2/dir");
            System.out.println("                      JJE5a/proc3/dir");
            System.out.println(" with PgmDirList    = JJE5a/pgm1/dir");
            System.out.println("                      JJE5a/pgm2/dir");
            System.out.println("                      JJE5a/pgm3/dir");
            System.out.println("     (and that is all)      ");
            jje5.setVerbose(false);
            jje5.setDescription("JJE5a Description");
            jje5.setName("JJE5a Name");
            jje5.setRouting("JJE5a RoutingName");
            jje5.setAuthor("JJE5a AuthorName");
            jje5.setPrinterClass("JJE5a PrinterClass");
            ArrayList<JdDirectory> newrestoreprocdirlist = new ArrayList<JdDirectory>();
            newrestoreprocdirlist.add(new JdDirectory("/JJE5a/proc1/dir"));
            newrestoreprocdirlist.add(new JdDirectory("/JJE5a/proc2/dir"));
            newrestoreprocdirlist.add(new JdDirectory("/JJE5a/proc3/dir"));
            jje5.setListProcDirs(newrestoreprocdirlist);
            ArrayList<JdDirectory> newrestorepgmdirlist = new ArrayList<JdDirectory>();
            newrestorepgmdirlist.add(new JdDirectory("/JJE5a/pgm1/dir"));
            newrestorepgmdirlist.add(new JdDirectory("/JJE5a/pgm2/dir"));
            newrestorepgmdirlist.add(new JdDirectory("/JJE5a/pgm3/dir"));
            jje5.setListPgmDirs(newrestorepgmdirlist);
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated (restored) object -- it should have new values");
            System.out.println(" ");
            System.out.println(" --- jje5 modified restored object --- ");
            Boolean new5aVerbose = new Boolean(jje5.getVerbose());
            String new5aVerboseStr = new5aVerbose.toString();
            System.out.println("Verbose      = " + new5aVerboseStr);
            System.out.println("Descrtiption = " + jje5.getDescription());
            System.out.println("Name         = " + jje5.getName());
            System.out.println("RoutingName  = " + jje5.getRouting());
            System.out.println("AuthorName   = " + jje5.getAuthor());
            System.out.println("PrinterClass = " + jje5.getPrinterClass());
            ArrayList newrestoreprint5procdirlist = new ArrayList();
            JdDirectory newrestoreprint5procdir = new JdDirectory();
            newrestoreprint5procdirlist = jje5.getListProcDirs();
            int i13 = 0;
            while (i13 < newrestoreprint5procdirlist.size()) {
                newrestoreprint5procdir = (JdDirectory)newrestoreprint5procdirlist.get(i13);
                System.out.println("ProcDir" + i13 + "     = " + newrestoreprint5procdir.getPathname());
                ++i13;
            }
            ArrayList newrestoreprint5pgmdirlist = new ArrayList();
            JdDirectory newrestoreprint5pgmdir = new JdDirectory();
            newrestoreprint5pgmdirlist = jje5.getListPgmDirs();
            int i14 = 0;
            while (i14 < newrestoreprint5pgmdirlist.size()) {
                newrestoreprint5pgmdir = (JdDirectory)newrestoreprint5pgmdirlist.get(i14);
                System.out.println("PgmDir" + i14 + "      = " + newrestoreprint5pgmdir.getPathname());
                ++i14;
            }
            System.out.println(" --- end jje5 modified clone --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the Original -- it should still be unchanged");
            System.out.println(" --- jje4 original --- ");
            System.out.println(" ");
            Boolean tmp4RVerbose = new Boolean(jje4.getVerbose());
            String tmp4RVerboseStr = tmp4Verbose.toString();
            System.out.println("Verbose      = " + tmp4VerboseStr);
            System.out.println("Descrtiption = " + jje4.getDescription());
            System.out.println("Name         = " + jje4.getName());
            System.out.println("RoutingName  = " + jje4.getRouting());
            System.out.println("AuthorName   = " + jje4.getAuthor());
            System.out.println("PrinterClass = " + jje4.getPrinterClass());
            ArrayList print4Rprocdirlist = new ArrayList();
            JdDirectory print4procRdir = new JdDirectory();
            print4Rprocdirlist = jje4.getListProcDirs();
            int i15 = 0;
            while (i15 < print4Rprocdirlist.size()) {
                print4procRdir = (JdDirectory)print4Rprocdirlist.get(i15);
                System.out.println("ProcDir" + i15 + "     = " + print4procRdir.getPathname());
                ++i15;
            }
            ArrayList print4Rpgmdirlist = new ArrayList();
            JdDirectory print4pgmRdir = new JdDirectory();
            print4Rpgmdirlist = jje4.getListPgmDirs();
            int i16 = 0;
            while (i16 < print4Rpgmdirlist.size()) {
                print4pgmRdir = (JdDirectory)print4Rpgmdirlist.get(i16);
                System.out.println("PgmDir" + i16 + "      = " + print4pgmRdir.getPathname());
                ++i16;
            }
            System.out.println(" --- end jje4 original --- ");
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Error: " + e.toString());
        }
        System.out.println("End of clone and restore test ");
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test writeObject and readObject");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        System.out.println("Creating jje6");
        System.out.println(" with Verbose       = true");
        System.out.println(" with Description   = JJE6 Description");
        System.out.println(" with Name          = JJE6 Name");
        System.out.println(" with RoutingName   = JJE6 RoutingName");
        System.out.println(" with AuthorName    = JJE6 AuthorName");
        System.out.println(" with PrinterClass  = JJE6 PrinterClass");
        System.out.println(" with ProcDirList   = JJE6/proc1/dir");
        System.out.println("                      JJE6/proc2/dir");
        System.out.println("                      JJE6/proc3/dir");
        System.out.println(" with PgmDirList    = JJE6/pgm1/dir");
        System.out.println("                      JJE6/pgm2/dir");
        System.out.println("                      JJE6/pgm3/dir");
        System.out.println("     (and that is all)      ");
        jje6.setVerbose(true);
        jje6.setDescription("JJE6 Description");
        jje6.setName("JJE6 Name");
        jje6.setRouting("JJE6 RoutingName");
        jje6.setAuthor("JJE6 AuthorName");
        jje6.setPrinterClass("JJE6 PrinterClass");
        ArrayList<JdDirectory> procdirlist = new ArrayList<JdDirectory>();
        procdirlist.add(new JdDirectory("/JJE6/proc1/dir"));
        procdirlist.add(new JdDirectory("/JJE6/proc2/dir"));
        procdirlist.add(new JdDirectory("/JJE6/proc3/dir"));
        jje6.setListProcDirs(procdirlist);
        ArrayList<JdDirectory> pgmdirlist = new ArrayList<JdDirectory>();
        pgmdirlist.add(new JdDirectory("/JJE6/pgm1/dir"));
        pgmdirlist.add(new JdDirectory("/JJE6/pgm2/dir"));
        pgmdirlist.add(new JdDirectory("/JJE6/pgm3/dir"));
        jje6.setListPgmDirs(pgmdirlist);
        System.out.println(" ");
        System.out.println("Write the Object");
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("JdJobElement.ser"));
            oos.writeObject(jje6);
            System.out.println(" ");
            System.out.println("Read the Object");
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream("JdJobElement.ser"));
            try {
                JdJobElement ijpse = (JdJobElement)ois.readObject();
                System.out.println(" ");
                System.out.println("--Print the contents of the Object--");
                Boolean tmpVerbose = new Boolean(ijpse.getVerbose());
                String tmpVerboseStr = tmpVerbose.toString();
                System.out.println("Verbose      = " + tmpVerboseStr);
                System.out.println("Descrtiption = " + ijpse.getDescription());
                System.out.println("Name         = " + ijpse.getName());
                System.out.println("RoutingName  = " + ijpse.getRouting());
                System.out.println("AuthorName   = " + ijpse.getAuthor());
                System.out.println("PrinterClass = " + ijpse.getPrinterClass());
                ArrayList printprocdirlist = new ArrayList();
                JdDirectory printprocdir = new JdDirectory();
                printprocdirlist = ijpse.getListProcDirs();
                int i17 = 0;
                while (i17 < printprocdirlist.size()) {
                    printprocdir = (JdDirectory)printprocdirlist.get(i17);
                    System.out.println("ProcDir" + i17 + "     = " + printprocdir.getPathname());
                    ++i17;
                }
                ArrayList printpgmdirlist = new ArrayList();
                JdDirectory printpgmdir = new JdDirectory();
                printpgmdirlist = ijpse.getListPgmDirs();
                int i18 = 0;
                while (i18 < printpgmdirlist.size()) {
                    printpgmdir = (JdDirectory)printpgmdirlist.get(i18);
                    System.out.println("PgmDir" + i18 + "      = " + printpgmdir.getPathname());
                    ++i18;
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error: " + e.toString());
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
        }
        System.out.println("End of write/read test ");
        System.out.println(" ");
        System.out.println(" ");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serialVersionUID = 8352722918406327392L;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("f_jdJobName", class$java$lang$String == null ? (class$java$lang$String = JdJobElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdPrinterClass", class$java$lang$String == null ? (class$java$lang$String = JdJobElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdRoutingName", class$java$lang$String == null ? (class$java$lang$String = JdJobElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdAuthorName", class$java$lang$String == null ? (class$java$lang$String = JdJobElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdJobDescription", class$java$lang$String == null ? (class$java$lang$String = JdJobElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdListProcDirs", class$java$util$ArrayList == null ? (class$java$util$ArrayList = JdJobElement.class$("java.util.ArrayList")) : class$java$util$ArrayList), new ObjectStreamField("f_jdListPgmDirs", class$java$util$ArrayList == null ? (class$java$util$ArrayList = JdJobElement.class$("java.util.ArrayList")) : class$java$util$ArrayList), new ObjectStreamField("f_jdVerbose", class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdJobElement.class$("java.lang.Boolean")) : class$java$lang$Boolean)};
    }
}

