/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.model;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIInputFile;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class JdInputFile
implements JdIInputFile {
    static final long serialVersionUID = -635879519927284321L;
    private static final ObjectStreamField[] serialPersistentFields;
    private boolean jdVerbose = false;
    private String jdName = "New Input File";
    private String jdInputData = "";
    private String jdDescription = "Enter Description";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public JdInputFile() {
    }

    public JdInputFile(String elementname) {
        this.jdName = elementname;
    }

    public void setInputData(String data) {
        this.jdInputData = data;
    }

    public void setVerbose(boolean verboseMode) {
        this.jdVerbose = verboseMode;
    }

    public void setName(String elementName) {
        this.jdName = elementName;
    }

    public void setDescription(String text) {
        this.jdDescription = text;
    }

    public void restoreFrom(JdIElement jdElement) {
        JdInputFile ljdInputFile = (JdInputFile)jdElement;
        this.jdName = ljdInputFile.jdName;
        this.jdInputData = ljdInputFile.jdInputData;
        this.jdDescription = ljdInputFile.jdDescription;
        this.jdVerbose = ljdInputFile.jdVerbose;
    }

    public void acceptVisitor(JdIVisitor visitor, JdIMutableTreeNode treeNodeOwner) {
        visitor.visitInputFile(this, treeNodeOwner);
    }

    public String getInputData() {
        return this.jdInputData;
    }

    public String getToolTipText() {
        if (this.jdInputData.length() > 72) {
            String jdAbridgedData = this.jdInputData.substring(0, 72) + "...";
            return "Input: " + jdAbridgedData;
        }
        return "Input: " + this.jdInputData;
    }

    public boolean getVerbose() {
        return this.jdVerbose;
    }

    public String getDescription() {
        return this.jdDescription;
    }

    public String getName() {
        return this.jdName;
    }

    public boolean canContain(JdIElement jdElement, JdIElement parentElement) {
        return false;
    }

    public boolean canInsert(int jType, int parentType) {
        if (parentType == 9) {
            switch (jType) {
                case 7: 
                case 10: 
                case 12: {
                    return true;
                }
            }
            return false;
        }
        switch (jType) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean canExport() {
        return false;
    }

    public boolean canImport() {
        return false;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canModify() {
        return true;
    }

    public int getElementType() {
        return 10;
    }

    public Object clone() throws CloneNotSupportedException {
        JdInputFile c = (JdInputFile)super.clone();
        return c;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        try {
            ObjectOutputStream.PutField fields = stream.putFields();
            fields.put("f_jdVerbose", new Boolean(this.jdVerbose));
            fields.put("f_jdName", this.jdName);
            fields.put("f_jdInputData", this.jdInputData);
            fields.put("f_jdDescription", this.jdDescription);
            stream.writeFields();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            ObjectInputStream.GetField fields = stream.readFields();
            this.jdVerbose = (Boolean)fields.get("f_jdVerbose", new Boolean(false));
            this.jdName = (String)fields.get("f_jdName", "New Input File");
            this.jdInputData = (String)fields.get("f_jdInputData", "");
            this.jdDescription = (String)fields.get("f_jdDescription", "Enter Description");
        }
        catch (ClassNotFoundException e) {
            System.err.println(e.toString());
        }
    }

    public static void main(String[] av) {
        System.out.println("-------------------------------------------------");
        System.out.println("Test Constructors: ");
        System.out.println("-------------------------------------------------");
        JdInputFile jif1 = new JdInputFile();
        JdInputFile jif2 = new JdInputFile();
        JdInputFile jif3 = new JdInputFile();
        JdInputFile jif4 = new JdInputFile();
        JdInputFile jif6 = new JdInputFile();
        System.out.println("Default File Name is " + jif1.getName());
        System.out.println("Default InputData is " + jif1.getInputData());
        System.out.println("Default File Description is " + jif1.getDescription());
        System.out.println("Verbose is " + jif1.getVerbose());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setInputData (short)");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setInputData with string: Death to Tyrants!");
        jif2.setInputData("Death to Tyrants!");
        System.out.println("getInputData returned InputData: " + jif2.getInputData());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText");
        System.out.println("-------------------------------------------------");
        System.out.println("Returns the Input Data from above preceded by 'Input: '");
        System.out.println("getTooTipText returned: " + jif2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setInputData (long)");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setInputData with string: Death to Tyrants!");
        jif2.setInputData("This string is way too long for a tooltip. This string is truncated here. This part of the string doesn't show in the tool tip.");
        System.out.println("getInputData returned InputData: " + jif2.getInputData());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText II");
        System.out.println("-------------------------------------------------");
        System.out.println("Returns the Input Data from above preceded by 'Input: ', but truncated to 72 characters plus an ellipsis (...).");
        System.out.println("getTooTipText returned: " + jif2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setVerbose ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setVerbose with true");
        jif1.setVerbose(true);
        System.out.println("getVerbose returned: " + jif1.getVerbose());
        System.out.println("Invoking setVerbose with false");
        jif2.setVerbose(false);
        System.out.println("getVerbose returned: " + jif2.getVerbose());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canContain ");
        System.out.println("-------------------------------------------------");
        System.out.println("This function ALWAYS returns false");
        System.out.println(" ");
        System.out.println("Invoked canContain with INVALID JdIElement JdJobElement, it returned: " + jif3.canContain(new JdJobElement(), null));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canInsert ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoked canInsert with VALID type JD_VSAM, it returned:  " + jif3.canInsert(8, 8));
        System.out.println("Invoked canInsert with INVALID type JD_FOLDER, it returned:  " + jif3.canInsert(1, 8));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test clone and restoreFrom");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        System.out.println("Creating jif4");
        System.out.println(" with Verbose           = true");
        System.out.println(" with Description       = JIF4 Description");
        System.out.println(" with Name              = JIF4 Name");
        System.out.println(" with InputData         = JIF4 InputData");
        System.out.println("     (and that is all)      ");
        jif4.setVerbose(true);
        jif4.setDescription("JIF4 Description");
        jif4.setName("JIF4 Name");
        jif4.setInputData("JIF4 InputData");
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Print the Original jif4 Object");
        System.out.println(" ");
        System.out.println(" --- jif4 original --- ");
        System.out.println(" ");
        Boolean org4Verbose = new Boolean(jif4.getVerbose());
        String org4VerboseStr = org4Verbose.toString();
        System.out.println("Verbose           = " + org4VerboseStr);
        System.out.println("Description       = " + jif4.getDescription());
        System.out.println("Name              = " + jif4.getName());
        System.out.println("InputData         = " + jif4.getInputData());
        System.out.println(" --- end jif4 original --- ");
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Make the clone, jif5, of the original, jif4");
        System.out.println(" ");
        try {
            JdInputFile jif5 = (JdInputFile)jif4.clone();
            System.out.println("Print the CLONE -- it should be identical to original");
            System.out.println(" ");
            System.out.println(" --- jif5 identical clone to jif4 --- ");
            System.out.println(" ");
            Boolean tmp5aVerbose = new Boolean(jif5.getVerbose());
            String tmp5aVerboseStr = tmp5aVerbose.toString();
            System.out.println("Verbose           = " + tmp5aVerboseStr);
            System.out.println("Description       = " + jif5.getDescription());
            System.out.println("Name              = " + jif5.getName());
            System.out.println("InputData         = " + jif5.getInputData());
            System.out.println(" --- end jif5 identical clone to jif4 --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Change the values of jif5");
            System.out.println(" ");
            System.out.println("Changing jif5");
            System.out.println(" with Verbose           = false");
            System.out.println(" with Description       = JIF5 Description");
            System.out.println(" with Name              = JIF5 Name");
            System.out.println(" with InputData         = JIF5 InputData");
            System.out.println("     (and that is all)      ");
            jif5.setVerbose(false);
            jif5.setDescription("JIF5 Description");
            jif5.setName("JIF5 Name");
            jif5.setInputData("JIF5 InputData");
            System.out.println(" ");
            System.out.println("Print the New Values of the clone, jif5");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated CLONE -- it should have new values");
            System.out.println(" ");
            System.out.println(" --- jif5 modified clone --- ");
            Boolean new5Verbose = new Boolean(jif5.getVerbose());
            String new5VerboseStr = new5Verbose.toString();
            System.out.println("Verbose           = " + new5VerboseStr);
            System.out.println("Description       = " + jif5.getDescription());
            System.out.println("Name              = " + jif5.getName());
            System.out.println("InputData         = " + jif5.getInputData());
            System.out.println(" --- end jif5 modified clone --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the Original -- it should be unchanged");
            System.out.println(" --- jif4 original --- ");
            System.out.println(" ");
            Boolean tmp4Verbose = new Boolean(jif4.getVerbose());
            String tmp4VerboseStr = tmp4Verbose.toString();
            System.out.println("Verbose           = " + tmp4VerboseStr);
            System.out.println("Description       = " + jif4.getDescription());
            System.out.println("Name              = " + jif4.getName());
            System.out.println("InputData         = " + jif4.getInputData());
            System.out.println(" --- end jif4 original --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Restore jif5 from jif4 so they are identical again.");
            jif5.restoreFrom(jif4);
            System.out.println(" ");
            System.out.println("Print out restored jif5 (should look like jif4)");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated CLONE -- it should have old values");
            System.out.println(" ");
            System.out.println(" --- jif5 modified clone --- ");
            Boolean res5Verbose = new Boolean(jif5.getVerbose());
            String res5VerboseStr = res5Verbose.toString();
            System.out.println("Verbose           = " + res5VerboseStr);
            System.out.println("Description       = " + jif5.getDescription());
            System.out.println("Name              = " + jif5.getName());
            System.out.println("InputData         = " + jif5.getInputData());
            System.out.println(" --- end jif5 restored --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Change the values of jif5");
            System.out.println(" ");
            System.out.println("Changing jif5");
            System.out.println(" with Verbose           = false");
            System.out.println(" with Description       = JIF5a Description");
            System.out.println(" with Name              = JIF5a Name");
            System.out.println(" with InputData         = JIF5a InputData");
            System.out.println("     (and that is all)      ");
            jif5.setVerbose(false);
            jif5.setDescription("JIF5a Description");
            jif5.setName("JIF5a Name");
            jif5.setInputData("JIF5a InputData");
            System.out.println(" ");
            System.out.println("Print the New (mnodified) values of the (previously) restored object, jif5");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the updated (restored) object -- it should have new values");
            System.out.println(" ");
            System.out.println(" --- jif5 modified restored object --- ");
            Boolean new5aVerbose = new Boolean(jif5.getVerbose());
            String new5aVerboseStr = new5aVerbose.toString();
            System.out.println("Verbose           = " + new5aVerboseStr);
            System.out.println("Description       = " + jif5.getDescription());
            System.out.println("Name              = " + jif5.getName());
            System.out.println("InputData         = " + jif5.getInputData());
            System.out.println(" --- end jif5 modified clone --- ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print the Original -- it should still be unchanged");
            System.out.println(" --- jif4 original --- ");
            System.out.println(" ");
            Boolean tmp4RVerbose = new Boolean(jif4.getVerbose());
            String tmp4RVerboseStr = tmp4Verbose.toString();
            System.out.println("Verbose           = " + tmp4VerboseStr);
            System.out.println("Description       = " + jif4.getDescription());
            System.out.println("Name              = " + jif4.getName());
            System.out.println("InputData         = " + jif4.getInputData());
            System.out.println(" --- end jif4 original --- ");
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Error: " + e.toString());
        }
        System.out.println("End of clone and restore test ");
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test writeObject and readObject");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        System.out.println("Creating jif6");
        System.out.println(" with Verbose           = true");
        System.out.println(" with Description       = JIF6 Description");
        System.out.println(" with Name              = JIF6 Name");
        System.out.println(" with InputData         = JIF6 InputData");
        System.out.println("     (and that is all)      ");
        jif6.setVerbose(true);
        jif6.setDescription("JIF6 Description");
        jif6.setName("JIF6 Name");
        jif6.setInputData("JIF6 InputData");
        System.out.println(" ");
        System.out.println("Write the Object");
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("JdInputFile.ser"));
            oos.writeObject(jif6);
            System.out.println(" ");
            System.out.println("Read the Object");
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream("JdInputFile.ser"));
            try {
                JdInputFile ijpse = (JdInputFile)ois.readObject();
                System.out.println(" ");
                System.out.println("--Print the contents of the Object--");
                Boolean tmpVerbose = new Boolean(ijpse.getVerbose());
                String tmpVerboseStr = tmpVerbose.toString();
                System.out.println("Verbose           = " + tmpVerboseStr);
                System.out.println("Description       = " + ijpse.getDescription());
                System.out.println("Name              = " + ijpse.getName());
                System.out.println("InputData         = " + ijpse.getInputData());
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error: " + e.toString());
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.toString());
        }
        System.out.println("End of write/read test ");
        System.out.println(" ");
        System.out.println(" ");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serialVersionUID = -635879519927284321L;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("f_jdVerbose", class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdInputFile.class$("java.lang.Boolean")) : class$java$lang$Boolean), new ObjectStreamField("f_jdName", class$java$lang$String == null ? (class$java$lang$String = JdInputFile.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdInputData", class$java$lang$String == null ? (class$java$lang$String = JdInputFile.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdDescription", class$java$lang$String == null ? (class$java$lang$String = JdInputFile.class$("java.lang.String")) : class$java$lang$String)};
    }
}

