/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.controller;

import com.sun.emp.mbm.jedit.controller.JdCommentParser;
import com.sun.emp.mbm.jedit.controller.JdLexicalAnalizer;
import com.sun.emp.mbm.jedit.controller.JdWarnParser;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.model.JdConcatenatedFile;
import com.sun.emp.mbm.jedit.model.JdInputFile;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.util.Log;
import java.util.logging.Level;

public class JdInputParser {
    private JdLexicalAnalizer _jdla = null;
    private JdIMutableTreeNode _jdTreeNode = null;
    private JdIMutableTreeNode _jtn = null;
    private int _token = 0;
    private String _tokVal = null;
    private JdInputFile _jdInput = null;
    private String _tokName = null;

    JdInputParser(JdLexicalAnalizer jdla, JdIMutableTreeNode treeNode) {
        this._jdla = jdla;
        this._jdTreeNode = treeNode;
        this._jdInput = new JdInputFile();
        this._jtn = new JdMutableTreeNode(this._jdInput);
    }

    public void parse() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"parse");
        boolean read_input = false;
        String data_string = null;
        if (this._jdTreeNode.getJdIElement() instanceof JdConcatenatedFile) {
            int childCount = ((JdMutableTreeNode)this._jdTreeNode).getChildCount();
            this._jdInput.setName(new String("CONCAT" + childCount));
        }
        block9: while (this._jdla.nextToken() != -1) {
            this._token = this._jdla.getToken();
            this._jdla.setStEOL(read_input);
            switch (this._token) {
                case 22: {
                    this._jdInput.setName(this._jdla.tokenValue());
                    break;
                }
                case 50: {
                    read_input = true;
                    this._jdla.setInstreamTokenizer();
                    break;
                }
                case 51: {
                    read_input = false;
                    this._jdla.setJclTokenizer();
                    this._jdInput.setInputData(data_string);
                    break;
                }
                case 17: {
                    int childnum = ((JdMutableTreeNode)this._jdTreeNode).getChildCount();
                    this._jdTreeNode.insertJdNode(this._jtn, childnum);
                    Log.exit((Level)Level.INFO, (Object)this, (String)"parse-1");
                    return;
                }
                case 9: {
                    JdCommentParser jdcp = new JdCommentParser(this._jdla, this._jtn);
                    jdcp.parse();
                    this._jdInput.setDescription(jdcp.getComment());
                    break;
                }
                case 10: {
                    if (!read_input) continue block9;
                    if (data_string == null) {
                        data_string = "\n";
                        break;
                    }
                    data_string = data_string + " \n";
                    break;
                }
                case 0: {
                    JdWarnParser jdwp = new JdWarnParser(this._jdla, this._jtn);
                    jdwp.parse();
                    break;
                }
                default: {
                    if (read_input) {
                        if (this._jdla.tokenValue() == null) continue block9;
                        if (data_string == null) {
                            data_string = this._jdla.tokenValue();
                            break;
                        }
                        data_string = data_string + " " + this._jdla.tokenValue();
                        break;
                    }
                    Log.buildMessage((Object)this, (String)("parse:" + read_input), (String)"Invalid token", (String)"W00002", (Object)"Invalid token");
                }
            }
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"parse-2");
    }

    public static void main(String[] av) {
        System.exit(0);
    }
}

