/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.command;

import com.sun.emp.mbm.jedit.command.ImportDialog;
import com.sun.emp.mbm.jedit.command.JdCommand;
import com.sun.emp.mbm.jedit.command.JdInvalidRedoException;
import com.sun.emp.mbm.jedit.controller.JdLexicalAnalizer;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIProjectElement;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JdImportCommand
extends JdCommand {
    private static final String _commandName = "import";
    private String _fileMap = null;
    private Properties _envProperties = null;
    JdIMutableTreeNode _jdTreeNode = null;
    JdIMutableTreeNode _newNode = null;

    public void doIt() {
        JdIMutableTreeNode l_jdTreeNode;
        Log.entry((Level)Level.INFO, (Object)this, (String)"doIt");
        String fmString = JdCommand._jdMediator.getFileMap();
        if (fmString == null) {
            Log.displayMessage((Object)this, (String)"doIt", (String)"Warning", (String)"E00009", (Object)"You must select a FileMap before you can import a JCL File.");
            Log.exit((Level)Level.INFO, (Object)this, (String)"doIt");
            return;
        }
        File l_fm = new File(fmString);
        if (!l_fm.exists() || l_fm.isDirectory()) {
            Log.displayMessage((Object)this, (String)"doIt", (String)"Warning", (String)"E00009", (Object)"You must select a FileMap before you can import a JCL File.");
            Log.exit((Level)Level.INFO, (Object)this, (String)"doIt");
            return;
        }
        this._fileMap = fmString;
        this._jdTreeNode = l_jdTreeNode = JdCommand._jdMediator.getSelectedNode();
        while (l_jdTreeNode.getJdIElement().getElementType() != 0) {
            l_jdTreeNode = l_jdTreeNode.getJdParent();
        }
        while (this._jdTreeNode.getJdIElement().getElementType() != 1) {
            this._jdTreeNode = this._jdTreeNode.getJdParent();
        }
        JdIProjectElement projectElement = (JdIProjectElement)l_jdTreeNode.getJdIElement();
        String exportPath = null;
        exportPath = this._jdTreeNode.toString().equals("procs") ? projectElement.getDirectoryPathname().getPathname() + File.separator + projectElement.getName() + File.separatorChar + "mvsp" + File.separator + "mvsfile" : projectElement.getDirectoryPathname().getPathname() + File.separator + projectElement.getName() + File.separatorChar + "jmvs" + File.separator + "mvsfile";
        JFileChooser chooser = new JFileChooser(exportPath);
        File selFile = new File(exportPath);
        chooser.setSelectedFile(selFile);
        chooser.setDialogTitle(new String("Please select the JCL file to Import:"));
        int option = chooser.showDialog(null, "Select");
        if (option == 0) {
            exportPath = chooser.getSelectedFile().getAbsolutePath();
            this.doMvstrans(exportPath);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"doIt");
    }

    public void undoIt() {
        throw new JdInvalidRedoException();
    }

    public void redoIt() {
        throw new JdInvalidRedoException();
    }

    public String canUndo() {
        return null;
    }

    public String canRedo() {
        return null;
    }

    public String getCommandName() {
        return new String("import ...");
    }

    private void doMvstrans(String jclFullPath) {
        try {
            Runtime rt = Runtime.getRuntime();
            String[] cmd = new String[3];
            String[] envp = null;
            cmd[0] = "mvstrans";
            int lastslash = jclFullPath.lastIndexOf(File.separatorChar);
            if (lastslash == -1) {
                return;
            }
            int jobProcSlash = jclFullPath.lastIndexOf(File.separatorChar, lastslash - 1);
            if (jobProcSlash == -1) {
                return;
            }
            String jclPath = jclFullPath.substring(0, jobProcSlash);
            String jobOrProc = jclFullPath.substring(jobProcSlash + 1, lastslash);
            String jclFile = jclFullPath.substring(lastslash + 1);
            if (!this.checkNodeName(jclFile)) {
                return;
            }
            cmd[1] = jclFile;
            cmd[2] = jobOrProc.equalsIgnoreCase("mvsp") ? "-fjp" : "-fj";
            File dirp = new File(jclPath);
            envp = this.getEnv();
            Process proc = rt.exec(cmd, envp, dirp);
            StreamProc errorGobbler = new StreamProc(proc.getErrorStream(), "MVSTRANS ERROR");
            JCLProc outputGobbler = new JCLProc(proc.getInputStream(), jclFile, this._jdTreeNode);
            errorGobbler.start();
            outputGobbler.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String[] getEnv() {
        try {
            Runtime rt = Runtime.getRuntime();
            String[] cmd = new String[3];
            String os = System.getProperty("os.name");
            if (os != null && os.startsWith("Windows")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/c";
                cmd[2] = "set";
            } else {
                cmd[0] = "ksh";
                cmd[1] = "-c";
                cmd[2] = "env";
            }
            Process proc = rt.exec(cmd);
            StreamProc errorGobbler = new StreamProc(proc.getErrorStream(), "ERROR");
            EnvProc outputGobbler = new EnvProc(proc.getInputStream(), "ENV");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            outputGobbler.join();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this._envProperties.setProperty("FILEMAP", this._fileMap);
        int propcount = this._envProperties.size();
        String[] env = new String[propcount];
        Enumeration<?> enprop = this._envProperties.propertyNames();
        int index = 0;
        String key = null;
        while (enprop.hasMoreElements()) {
            key = (String)enprop.nextElement();
            env[index++] = key + "=" + this._envProperties.getProperty(key);
        }
        return env;
    }

    private boolean checkNodeName(String name) {
        JdMutableTreeNode currentNode = null;
        boolean nodeExists = false;
        boolean replaceNode = true;
        if (this._jdTreeNode.getJdIElement().getElementType() == 1) {
            Enumeration enumeration = this._jdTreeNode.getAllChildren();
            while (enumeration.hasMoreElements() && !nodeExists) {
                currentNode = (JdMutableTreeNode)enumeration.nextElement();
                if (!currentNode.toString().equals(name)) continue;
                nodeExists = true;
            }
            if (nodeExists) {
                replaceNode = this.existsDialog(name);
                if (replaceNode) {
                    JdCommand._jdMediator.removeNodeFrom(this._jdTreeNode, currentNode);
                }
                return replaceNode;
            }
        }
        return true;
    }

    private boolean existsDialog(String name) {
        int yesno = -9;
        JOptionPane optionpane = new JOptionPane();
        String jdmessage = null;
        Object[] options = new Object[]{"Yes", "No"};
        jdmessage = "Job " + name + " already exists,\nDo you wish to replace it with this one?\n";
        yesno = JOptionPane.showConfirmDialog(null, jdmessage, "Job Editor - Confirm JCL replacement", 0);
        if (yesno == 0) {
            return true;
        }
        return yesno != 1;
    }

    static {
        _commandName = _commandName;
    }

    class JCLProc
    extends Thread {
        InputStream is;
        String type;
        JdIMutableTreeNode treeNode;

        JCLProc(InputStream is, String type, JdIMutableTreeNode jdtn) {
            this.is = is;
            this.type = type;
            this.treeNode = jdtn;
        }

        public void run() {
            ImportDialog importDialog = new ImportDialog(this.type);
            importDialog.show();
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            Object line = null;
            JdLexicalAnalizer jsp = new JdLexicalAnalizer(br, this.type, this.treeNode, JdCommand._jdMediator);
            JdImportCommand.this._newNode = jsp.parse();
            if (JdImportCommand.this._newNode != null) {
                JdCommand._jdMediator.setEndNew();
                JdCommand._jdMediator.setEndUpdate();
                JdCommand._jdMediator.selectedNode(JdImportCommand.this._newNode);
                JdCommand._jdMediator.treeExpanded(JdImportCommand.this._newNode);
                JdCommand._jdMediator.selectedNode(this.treeNode);
                JdCommand._jdMediator.reset();
                JdCommand._jdMediator.selectedNode(JdImportCommand.this._newNode);
            }
            importDialog.hide();
            Log.displayBuildMessage();
        }
    }

    class EnvProc
    extends Thread {
        InputStream is;
        String type;

        EnvProc(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    StringTokenizer strtok = new StringTokenizer(line, "=");
                    if (strtok.countTokens() != 2) continue;
                    String key = strtok.nextToken();
                    String value = strtok.nextToken();
                    if (JdImportCommand.this._envProperties == null) {
                        JdImportCommand.this._envProperties = new Properties();
                    }
                    JdImportCommand.this._envProperties.setProperty(key, value);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            JdImportCommand.this._envProperties.setProperty("SYSTEM_OUTPUT", "JCL");
        }
    }

    class StreamProc
    extends Thread {
        InputStream is;
        String type;

        StreamProc(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void run() {
            boolean mvserr = false;
            String mvserrors = null;
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                if (this.type.equals("MVSTRANS ERROR")) {
                    mvserr = true;
                }
                while ((line = br.readLine()) != null) {
                    if (!mvserr || line.indexOf("(E)") == -1 && line.indexOf("(S)") == -1) continue;
                    mvserrors = mvserrors == null ? "\n" + line : mvserrors + "\n" + line;
                }
                if (mvserrors != null) {
                    Log.displayMessage((Object)this, (String)"doMvstrans", (String)"{0}", null, mvserrors);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

