#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)rg_view.pl	1.21	03/02/26 SMI"
#
# View resource groups

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Rg;
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Common;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a rg object
my $rg = new Cluster::Rg;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Set views
my $rg_view = "/cgi-bin/rg/rg_view.pl",
my $rg_topological_view = "/cgi-bin/rg/rg_view.pl\?view=topological",

# Get the optional parameters
my $rg_name = $q->param("rg");
my $mode = $q->param("mode");
my $view = $q->param("view");

# Set the page title
my $title = gettext("Resource Groups");

# Print the query header and make the page expire now
print $q->header(-expires => "now");

my $yoke_jscript;
if (defined($rg_name)) {
    $yoke_jscript = $q->yoke_jscript("rg-$rg_name");
} else {
    $yoke_jscript = $q->yoke_jscript("rg");
}

if (!(defined $view && $view eq "topological")) {
    $yoke_jscript .= $q->refresh_jscript('content',
	'ESC_cluster_rg_,ESC_cluster_r_');
}

# Start the document
print $q->start_html({ TITLE => gettext("View Resource Group"),
		       STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       CLASS  => "default-body",
                       ONUNLOAD => $q->unregister_jscript(),
		       SCRIPT => $q->jump_menu_jscript() . $yoke_jscript
		       });

# Check for resource read authorization
if (!$rbac->check_auth($CL_AUTH_RESOURCE_READ)) {
	$rbac->auth_error($q, $title);
	exit;
}

# Print the rg table for a single rg
if (defined $rg_name) {

	# Print the help marker
	print $q->start_script();
        print "top.helpMarker=\"rg_view-single\"";
        print $q->end_script();

	# Start the action bar table
	$q->start_action_bar_table([$title, $rg_view,
	    $rg_name]);

	# Print the middle of the action table
	$q->mid_action_bar_table();

	# Load the help markers
	my @helpMarkers = $rg->rg_action_helpMarkers();
	$q->load_action_helpMarkers(\@helpMarkers);

	# Get the common get of links for rg pages
	my @links = $rg->rg_action_links("rg", $rg_name);

	# Print if the user has resource.admin or resource.modify
	if ($rbac->check_auth($CL_AUTH_RESOURCE_MODIFY) ||
	    $rbac->check_auth($CL_AUTH_RESOURCE_ADMIN)) {
		$q->actions_menu(gettext("Actions Menu"), \@links);
	}

	# End the action bar table
	$q->end_action_bar_table();

	# Print the table of resources in the group
	$rg->rg_resources_table($q, $rg_name);

	# Print the resource group status table
	$rg->resource_group_status_table($q, $rg_name);

	# Print the resource group properties table
	$rg->resource_group_properties_table($q, $rg_name);

} elsif (defined $view && $view eq "topological") {

	# Print the help marker
	print $q->start_script();
        print "top.helpMarker=\"rg_view-topo\"";
        print $q->end_script();

	# Start the action bar table
	$q->start_action_bar_table($title);

	# Create the view menu links
	my @viewlinks = (gettext("Resource Group Status Table"),
			 $rg_view,
			 gettext("Resource Group Topology"),
			 $rg_topological_view
			 );

	# Print the view menu
	$q->view_menu(\@viewlinks, $rg_topological_view);

	# Print the middle of the action table
	$q->mid_action_bar_table();

	# Load the help markers
	my @helpMarkers = $rg->rg_action_helpMarkers();
	$q->load_action_helpMarkers(\@helpMarkers);

	# Get the common get of links for rg pages
	my @links = $rg->rg_action_links();

	# Print if the user has resource.admin or resource.modify
	if ($rbac->check_auth($CL_AUTH_RESOURCE_MODIFY) ||
	    $rbac->check_auth($CL_AUTH_RESOURCE_ADMIN)) {
		$q->actions_menu(gettext("Actions Menu"), \@links);
	}

	# End the action bar table
	$q->end_action_bar_table();

	# Print the applet
	print $q->applet({ name => 'viewApplet',
			   codebase => '/',
			   code => 'View.class',
			   height => 500,
			   width => 700
			   });

	my $cName = $rg->get_clustername();
	my $nName = $rg->get_hostname();
	print $q->Param({ name => 'cName', value => $cName });
	print $q->end_Param();
	print $q->Param({ name => 'nName', value => $nName });
	print $q->end_Param();
	print $q->Param({ name => 'mode', value => 2 });
	print $q->end_Param();
	print $q->end_applet();

} else {

	# Print the help marker
	print $q->start_script();
        print "top.helpMarker=\"rg_view-table\"";
        print $q->end_script();

	# Start the action bar table
	$q->start_action_bar_table($title);

	# Create the view menu links if we don't have too many rgs
	if (($rg->get_clustersize() <= 4) && 
	    ($rg->get_num_rgs() <= 4)) {
		my @viewlinks = (gettext("Resource Group Status Table"),
				 $rg_view,
				 gettext("Resource Group Topology"),
				 $rg_topological_view,
				 );
		$q->view_menu(\@viewlinks, $rg_view);
	}

	# Print the middle of the action table
	$q->mid_action_bar_table();

	# Load the help markers
	my @helpMarkers = $rg->rg_action_helpMarkers();
	$q->load_action_helpMarkers(\@helpMarkers);

	# Create the actions menu links
	my @links = $rg->rg_action_links();

	# Print if the user has resource.admin or resource.modify
	if ($rbac->check_auth($CL_AUTH_RESOURCE_MODIFY) ||
	    $rbac->check_auth($CL_AUTH_RESOURCE_ADMIN)) {
		$q->actions_menu(gettext("Actions Menu"), \@links);
	}

	# End the action bar table
	$q->end_action_bar_table();

	# Print the table of resources in the group
	$rg->resource_groups_table($q);
}

# End the html document
$rg->footer($q);
