#!/usr/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)quorum_view.pl 1.12     03/02/26 SMI"
#
# quorum_view.cgi -- Generate Sun Cluster quorum view page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Quorum;
use Sun::Solaris::Utils qw(gettext);

# Create the cluster objects
my $q = new Cluster::Cgi;
my $rbac = new Cluster::RBAC;
my $quorum = new Cluster::Quorum;

# Set the page title
my $title = gettext("Quorum");

# Check if in cluster mode
if ($quorum->is_clustermode() != 0) {
	# not in cluster mode
	$quorum->print_nonclustermode_error($q);
	exit;
}

my $quorumdevice = $q->param('quorumdevice');

# Get output of usefull commands into tmp files 
$quorum->get_commandoutput();

# Check args
#if ($quorum->check_args($q, $type, $name, "VIEW") != 0) {
#	goto DONE;
#}

# Print the query header and make the page expire now
print $q->header(-expires => "now");

my $yoke_jscript;
if (defined($quorumdevice)) {
    $yoke_jscript = $q->yoke_jscript("q-$quorumdevice");
} else {
    $yoke_jscript = $q->yoke_jscript("q");
}

# Start the document
print $q->start_html({  STYLE  => { 'src' => '/css/clustmgr-style.css'},
			TITLE  => gettext("View Quorum"),
			CLASS  => "default-body",
			ONUNLOAD => $q->unregister_jscript(),
			SCRIPT => "top.helpMarker=\"quorum-top\"\n" . $q->jump_menu_jscript() . $yoke_jscript .
$q->refresh_jscript('content', 'ESC_cluster_quorum')
		});

# Check for resource read authorization
if (!$rbac->check_auth($CL_AUTH_QUORUM_READ)) {
	$rbac->auth_error($q, $title);
	exit;
}


if ($quorum->is_installmode()) {
	# cluster is in installmode, we need reset reset the votes
	$quorum->quorum_header($q,
	    [$title, "/cgi-bin/quorum/quorum_view.pl",
	    gettext("Warning")]);
	print "<form>";
	$q->start_message_table("warning");
	print $q->start_p({ class => "message-header-text" });
	print gettext("Cluster is currently in install mode");
	print $q->end_p();
	$q->end_message_table($q);
	$q->buttons_table(gettext("  Reset Quorum Votes  "), "window.location.href=\"/cgi-bin/quorum/quorum_config.pl\?func=Clearinstallmode\"" );
	print "</form>"; 
	goto DONE;
}

# Start the html document
if (!defined $quorumdevice) {
	# Print the whole cluster's quorum configuration
	$quorum->quorum_header($q,  $title);

	# Print the table of quorum votes
	$quorum->votes_table($q);
} else {
	# Print the individual quorum device configuration
	$quorum->quorum_header($q,
	    [$title, "/cgi-bin/quorum/quorum_view.pl",
	    $quorumdevice], $quorumdevice);

	$quorum->quorum_table($q, $quorumdevice);
}

# End the html document
DONE: $quorum->footer($q);
