#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)network_config.pl 1.10     03/05/27 SMI"
#
# Network configure page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Network;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a network object
my $network = new Cluster::Network;

# Create the rbac object
my $rbac = new Cluster::RBAC;

my $node = $q->param('node');
my $adp = $q->param('adp');
my $step = $q->param('step');
my $func = $q->param('func');
my $nafogroup = $q->param('nafogroup');
my $unplumb = $q->param('unplumb') ;

# Set the page title
my $title = gettext("Configure Network");

# Check if in Cluster mode
if ($network->is_clustermode($q) != 0) {
        # not in cluster mode
        $network->print_nonclustermode_error($q);
        exit;
}

# Print the query header
print $q->header();

# Start the document
my $menu_jscript = $q->jump_menu_jscript();
my $network_jscript = $network->network_jscript();
my $jscript = $menu_jscript . "\n" . $network_jscript .
    $q->yoke_jscript("nf-$node");
print $q->start_html({  TITLE => $title,
			STYLE  => { 'src' => '/css/clustmgr-style.css'},
                        CLASS  => "default-body",
                        SCRIPT => $jscript
                        });

# Check if the user is root (uid == 0). IPMP actions require the
# effective user to be root. This follows ifconfig semantics, which are
# not currently RBAC aware.
if (!$rbac->check_root()) {
	$rbac->auth_error($q, [gettext("Nodes"), undef, $node, undef,
			       gettext("IPMP Groups")]);
	exit;
}

SWITCH: {
	if ($func eq "Add") {
		$network->add_adapter($q, $step, $node, $nafogroup, $adp);
		last SWITCH;
	}
	if ($func eq "Remove") {
		$network->remove_adapter($q, $step, $node, $nafogroup, $adp, $unplumb);
		last SWITCH;
	}
	if ($func eq "Move") {
		$network->move_adapter($q, $step, $node, $nafogroup, $adp);
		last SWITCH;
	}
}

# End the html document
$network->footer($q);
