#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)log.pl	1.16	03/02/26 SMI"
#
# Node system log page

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Log;
use Cluster::RBAC;
use Sun::Solaris::Utils qw(gettext);
use constant TRUE  => 0;
use constant FALSE => 1;

# Create the html query object
my $q = new Cluster::Cgi;

# Create a Process object
my $log = new Cluster::Log;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Get the node to print the logs for
my $node = $q->param("node");
if (!defined $node || $node eq "") {
	$node = $log->get_hostname();
}

# Get the length of the log history we're interested in
my $size = $q->param("size");
if (!defined $size || $size eq "" || $size <= 0) {
	$size = 100;
}

# Get the file we're looking at
my $file = $q->param("file");
if (!defined $file || $file eq "") {
	$file = "/var/adm/messages";
}

# Print the query header and make the page expire now
print $q->header(-expires => "now");

# Start the document
print $q->start_html({ TITLE  => gettext("System Logs"),
		       STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       CLASS  => "default-body",
		       SCRIPT => "top.helpMarker=\"logs-top\"\n" . 
			         $q->jump_menu_jscript() .
				 $q->yoke_jscript("nl-$node")
		       });

# Check for node read authorization
if (!$rbac->check_auth($CL_AUTH_NODE_READ)) {
	$rbac->auth_error($q, [gettext("Nodes"), undef, $node, undef,
			       gettext("System Logs")]);
	exit;
}

##############################################################################
#
# Action Bar Table
#
##############################################################################

# Start the action bar table
$q->start_action_bar_table([gettext("Nodes"), "/cgi-bin/node/node_status.pl",
	    $node, "/cgi-bin/node/node_info.pl?node=$node",
	    sprintf(gettext("System Logs: %s"), $file)],
	FALSE,
	{ALIGN => "right", WIDTH => "99%", NOWRAP => undef}
	);

# Get the list of log files on the remote node
my @files = $log->get_logset_remote($node);

if (!defined($files[0])) {
	# Communication error
	# End the action bar table
	$q->end_action_bar_table(FALSE);
	# End the html document
	$log->footer($q);
	return;
}

# Print the telnet link to the node
$q->telnet_link($node);

# Print the middle of the action table
$q->mid_action_bar_table();

# End the action bar table
$q->end_action_bar_table(FALSE);

# Start the logfile form
print $q->start_form({ NAME   => "logform",
		       ACTION => "/cgi-bin/log/log.pl"
		       });


print $q->start_table({CLASS => "action-bar-table",
			WIDTH => "98%",
			BORDER => "0",
			CELLPADDING => "0",
			CELLSPACING => "0",
			ALIGN => "center"});

print $q->start_Tr();
print $q->start_td({NOWRAP => undef,
			ALIGN => "right",
			WIDTH => "98%"});
# Print the log selection widget
print "&nbsp", $q->span({ CLASS => "action-bar-menu-label-text" });
print gettext("Log History:");
print "&nbsp;";
print $q->end_span();
print $q->input({ TYPE  => "TEXT",
		  NAME  => "size",
		  VALUE => $size,	
		  SIZE  => 4
		  });
print "&nbsp;";

print $q->popup_menu({ NAME     => "file",
			  VALUES   => \@files,
			  DEFAULT  => $file
			  });

print $q->input({ TYPE  => "SUBMIT",
		  VALUE => gettext("Go")
		  });
print $q->end_td(), $q->end_Tr(), $q->end_table();

# Print the hidden elements
print $q->input({ TYPE => "HIDDEN",
		  NAME => "node",
		  VALUE => $node
		  });

# End the log form
print $q->end_form();

##############################################################################
#
# Content Table
#
##############################################################################

# Print the processes for the selected node in a table
$log->log_table($q, $node, $file, $size);

# End the html document
$log->footer($q);
