#!/usr/perl5/bin/perl -w
#
# Copyright (c) 2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident	"@(#)step3.pl	1.23	03/01/07 SMI"
#
# Verify the given nodelist and then print a selection of adapters to
# use for the interconnects.

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Net::Ping;
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Verify the cluster nodes given in the previous step. Contact a
# script to make sure that the web server (and thus the node) are up.
my @nodelist = $install->get_nodelist($q);
my @bad_nodelist;
my $missing = 0;

my (%nodelist);

foreach my $node (@nodelist) {    
    if ($node eq "") {
	$missing = 1;
	last;
    }
    $nodelist{$node} = 1; # Check for repeats
}

if ($#nodelist+1 != $q->param('cluster_size') || $missing ||
	scalar(keys(%nodelist)) != $q->param('cluster_size')) {
    # Print the form for the back button
    $install->header($q, [gettext("Sun Cluster Installation"),
	"/cgi-bin/installation/step0.pl",
	gettext("Node Names (Step 2 of 8)")]);
    $install->start_message_table($q, "/images/error_32.gif",
	gettext("Error"), gettext("Missing node names"),
	gettext("One or more node names are missing."));
    $install->end_message_table($q);

    print $q->p({class => "action-window-normal-text"});
    print gettext("Please return to the previous page and enter a cluster name.");
    print $q->start_form();

    $install->start_button_table($q);

    print $q->button({ value   => gettext("  < Back  "),
		       onClick => "history.back()"
		       });
    $install->end_button_table($q, "cancel");

    print $q->end_form();
    
    # End the html document
    $install->footer($q);

    # Exit gracefully
    exit(0);
}

foreach my $node (@nodelist) {    
    if ($install->check_auth($node) != 0) {
	$install->syslog("Found bad node: $node");
	push @bad_nodelist, $node;
    }
}

# If we found any downed or nonexistant servers, process the list and
# report to the user.
if ($#bad_nodelist > -1) {
    # Start the html document
    $install->header($q, [gettext("Sun Cluster Installation"),
	"/cgi-bin/installation/step0.pl",
	gettext("Node Names (Step 2 of 8)")]);
    $install->start_message_table($q, "/images/error_32.gif",
	gettext("Error"), gettext("Unreachable Nodes"),
	gettext("The following node(s) are unreachable:"));

    # Print unreachable nodes
    print $q->br(), $q->br();

    foreach my $node (@bad_nodelist) {
	if ($node eq "") {
	    $node = "--empty--";
	}
	print $q->start_b(), $node, $q->end_b(), $q->br();
    }

    print $q->br();
    $install->end_message_table($q);
    print $q->p({class => "action-window-normal-text"});
    print gettext("Make sure that the specified hostnames are correct, " .
        "that your login id and password are set up on all the " .
	"nodes as described in the Sun Cluster 3.0 Installation Guide, " .
    	"and that the SUNWscvw package has been properly " .
    	"installed on all nodes.");


    print $q->start_form();

    $install->start_button_table($q);

    print $q->button({ value   => gettext("  < Back  "),
		       onClick => "history.back()"
		       });
    $install->end_button_table($q, "cancel");

    print $q->end_form();
    
    # End the html document
    $install->footer($q);

    # Exit gracefully
    exit(0);
}

# The validation succeeded, ask for the transports
    $install->header($q, [gettext("Sun Cluster Installation"),
	"/cgi-bin/installation/step0.pl",
    gettext("Cluster Transports (Step 3 of 8)")]);
print $q->p({class => "action-window-normal-text"});

print gettext("Specify two unique interconnects for each node.  If the " .
    "interconnects are not correct then the installation will fail.")."<BR>";

print $q->end_p(),"\n";

# Get global values
my $cluster_name = $q->param('cluster_name');

# Get autodiscovered values
my ($num_transports) = $install->determine_transports($q, @nodelist);

# Print the form
print $q->start_form({ action => '/cgi-bin/installation/sds_step1.pl' });
print $q->start_table({ cellpadding => 5,
		cellspacing => 0,
		class => "action-table"});

print $q->start_Tr();

print $q->start_td({nowrap => undef});
print $q->start_div({class => "action-window-label-text"});
print gettext("Node");
print $q->end_div(), $q->end_td(), "\n";

print $q->start_td({nowrap => undef});
print $q->start_div({class => "action-window-label-text"});
print gettext("Adapter 1");
print $q->end_div(), $q->end_td();

print $q->start_td({nowrap => undef});
print $q->start_div({class => "action-window-label-text"});
print gettext("Adapter 2");
print $q->end_div(), $q->end_td();
print $q->end_Tr();

# Print out transport selectors for each node
for (my $i=1; $i<=$q->param('cluster_size'); $i++) {
    my $nodename = $q->param("node_$i.name");

    print $q->start_Tr();
    print $q->start_td({ nowrap => undef});
    print $q->start_div({class => "action-window-table-normal-text"});
    print sprintf(gettext("%s:"), $nodename);
    print $q->end_div(), $q->end_td();

    my @transport_1_values = $install->get_remote_interfaces($nodename);
    print $q->start_td({align => "center"});
    print $q->popup_menu({ name => "node_$i.transport_1",
			   values => \@transport_1_values
			   });
    print $q->end_td();

    my @transport_2_values = $install->get_remote_interfaces($nodename);
    print $q->start_td({align => "center"});
    print $q->popup_menu({ name => "node_$i.transport_2",
			   values => \@transport_2_values,
			   default=> $transport_2_values[1]
			   });
    print $q->end_td();
    print $q->end_Tr();
}

print $q->end_table(); 

# Print the hidden cluster fields
print $q->hidden({ name    => "cluster_name"});
print $q->hidden({ name    => "cluster_size"});
for (my $i = 1; $i <= $q->param('cluster_size'); $i++) {
    print $q->hidden({ name    => "node_$i.name"});
}

$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });


# Put spaces between the buttons
print "&nbsp;" ;

print $q->submit({ name  => 'submit_step_3',
		   value => gettext("  Next >  ")
		   });
$install->end_button_table($q, "cancel");

print $q->end_form();

# End the html document
$install->footer($q);

