#!/usr/perl5/bin/perl -w
#
# Copyright (c) 2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident	"@(#)install_state.pl	1.7	03/01/07 SMI"
#
# Get the state of the installation

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;

# Create a install object
my $install = new Cluster::Install;

# File definitions
my $logdir = $install->get_logdir();
my $DONE_SDS_FILE = "$logdir/done_sds";
my $DONE_COPY_UNCOMPRESS_PATCHES_FILE = "$logdir/done_copy_uncompress_patches";
my $DONE_PATCHES_FILE = "$logdir/done_patches";
my $FINISH_INSTALL = "$logdir/finish_install";
my $DONE_SCINSTALL_I = "$logdir/done_scinstall_i";
my $DONE_SCCHECK = "$logdir/done_sccheck";

# Create a cgi object
my $q = new Cluster::Cgi;

# Print the header
print $q->header();

# Get the step we care about
my $step = $q->param('step');

# Report on the step
if ($step eq 'DONE_SDS' && -e $DONE_SDS_FILE) {
    print "YES";
} elsif ($step eq 'DONE_PATCHES' && -e $DONE_PATCHES_FILE) {
    print "YES";
} elsif ($step eq 'DONE_COPY_UNCOMPRESS_PATCHES' && -e $DONE_COPY_UNCOMPRESS_PATCHES_FILE) {
    print "YES";
} elsif ($step eq 'FINISH_INSTALL' && -e $FINISH_INSTALL) {
    print "YES";
} elsif ($step eq 'DONE_SCINSTALL_I' && -e $DONE_SCINSTALL_I) {
    print "YES";
} elsif ($step eq 'DONE_SCCHECK' && -e $DONE_SCCHECK) {
    print "YES";
} else {
    print "NO";
}
