#!/bin/pfsh -- # perl, to stop looping
eval 'exec /usr/perl5/bin/perl -w -S $0 ${1+"$@"}'
  if 0;
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#pragma ident   "@(#)iplanet-script.pl 1.10     03/02/25 SMI"
#


use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Sun::Solaris::Utils qw(gettext);
use Cluster::Cgi;
use Cluster::Common;
use Cluster::Script;

(new Cluster::Common)->run_script(\&run_script);

sub run_script {
    my ($q, $outfd) = @_;

# install: Run the iplanet install script
# update: Update the log files

    if ($q->param('mode') eq "install") {
	&install($q, $outfd);
    } elsif ($q->param('mode') eq "update") {
	&update($q, $outfd);
    } else {
	die("Bad operation ".$q->param('mode'));
    }
}

sub install {
    my ($q, $outfd) = @_;
    # Validate input
    my $i;
    foreach $i ('mode', 'setupdir', 'loc', 'server', 'nspassword', 'aport',
	    'wport', 'root') {
	print STDERR $i." ".$q->param($i)."\n"; #XXX
	($q->param($i) ne "") || die(sprintf(gettext("Parameter %s undefined"), $i));
    }

    my $cmd = $q->param('setupdir')."/setup";

    my $script = new Cluster::Script;
    $script->run($cmd, "script-iplanet", $q, $outfd);
}

sub update {
    my ($q, $outfd) = @_;
    # Validate input
    my $i;
    foreach $i ('confhost', 'idir', 'logdir', 'bind') {
	($q->param($i) ne "") || die(sprintf(gettext("Parameter %s undefined"), $i));
    }

    my ($confhost) = $q->param('confhost');
    my ($idir) = $q->param('idir');
    my ($logdir) = $q->param('logdir');
    my ($bind) = $q->param('bind');

    if ($confhost eq "" || $idir eq "" || $logdir eq "" || $bind eq "") {
	die(gettext("Must specify confhost sunone-directory log-directory bindaddr"));
    }

    &mkdirp($logdir);
    print $outfd sprintf(gettext("Made log directory %s\n"), $logdir);

    my $hostname = `hostname`;
    chop $hostname;
    if ($confhost ne "all" && $confhost ne $hostname) {
	return;
    }

    # For local installation, update magnus.conf on "all" nodes
    # For global installation, only one node ($confhost) updates magnus.conf

    foreach $i ("magnus.conf", "obj.conf") {
	&editfile($outfd, $i, $idir, $bind, $logdir);
    }
    print $outfd gettext("Updated magnus.conf and obj.conf\n");
}

# Make a directory
sub mkdirp {
    my ($dir) = @_;
    my $status = system("mkdir -p $dir");
    if ($status) {
	die("mkdir $dir failed $?");
    }
    chown((getpwnam("nobody"))[2,3], $dir);
}

# Edit a config file
sub editfile {
    my ($outfd, $filename, $idir, $bind, $logdir) = @_;
    $filename = "$idir/$filename";
    my ($dev, $ino, $mode, $nlink, $uid, $gid) = stat($filename);
    open(IN, "<$filename") || die ("can't open $filename");
    open(OUT, ">$filename.new") || die ("can't open $filename.new");
    while (<IN>) {
	if (/^ErrorLog/) {
	    $_ = "ErrorLog $logdir/error\n";
	} elsif (/^PidLog/) {
	    $_ = "PidLog $logdir/pid\n";
	} elsif (/access=/) {
	    $_ =~ s/access="[^"]*"/access="$logdir\/access"/;
	}
	print OUT $_;
    }
    if ($filename =~ /magnus.conf$/) {
	print OUT "Address $bind\n";
    }
    close(IN);
    close(OUT);
    if (!rename "$filename", "$filename.old") {
	print $outfd "ERROR: "."$! $filename $filename.old\n";
    }
    if (!rename "$filename.new", "$filename") {
	print $outfd "ERROR: "."$! $filename.new $filename\n";
    }
    # Set ownership and mode back
    chown $uid, $gid, $filename;
    chmod $mode, $filename;
}
