#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)device_view.pl 1.21     03/03/30 SMI"
#
# Device group view page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Device;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a Device object
my $device = new Cluster::Device;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Check if in Cluster mode
if ($device->is_clustermode($q) != 0) {
	# not in cluster mode
	$device->print_nonclustermode_error($q);
	exit;
}

# Set the page title
my $title = gettext("Global Devices");

#
# Get the parameter for this page.
# devicegroup - devicegroup'name 
# view - table view or topological view 
#
my $devicegroup = $q->param('devicegroup');
my $view = $q->param('view');

# Print the query header and make the page expire now
print $q->header(-expires => "now");

my $yoke_jscript;
if (defined($devicegroup)) {
    $yoke_jscript = $q->yoke_jscript("d-$devicegroup");
} else {
    $yoke_jscript = $q->yoke_jscript("d");
}

if (defined $view && $view eq "topological") {
    # Nothing for topological
} else {
    $yoke_jscript .= $q->refresh_jscript('content',
	'ESC_cluster_dcs,ESC_cluster_dpm_disk_path');
}

# Start the document
print $q->start_html({  TITLE  => $title,
			STYLE  => { 'src' => '/css/clustmgr-style.css'},
                        CLASS  => "default-body",
			ONUNLOAD => $q->unregister_jscript(),
                        SCRIPT => $q->jump_menu_jscript() . $yoke_jscript
                        });

# Check for device read authorization
if (!$rbac->check_auth($CL_AUTH_DEVICE_READ)) {
	$rbac->auth_error($q, $title);
	exit;
}

# Read the configuration and status into memory if needed
$device->get_commandoutput();

if (defined $view && $view eq "topological") {
	# Print the header
        $device->device_header($q, $title);

	print $q->start_script();
        print "document.actionform.viewmenu.selectedIndex=1;";
        print "top.helpMarker=\"device_view-topo\"";
        print $q->end_script();

	# Print the applet
        print $q->applet({ name => 'viewApplet',
                       codebase => '/',
                       code => 'View.class',
                       height => 500,
                       width => 700});

	my $cName = $device->get_clustername();
	my $nName = $device->get_hostname();
	print $q->Param({ name => 'cName', value => $cName });
	print $q->end_Param();
	print $q->Param({ name => 'nName', value => $nName });
	print $q->end_Param();
	print $q->Param({ name => 'mode', value => 3 });
	print $q->end_Param();
	print $q->end_applet();
} else {
	print $q->start_script();
        print "top.helpMarker=\"device_view-tables\"";
        print $q->end_script();

	if (!defined $devicegroup) {
		# Cluster-wide overview
		$device->device_header($q, $title);
		
		# Print the global devices table
		$device->global_devices_table($q);

		# Print the monitored devices table
		$device->monitored_disks_table($q);

	} else {
		# Cluster-wide overview
		$device->device_header($q, [$title,
			"/cgi-bin/device/device_view.pl",
		    $devicegroup], $devicegroup);
		
		# Print the global devices table
		$device->devicegroup_table($q, $devicegroup);
	}
}

# End the html document
$device->footer($q);
