/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Client;
import com.sun.cluster.sccheck.ClientThread;
import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.KEWrapper;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.SCProperties;
import com.sun.cluster.sccheck.Utils;
import com.sun.cluster.sccheck.WrapperException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class SccheckClient
implements Client,
ProgressListener,
Globals {
    private boolean brief = false;
    private boolean verbose = false;
    private boolean vverbose = false;
    private int minSeverity = 0;
    private String hostlist = null;
    private String reportsDir = null;
    private String explorersgzDir = null;
    private String explorersUnpackDir = null;
    private Vector zippedExplorers = new Vector();
    private String clientNumber = System.getProperty("sccheck.clientnumber");
    private String clientName = null;
    private String clustername = null;
    private boolean clientThreadFailed = false;
    private String failedNodes = null;
    private int numHosts = 0;
    private String[] genDates = null;
    private String[] clusterPublicNames = null;
    private String[] clusterPrivateNames = null;
    private String[] sessionPublicNames = null;
    private String[] sessionPrivateNames = null;
    private boolean inClusterMode = true;
    private int maxServerExitCode = 0;
    private int multiReportExitCode = 0;
    private Logger logger = null;
    private SCProperties props = null;

    public SccheckClient() {
        String string;
        if (this.clientNumber == null) {
            this.clientNumber = "0";
        }
        try {
            this.props = SCProperties.getSCProperties("/etc/default/sccheck");
        }
        catch (IOException iOException) {}
        boolean bl = SCProperties.booleanFromProps("LOGGING", false, this.props);
        this.logger = new Logger("/var/cluster/logs/sccheck/client.log." + this.clientNumber, bl);
        this.logger.info("SccheckClient() -- ENTER; clientNumber: " + this.clientNumber);
        if (!bl) {
            System.setProperty("logging.FileHandler.path", "/dev/null");
        }
        try {
            this.checkRequiredDefines();
        }
        catch (SCException sCException) {
            string = sCException.getMessage();
            this.logger.error("SccheckClient() usage error: " + string);
            this.earlyExit(103, string);
        }
        this.loadOptionalDefines();
        try {
            this.expandHostlist();
        }
        catch (SCException sCException) {
            string = sCException.getMessage();
            this.logger.error("SccheckClient() bad hostname: " + string);
            this.earlyExit(105, string);
        }
        try {
            this.remoteOperations(this.sessionPublicNames, this.sessionPrivateNames);
        }
        catch (SCException sCException) {
            string = sCException.getMessage();
            this.logger.error("SccheckClient() remote ops exception: " + string);
            if (this.clientThreadFailed) {
                this.earlyExit(107, string);
            }
            this.earlyExit(108, string);
        }
        if (this.zippedExplorers.size() > 1) {
            this.logger.trace("SccheckClient(): " + this.clustername + ": running multi-node checks");
            try {
                this.multiReportExitCode = this.runKE(this.zippedExplorers);
            }
            catch (WrapperException wrapperException) {
                this.logger.error("SccheckClient() in WrapperException wex2: " + wrapperException.getMessage());
                this.earlyExit(108, wrapperException.getMessage());
            }
        } else {
            this.logger.trace(String.valueOf(this.clustername) + ": skipping multi-node checks");
        }
        this.compareGenDates();
        this.logger.trace("SccheckClient() --EXIT-- " + this.maxServerExitCode);
        this.logger.close();
    }

    public synchronized void addGenDate(String string, String string2) {
        this.logger.info("SccheckClient.addGenDate(): " + string2 + " from " + string);
        boolean bl = false;
        int n = 0;
        while (n < this.sessionPublicNames.length) {
            if (this.sessionPublicNames[n].equals(string)) {
                this.genDates[n] = string2;
                bl = true;
                this.logger.info("SccheckClient.addGenDate() match: " + string);
                break;
            }
            ++n;
        }
        if (!bl) {
            this.logger.error("SccheckClient.addGenDate() couldn't match " + string + " in sessionPublicNames[]");
        }
        this.logger.trace("SccheckClient.addGenDate() -- EXIT --");
    }

    public synchronized void addServerExitCode(String string, int n) {
        this.logger.info("SccheckClient.addServerExitCode(): " + n + " from " + string);
        if (n > this.maxServerExitCode) {
            this.maxServerExitCode = n;
        }
        this.logger.info("SccheckClient.addServerExitCode() maxServerExitCode: " + this.maxServerExitCode);
    }

    public synchronized void addZippedExplorer(String string) {
        this.zippedExplorers.addElement(string);
    }

    private void checkRequiredDefines() throws SCException {
        String string = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement("configSuffix");
        vector.addElement("kae.kce.KCEFactFactory.KCEre");
        vector.addElement("kae.Explorer.LocalDB");
        vector.addElement("kae.kce.KCEFactFactory.useDBStore");
        vector.addElement("kae.useRMI");
        vector.addElement("logging.handlers");
        vector.addElement("logging.FileHandler.level");
        vector.addElement("logging.FileHandler.level");
        vector.addElement("sccheck.clustermode");
        vector.addElement("sccheck.clustername");
        vector.addElement("sccheck.localname");
        vector.addElement("sccheck.publicnodenames");
        vector.addElement("sccheck.privatenodenames");
        vector.addElement("sccheck.outputDir");
        vector.addElement("sccheck.explorersgzDir");
        vector.addElement("sccheck.explorersUnpackDir");
        vector.addElement("sccheck.gunzip");
        vector.addElement("sccheck.tar");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = System.getProperty(string2);
            if (string3 != null) continue;
            string = string == null ? string2 : String.valueOf(string) + ", " + string2;
        }
        if (string != null) {
            Object[] objectArray = new Object[]{string};
            String string4 = I18n.getLocalized("requiredDefinesMissing", objectArray);
            throw new SCException(string4);
        }
        this.clustername = System.getProperty("sccheck.clustername");
        this.logger.info("SccheckClient.checkRequiredDefines() clustername: " + this.clustername);
        this.clientName = System.getProperty("sccheck.localname");
        this.logger.info("SccheckClient.checkRequiredDefines() clientName: " + this.clientName);
        String string5 = System.getProperty("sccheck.publicnodenames");
        this.clusterPublicNames = this.preProcessNodeNames(string5);
        string5 = System.getProperty("sccheck.privatenodenames");
        this.clusterPrivateNames = this.preProcessNodeNames(string5);
        this.reportsDir = System.getProperty("sccheck.outputDir");
        this.explorersgzDir = System.getProperty("sccheck.explorersgzDir");
        this.explorersUnpackDir = System.getProperty("sccheck.explorersUnpackDir");
        this.inClusterMode = Boolean.getBoolean("sccheck.clustermode");
        this.logger.info("SccheckClient.checkRequiredDefines() inClusterMode: " + this.inClusterMode);
        this.logger.info("SccheckClient.checkRequiredDefines() gunzip: " + System.getProperty("sccheck.gunzip"));
    }

    private void compareGenDates() {
        this.logger.trace("SccheckClient.compareGenDates() -- ENTER -- ");
        String string = this.genDates[0];
        int n = 0;
        while (n < this.genDates.length) {
            if (!string.equals(this.genDates[n])) {
                this.warnGenDates();
                break;
            }
            ++n;
        }
        this.logger.trace("SccheckClient.compareGenDates() -- EXIT -- ");
    }

    private void earlyExit(int n) {
        this.earlyExit(n, null);
    }

    private void earlyExit(int n, String string) {
        String string2 = "";
        switch (n) {
            case 101: {
                string2 = "permissionDenied";
                break;
            }
            case 102: {
                string2 = "componentError";
                break;
            }
            case 103: {
                string2 = "internalInvocationError";
                break;
            }
            case 104: {
                string2 = "unableToLoadClusterData";
                break;
            }
            case 105: {
                if (this.inClusterMode) {
                    string2 = "noClusterNodeNameMatching";
                    break;
                }
                string2 = "hostlistNotAllowedInNonClusterMode";
                break;
            }
            case 107: {
                string2 = "unableToRunChecksOn";
                break;
            }
            case 108: {
                string2 = "internalError";
                break;
            }
            default: {
                string2 = "unknownError";
            }
        }
        Object[] objectArray = new Object[]{I18n.getLocalized("sccheck"), I18n.getLocalized(string2), string};
        String string3 = I18n.getLocalized("earlyExitFormat", objectArray);
        System.err.println(string3);
        this.logger.info("SccheckClient.earlyExit() called with code " + n + " (" + string + ")");
        this.logger.close();
        System.exit(n);
    }

    private void expandHostlist() throws SCException {
        if (this.inClusterMode) {
            this.expandHostlistClusterMode();
        } else {
            this.expandHostlistNonClusterMode();
        }
        this.logger.info("SccheckClient.expandHostlist() -- sessionPublicNames: " + Utils.dumpStringArray(this.sessionPublicNames));
        this.logger.info("SccheckClient.expandHostlist() -- sessionPrivateNames: " + Utils.dumpStringArray(this.sessionPrivateNames));
    }

    private void expandHostlistClusterMode() throws SCException {
        int n = 0;
        if (this.hostlist == null) {
            n = this.clusterPublicNames.length;
            this.sessionPublicNames = new String[n];
            this.sessionPrivateNames = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.sessionPublicNames[n2] = this.clusterPublicNames[n2];
                this.sessionPrivateNames[n2] = this.clusterPrivateNames[n2];
                ++n2;
            }
        } else {
            StringBuffer stringBuffer = null;
            StringTokenizer stringTokenizer = new StringTokenizer(this.hostlist, ",");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (vector.contains(string)) continue;
                vector.add(string);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string);
            }
            stringTokenizer = new StringTokenizer(stringBuffer.toString(), ",");
            n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            this.sessionPublicNames = new String[n];
            this.sessionPrivateNames = new String[n];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string;
                stringArray[n3] = string = stringTokenizer.nextToken();
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.sessionPublicNames.length) {
                boolean bl = false;
                int n5 = 0;
                while (n5 < this.clusterPublicNames.length) {
                    if (stringArray[n4].equals(this.clusterPublicNames[n5])) {
                        this.sessionPublicNames[n4] = stringArray[n4];
                        this.sessionPrivateNames[n4] = this.clusterPrivateNames[n5];
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    this.logger.error("SccheckClient.expandHostlistClusterMode() hostname not a cluster member: " + stringArray[n4]);
                    throw new SCException(stringArray[n4]);
                }
                ++n4;
            }
        }
    }

    private void expandHostlistNonClusterMode() throws SCException {
        if (this.hostlist != null) {
            throw new SCException(this.hostlist);
        }
        this.sessionPublicNames = new String[]{this.clientName};
        this.sessionPrivateNames = new String[]{"localhost"};
    }

    public String getAuth() {
        return null;
    }

    public String getClientHostname() {
        return this.clientName;
    }

    public String getClusterName() {
        return this.clustername;
    }

    public int getExitCode() {
        if (this.getMaxServerExitCode() >= this.getMultiReportExitCode()) {
            return this.getMaxServerExitCode();
        }
        return this.getMultiReportExitCode();
    }

    public String getLocaleCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getLocaleLang() {
        return Locale.getDefault().getLanguage();
    }

    public String getLocaleVariant() {
        return Locale.getDefault().getVariant();
    }

    private int getMaxServerExitCode() {
        return this.maxServerExitCode;
    }

    private int getMultiReportExitCode() {
        return this.multiReportExitCode;
    }

    private void loadOptionalDefines() {
        this.brief = Boolean.getBoolean("sccheck.brief");
        this.logger.info("SccheckClient.loadOptionalDefines() brief: " + this.brief);
        this.verbose = Boolean.getBoolean("sccheck.verbose");
        this.logger.info("SccheckClient.loadOptionalDefines() verbose: " + this.verbose);
        this.vverbose = Boolean.getBoolean("sccheck.vverbose");
        this.logger.info("SccheckClient.loadOptionalDefines() vverbose: " + this.vverbose);
        this.hostlist = System.getProperty("sccheck.hostlist");
        this.logger.info("SccheckClient.loadOptionalDefines() hostlist: " + this.hostlist);
        this.minSeverity = 0;
        Integer n = Integer.getInteger("sccheck.severity");
        if (n != null) {
            this.minSeverity = n;
        }
        this.logger.info("SccheckClient.loadOptionalDefines() minSeverity: " + this.minSeverity);
    }

    public static void main(String[] stringArray) {
        SccheckClient sccheckClient = new SccheckClient();
        int n = sccheckClient.getExitCode();
        System.exit(n);
    }

    public synchronized void postErrMsg(String string) {
        this.logger.info("postErrMsg: " + string);
        Object[] objectArray = new Object[]{I18n.getLocalized("sccheck"), string};
        String string2 = I18n.getLocalized("postErrMsgFormat", objectArray);
        System.err.println(string2);
    }

    public synchronized void postFailure(String string) {
        this.clientThreadFailed = true;
        this.failedNodes = this.failedNodes == null ? string : String.valueOf(this.failedNodes) + "," + string;
    }

    public synchronized void postProgress(int n, String string) {
        this.logger.info("postProgress: (verbose: " + n + ") " + string);
        if (n == 0 || this.vverbose || n == 1 && this.verbose) {
            Object[] objectArray = new Object[]{I18n.getLocalized("sccheck"), string};
            String string2 = I18n.getLocalized("postProgressFormat", objectArray);
            System.out.println(string2);
        }
    }

    private String[] preProcessNodeNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        String[] stringArray = new String[n];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private void remoteOperations(String[] stringArray, String[] stringArray2) throws SCException {
        String string;
        this.logger.info("SccheckClient.remOps(): " + Utils.dumpStringArray(stringArray) + " / " + Utils.dumpStringArray(stringArray));
        this.numHosts = stringArray.length;
        this.genDates = new String[this.numHosts];
        ClientThread[] clientThreadArray = new ClientThread[this.numHosts];
        int n = 0;
        while (n < this.numHosts) {
            string = stringArray[n];
            String string2 = stringArray2[n];
            String string3 = String.valueOf(this.explorersgzDir) + "/" + string + ".expl.gzip";
            String string4 = String.valueOf(this.reportsDir) + "/" + "sccheck-results" + "." + string;
            this.logger.info("SccheckClient.remOps() reportsDir: " + this.reportsDir);
            this.logger.info("SccheckClient.remOps() CLIENT_REPORTNAME: sccheck-results");
            this.logger.info("SccheckClient.remOps() reportFilename: " + string4);
            this.logger.info("SccheckClient.remOps() new thread for: " + string + "/" + string2);
            Object[] objectArray = new Object[]{string};
            String string5 = I18n.getLocalized("requestingExplorerAndNodeReportFrom", objectArray);
            this.postProgress(1, string5);
            clientThreadArray[n] = new ClientThread(this, this, string, string2, string3, string4, this.brief, this.minSeverity);
            clientThreadArray[n].start();
            ++n;
        }
        try {
            this.waitForClientThreads(clientThreadArray);
        }
        catch (InterruptedException interruptedException) {
            this.logger.error("SccheckClient.remOps() InterruptedException");
            string = I18n.getLocalized("interruptionBeforeRequestsCompleted");
            throw new SCException(string);
        }
        if (this.clientThreadFailed) {
            this.logger.error("SccheckClient.remOps() failedNodes: " + this.failedNodes);
            throw new SCException(this.failedNodes);
        }
        this.logger.trace("SccheckClient.remOps() -- EXIT -- ");
    }

    private int runKE(Vector vector) throws WrapperException {
        this.logger.trace("SccheckClient.runKE() --ENTER--");
        String string = String.valueOf(this.reportsDir) + "/" + "sccheck-results" + "." + this.clustername;
        String string2 = "/usr/cluster/lib/sccheck/checklist.cluster.multinode.xml";
        int n = 0;
        String string3 = I18n.getLocalized("startingMultiNodeChecks");
        this.postProgress(1, string3);
        this.logger.trace("SccheckClient.runKE() about to make KEWrapper");
        this.logger.info("SccheckClient.runKE() explorersUnpackDir: " + this.explorersUnpackDir);
        KEWrapper kEWrapper = null;
        try {
            kEWrapper = new KEWrapper(this, string, vector, this.explorersUnpackDir, string2, this.brief, this.minSeverity);
            kEWrapper.runKE();
            string3 = I18n.getLocalized("multiNodeChecksFinished");
            this.postProgress(1, string3);
            kEWrapper.removeUnpackedExplorers();
        }
        catch (WrapperException wrapperException) {
            this.logger.error("SccheckClient.runKE() in WrapperException wex: " + wrapperException.getMessage());
            throw new WrapperException(wrapperException.getMessage());
        }
        n = kEWrapper.getMaxSeverity();
        this.logger.trace("SccheckClient.runKE() --EXIT: " + n);
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private void waitForClientThreads(ClientThread[] var1_1) throws InterruptedException {
        block4: {
            this.logger.trace("SccheckClient.waitForClientThreads() -- ENTER -- ");
            var2_2 = var1_1.length;
            try {
                var3_3 = 0;
                while (var3_3 < var2_2) {
                    var1_1[var3_3].join();
                    ++var3_3;
                }
                break block4;
            }
            catch (InterruptedException var3_4) {
                this.logger.error("SccheckClient.waitForClientThreads() InterruptedException");
                var4_5 = 0;
                ** while (var4_5 < var2_2)
            }
lbl-1000:
            // 1 sources

            {
                var1_1[var4_5].die();
                ++var4_5;
                continue;
            }
lbl17:
            // 1 sources

            throw var3_4;
        }
        this.logger.trace("SccheckClient.waitForClientThreads() -- EXIT -- ");
    }

    private void warnGenDates() {
        this.logger.trace("SccheckClient.warnGenDates() -- ENTER -- ");
        this.postProgress(0, I18n.getLocalized("warnGenDates"));
        if (!this.verbose && !this.vverbose) {
            this.postProgress(0, I18n.getLocalized("rerunWithVVForMoreDetails"));
        }
        int n = 0;
        while (n < this.genDates.length) {
            Object[] objectArray = new Object[]{String.valueOf(this.sessionPublicNames[n]) + ":", this.genDates[n]};
            String string = I18n.getLocalized("showGenDate", objectArray);
            this.postProgress(1, string);
            ++n;
        }
        this.logger.trace("SccheckClient.warnGenDates() -- EXIT -- ");
    }
}

